/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.text.utils;

final class CharSequenceConcatRightTrim
implements CharSequence {
    private final CharSequence a;
    private final CharSequence b;

    CharSequenceConcatRightTrim(CharSequence a, CharSequence b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public int length() {
        int i;
        for (i = this.a.length() + this.b.length() - 1; i > 0 && Character.isWhitespace(this.charAt(i)); --i) {
        }
        return i + 1;
    }

    @Override
    public char charAt(int index) {
        if (index < this.a.length()) {
            return this.a.charAt(index);
        }
        return this.b.charAt(index - this.a.length());
    }

    @Override
    public CharSequence subSequence(final int start, final int end) {
        return new CharSequence(){

            @Override
            public int length() {
                return end - start;
            }

            @Override
            public char charAt(int index) {
                return CharSequenceConcatRightTrim.this.charAt(start + index);
            }

            @Override
            public CharSequence subSequence(int start2, int end2) {
                StringBuilder s = new StringBuilder(end2 - start2);
                for (int i = start2; i < end2; ++i) {
                    s.append(this.charAt(i));
                }
                return s;
            }

            @Override
            public String toString() {
                StringBuilder s = new StringBuilder();
                int len = this.length();
                for (int i = 0; i < len; ++i) {
                    s.append(this.charAt(i));
                }
                return s.toString();
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            s.append(this.charAt(i));
        }
        return s.toString();
    }
}

