/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.webdrivertools;

import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SeleniumUtils {
    private static final String LogIdent = "[SeleniumUtils] ";
    protected static String[] xpathSearchString = new String[0];
    protected static String[] xpathSearchStringExclusion = new String[0];

    public static String getBrowserAndVersion(RemoteWebDriver browserDriver, Class<?> externalLogger) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        String browser_version = null;
        Capabilities cap = browserDriver.getCapabilities();
        String browsername = cap.getBrowserName();
        if ("internet explorer".equalsIgnoreCase(browsername)) {
            String uAgent = (String)browserDriver.executeScript("return navigator.userAgent;", new Object[0]);
            LogInfo.invoke((Object)LogInfo, "[SeleniumUtils] RAW uAgent: " + uAgent);
            browser_version = uAgent.contains("MSIE") && uAgent.contains("Windows") ? uAgent.substring(uAgent.indexOf("MSIE") + 5, uAgent.indexOf("Windows") - 2) : (uAgent.contains("Trident/7.0") ? "11.0" : "0.0");
        } else {
            browser_version = cap.getBrowserVersion();
        }
        String browserversion = browser_version.substring(0, browser_version.indexOf("."));
        LogInfo.invoke((Object)LogInfo, "[SeleniumUtils] return formated Name+Version: " + browsername + " ver. " + browserversion);
        return browsername + " ver. " + browserversion;
    }

    public static String getBrowserVersion(RemoteWebDriver browserDriver, Class<?> ExternalLogger) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        String browser_version = null;
        Capabilities cap = browserDriver.getCapabilities();
        String browsername = cap.getBrowserName();
        LogInfo.invoke((Object)LogInfo, "[SeleniumUtils] Browsername: " + browsername);
        if ("internet explorer".equalsIgnoreCase(browsername)) {
            String uAgent = (String)browserDriver.executeScript("return navigator.userAgent;", new Object[0]);
            LogInfo.invoke((Object)LogInfo, "[SeleniumUtils] RAW uAgent: " + uAgent);
            browser_version = uAgent.contains("MSIE") && uAgent.contains("Windows") ? uAgent.substring(uAgent.indexOf("MSIE") + 5, uAgent.indexOf("Windows") - 2) : (uAgent.contains("Trident/7.0") ? "11.0" : "0.0");
        } else {
            browser_version = cap.getBrowserVersion();
        }
        LogInfo.invoke((Object)LogInfo, "[SeleniumUtils] Browser-Version: " + browser_version);
        return browser_version;
    }

    public static boolean waitForJSandJQueryToLoad(WebDriver seleniumWebDriver) {
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        ExpectedCondition<Boolean> jQueryLoad = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return (Long)SeleniumUtils.getDriver(driver).executeScript("return jQuery.active", new Object[0]) == 0L;
                }
                catch (Exception e) {
                    return true;
                }
            }
        };
        ExpectedCondition<Boolean> jsLoad = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return SeleniumUtils.getDriver(driver).executeScript("return document.readyState", new Object[0]).toString().equals("complete");
            }
        };
        return (Boolean)wait.until((Function)jQueryLoad) != false && (Boolean)wait.until((Function)jsLoad) != false;
    }

    public static void takeSeleniumSnapshot(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface, String fileName) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String sourceCodeFilePath = SysUtils.SUPPORT_TEMP_PATH + fileName + ".html";
        String screenshotFilePath = System.getProperty("java.io.tmpdir") + File.separator + fileName + ".png";
        SeleniumUtils.takeRuntimeCodeToFile(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface, sourceCodeFilePath);
        SeleniumUtils.takeErrorScreenshotInTemp(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface, fileName);
        FileUtils.copyFileToDirectory((File)new File(screenshotFilePath), (File)new File(SysUtils.SUPPORT_TEMP_PATH));
        FileUtils.copyFileToDirectory((File)new File(System.getProperty("chromedriver.logfile.path")), (File)new File(SysUtils.SUPPORT_TEMP_PATH));
        FileSysUtils.forceDeleteTarget(new File(screenshotFilePath));
    }

    public static void takeRuntimeCodeToFile(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface, String sourceCodeFilePath) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        FileUtils.writeStringToFile((File)new File(sourceCodeFilePath), (String)seleniumWebDriver.findElement(By.xpath((String)"//html")).getAttribute("outerHTML"), (String)"UTF-8");
        try {
            List iframes = seleniumWebDriver.findElements(By.xpath((String)"//iframe"));
            for (int i = 0; i < iframes.size(); ++i) {
                if (((WebElement)iframes.get(i)).getAttribute("style").contains("display: none") || ((WebElement)iframes.get(i)).getAttribute("style").contains("display:none")) continue;
                seleniumWebDriver.switchTo().frame(i);
                FileUtils.writeStringToFile((File)new File(sourceCodeFilePath.replace(".html", "_iframe" + String.valueOf(i) + ".html")), (String)seleniumWebDriver.findElement(By.xpath((String)"//html")).getAttribute("outerHTML"), (String)"UTF-8");
                seleniumWebDriver.switchTo().defaultContent();
            }
        }
        catch (Exception error) {
            LogError.invoke((Object)LogError, "[SeleniumUtils] iFrames auslesen fehlerhaft: ! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
        }
        try {
            String currentWindow = seleniumWebDriver.getWindowHandle();
            int currentWindowCount = 0;
            if (seleniumWebDriver.getWindowHandles().size() < 1) {
                for (String window : seleniumWebDriver.getWindowHandles()) {
                    if (window.equals(currentWindow)) continue;
                    seleniumWebDriver.switchTo().window(window);
                    LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] Modal dialog or other Tab found...");
                    FileUtils.writeStringToFile((File)new File(sourceCodeFilePath.replace(".html", "_TabOrModalDialog" + String.valueOf(++currentWindowCount) + ".html")), (String)seleniumWebDriver.findElement(By.xpath((String)"//html")).getAttribute("outerHTML"), (String)"UTF-8");
                }
            }
            seleniumWebDriver.switchTo().window(currentWindow);
        }
        catch (Exception error) {
            LogError.invoke((Object)LogError, "[SeleniumUtils] ModalDialoge/Tabs auslesen fehlerhaft: ! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String takeErrorScreenshotInTemp(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface, String fileName) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        TakesScreenshot screenshotObject = (TakesScreenshot)seleniumWebDriver;
        File screenShotFile = (File)screenshotObject.getScreenshotAs(OutputType.FILE);
        String tempScreenshotPath = System.getProperty("java.io.tmpdir") + File.separator + fileName + ".png";
        FileUtils.moveFile((File)screenShotFile, (File)new File(tempScreenshotPath));
        LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] INFO: Vom folgenden Fehler wurde ein Screenshot im Temp-Verzeichnis abgelegt! Datei: " + fileName + " (Pfad: " + tempScreenshotPath + ")");
        return tempScreenshotPath;
    }

    public static void takeErrorScreenshotOnDesktop(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface, String logoPath, String bankName, String fileName) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogNotifyError = externalDialogInterface.getMethod("notifyError", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        TakesScreenshot screenshotObject = (TakesScreenshot)seleniumWebDriver;
        File screenShotFile = (File)screenshotObject.getScreenshotAs(OutputType.FILE);
        String tempScreenshotPath = FileSysUtils.getUsersDesktop() + fileName + ".png";
        FileUtils.moveFile((File)screenShotFile, (File)new File(tempScreenshotPath));
        LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] INFO: Vom folgenden Fehler wurde ein Screenshot auf dem Desktop abgelegt! Datei: " + fileName + " (Pfad: " + FileSysUtils.getUsersDesktop() + ")");
        MonitorLog.invoke((Object)MonitorLog, "INFO: Vom folgenden Fehler wurde ein Screenshot auf dem Desktop abgelegt! Datei: " + fileName + " (Pfad: " + FileSysUtils.getUsersDesktop() + ")");
        DialogNotifyError.invoke((Object)DialogNotifyError, "Vom folgenden Fehler des " + bankName + "-Sync wurde ein Screenshot auf dem Desktop abgelegt!\n\nDatei:\n" + fileName + ".png\n(Pfad: " + FileSysUtils.getUsersDesktop() + ")\n\n\n(Dieses Verhalten kann in den Synchronisierungsoptionen des Kontos deaktiviert werden)", logoPath);
    }

    protected static JavascriptExecutor getDriver(WebDriver driver) {
        return (JavascriptExecutor)driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void quitBrowserDriver(WebDriver seleniumWebDriver, Class<?> externalLogger) throws Exception {
        block38: {
            Method LogError = externalLogger.getMethod("error", String.class);
            Method LogDebug = externalLogger.getMethod("debug", String.class);
            Method LogTrace = externalLogger.getMethod("trace", String.class);
            String webdriver = "webdriver";
            if (seleniumWebDriver instanceof FirefoxDriver) {
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] WebDriver-Instanz ist GeckoDriver und wird nun beendet ...");
                webdriver = "geckodriver";
            } else if (seleniumWebDriver instanceof ChromeDriver) {
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] WebDriver-Instanz ist ChromeDriver und wird nun beendet ...");
                webdriver = "chromedriver";
            } else if (seleniumWebDriver instanceof PhantomJSDriver) {
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] WebDriver-Instanz ist PhantomJSDriver und wird nun beendet ...");
                webdriver = "phantomjs";
            }
            try {
                seleniumWebDriver.close();
            }
            catch (NullPointerException nullerror) {
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] Keine WebDriver-Instanz zum schlie\u00dfen vorhanden! (NullPointerException)");
            }
            catch (Exception error) {
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] WebDriver schlie\u00dfen ausgef\u00fchrt mit Fehlern, wohl bereits sauber beendet. => " + error.getMessage());
            }
            seleniumWebDriver.quit();
            LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] Noch laufende WebDriver killen...");
            String osname = System.getProperty("os.name");
            String osarch = System.getProperty("os.arch");
            LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] OS-Info: " + osname + " " + osarch);
            try {
                String line;
                String[] cmd;
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.redirectInput();
                builder.redirectOutput();
                builder.redirectErrorStream(true);
                if (osname.contains("Win")) {
                    cmd = new String[]{"cmd", "/c", "taskkill", "/f", "/im", webdriver + ".exe"};
                    builder.command(cmd);
                } else {
                    cmd = new String[]{"killall", "-v", webdriver};
                    builder.command(cmd);
                }
                Process process = builder.start();
                LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command-Object: " + process.toString());
                LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command InputStream: " + process.getInputStream().toString());
                InputStream is = process.getInputStream();
                InputStreamReader r = new InputStreamReader(is);
                BufferedReader in = new BufferedReader(r);
                String output = "";
                int linerun = 0;
                while ((line = in.readLine()) != null) {
                    if (++linerun > 1) {
                        output = output + "\n";
                    }
                    output = output + line;
                }
                in.close();
                LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command Input/Output/Error: " + output);
            }
            catch (Exception error) {
                LogError.invoke((Object)LogError, "[SeleniumUtils] WebDriver Task-Kill fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            break block38;
            catch (NullPointerException nullerror) {
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] Keine WebDriver-Instanz zum beenden vorhanden. (NullPointerException)");
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] Noch laufende WebDriver killen...");
                osname = System.getProperty("os.name");
                osarch = System.getProperty("os.arch");
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] OS-Info: " + osname + " " + osarch);
                try {
                    String line;
                    String[] cmd;
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    builder.redirectInput();
                    builder.redirectOutput();
                    builder.redirectErrorStream(true);
                    if (osname.contains("Win")) {
                        cmd = new String[]{"cmd", "/c", "taskkill", "/f", "/im", webdriver + ".exe"};
                        builder.command(cmd);
                    } else {
                        cmd = new String[]{"killall", "-v", webdriver};
                        builder.command(cmd);
                    }
                    Process process = builder.start();
                    LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command-Object: " + process.toString());
                    LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command InputStream: " + process.getInputStream().toString());
                    InputStream is = process.getInputStream();
                    InputStreamReader r = new InputStreamReader(is);
                    BufferedReader in = new BufferedReader(r);
                    String output = "";
                    int linerun = 0;
                    while ((line = in.readLine()) != null) {
                        if (++linerun > 1) {
                            output = output + "\n";
                        }
                        output = output + line;
                    }
                    in.close();
                    LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command Input/Output/Error: " + output);
                }
                catch (Exception error) {
                    LogError.invoke((Object)LogError, "[SeleniumUtils] WebDriver Task-Kill fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            catch (Exception error) {
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] WebDriver beenden nicht durchgef\u00fchrt, wohl bereits sauber beendet. => " + error.getMessage());
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] Noch laufende WebDriver killen...");
                osname = System.getProperty("os.name");
                osarch = System.getProperty("os.arch");
                LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] OS-Info: " + osname + " " + osarch);
                try {
                    String line;
                    String[] cmd;
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    builder.redirectInput();
                    builder.redirectOutput();
                    builder.redirectErrorStream(true);
                    if (osname.contains("Win")) {
                        cmd = new String[]{"cmd", "/c", "taskkill", "/f", "/im", webdriver + ".exe"};
                        builder.command(cmd);
                    } else {
                        cmd = new String[]{"killall", "-v", webdriver};
                        builder.command(cmd);
                    }
                    Process process = builder.start();
                    LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command-Object: " + process.toString());
                    LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command InputStream: " + process.getInputStream().toString());
                    InputStream is = process.getInputStream();
                    InputStreamReader r = new InputStreamReader(is);
                    BufferedReader in = new BufferedReader(r);
                    String output = "";
                    int linerun = 0;
                    while ((line = in.readLine()) != null) {
                        if (++linerun > 1) {
                            output = output + "\n";
                        }
                        output = output + line;
                    }
                    in.close();
                    LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command Input/Output/Error: " + output);
                }
                catch (Exception error2) {
                    LogError.invoke((Object)LogError, "[SeleniumUtils] WebDriver Task-Kill fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error2));
                }
                {
                    catch (Throwable throwable) {
                        LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] Noch laufende WebDriver killen...");
                        String osname2 = System.getProperty("os.name");
                        String osarch2 = System.getProperty("os.arch");
                        LogDebug.invoke((Object)LogDebug, "[SeleniumUtils] OS-Info: " + osname2 + " " + osarch2);
                        try {
                            String line;
                            String[] cmd;
                            ProcessBuilder builder = new ProcessBuilder(new String[0]);
                            builder.redirectInput();
                            builder.redirectOutput();
                            builder.redirectErrorStream(true);
                            if (osname2.contains("Win")) {
                                cmd = new String[]{"cmd", "/c", "taskkill", "/f", "/im", webdriver + ".exe"};
                                builder.command(cmd);
                            } else {
                                cmd = new String[]{"killall", "-v", webdriver};
                                builder.command(cmd);
                            }
                            Process process = builder.start();
                            LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command-Object: " + process.toString());
                            LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command InputStream: " + process.getInputStream().toString());
                            InputStream is = process.getInputStream();
                            InputStreamReader r = new InputStreamReader(is);
                            BufferedReader in = new BufferedReader(r);
                            String output = "";
                            int linerun = 0;
                            while ((line = in.readLine()) != null) {
                                if (++linerun > 1) {
                                    output = output + "\n";
                                }
                                output = output + line;
                            }
                            in.close();
                            LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Command Input/Output/Error: " + output);
                        }
                        catch (Exception error3) {
                            LogError.invoke((Object)LogError, "[SeleniumUtils] WebDriver Task-Kill fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error3));
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public static void showFormatedListOfAllWebElementsInLog(WebDriver seleniumWebDriver, String xpathForElements, Class<?> externalLogger) throws Exception {
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        List allElements = seleniumWebDriver.findElements(By.xpath((String)xpathForElements));
        DecimalFormat df = new DecimalFormat("0000");
        String logListe = new String();
        for (int i = 0; i < allElements.size(); ++i) {
            logListe = logListe + "\n| " + df.format(i) + " |  outerHTML:: " + ((WebElement)allElements.get(i)).getAttribute("outerHTML") + " |  innerHTML:: " + ((WebElement)allElements.get(i)).getAttribute("innerHTML") + " |  getText (shrinked):: " + StringCharUtils.shrinkString(((WebElement)allElements.get(i)).getText());
        }
        LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Liste aller WebElemente die dem xPath entsprechen:" + logListe);
    }

    public static void showSortedListOfTextOfAllWebElements(WebDriver seleniumWebDriver, String xpathForElements, boolean reverseSort, Class<?> externalLogger) throws Exception {
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        List allElements = seleniumWebDriver.findElements(By.xpath((String)xpathForElements));
        DecimalFormat df = new DecimalFormat("0000");
        String logListe = new String();
        ArrayList<String> obtainedList = new ArrayList<String>();
        for (Object we : allElements) {
            obtainedList.add(we.getText());
        }
        ArrayList<String> sortedList = new ArrayList<String>();
        for (String s : obtainedList) {
            sortedList.add(s);
        }
        Collections.sort(sortedList);
        if (reverseSort) {
            Collections.reverse(sortedList);
        }
        for (int i = 0; i < sortedList.size(); ++i) {
            logListe = logListe + "\n| " + df.format(i) + " |  " + StringCharUtils.shrinkString((String)sortedList.get(i));
        }
        LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Liste aller WebElemente-Texte die dem xPath entsprechen (sortiert):" + logListe);
    }

    public static ArrayList<String> getSortedDatesAsStringOfAllWebElements(WebDriver seleniumWebDriver, String xpathForElements, String dateRegex, boolean reverseSort, Class<?> externalLogger) throws Exception {
        int i;
        int i2;
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        List allElements = seleniumWebDriver.findElements(By.xpath((String)xpathForElements));
        ArrayList<String> originalDateTextList = new ArrayList<String>();
        ArrayList<String> correctDateTextList = new ArrayList<String>();
        DecimalFormat df2 = new DecimalFormat("00");
        DecimalFormat df4 = new DecimalFormat("0000");
        String logListe = new String();
        for (Object we : allElements) {
            String elementText = we.getText();
            LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Linktext der nun nach Datum durchsucht wird:" + elementText);
            Pattern datumsMuster = Pattern.compile(dateRegex);
            Matcher datumsSuche = datumsMuster.matcher(elementText);
            datumsSuche.find();
            LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Search-Matcher: " + datumsSuche);
            originalDateTextList.add(datumsSuche.group(0));
            String[] datumArray = datumsSuche.group(0).split("\\.");
            correctDateTextList.add(datumArray[2] + df2.format(Integer.valueOf(datumArray[1])) + df2.format(Integer.valueOf(datumArray[0])));
        }
        logListe = "";
        for (i2 = 0; i2 < originalDateTextList.size(); ++i2) {
            logListe = logListe + "\n| " + df4.format(i2) + " |  " + StringCharUtils.shrinkString((String)originalDateTextList.get(i2));
        }
        LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Liste aller ausgelesenen Datum-Texte in WebElemente-Texte dem xPath entsprechen (im Original):" + logListe);
        logListe = "";
        for (i2 = 0; i2 < correctDateTextList.size(); ++i2) {
            logListe = logListe + "\n| " + df4.format(i2) + " |  " + StringCharUtils.shrinkString((String)correctDateTextList.get(i2));
        }
        LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Liste aller ausgelesenen Datum-Texte in WebElemente-Texte dem xPath entsprechen (neu formatiert):" + logListe);
        ArrayList<String> sortedList = new ArrayList<String>();
        for (String s : correctDateTextList) {
            sortedList.add(s);
        }
        Collections.sort(sortedList);
        for (i = 0; i < sortedList.size(); ++i) {
            for (int x = 0; x < correctDateTextList.size(); ++x) {
                sortedList.set(i, ((String)sortedList.get(i)).replaceAll((String)correctDateTextList.get(x), (String)originalDateTextList.get(x)));
            }
        }
        if (reverseSort) {
            Collections.reverse(sortedList);
        }
        logListe = "";
        for (i = 0; i < sortedList.size(); ++i) {
            logListe = logListe + "\n| " + df4.format(i) + " |  " + StringCharUtils.shrinkString((String)sortedList.get(i));
        }
        LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Liste aller ausgelesenen Datum-Texte in WebElemente-Texte dem xPath entsprechen (sortiert):" + logListe);
        return sortedList;
    }

    public static String getFormatedListOfAllWebElements(WebDriver seleniumWebDriver, String xpathForElements, Class<?> externalLogger) throws Exception {
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        List allButtons = seleniumWebDriver.findElements(By.xpath((String)xpathForElements));
        DecimalFormat df = new DecimalFormat("0000");
        String logListe = new String();
        for (int i = 0; i < allButtons.size(); ++i) {
            logListe = logListe + "\n| " + df.format(i) + " |  outerHTML:: " + ((WebElement)allButtons.get(i)).getAttribute("outerHTML") + " |  innerHTML:: " + ((WebElement)allButtons.get(i)).getAttribute("innerHTML") + " |  getText (shrinked):: " + StringCharUtils.shrinkString(((WebElement)allButtons.get(i)).getText());
        }
        LogTrace.invoke((Object)LogTrace, "[SeleniumUtils] Liste aller WebElemente die dem xPath entsprechen:" + logListe);
        return logListe;
    }

    public static void clickElementHandleErrors(WebDriver seleniumWebDriver, String elementName, String xPath, String loaderCatchString, String loaderExclusion, String loaderPath, String loadingText, boolean loaderCritIsElement, Class<?> externalLogger) throws NoSuchElementException, TimeoutException, Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[clickErrorHandle] ";
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(15L));
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        boolean isSelfException = false;
        WebElement thisElement = null;
        LogDebug.invoke((Object)LogDebug, getLogMethod + "click " + elementName + ": " + xPath);
        try {
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)xPath)));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new NoSuchElementException("element '" + elementName + "' not found: " + ExceptionUtils.getStackTrace((Throwable)notFounderr));
            }
            boolean clickSuccessful = false;
            boolean clickCanceled = false;
            int round = 1;
            do {
                Actions actions;
                try {
                    thisElement = seleniumWebDriver.findElement(By.xpath((String)xPath));
                    wait1.until((Function)ExpectedConditions.elementToBeClickable((WebElement)thisElement));
                    thisElement.click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, loaderPath, loadingText, loaderCritIsElement, externalLogger);
                    Thread.sleep(500L);
                    clickSuccessful = true;
                }
                catch (ElementClickInterceptedException clickError) {
                    if (clickError.getMessage().contains(loaderCatchString) || clickError.getMessage().contains("bb-notification--success")) {
                        LogTrace.invoke((Object)LogTrace, getLogMethod + "{ElementClickInterceptedException} element '" + elementName + "' miss, loader catch the click: " + clickError.getMessage().split("\\R", 2)[0]);
                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, loaderPath, loadingText, loaderCritIsElement, externalLogger);
                        Thread.sleep(1000L);
                    }
                    if (clickError.getMessage().contains(loaderExclusion)) {
                        LogTrace.invoke((Object)LogTrace, getLogMethod + "{ElementClickInterceptedException} element '" + elementName + "' miss, error-Overlay catch the click: " + clickError.getMessage().split("\\R", 2)[0]);
                        clickCanceled = true;
                        break;
                    }
                    if (clickError.getMessage().contains("element click intercepted: Element is not clickable at point")) {
                        LogTrace.invoke((Object)LogTrace, getLogMethod + "{ElementClickInterceptedException} element '" + elementName + "' click intercepted: Element is not clickable at point -> versuche 'Scroll Element to Middle und Action-Click' als Alternative ...");
                        SeleniumUtils.scrollElementInMiddleOfScreen(seleniumWebDriver, xPath);
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, loaderPath, loadingText, loaderCritIsElement, externalLogger);
                        Thread.sleep(250L);
                        actions = new Actions(seleniumWebDriver);
                        thisElement = seleniumWebDriver.findElement(By.xpath((String)xPath));
                        actions.moveToElement(thisElement).click().build().perform();
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, loaderPath, loadingText, loaderCritIsElement, externalLogger);
                        clickSuccessful = true;
                    }
                    LogTrace.invoke((Object)LogTrace, getLogMethod + "{ElementClickInterceptedException} element '" + elementName + "' miss the click: " + clickError.getMessage().split("\\R", 2)[0] + "\nwith this outerHTML:\n");
                    isSelfException = true;
                    throw new Exception("{ElementClickInterceptedException} element '" + elementName + "' miss the click: " + ExceptionUtils.getStackTrace((Throwable)clickError));
                }
                catch (TimeoutException timeoutError) {
                    if (timeoutError.getMessage().contains("waiting for element to be clickable") && round != 2 && round != 4 && round != 6 && round != 8 && round != 10) {
                        LogTrace.invoke((Object)LogTrace, getLogMethod + "{TimeoutException} element '" + elementName + "' not clickable at this time: " + timeoutError.getMessage());
                        thisElement = seleniumWebDriver.findElement(By.xpath((String)xPath));
                    } else if (round == 2 || round == 4 || round == 6 || round == 8 || round == 10) {
                        LogTrace.invoke((Object)LogTrace, getLogMethod + "{TimeoutException} element '" + elementName + "' not clickable at this time: Expected condition failed: waiting for element to be clickable ->  Versuch #" + round + ": wende 'action' als Alternative an...");
                        actions = new Actions(seleniumWebDriver);
                        thisElement = seleniumWebDriver.findElement(By.xpath((String)xPath));
                        actions.moveToElement(thisElement).click().build().perform();
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, loaderPath, loadingText, loaderCritIsElement, externalLogger);
                        Thread.sleep(250L);
                        clickSuccessful = true;
                    } else if (!timeoutError.getMessage().contains("waiting for element to be clickable")) {
                        isSelfException = true;
                        throw new Exception("{TimeoutException}SELF element '" + elementName + "' click-timeout: " + ExceptionUtils.getStackTrace((Throwable)timeoutError));
                    }
                }
                catch (StaleElementReferenceException statleError) {
                    try {
                        LogTrace.invoke((Object)LogTrace, getLogMethod + "... reagiere auf {StaleElementReferenceException} element '" + elementName + "'...");
                        thisElement = seleniumWebDriver.findElement(By.xpath((String)xPath));
                    }
                    catch (NoSuchElementException notFound) {
                        LogTrace.invoke((Object)LogTrace, getLogMethod + "{StaleElementReferenceException} element '" + elementName + "'Element nicht mehr gefunden nach StaleElementReferenceException...");
                        clickCanceled = true;
                        break;
                    }
                }
                catch (NoSuchElementException notFound) {
                    LogTrace.invoke((Object)LogTrace, getLogMethod + "{NoSuchElementException} element '" + elementName + "'Element nicht mehr gefunden... breche ab... eventuell Folgefehler...");
                    clickCanceled = true;
                    break;
                }
                catch (ElementNotInteractableException notClickable) {
                    throw new ElementNotInteractableException("Element not clickable, maybe a shadow-twin was selected: " + notClickable.getMessage());
                }
                if (round > 60) {
                    isSelfException = true;
                    throw new Exception("element '" + elementName + "' round-timeout for click on the element");
                }
                ++round;
            } while (!clickSuccessful);
            if (clickCanceled) {
                LogDebug.invoke((Object)LogDebug, getLogMethod + "clicking on element '" + elementName + "' was canceled. now you have to check the page for errors...");
                seleniumWebDriver.switchTo().defaultContent();
            } else {
                LogDebug.invoke((Object)LogDebug, getLogMethod + "clicking on element '" + elementName + "' was successfully. now wait for loading...");
                seleniumWebDriver.switchTo().defaultContent();
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, loaderPath, loadingText, loaderCritIsElement, externalLogger);
            }
        }
        catch (ElementNotInteractableException notClickable) {
            throw new ElementNotInteractableException(notClickable.getMessage());
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static void waitForPageLoading(WebDriver seleniumWebDriver, String xPath, String loadingText, boolean isElementSearch, Class<?> externalLogger) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[waitForPageLoading] ";
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        int waitCyclus = 0;
        int currentloaderRound = 0;
        do {
            try {
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                if (StringCharUtils.isNullOrEmptyOrNothing(xPath)) {
                    xPath = "//div[contains(@class,'LoadingOverlay') or contains(@class,'pageLoader') and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
                }
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)xPath)));
                WebElement loaderElement = (WebElement)seleniumWebDriver.findElements(By.xpath((String)xPath)).get(0);
                String loaderElementText = "DummyText";
                try {
                    loaderElementText = StringCharUtils.shrinkString(loaderElement.getText());
                }
                catch (Exception error) {
                    LogError.invoke((Object)LogError, LogIdent + getLogMethod + "Text des Loaders nicht lesbar: " + error.getMessage());
                }
                if (!isElementSearch && loaderElementText.contains(loadingText) || isElementSearch) {
                    LogTrace.invoke((Object)LogTrace, LogIdent + getLogMethod + "xPath und/oder Text von Loader-Animation gefunden, fokusiere Loader und warte eine Sekunde ...");
                    SeleniumUtils.scrollElementInMiddleOfScreen(seleniumWebDriver, xPath);
                    Thread.sleep(1000L);
                    ++waitCyclus;
                    if (++currentloaderRound < 5) continue;
                    JavascriptExecutor js = (JavascriptExecutor)seleniumWebDriver;
                    LogTrace.invoke((Object)LogTrace, LogIdent + getLogMethod + "scroll up to restart the scroll-down action, because the time to load looks like the load is hang...");
                    js.executeScript("window.scrollTo(0, 0)", new Object[0]);
                    Thread.sleep(2000L);
                    currentloaderRound = 0;
                    continue;
                }
                LogDebug.invoke((Object)LogDebug, LogIdent + getLogMethod + "Warte-Text in xPath nicht (mehr) gefunden, Laden ist wohl beendet (Lade-Dauer: ca. " + waitCyclus + " Sek.)");
            }
            catch (IndexOutOfBoundsException | NoSuchElementException | TimeoutException notFounderr) {
                LogDebug.invoke((Object)LogDebug, LogIdent + getLogMethod + "Loader-xPath not found, Laden ist wohl beendet (Lade-Dauer: ca. " + waitCyclus + " Sek.) :: " + notFounderr.getMessage());
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            break;
        } while (waitCyclus < 60);
    }

    public static void waitForWindow(WebDriver seleniumWebDriver, Class<?> externalLogger) throws InterruptedException {
        int timecount = 1;
        do {
            seleniumWebDriver.getWindowHandles();
            Thread.sleep(200L);
        } while (++timecount <= 30 && seleniumWebDriver.getWindowHandles().size() != 2);
    }

    public static void switchToModalDialog(WebDriver seleniumWebDriver, String parent, Class<?> externalLogger) {
        if (seleniumWebDriver.getWindowHandles().size() == 2) {
            for (String window : seleniumWebDriver.getWindowHandles()) {
                if (window.equals(parent)) continue;
                seleniumWebDriver.switchTo().window(window);
                System.out.println("Modal dialog found");
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeCookieLaw(WebDriver seleniumWebDriver, String logIdent, String longName, String logo, String cookieDetectPath, String cookieAcceptPath, String loaderCatchString, String loaderExclusion, String loaderPath, String loaderText, Class<?> externalLogger) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        logIdent = logIdent + LogIdent;
        String getLogMethod = "[closeCookieLaw] ";
        boolean isSelfException = false;
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        WebDriverWait wait7 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(7L));
        boolean isClosed = false;
        int round = 1;
        WebElement submitButton = null;
        String iframeID = null;
        int shadowCount = cookieDetectPath.split(",").length - 1;
        String[] shadowHostPath = new String[shadowCount];
        String shadowContentPath = null;
        WebElement[] shadowHost = new WebElement[shadowCount];
        Object javascriptExecutor = null;
        SearchContext shadowRoot = null;
        WebElement shadowContent = null;
        do {
            try {
                if (cookieDetectPath.startsWith("iframe")) {
                    iframeID = cookieDetectPath.split(":")[1];
                    wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)iframeID)));
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Cookie-Law im iFrame gefunden das nun geschlossen werden soll...");
                    seleniumWebDriver.switchTo().frame(iframeID);
                    wait7.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)cookieAcceptPath)));
                    submitButton = seleniumWebDriver.findElement(By.xpath((String)cookieAcceptPath));
                } else if (cookieDetectPath.startsWith("//")) {
                    wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)cookieDetectPath)));
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Cookie-Law mit xPath gefunden das nun geschlossen werden soll...");
                } else {
                    String cookieCssPath = cookieDetectPath;
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "shadowCount: " + shadowCount);
                    if (cookieDetectPath.contains("###")) {
                        cookieCssPath = cookieDetectPath.replace("###", "");
                    }
                    for (int shadow = 0; shadow < shadowCount; ++shadow) {
                        shadowHostPath[shadow] = cookieCssPath.split(",")[shadow];
                        LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "shadowHostPath: " + shadowHostPath);
                        if (shadow == 0) {
                            wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)shadowHostPath[shadow])));
                            shadowHost[shadow] = seleniumWebDriver.findElement(By.cssSelector((String)shadowHostPath[shadow]));
                        } else {
                            try {
                                shadowHost[shadow] = shadowRoot.findElement(By.cssSelector((String)shadowHostPath[shadow]));
                            }
                            catch (NoSuchElementException notFind) {
                                int rounds = 0;
                                do {
                                    Thread.sleep(1000L);
                                    try {
                                        shadowHost[shadow] = shadowRoot.findElement(By.cssSelector((String)shadowHostPath[shadow]));
                                    }
                                    catch (NoSuchElementException notFindNext) {
                                        shadowHost[shadow] = null;
                                    }
                                } while (shadowContent == null && ++rounds < 3);
                            }
                        }
                        LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "Cookie-Law shadowHost#" + shadow + ":\n" + shadowHost[shadow].getAttribute("outerHTML"));
                        if (shadowHost[shadow] != null) {
                            shadowRoot = shadowHost[shadow].getShadowRoot();
                            LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "Cookie-Law shadowRoot: " + shadowRoot);
                            continue;
                        }
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Kein Cookie-Law gefunden das geschlossen werden konnte: shadowHost" + shadow + "  = null");
                        isClosed = true;
                        break;
                    }
                    if (shadowRoot == null) {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Kein Cookie-Law gefunden das geschlossen werden konnte: shadowRoot = null");
                        return;
                    }
                    shadowContentPath = cookieCssPath.split(",")[shadowCount];
                    LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "shadowContentPath: " + shadowContentPath);
                    int rounds = 0;
                    do {
                        Thread.sleep(500L);
                        try {
                            shadowContent = shadowRoot.findElement(By.cssSelector((String)shadowContentPath));
                        }
                        catch (NoSuchElementException notFind) {
                            shadowContent = null;
                        }
                    } while (shadowContent == null && ++rounds < 3);
                    LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "Cookie-Law shadowContent:\n" + shadowContent.getAttribute("outerHTML"));
                    if (shadowContent == null) {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Kein Cookie-Law gefunden das geschlossen werden konnte: shadowContent = null;");
                        return;
                    }
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Cookie-Law mit CSS gefunden das nun geschlossen werden soll...");
                    submitButton = cookieAcceptPath.equals("*") ? shadowContent : shadowContent.findElement(By.cssSelector((String)cookieAcceptPath));
                }
                try {
                    if (cookieDetectPath.startsWith("//") || cookieDetectPath.startsWith("iframe")) {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "acceptCookies", cookieAcceptPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    } else {
                        try {
                            submitButton.click();
                            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        }
                        catch (ElementClickInterceptedException clickIntercept) {
                            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "ElementClickInterceptedException: " + clickIntercept.getMessage().split("\n")[0]);
                            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Klicke shadowContent als Alternative...");
                            shadowContent.click();
                        }
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    }
                    Thread.sleep(1500L);
                    try {
                        if (cookieDetectPath.startsWith("//") || cookieDetectPath.startsWith("iframe")) {
                            seleniumWebDriver.findElement(By.xpath((String)cookieDetectPath));
                        } else {
                            shadowRoot.findElement(By.cssSelector((String)shadowContentPath));
                        }
                        if (round >= 5) {
                            isSelfException = true;
                            throw new Exception("Klick hat auch nach 5 Versuchen nicht gewirkt?!");
                        }
                        ++round;
                    }
                    catch (NoSuchElementException notFind) {
                        return;
                    }
                }
                catch (Exception error) {
                    if (error.getMessage().contains("detached shadow root")) return;
                    if (error.getMessage().contains("contains unresolvable namespaces")) {
                        return;
                    }
                    if (isSelfException) {
                        throw new Exception("Cookie-Law konnte nicht geschlossen werden: " + error.getMessage());
                    }
                    isSelfException = true;
                    throw new Exception("Cookie-Law konnte nicht geschlossen werden: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            catch (TimeoutException noCookieLawAfterWait) {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Kein Cookie-Law gefunden das geschlossen werden konnte: wait timeout (TimeoutException): " + noCookieLawAfterWait.getMessage().split("\n")[0]);
                return;
            }
            catch (NoSuchElementException noElement) {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Cookie-Law oder Element nicht gefunden (NoSuchElementException): " + noElement.getMessage().split("\n")[0]);
                return;
            }
            catch (Exception error) {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Cookie-Law  konnte nicht geschlossen werden: " + ExceptionUtils.getStackTrace((Throwable)error));
                return;
            }
        } while (!isClosed);
    }

    public static void checkSecBorderBuster(WebDriver seleniumWebDriver, String logIdent, String longName, String logo, String loaderCatchString, String loaderExclusion, String loaderPath, String loaderText, Class<?> externalLogger) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        logIdent = logIdent + LogIdent;
        String getLogMethod = "[checkSecBorderBuster] ";
        boolean isSelfException = false;
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        WebDriverWait wait15 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(15L));
        try {
            String reCaptchaDetect = "//iframe[@title='reCAPTCHA']";
            String reCaptchaCheckboxPath = "//span[contains(@class,'recaptcha-checkbox')]";
            wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)reCaptchaDetect)));
            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Security-Border erkannt, starte Challange ...");
            WebElement reCaptchaFrame = seleniumWebDriver.findElement(By.xpath((String)reCaptchaDetect));
            seleniumWebDriver.switchTo().frame(reCaptchaFrame.getAttribute("name"));
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "startChallangeCheckbox", reCaptchaCheckboxPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            boolean callangeToDo = true;
            int challangeRound = 1;
            do {
                try {
                    String reCaptchaChallengeDetect = "//iframe[contains(@title,'recaptcha challenge')]";
                    wait15.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)reCaptchaChallengeDetect)));
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Sicherheits-Challange erkannt, starte Buster ...");
                    Thread.sleep(2000L);
                    WebElement reCaptchaChallengeFrame = seleniumWebDriver.findElement(By.xpath((String)reCaptchaChallengeDetect));
                    seleniumWebDriver.switchTo().frame(reCaptchaChallengeFrame.getAttribute("name"));
                }
                catch (NoSuchElementException | TimeoutException waiterror) {
                    if (challangeRound == 1) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: Sicherheitsaufgabe nach Aufruf nicht erkannt?! " + waiterror.getMessage());
                    }
                    callangeToDo = false;
                    break;
                }
                try {
                    Thread.sleep(500L);
                    String helpShadowPath = "//div[contains(@class,'help-button-holder')]";
                    wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)helpShadowPath)));
                    WebElement helpShadow = seleniumWebDriver.findElement(By.xpath((String)helpShadowPath));
                    helpShadow.click();
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Challange-Buster click #" + challangeRound + " done, wait...");
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    ++challangeRound;
                    Thread.sleep(4000L);
                }
                catch (ElementClickInterceptedException clickerror) {
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)reCaptchaDetect));
                        LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "Security-Border ist wohl noch am schlie\u00dfen ...");
                    }
                    catch (NoSuchElementException | TimeoutException waiterror) {
                        callangeToDo = false;
                    }
                }
                catch (NoSuchElementException | TimeoutException waiterror) {
                    if (challangeRound == 1) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: Sicherheitsaufgabe erkannt, aktivieren Sie eine Erweiterung zum Erledigen");
                    }
                    callangeToDo = false;
                }
                if (challangeRound > 15) {
                    throw new Exception("WebDriver-Fehler: Sicherheitsaufgabe nach 15 Versuchen ungel\u00f6st. Bitte versuchen Sie es nochmals");
                }
                seleniumWebDriver.switchTo().defaultContent();
            } while (callangeToDo);
        }
        catch (NoSuchElementException | TimeoutException throwable) {
            // empty catch block
        }
    }

    public static String checkWebDriverResponse(String responsePageAsString, WebDriver seleniumWebDriver, String logIdent, String longName, String logo, String[] xpathSearchArray, String[] xpathSearchArrayExclusion, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        logIdent = logIdent + LogIdent;
        String getLogMethod = "[checkWebDriverResponse] ";
        boolean isSelfException = false;
        try {
            LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "Funktion 'StringCharUtils.checkWebDriverResponse' wurde aufgerufen...");
            xpathSearchString = xpathSearchArray;
            xpathSearchStringExclusion = xpathSearchArrayExclusion;
            WebElement xPathResultElement = null;
            String xPathResult = null;
            String xpathSearchRun = null;
            try {
                for (String searchString : xpathSearchString) {
                    try {
                        xPathResultElement = seleniumWebDriver.findElement(By.xpath((String)searchString));
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundene xPathExpression: " + searchString);
                        xPathResult = xPathResultElement.getText();
                        boolean isReal = true;
                        if (StringCharUtils.isNullOrEmptyOrNothing(xPathResult)) {
                            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "diese xPathExpression ist aber beim Auslesen mit Selenium leer und liefert keinen Text ... versuche noch alternativ den CSS-InnerHTML ...");
                            xPathResult = xPathResultElement.getAttribute("innerHTML");
                            xPathResult = xPathResult.replaceAll("\\<.*?\\>", "").trim();
                            if (StringCharUtils.isNullOrEmptyOrNothing(xPathResult)) {
                                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "diese xPathExpression ist aber scheinbar wirklich leer und liefert keinen Text ...");
                                isReal = false;
                            } else {
                                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "diese xPathExpression enth\u00e4lt den innerHTML (ohne HTML-Tags!) also nur Text: " + xPathResult);
                            }
                        }
                        if (!StringCharUtils.isNullOrEmptyOrNothing(xPathResult)) {
                            for (String searchExclusionString : xpathSearchStringExclusion) {
                                if (!xPathResult.contains(searchExclusionString)) continue;
                                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "diese xPathExpression enth\u00e4lt aber folgende Ausnahme: " + searchExclusionString);
                                isReal = false;
                            }
                        }
                        if (!isReal) continue;
                        xpathSearchRun = searchString;
                        break;
                    }
                    catch (NoSuchElementException | TimeoutException notFounderr) {
                        LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "xPathExpression '" + searchString + "' ergab kein Ergebnis");
                    }
                }
            }
            catch (Exception notFounderr) {
                isSelfException = true;
                throw new Exception("xPath-Suche fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)notFounderr));
            }
            if (xpathSearchRun != null) {
                String formatedMessageText;
                try {
                    formatedMessageText = StringCharUtils.formMessageText(logIdent + getLogMethod, xPathResult, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error);
                }
                String xPathResultHTML = xPathResultElement.getAttribute("outerHTML");
                LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "xPathExpressions outerHTML: " + xPathResultHTML);
                if (!(!xPathResultHTML.contains("info") && !xPathResultHTML.contains("Info") && !xpathSearchRun.contains("info") && !xpathSearchRun.contains("Info") || xPathResultHTML.contains("class=\"screeninfo\"") || xPathResultHTML.contains("error") || xPathResultHTML.contains("Error") || xpathSearchRun.contains("error") || xpathSearchRun.contains("Error") || xPathResultHTML.contains("alert-danger") || xPathResultHTML.contains("alert-icon") || xPathResultHTML.contains("alert-warn") || xPathResultHTML.contains("aufgrund von Systemarbeiten"))) {
                    LogInfo.invoke((Object)LogInfo, logIdent + getLogMethod + "Informations-Nachricht der " + longName + ": " + formatedMessageText);
                    MonitorLog.invoke((Object)MonitorLog, "Informations-Nachricht der " + longName + ": " + formatedMessageText);
                    return null;
                }
                if (!(!xPathResultHTML.contains("warn") && !xPathResultHTML.contains("Warn") && !xpathSearchRun.contains("warn") && !xpathSearchRun.contains("Warn") && !xPathResultHTML.contains("exclamationMark") && !xPathResultHTML.contains("Ohne ausreichend Guthaben") && !xPathResultHTML.contains("servicebanner") || xPathResultHTML.contains("error") || xPathResultHTML.contains("Error") || xPathResultHTML.contains("ERROR") || xpathSearchRun.contains("error") || xpathSearchRun.contains("Error") || xPathResultHTML.contains("iconWarning") || xpathSearchRun.contains("iconWarning") || xPathResultHTML.contains("alert-danger") || xPathResultHTML.contains("alert-icon") || xPathResultHTML.contains("alert-warn"))) {
                    LogWarn.invoke((Object)LogWarn, logIdent + getLogMethod + "Warnungs-Nachricht der " + longName + ": " + formatedMessageText);
                    MonitorLog.invoke((Object)MonitorLog, "Warnungs-Nachricht der " + longName + ": " + formatedMessageText);
                    return null;
                }
                if (xPathResultHTML.contains(" hidden") || xPathResultHTML.contains(" Hidden")) {
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "dieses xPathResultHTML enth\u00e4lt aber folgende Attribute-Ausnahme: hidden");
                    return null;
                }
                DialogError.invoke((Object)DialogError, "Fehlermeldung von " + longName + ":\n\n\n" + formatedMessageText, logo);
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + formatedMessageText);
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkWebDriverResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String downloadStatementAndConvert(WebDriver seleniumWebDriver, String logIdent, String downloadButtonPath, String fileencoding, String loader_catchstring, String loader_exclustions, String loader_path, String loader_text, Class<?> externalLogger) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        logIdent = logIdent + LogIdent;
        String getLogMethod = "[downloadStatementAndConvert] ";
        boolean isSelfException = false;
        LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "Funktion 'StringCharUtils.downloadStatementAndConvert' wurde aufgerufen...");
        File downloadedFile = null;
        String doctext = null;
        String doctype = "???";
        try {
            HSSFWorkbook workbook;
            FileInputStream fis;
            boolean localTest = false;
            if (localTest) {
                String docFixTempFilePath = "C:\\Users\\richs\\Desktop\\Kontoauszug.xlsx";
                downloadedFile = new File(docFixTempFilePath);
            }
            boolean downloadedFileIsFalse = false;
            int downloadCount = 1;
            do {
                if (!localTest) {
                    WebElement downloadButton = seleniumWebDriver.findElement(By.xpath((String)downloadButtonPath));
                    JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
                    jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{downloadButton});
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadButton", downloadButtonPath, loader_catchstring, loader_exclustions, loader_path, loader_text, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                    do {
                        Thread.sleep(500L);
                        int waiter = 0;
                        do {
                            if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                            Thread.sleep(1000L);
                            ++waiter;
                        } while (downloadedFile == null && waiter < 30);
                        if (downloadedFile != null && downloadedFile.exists()) continue;
                        isSelfException = true;
                        throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                    } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                }
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                doctype = downloadedFile.getAbsolutePath().substring(downloadedFile.getAbsolutePath().lastIndexOf(".") + 1).toLowerCase();
                if (doctype.equals("txt") || doctype.equals("htm") || doctype.equals("html") || doctype.equals("asp") || doctype.equals("js")) {
                    LogWarn.invoke((Object)LogDebug, logIdent + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / Falscher Dateityp, versuche es nochmals ...");
                    ++downloadCount;
                    downloadedFileIsFalse = true;
                } else {
                    downloadedFileIsFalse = false;
                }
                if (downloadCount < 4) continue;
                isSelfException = true;
                throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert: Typ: " + doctype.toUpperCase());
            } while (downloadedFileIsFalse);
            if (doctype.equals("xls")) {
                fis = new FileInputStream(downloadedFile);
                workbook = new HSSFWorkbook((InputStream)fis);
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "[workbook " + doctype + "-FILE]: " + workbook);
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Erzeuge einen Kontoauszug aus dem " + doctype.toUpperCase() + "-Dokument ...");
                try {
                    HSSFSheet sheet = workbook.getSheetAt(0);
                    for (Row row : sheet) {
                        Iterator cellIterator = row.cellIterator();
                        while (cellIterator.hasNext()) {
                            Cell cell = (Cell)cellIterator.next();
                            doctext = doctext + StringCharUtils.shrinkString(cell.toString()) + ";";
                        }
                        doctext = doctext + "\n";
                    }
                    workbook.close();
                    fis.close();
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Beim Lesen der hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            } else if (doctype.equals("xlsx")) {
                fis = new FileInputStream(downloadedFile);
                workbook = new XSSFWorkbook((InputStream)fis);
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "[workbook " + doctype + "-FILE]: " + workbook);
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Erzeuge einen Kontoauszug aus dem " + doctype.toUpperCase() + "-Dokument ...");
                try {
                    XSSFSheet sheet = workbook.getSheetAt(0);
                    for (Row row : sheet) {
                        Iterator cellIterator = row.cellIterator();
                        while (cellIterator.hasNext()) {
                            Cell cell = (Cell)cellIterator.next();
                            doctext = doctext + StringCharUtils.shrinkString(cell.toString()) + ";";
                        }
                        doctext = doctext + "\n";
                    }
                    workbook.close();
                    fis.close();
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Beim Lesen der hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            } else if (doctype.equals("csv")) {
                String fileResponse = "";
                fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "raw-fileResponse witout file-encoding convert:\n\n====================== BEGIN RAW DATA WITH ORIGINAL ENCODING ======================\n" + fileResponse + "\n======================= END RAW DATA WITH ORIGINAL ENCODING =======================\n");
                if (!fileencoding.equals("UTF-8")) {
                    LogInfo.invoke((Object)LogInfo, logIdent + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                    byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                    doctext = new String(filebytes, System.getProperty("file.encoding"));
                } else {
                    doctext = fileResponse;
                }
            }
            if (!localTest) {
                FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
            }
            LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "getDataExport: soeben abgeholte und ausgelesener " + doctype.toUpperCase() + "-Auszug (text): \n====================== BEGIN RAW DATA ======================\n" + doctext + "\n======================= END RAW DATA =======================\n");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkWebDriverResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return doctext;
    }

    public static WebDriver fillDateRangeSearchFields(WebDriver seleniumWebDriver, String logIdent, String longName, String logo, String fromDate, String toDate, String fromDateInputPath, String toDateInputPath, String searchButtonPath, boolean closeSelector, String loaderCatchstring, String loaderExclustions, String loaderPath, String loadingText, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        logIdent = logIdent + LogIdent;
        String getLogMethod = "[fillDateRangeSearchFields] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "Funktion 'StringCharUtils.fillDateRangeSearchFields' wurde aufgerufen...");
        try {
            WebElement toDateInput;
            WebElement fromDateInput;
            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "fromDate: " + fromDate);
            try {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundenes Von-Datum Feld: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)fromDateInputPath))));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Von-Datum Feld wurde nicht gefunden.  xPathExpression " + fromDateInputPath + " ergab kein Ergebnis");
            }
            Boolean staleElement = true;
            while (staleElement.booleanValue()) {
                try {
                    fromDateInput = seleniumWebDriver.findElement(By.xpath((String)fromDateInputPath));
                    SeleniumUtils.scrollElementInMiddleOfScreen(seleniumWebDriver, fromDateInputPath);
                    fromDateInput.click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(200L);
                    staleElement = false;
                }
                catch (StaleElementReferenceException e) {
                    staleElement = true;
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Wait for staleElement: StaleElementReferenceException");
                }
            }
            staleElement = true;
            while (staleElement.booleanValue()) {
                try {
                    fromDateInput = seleniumWebDriver.findElement(By.xpath((String)fromDateInputPath));
                    fromDateInput.clear();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(100L);
                    staleElement = false;
                }
                catch (StaleElementReferenceException e) {
                    staleElement = true;
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Wait for staleElement: StaleElementReferenceException");
                }
                catch (InvalidElementStateException i) {
                    staleElement = false;
                }
            }
            staleElement = true;
            while (staleElement.booleanValue()) {
                try {
                    fromDateInput = seleniumWebDriver.findElement(By.xpath((String)fromDateInputPath));
                    new Actions(seleniumWebDriver).click(fromDateInput).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(200L);
                    staleElement = false;
                }
                catch (StaleElementReferenceException e) {
                    staleElement = true;
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Wait for staleElement: StaleElementReferenceException");
                }
            }
            staleElement = true;
            while (staleElement.booleanValue()) {
                try {
                    fromDateInput = seleniumWebDriver.findElement(By.xpath((String)fromDateInputPath));
                    fromDateInput.sendKeys(new CharSequence[]{fromDate});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(100L);
                    if (closeSelector) {
                        new Actions(seleniumWebDriver).sendKeys(new CharSequence[]{Keys.ESCAPE}).perform();
                    }
                    staleElement = false;
                }
                catch (StaleElementReferenceException e) {
                    staleElement = true;
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Wait for staleElement: StaleElementReferenceException");
                }
            }
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            Thread.sleep(500L);
            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "toDate: " + toDate);
            try {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundenes Bis-Datum Feld: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)toDateInputPath))));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Bis-Datum Feld wurde nicht gefunden.  xPathExpression " + toDateInputPath + " ergab kein Ergebnis");
            }
            staleElement = true;
            while (staleElement.booleanValue()) {
                try {
                    toDateInput = seleniumWebDriver.findElement(By.xpath((String)toDateInputPath));
                    toDateInput.click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(200L);
                    staleElement = false;
                }
                catch (StaleElementReferenceException e) {
                    staleElement = true;
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Wait for staleElement: StaleElementReferenceException");
                }
            }
            staleElement = true;
            while (staleElement.booleanValue()) {
                try {
                    toDateInput = seleniumWebDriver.findElement(By.xpath((String)toDateInputPath));
                    toDateInput.clear();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(100L);
                    staleElement = false;
                }
                catch (StaleElementReferenceException e) {
                    staleElement = true;
                }
                catch (InvalidElementStateException i) {
                    staleElement = false;
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Wait for staleElement: StaleElementReferenceException");
                }
            }
            staleElement = true;
            while (staleElement.booleanValue()) {
                try {
                    toDateInput = seleniumWebDriver.findElement(By.xpath((String)toDateInputPath));
                    new Actions(seleniumWebDriver).click(toDateInput).pause(200L).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(100L);
                    staleElement = false;
                }
                catch (StaleElementReferenceException e) {
                    staleElement = true;
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Wait for staleElement: StaleElementReferenceException");
                }
            }
            staleElement = true;
            while (staleElement.booleanValue()) {
                try {
                    toDateInput = seleniumWebDriver.findElement(By.xpath((String)toDateInputPath));
                    toDateInput.sendKeys(new CharSequence[]{toDate});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(100L);
                    if (closeSelector) {
                        new Actions(seleniumWebDriver).sendKeys(new CharSequence[]{Keys.ESCAPE}).perform();
                    }
                    staleElement = false;
                }
                catch (StaleElementReferenceException e) {
                    staleElement = true;
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Wait for staleElement: StaleElementReferenceException");
                }
            }
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            Thread.sleep(500L);
        }
        catch (Exception error) {
            isSelfException = true;
            throw new Exception("Fehler beim Setzen der Formular-Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        SeleniumUtils.scrollElementInMiddleOfScreen(seleniumWebDriver, searchButtonPath);
        try {
            seleniumWebDriver.findElement(By.xpath((String)searchButtonPath)).click();
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
        }
        catch (Exception error) {
            isSelfException = true;
            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        Thread.sleep(2000L);
        return seleniumWebDriver;
    }

    public static void scrollElementInMiddleOfScreen(WebDriver seleniumWebDriver, String elementPath) throws InterruptedException {
        int currentY;
        WebElement element = seleniumWebDriver.findElement(By.xpath((String)elementPath));
        JavascriptExecutor javaScriptExector = (JavascriptExecutor)seleniumWebDriver;
        int startY = element.getLocation().getY();
        System.out.print("element [" + elementPath + "] Start Y-Postion from Selenium: " + String.valueOf(startY) + "\n");
        int startYj = Integer.valueOf(String.valueOf(javaScriptExector.executeScript("return arguments[0].getBoundingClientRect().top;", new Object[]{element})).split("\\.")[0]);
        System.out.print("element [" + elementPath + "] Start Y-Postion from JavaScript: " + String.valueOf(startYj) + "\n");
        int round = 0;
        do {
            javaScriptExector = (JavascriptExecutor)seleniumWebDriver;
            element = seleniumWebDriver.findElement(By.xpath((String)elementPath));
            javaScriptExector.executeScript("arguments[0].scrollIntoView({\n            behavior: 'auto',\n            block: 'center',\n            inline: 'center'\n        });", new Object[]{element});
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            Thread.sleep(500L);
            element = seleniumWebDriver.findElement(By.xpath((String)elementPath));
            currentY = element.getLocation().getY();
            System.out.print("element [" + elementPath + "] current Y-Postion from Selenium: " + currentY + "\n");
            int currentYj = Integer.valueOf(String.valueOf(javaScriptExector.executeScript("return arguments[0].getBoundingClientRect().top;", new Object[]{element})).split("\\.")[0]);
            System.out.print("element [" + elementPath + "] current Y-Postion from JavaScript: " + currentYj + "\n");
            if (startY != currentY || startY == currentYj || startYj == currentYj) continue;
            currentY = currentYj;
            System.out.print("current corrected Y-Postion of element  [" + elementPath + "]: " + currentY + "\n");
        } while (++round < 5 && currentY == startY);
    }

    public static void checkAndCloseInfoMessage(WebDriver seleniumWebDriver, String logident, String longName, String loginUrl, String logoPath, String detectPath, String messagePath, String closePath, String lOADER_CATCHSTRING, String lOADER_EXCLUSIONS, String lOADER_PATH, String lOADER_TEXT, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        boolean isSelfException = false;
        WebDriverWait wait2 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        try {
            boolean hasAbortButton = false;
            do {
                LogInfo.invoke((Object)LogInfo, logident + "Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPath)));
                LogDebug.invoke((Object)LogDebug, logident + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                String formWarnText = "";
                List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)messagePath));
                for (WebElement headline : allHeadlines) {
                    String headlinetext = headline.getText();
                    formWarnText = formWarnText + StringCharUtils.formMessageText(logident, headlinetext, externalLogger) + " ";
                }
                LogDebug.invoke((Object)LogDebug, logident + "warnText: " + formWarnText);
                DialogWarn.invoke((Object)DialogWarn, "Meldung der " + longName + ":\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + loginUrl + "\nan und best\u00e4tigen Sie diese Meldung(en).", logoPath);
                LogDebug.invoke((Object)LogDebug, logident + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                try {
                    wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closePath)));
                }
                catch (NoSuchElementException | TimeoutException notAborterr) {
                    hasAbortButton = false;
                    isSelfException = true;
                    throw new Exception("Im Onlinebanking muss auf folgende Meldung reagiert werden: " + formWarnText.trim());
                }
                hasAbortButton = true;
                LogWarn.invoke((Object)LogWarn, logident + "Meldung(en) der Bank: " + formWarnText);
                MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", closePath, lOADER_CATCHSTRING, lOADER_EXCLUSIONS, lOADER_PATH, lOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            } while (hasAbortButton);
        }
        catch (NoSuchElementException | TimeoutException notFounderr) {
            LogInfo.invoke((Object)LogInfo, logident + "Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Meldung anzeigen fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

