/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.webdrivertools;

import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.ZipFileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;

public class HTMLUnitUtils {
    private static final String LogIdent = "[HTMLUnitUtils] ";
    protected static String[] xpathSearchString = new String[0];
    protected static String[] xpathSearchStringExclusion = new String[0];
    private static String tempWebSitePath = System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp" + File.separator + "template_" + String.valueOf(new Date().getTime()) + "-transfer.htm";

    public static String checkHTMLUnitWebClientResponse(String currentPageResponse, Page currentPage, String logIdent, String longName, String logo, String[] xpathSearchArray, String[] xpathSearchArrayExclusion, Class<?> externalLogger, Class<?> ExternalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogError = ExternalDialogInterface.getMethod("error", String.class, String.class);
        logIdent = logIdent + LogIdent;
        String getLogMethod = "[checkHTMLUnitWebClientResponse] ";
        boolean isSelfException = false;
        try {
            LogTrace.invoke((Object)LogTrace, logIdent + "Funktion checkHTMLUnitWebClientResponse wurde aufgerufen...");
            xpathSearchString = xpathSearchArray;
            xpathSearchStringExclusion = xpathSearchArrayExclusion;
            String errorText = null;
            String xpathSearchRun = null;
            String xpathSearchResult = null;
            try {
                if (currentPage.isHtmlPage()) {
                    for (String searchString : xpathSearchString) {
                        HtmlElement xpathSearch = (HtmlElement)((HtmlPage)currentPage).getFirstByXPath(searchString);
                        if (xpathSearch != null) {
                            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundene xPathExpression: " + searchString);
                            xpathSearchRun = searchString;
                            xpathSearchResult = xpathSearch.asNormalizedText();
                            boolean isReal = true;
                            if (StringCharUtils.isNullOrEmptyOrNothing(xpathSearchResult)) {
                                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "diese xPathExpression ist aber beim Auslesen mit HtmlUnit-TextConent leer und liefert keinen Text ...");
                            } else {
                                for (String searchExclusionString : xpathSearchStringExclusion) {
                                    if (!xpathSearchResult.contains(searchExclusionString)) continue;
                                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "diese xPathExpression enth\u00e4lt aber folgende Ausnahme: " + searchExclusionString);
                                    isReal = false;
                                }
                            }
                            if (isReal) continue;
                            xpathSearchRun = null;
                            continue;
                        }
                        LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "xPathExpression \"" + searchString + "\" ergab kein Ergebnis");
                        xpathSearchRun = null;
                    }
                }
            }
            catch (Exception notFounderr) {
                isSelfException = true;
                throw new Exception("xPath-Suche fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)notFounderr));
            }
            if (xpathSearchRun != null) {
                String formErrorText;
                errorText = xpathSearchResult;
                LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "ErrorText (unformatiert): " + errorText);
                try {
                    formErrorText = StringCharUtils.formMessageText(logIdent, errorText, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error);
                }
                DialogError.invoke((Object)DialogError, "Fehlermeldung von " + longName + ":\n\n\n" + formErrorText, logo);
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + formErrorText);
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkHTMLUnitWebClientResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static HtmlPage closeCookieLaw(WebClient syncWebClient, HtmlPage currentPage, String logIdent, String longName, String logo, String cookieDetectPath, String cookieAcceptPath, Class<?> externalLogger) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        logIdent = logIdent + LogIdent;
        String getLogMethod = "[closeCookieLaw] ";
        boolean isSelfException = false;
        boolean isClosed = false;
        int round = 1;
        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Pr\u00fcfen auf Cookie-Banner das geschlossen werden muss ...");
        while (!isClosed) {
            try {
                DomElement detectBanner = (DomElement)currentPage.getFirstByXPath(cookieDetectPath);
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "detectBanner: " + detectBanner);
                if (detectBanner != null) {
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Cookie-Banner erkannt das nun geschlossen werden muss ...");
                    DomElement closeCookieButton = (DomElement)currentPage.getFirstByXPath(cookieAcceptPath);
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "closeCookieButton: " + closeCookieButton);
                    try {
                        currentPage = (HtmlPage)closeCookieButton.click();
                        syncWebClient.waitForBackgroundJavaScript(5000L);
                        Thread.sleep(1000L);
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "DataPage (callTan): " + currentPage);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    if (currentPage == null) {
                        isSelfException = true;
                        throw new Exception("Die Seite konnte nach dem Schlie\u00dfen des Cookie-Banner nicht aufgerufen werden!");
                    }
                } else {
                    isClosed = true;
                }
                if (round < 10) continue;
                isSelfException = true;
                throw new Exception("Cookie-Banner konnte auch nach mehreren Versuchen nicht geschlossen werden!");
            }
            catch (Exception error) {
                if (isSelfException) {
                    throw new Exception(error.getMessage());
                }
                LogError.invoke((Object)LogError, logIdent + getLogMethod + "Fehler beim Schlie\u00dfen des Cookie-Banner: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        return currentPage;
    }

    public static String saveCurrentPageAndBuildROScreenshot(WebClient webClientSession, Class<?> externalLogger) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        String getLogMethod = "[screenCaputre] ";
        Boolean activeJS = webClientSession.getOptions().isJavaScriptEnabled();
        try {
            if (!activeJS.booleanValue()) {
                webClientSession.getOptions().setJavaScriptEnabled(true);
            }
            HtmlPage currentPage = ((HtmlPage)webClientSession.getCurrentWindow().getEnclosedPage()).cloneNode(true);
            tempWebSitePath = System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp" + File.separator + currentPage.getUrl().getHost() + "_" + String.valueOf(new Date().getTime()) + "-transfer.htm";
            List allHref = currentPage.getByXPath("//*[@href][not(self::link)]");
            for (Object element : allHref) {
                element.setAttribute("href", "javascript:");
            }
            List allOnClick = currentPage.getByXPath("//*[@onClick]");
            for (Object element : allOnClick) {
                element.setAttribute("onClick", "javascript:");
            }
            List allTarget = currentPage.getByXPath("//*[@target]");
            for (Object element : allTarget) {
                element.setAttribute("target", "");
            }
            List allForms = currentPage.getByXPath("//form");
            for (Object element : allForms) {
                element.setAttribute("action", "");
            }
            List allTextWithEUR = currentPage.getByXPath("//*[contains(text(),'\u20ac')]");
            for (Object element : allTextWithEUR) {
                element.setTextContent(element.getTextContent().replaceAll("\u20ac", "&euro;"));
            }
            List allTextWithPound = currentPage.getByXPath("//*[contains(text(),'\u20a3')]");
            for (Object element : allTextWithPound) {
                element.setTextContent(element.getTextContent().replaceAll("\u20a3", "&pound;"));
            }
            List allTextWithCurrent = currentPage.getByXPath("//*[contains(text(),'\u20a4')]");
            for (Object element : allTextWithCurrent) {
                element.setTextContent(element.getTextContent().replaceAll("\u20a4", "&curren;"));
            }
            List allTextWithDollar = currentPage.getByXPath("//*[contains(text(),'$')]");
            for (DomElement element : allTextWithDollar) {
                element.setTextContent(element.getTextContent().replaceAll("$", "&#x24;"));
            }
            if (!new File(System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp").exists()) {
                new File(System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp").mkdir();
            }
            File tempWebSiteFile = new File(tempWebSitePath);
            currentPage.save(tempWebSiteFile);
            LogDebug.invoke((Object)LogDebug, getLogMethod + "PageEncoding: " + currentPage.getCharset().displayName());
            LogDebug.invoke((Object)LogDebug, getLogMethod + "System-Encoding: " + System.getProperty("file.encoding"));
            if (!System.getProperty("file.encoding").equals(currentPage.getCharset().displayName())) {
                FileSysUtils.fileEncodingConverter(new String[]{tempWebSiteFile.getAbsolutePath(), System.getProperty("file.encoding"), tempWebSiteFile.getAbsolutePath() + "l", currentPage.getCharset().displayName()});
                FileUtils.forceDelete((File)tempWebSiteFile);
                tempWebSiteFile = new File(tempWebSiteFile.getAbsolutePath() + "l");
            }
            if (!activeJS.booleanValue()) {
                webClientSession.getOptions().setJavaScriptEnabled(false);
            }
            LogDebug.invoke((Object)LogDebug, getLogMethod + "creating screencaputre from current page to temp done");
            return tempWebSiteFile.getAbsolutePath();
        }
        catch (Exception error) {
            try {
                if (!new File(System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp").exists()) {
                    new File(System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp").mkdir();
                }
                File ausgabedatei = new File(tempWebSitePath);
                FileWriter fw = new FileWriter(ausgabedatei);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write("<html><h1>Beim Erstellen der aktuellen Ansicht ist ein Fehler aufgetreten. Sehen Sie im Log nach und informieren bitte den Entwickler im Forum. Danke</h1></html>");
                bw.close();
            }
            catch (Exception ioe) {
                LogError.invoke((Object)LogError, getLogMethod + "Erstellung einer Error-Ersatzseite ist fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)ioe));
            }
            LogError.invoke((Object)LogError, getLogMethod + "Exception beim Erstellen eines ScreenCaputure: " + ExceptionUtils.getStackTrace((Throwable)error));
            return tempWebSitePath;
        }
    }

    public static void saveCurrentPageAsScreenshot(WebClient webClientSession, File savePath, String logoPath, String bankName, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        String getLogMethod = "[screenCaputre] ";
        Boolean activeJS = webClientSession.getOptions().isJavaScriptEnabled();
        File folderPath = new File(savePath.getParent());
        try {
            if (!activeJS.booleanValue()) {
                webClientSession.getOptions().setJavaScriptEnabled(true);
            }
            HtmlPage currentPage = ((HtmlPage)webClientSession.getCurrentWindow().getEnclosedPage()).cloneNode(true);
            if (!folderPath.exists()) {
                folderPath.mkdir();
            }
            currentPage.save(savePath);
            LogDebug.invoke((Object)LogDebug, getLogMethod + "PageEncoding: " + currentPage.getCharset().displayName());
            LogDebug.invoke((Object)LogDebug, getLogMethod + "System-Encoding: " + System.getProperty("file.encoding"));
            if (!System.getProperty("file.encoding").equals(currentPage.getCharset().displayName())) {
                File convertedFile = new File(savePath.getAbsolutePath() + ".converted");
                FileSysUtils.fileEncodingConverter(new String[]{savePath.getAbsolutePath(), System.getProperty("file.encoding"), convertedFile.getAbsolutePath(), currentPage.getCharset().displayName()});
                FileUtils.forceDelete((File)savePath);
                FileUtils.moveFile((File)convertedFile, (File)savePath);
            }
            if (!activeJS.booleanValue()) {
                webClientSession.getOptions().setJavaScriptEnabled(false);
            }
            LogDebug.invoke((Object)LogDebug, getLogMethod + "creating screencapture from current page to temp done");
        }
        catch (Exception error) {
            try {
                if (!new File(System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp").exists()) {
                    new File(System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp").mkdir();
                }
                File ausgabedatei = new File(tempWebSitePath);
                FileWriter fw = new FileWriter(ausgabedatei);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write("<html><h1>Beim Erstellen der aktuellen Ansicht ist ein Fehler aufgetreten. Sehen Sie im Log nach und informieren bitte den Entwickler im Forum. Danke</h1></html>");
                bw.close();
            }
            catch (Exception ioe) {
                LogError.invoke((Object)LogError, getLogMethod + "Erstellung einer Error-Ersatzseite ist fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)ioe));
            }
            LogError.invoke((Object)LogError, getLogMethod + "Exception beim Erstellen eines ScreenCaputure: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static void saveCurrentPageAsScreenshotArchiv(WebClient webClientSession, File savePath, String logoPath, String bankName, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method DialogNotifyError = externalDialogInterface.getMethod("notifyError", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[screenCaputreArchiv] ";
        File folderPath = new File(savePath.getParent());
        File archivPath = new File(folderPath.getParent() + File.separator + savePath.getName().substring(0, savePath.getName().lastIndexOf(".")) + ".zip");
        String fileName = archivPath.getName();
        try {
            HTMLUnitUtils.saveCurrentPageAsScreenshot(webClientSession, savePath, logoPath, bankName, externalLogger, externalProgressMonitor, externalDialogInterface);
            ZipFileUtils.compressDirectory(folderPath, true, archivPath, externalLogger);
            FileSysUtils.forceDeleteTarget(folderPath);
            LogDebug.invoke((Object)LogDebug, "[HTMLUnitUtils] INFO: Vom folgenden Fehler wurde ein Screenshot-Archiv auf dem Desktop abgelegt! Datei: " + archivPath + " (Pfad: " + FileSysUtils.getUsersDesktop() + ")");
            MonitorLog.invoke((Object)MonitorLog, "INFO: Vom folgenden Fehler wurde ein Screenshot-Archiv auf dem Desktop abgelegt! Datei: " + archivPath + " (Pfad: " + FileSysUtils.getUsersDesktop() + ")");
            DialogNotifyError.invoke((Object)DialogNotifyError, "Vom folgenden Fehler des " + bankName + "-Sync wurde ein Screenshot-Archiv auf dem Desktop abgelegt!\n\nDatei:\n" + fileName + "\n(Pfad: " + FileSysUtils.getUsersDesktop() + ")\n\n\n(Dieses Verhalten kann in den Synchronisierungsoptionen des Kontos deaktiviert werden)", logoPath);
        }
        catch (Exception error) {
            try {
                if (!new File(System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp").exists()) {
                    new File(System.getProperty("java.io.tmpdir") + "syncWebClient_ScreenCaptureTmp").mkdir();
                }
                File ausgabedatei = new File(tempWebSitePath);
                FileWriter fw = new FileWriter(ausgabedatei);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write("<html><h1>Beim Erstellen der aktuellen Ansicht ist ein Fehler aufgetreten. Sehen Sie im Log nach und informieren bitte den Entwickler im Forum. Danke</h1></html>");
                bw.close();
            }
            catch (Exception ioe) {
                LogError.invoke((Object)LogError, getLogMethod + "Erstellung einer Error-Ersatzseite ist fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)ioe));
            }
            LogError.invoke((Object)LogError, getLogMethod + "Exception beim Erstellen eines ScreenCaputure: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

