/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.webdrivertools;

import de.derrichter.finance.websync.utils.DmgFileUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.OnlineUtils;
import de.derrichter.finance.websync.utils.SecurityUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.TarBzip2FileUtils;
import de.derrichter.finance.websync.utils.ZipFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class GeckoDriverUtils {
    private static final String LogIdent = "[GeckoDriverUtils] ";
    private static String rawGeckoDriverBinaryPath = System.getProperty("webdriver.gecko.driver");
    private static final String rawFirefoxRootPath = System.getProperty("firefox.root.path");
    private static final String rawFirefoxBinaryPath = System.getProperty("firefox.binary.path");
    public static final String FIREFOX_DOWNLOAD_MAC = "https://ftp.mozilla.org/pub/firefox/nightly/2024/08/2024-08-01-09-29-33-mozilla-central-l10n/firefox-130.0a1.de.mac.dmg";
    public static final String FIREFOX_DOWNLOAD_WIN32 = "https://ftp.mozilla.org/pub/firefox/nightly/2024/08/2024-08-01-09-29-33-mozilla-central-l10n/firefox-130.0a1.de.win32.zip";
    public static final String FIREFOX_DOWNLOAD_WIN64 = "https://ftp.mozilla.org/pub/firefox/nightly/2024/08/2024-08-01-09-29-33-mozilla-central-l10n/firefox-130.0a1.de.win64.zip";
    public static final String FIREFOX_DOWNLOAD_LINUX32 = "https://ftp.mozilla.org/pub/firefox/nightly/2024/08/2024-08-01-09-29-33-mozilla-central-l10n/firefox-130.0a1.de.linux-i686.tar.bz2";
    public static final String FIREFOX_DOWNLOAD_LINUX64 = "https://ftp.mozilla.org/pub/firefox/nightly/2024/08/2024-08-01-09-29-33-mozilla-central-l10n/firefox-130.0a1.de.linux-x86_64.tar.bz2";

    public static void getFirefoxBrowser(Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception, Exception {
        File toDownloadTmpFile;
        String osname;
        File extractRootPath;
        Method MonitorLog;
        Method LogDebug;
        Method LogInfo;
        block29: {
            LogInfo = ExternalLogger.getMethod("info", String.class);
            LogDebug = ExternalLogger.getMethod("debug", String.class);
            MonitorLog = ExternalProgressMonitor.getMethod("log", String.class);
            extractRootPath = new File(rawFirefoxRootPath);
            osname = System.getProperty("os.name").toLowerCase();
            String osarch = System.getProperty("os.arch").toLowerCase();
            try {
                String toDownloadTmp = osname.toLowerCase().contains("mac") ? System.getProperty("java.io.tmpdir") + File.separator + "geckodriver-downloads" + File.separator + "firefox-stable.dmg" : (osname.toLowerCase().contains("linux") ? System.getProperty("java.io.tmpdir") + File.separator + "geckodriver-downloads" + File.separator + "firefox-stable.tar.bz2" : System.getProperty("java.io.tmpdir") + File.separator + "geckodriver-downloads" + File.separator + "firefox-stable.zip");
                toDownloadTmpFile = new File(toDownloadTmp);
                try {
                    FileUtils.forceDelete((File)toDownloadTmpFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (osname.toLowerCase().contains("mac")) {
                    OnlineUtils.downloadFromURL_getStatusPercent(FIREFOX_DOWNLOAD_MAC, toDownloadTmp, ExternalLogger, ExternalProgressMonitor);
                    break block29;
                }
                if (osname.toLowerCase().contains("win") && osarch.contains("386")) {
                    OnlineUtils.downloadFromURL_getStatusPercent(FIREFOX_DOWNLOAD_WIN32, toDownloadTmp, ExternalLogger, ExternalProgressMonitor);
                    break block29;
                }
                if (osname.toLowerCase().contains("win") && (osarch.contains("64") || osarch.toLowerCase().contains("amd64"))) {
                    OnlineUtils.downloadFromURL_getStatusPercent(FIREFOX_DOWNLOAD_WIN64, toDownloadTmp, ExternalLogger, ExternalProgressMonitor);
                    break block29;
                }
                if (osname.toLowerCase().contains("linux") && (osarch.toLowerCase().contains("arm64") || osarch.toLowerCase().contains("aarch64") || osarch.toLowerCase().contains("armv8") || osarch.toLowerCase().contains("armv9"))) {
                    throw new Exception("Firefox wird unter aarch64-Linux nicht direkt angeboten! Installieren Sie Firefox mit/und passendem firefox-geckodriver \u00fcber die Paketverwaltung!");
                }
                if (osname.toLowerCase().contains("linux") && osarch.contains("386")) {
                    OnlineUtils.downloadFromURL_getStatusPercent(FIREFOX_DOWNLOAD_LINUX32, toDownloadTmp, ExternalLogger, ExternalProgressMonitor);
                    break block29;
                }
                if (osname.toLowerCase().contains("linux") && (osarch.toLowerCase().contains("arm") || osarch.toLowerCase().contains("aarch"))) {
                    throw new Exception("Firefox wird unter aarch32-Linux nicht direkt angeboten! Installieren Sie Firefox mit/und passendem firefox-geckodriver \u00fcber die Paketverwaltung!");
                }
                if (osname.toLowerCase().contains("linux") && (osarch.contains("64") || osarch.toLowerCase().contains("amd64"))) {
                    OnlineUtils.downloadFromURL_getStatusPercent(FIREFOX_DOWNLOAD_LINUX64, toDownloadTmp, ExternalLogger, ExternalProgressMonitor);
                    break block29;
                }
                throw new Exception("OS konnte nicht ermittelt werden!");
            }
            catch (Exception error) {
                throw new Exception("Download fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        LogInfo.invoke((Object)LogInfo, "[GeckoDriverUtils] ... Download erfolgreich, beginne entpacken ...");
        MonitorLog.invoke((Object)MonitorLog, "... Download erfolgreich, beginne entpacken ...");
        try {
            if (extractRootPath.exists()) {
                FileUtils.forceDelete((File)extractRootPath);
            }
            if (!extractRootPath.exists()) {
                FileUtils.forceMkdir((File)extractRootPath);
            }
            if (osname.contains("Mac")) {
                String firefoxVol = "/Volumes/Firefox Nightly/";
                String firefoxVolApp = "/Volumes/Firefox Nightly/Firefox Nightly.app";
                DmgFileUtils.mountDmgImage(toDownloadTmpFile.getAbsolutePath(), ExternalLogger);
                FileSysUtils.copyDirectory(new File(firefoxVolApp), new File(rawFirefoxRootPath + "/Firefox Nightly.app"));
                DmgFileUtils.umountDmgImage(firefoxVol, ExternalLogger);
            } else if (osname.contains("Linux")) {
                TarBzip2FileUtils.extractAll(toDownloadTmpFile.getAbsolutePath(), extractRootPath.getAbsolutePath(), ExternalLogger);
            } else {
                ZipFileUtils.extractAll(toDownloadTmpFile, extractRootPath, ExternalLogger);
            }
        }
        catch (Exception error) {
            try {
                FileUtils.forceDelete((File)extractRootPath);
            }
            catch (Exception delLater) {
                FileUtils.forceDeleteOnExit((File)extractRootPath);
            }
            throw new Exception("Entpacken fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        try {
            try {
                FileUtils.forceDelete((File)toDownloadTmpFile);
            }
            catch (Exception delLater) {
                FileUtils.forceDeleteOnExit((File)toDownloadTmpFile);
            }
            if (StringCharUtils.isNullOrEmptyOrNothing(rawFirefoxBinaryPath)) {
                throw new Exception("Pfad zur Firefox-Binary ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"firefox.binary.path\", <Pfad zur Binary>);'");
            }
            try {
                File firefoxBinary = new File(rawFirefoxBinaryPath);
                if (!firefoxBinary.canExecute()) {
                    firefoxBinary.setExecutable(true);
                    LogDebug.invoke((Object)LogDebug, "[GeckoDriverUtils] Firefox-Binary wurde erfolgreich als ausf\u00fcrbar markiert");
                }
            }
            catch (Exception error1) {
                throw new Exception("Firefox-Binary konnte nicht auf Ausf\u00fchrbarkeit gepr\u00fcft oder gesetzt werden: " + ExceptionUtils.getStackTrace((Throwable)error1));
            }
            LogInfo.invoke((Object)LogInfo, "[GeckoDriverUtils] OK. Firefox erfolgreich bezogen und abgelegt unter '" + extractRootPath.getAbsolutePath() + "'");
            MonitorLog.invoke((Object)MonitorLog, "OK. Firefox erfolgreich bezogen und abgelegt unter '" + extractRootPath.getAbsolutePath() + "'");
        }
        catch (Exception error) {
            throw new Exception("Einrichten fehlgeschlagen! " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static void secuityCheckOfBrowser(Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        Method LogWarn = ExternalLogger.getMethod("warn", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method MonitorLog = ExternalProgressMonitor.getMethod("log", String.class);
        String osname = System.getProperty("os.name").toLowerCase();
        String osarch = System.getProperty("os.arch").toLowerCase();
        String checkurl = "http://scripting-updates.derrichter.de/browserchecksum.php?browser=firefox&os=ARCH";
        String storeCecksum = null;
        try {
            LogInfo.invoke((Object)LogInfo, "[GeckoDriverUtils] Sicherheits-Check der Integrit\u00e4t des alternativen Firefox-Browser gegen Manipulation ...");
            MonitorLog.invoke((Object)MonitorLog, "Sicherheits-Check der Integrit\u00e4t des alternativen Firefox-Browser gegen Manipulation ...");
            if (osname.toLowerCase().contains("mac") && new File(rawFirefoxRootPath + "/Firefox Nightly.app/Contents/_CodeSignature/CodeResources").exists()) {
                LogInfo.invoke((Object)LogInfo, "[GeckoDriverUtils] ... wird ausgelassen, da dieser Chromium scheinbar signiert wurde.");
                MonitorLog.invoke((Object)MonitorLog, "... wird ausgelassen, da dieser Chromium scheinbar signiert wurde.");
                LogDebug.invoke((Object)LogDebug, LogIdent + rawFirefoxRootPath + "/Firefox Nightly.app/Contents/_CodeSignature/CodeResources is file?: " + String.valueOf(new File(rawFirefoxRootPath + "/Firefox Nightly.app/Contents/_CodeSignature/CodeResources").isFile()));
                LogDebug.invoke((Object)LogDebug, LogIdent + rawFirefoxRootPath + "/Firefox Nightly.app/Contents/_CodeSignature/CodeResources is directory?: " + String.valueOf(new File(rawFirefoxRootPath + "/Firefox Nightly.app/Contents/_CodeSignature/CodeResources").isDirectory()));
            } else if (osarch.toLowerCase().contains("aarch") || osname.toLowerCase().contains("arm")) {
                LogInfo.invoke((Object)LogInfo, "[GeckoDriverUtils] ... wird ausgelassen, da dieser Firefox als aarch/arm-Variante vorliegen sollte...");
                MonitorLog.invoke((Object)MonitorLog, "... wird ausgelassen, da dieser Firefox als aarch/arm-Variante vorliegen sollte...");
            } else {
                long startTime = new Date().getTime();
                String checksum = SecurityUtils.checkBrowserHashWithApacheCommons(rawFirefoxRootPath, ExternalLogger);
                LogDebug.invoke((Object)LogDebug, "[GeckoDriverUtils] calculated security-checksum for this browser is: " + checksum);
                if (osname.toLowerCase().contains("mac")) {
                    storeCecksum = IOUtils.toString((URL)new URL(checkurl.replace("ARCH", "macos")), (String)"UTF-8");
                } else if (osname.toLowerCase().contains("win") && osarch.contains("386")) {
                    storeCecksum = IOUtils.toString((URL)new URL(checkurl.replace("ARCH", "win32")), (String)"UTF-8");
                } else if (osname.toLowerCase().contains("win") && osarch.contains("64")) {
                    storeCecksum = IOUtils.toString((URL)new URL(checkurl.replace("ARCH", "win64")), (String)"UTF-8");
                } else if (osname.toLowerCase().contains("linux") && osarch.contains("386")) {
                    storeCecksum = IOUtils.toString((URL)new URL(checkurl.replace("ARCH", "linux32")), (String)"UTF-8");
                } else if (osname.toLowerCase().contains("linux") && (osarch.contains("64") || osarch.toLowerCase().contains("amd64"))) {
                    storeCecksum = IOUtils.toString((URL)new URL(checkurl.replace("ARCH", "linux64")), (String)"UTF-8");
                } else {
                    throw new Exception("OS konnte nicht ermittelt werden!");
                }
                LogDebug.invoke((Object)LogDebug, "[GeckoDriverUtils] stored security-checksums for this browser are: " + storeCecksum);
                long endTime = new Date().getTime();
                long runtime = (endTime - startTime) / 1000L;
                if (checksum == null) {
                    LogWarn.invoke((Object)LogWarn, "[GeckoDriverUtils] Pr\u00fcfsummen-Berechnung abgebrochen! (Pfad war falsch oder existiert nicht)");
                    MonitorLog.invoke((Object)MonitorLog, "Pr\u00fcfsummen-Berechnung abgebrochen! (Pfad war falsch oder existiert nicht)");
                    return;
                }
                if (storeCecksum.contains(checksum)) {
                    LogInfo.invoke((Object)LogInfo, "[GeckoDriverUtils] OK. Ergebnis der Berechnung: " + checksum.toUpperCase() + " (Dauer: " + String.valueOf(runtime) + " Sek.)");
                    MonitorLog.invoke((Object)MonitorLog, "OK. Ergebnis der Berechnung: " + checksum.toUpperCase() + " (Dauer: " + String.valueOf(runtime) + " Sek.)");
                } else {
                    LogWarn.invoke((Object)LogWarn, "[GeckoDriverUtils] Browser hat Pr\u00fcfsummen-Test nicht bestanden! Wird daher nun neu geladen ...");
                    MonitorLog.invoke((Object)MonitorLog, "Browser hat Pr\u00fcfsummen-Test nicht bestanden! Wird daher nun neu geladen ...");
                    GeckoDriverUtils.getFirefoxBrowser(ExternalLogger, ExternalProgressMonitor);
                }
            }
        }
        catch (Exception err) {
            throw new Exception("Checksum-Test fehlgeschlagen! " + err.getMessage());
        }
    }

    public static String getGeckoDriverVersion(Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String osname = System.getProperty("os.name");
        String osarch = System.getProperty("os.arch");
        LogDebug.invoke((Object)LogDebug, "[GeckoDriverUtils] OS-Info: " + osname + " " + osarch);
        if (StringCharUtils.isNullOrEmptyOrNothing(rawGeckoDriverBinaryPath)) {
            throw new Exception("Pfad zur GeckoDriver-Binary ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"webdriver.gecko.driver\", <Pfad zur Binary>);'");
        }
        File geckoDriverBinary = new File(rawGeckoDriverBinaryPath);
        if (!geckoDriverBinary.exists()) {
            if (rawGeckoDriverBinaryPath.endsWith("hibiscus.scripting.geckodriver" + File.separator + "bin" + File.separator + "macos" + File.separator + "geckodriver")) {
                rawGeckoDriverBinaryPath = rawGeckoDriverBinaryPath.replace("macos", "macos64");
            } else if (rawGeckoDriverBinaryPath.endsWith("hibiscus.scripting.geckodriver" + File.separator + "bin" + File.separator + "macos64" + File.separator + "geckodriver")) {
                rawGeckoDriverBinaryPath = rawGeckoDriverBinaryPath.replace("macos64", "macos");
            } else if (rawGeckoDriverBinaryPath.endsWith("hibiscus.scripting.geckodriver" + File.separator + "bin" + File.separator + "macos-arm" + File.separator + "geckodriver")) {
                rawGeckoDriverBinaryPath = rawGeckoDriverBinaryPath.replace("macos-arm", "macos-aarch64");
            } else if (rawGeckoDriverBinaryPath.endsWith("hibiscus.scripting.geckodriver" + File.separator + "bin" + File.separator + "macos-aarch64" + File.separator + "geckodriver")) {
                rawGeckoDriverBinaryPath = rawGeckoDriverBinaryPath.replace("macos-aarch64", "macos-arm");
            }
            geckoDriverBinary = new File(rawGeckoDriverBinaryPath);
            if (!geckoDriverBinary.exists() && Files.isSymbolicLink(geckoDriverBinary.toPath())) {
                throw new Exception("Pfad zur GeckoDriver-Binary scheint nicht korrekt. Bitte \u00fcberpr\u00fcfen Sie diesen:\n" + rawGeckoDriverBinaryPath + "\nBitte beachten Sie: Setzen Sie den Symbolic-Link richtig oder installieren Sie Firefox mit/und passendem firefox-geckodriver \u00fcber die Paketverwaltung!");
            }
            if (!geckoDriverBinary.exists() && osname.toLowerCase().contains("linux") && (osarch.toLowerCase().contains("arm") || osarch.toLowerCase().contains("aarch"))) {
                throw new Exception("Pfad zur GeckoDriver-Binary scheint nicht korrekt. Bitte \u00fcberpr\u00fcfen Sie diesen:\n" + rawGeckoDriverBinaryPath + "\nBitte beachten Sie: Installieren Sie Firefox mit/und passendem firefox-geckodriver \u00fcber die Paketverwaltung!");
            }
            if (!geckoDriverBinary.exists()) {
                throw new Exception("Pfad zur GeckoDriver-Binary scheint nicht korrekt. Bitte \u00fcberpr\u00fcfen Sie diesen: " + rawGeckoDriverBinaryPath);
            }
        }
        LogDebug.invoke((Object)LogDebug, "[GeckoDriverUtils] Pfad zur GeckoDriver-Binary: " + geckoDriverBinary.getAbsolutePath());
        try {
            if (!geckoDriverBinary.canExecute()) {
                geckoDriverBinary.setExecutable(true);
                LogDebug.invoke((Object)LogDebug, "[GeckoDriverUtils] GeckoDriver-Binary wurde erfolgreich als ausf\u00fcrbar markiert");
            }
        }
        catch (Exception error1) {
            throw new Exception("GeckoDriver-Binary konnte nicht auf Ausf\u00fchrbarkeit gepr\u00fcft oder gesetzt werden: " + ExceptionUtils.getStackTrace((Throwable)error1));
        }
        String output = "";
        try {
            String line;
            String[] cmd;
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.redirectInput();
            builder.redirectOutput();
            builder.redirectErrorStream(true);
            if (osname.toLowerCase().contains("win")) {
                cmd = new String[]{"cmd", "/c", geckoDriverBinary.getAbsolutePath(), "--version"};
                builder.command(cmd);
            } else {
                cmd = new String[]{geckoDriverBinary.getAbsolutePath(), "--version"};
                builder.command(cmd);
            }
            Process process = builder.start();
            LogTrace.invoke((Object)LogTrace, "[GeckoDriverUtils] Version-Object: " + process.toString());
            LogTrace.invoke((Object)LogTrace, "[GeckoDriverUtils] Version-Command InputStream: " + process.getInputStream().toString());
            InputStream is = process.getInputStream();
            InputStreamReader r = new InputStreamReader(is);
            BufferedReader in = new BufferedReader(r);
            while ((line = in.readLine()) != null) {
                output = output + line + "\n";
            }
            in.close();
        }
        catch (Exception error) {
            throw new Exception("GeckoDriver-Version konnte nicht ermittelt werden! Stellen Sie sicher die passende GeckoDriver-Binary f\u00fcr ihr System installiert ist\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        LogTrace.invoke((Object)LogTrace, "[GeckoDriverUtils] Version-Command Input/Output/Error: " + output);
        String[] geckoDriverVerRAWarray = output.substring(output.indexOf("geckodriver")).split(" ", 2);
        String geckoDriverVer = StringCharUtils.shrinkString(geckoDriverVerRAWarray[1]).split(" ", 2)[0];
        return geckoDriverVer;
    }
}

