/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.webdrivertools;

import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.OnlineUtils;
import de.derrichter.finance.websync.utils.SecurityUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.ZipFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.SessionId;

public class ChromeDriverUtils {
    private static final String LogIdent = "[ChromeDriverUtils] ";
    private static String rawChromeDriverBinaryPath = System.getProperty("chromedriver.binary.path");
    private static final String rawChromiumRootPath = System.getProperty("chromium.root.path");
    private static final String rawChromiumBinaryPath = System.getProperty("chromium.binary.path");
    public static final String CHROMIUM_DOWNLOAD_LINUX64 = "https://storage.googleapis.com/chrome-for-testing-public/<version>/linux64/chrome-linux64.zip";
    public static final String CHROMIUM_DONWLOAD_MAC64 = "https://storage.googleapis.com/chrome-for-testing-public/<version>/mac-x64/chrome-mac-x64.zip";
    public static final String CHROMIUM_DONWLOAD_MACARM = "https://storage.googleapis.com/chrome-for-testing-public/<version>/mac-arm64/chrome-mac-arm64.zip";
    public static final String CHROMIUM_DOWNLOAD_WIN32 = "https://storage.googleapis.com/chrome-for-testing-public/<version>/win32/chrome-win32.zip";
    public static final String CHROMIUM_DOWNLOAD_WIN64 = "https://storage.googleapis.com/chrome-for-testing-public/<version>/win64/chrome-win64.zip";

    public static final String getCurrentStableVersion(Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        JSONObject currentChromiumVersionsArray = OnlineUtils.getJson(new URL("https://googlechromelabs.github.io/chrome-for-testing/last-known-good-versions.json")).getJSONObject("channels");
        LogTrace.invoke((Object)LogTrace, "[ChromeDriverUtils] currentChromiumVersionsArray: " + currentChromiumVersionsArray);
        JSONObject currentChromiumStable = currentChromiumVersionsArray.getJSONObject("Stable");
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] currentChromiumStable: " + currentChromiumStable);
        String currentChromiumStableVersion = currentChromiumStable.getString("version");
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] currentChromiumStableVersion: " + currentChromiumStableVersion);
        return currentChromiumStableVersion;
    }

    public static final String getCurrentStableMainVersion(Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        String currentChromiumStableMainVersion = ChromeDriverUtils.getCurrentStableVersion(externalLogger, externalProgressMonitor).split("\\.")[0];
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] currentChromiumStableVersion: " + String.valueOf(currentChromiumStableMainVersion));
        return currentChromiumStableMainVersion;
    }

    public static final String getCurrentBetaVersion(Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        JSONObject currentChromiumVersionsArray = OnlineUtils.getJson(new URL("https://googlechromelabs.github.io/chrome-for-testing/last-known-good-versions.json")).getJSONObject("channels");
        LogTrace.invoke((Object)LogTrace, "[ChromeDriverUtils] currentChromiumVersionsArray: " + currentChromiumVersionsArray);
        JSONObject currentChromiumBeta = currentChromiumVersionsArray.getJSONObject("Beta");
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] currentChromiumBeta: " + currentChromiumBeta);
        String currentChromiumBetaVersion = currentChromiumBeta.getString("version");
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] currentChromiumBetaVersion: " + currentChromiumBetaVersion);
        return currentChromiumBetaVersion;
    }

    public static void getChromiumBrowser(Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        File toDownloadTmpFile;
        String osarch;
        String osname;
        File extractRootPath;
        Method MonitorLog;
        Method LogTrace;
        Method LogError;
        Method LogDebug;
        Method LogInfo;
        block42: {
            LogInfo = externalLogger.getMethod("info", String.class);
            LogDebug = externalLogger.getMethod("debug", String.class);
            LogError = externalLogger.getMethod("error", String.class);
            LogTrace = externalLogger.getMethod("trace", String.class);
            MonitorLog = externalProgressMonitor.getMethod("log", String.class);
            boolean isSelfException = false;
            extractRootPath = new File(rawChromiumRootPath);
            osname = System.getProperty("os.name").toLowerCase();
            osarch = System.getProperty("os.arch").toLowerCase();
            String osversion = System.getProperty("os.version").toLowerCase();
            LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] os.name: " + osname);
            LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] os.arch: " + osarch);
            LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] os.version: " + osversion);
            String toDownloadTmp = System.getProperty("java.io.tmpdir") + File.separator + "chromedriver-downloads" + File.separator + "chromium-stable.zip";
            toDownloadTmpFile = new File(toDownloadTmp);
            String runningChromeDriverVersion = ChromeDriverUtils.getChromeDriverVersion(externalLogger, externalProgressMonitor);
            LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] runningChromeDriverVersion: " + runningChromeDriverVersion);
            int runningChromeDriverMainVersion = Integer.valueOf(runningChromeDriverVersion.split("\\.")[0]);
            try {
                try {
                    FileSysUtils.forceDeleteTarget(toDownloadTmpFile);
                }
                catch (Exception delLater) {
                    LogError.invoke((Object)LogError, "[ChromeDriverUtils] L\u00f6schen des alternativen Chromium-Download fehlerhaft: " + delLater.getMessage());
                }
                if (osname.toLowerCase().contains("mac") && (osarch.toLowerCase().contains("arm64") || osarch.toLowerCase().contains("aarch64"))) {
                    OnlineUtils.downloadFromURL_getStatusPercent(CHROMIUM_DONWLOAD_MACARM.replace("<version>", runningChromeDriverVersion), toDownloadTmp, externalLogger, externalProgressMonitor);
                    break block42;
                }
                if (runningChromeDriverMainVersion > 113 && osname.toLowerCase().contains("mac") && osversion.toLowerCase().startsWith("10.") && Integer.valueOf(osversion.split("\\.")[1]) < 13) {
                    isSelfException = true;
                    throw new Exception("Der aktuelle Chrome/Chromium und ChromeDriver wird von dieser macOS-Version nicht mehr unterst\u00fctzt!\nDowngraden Sie ChromeDriver auf Version 113 oder installieren Sie Chromium-legacy von https://github.com/blueboxd/chromium-legacy/releases/tag/stable");
                }
                if (runningChromeDriverMainVersion > 116 && osname.toLowerCase().contains("mac") && osversion.toLowerCase().startsWith("10.") && Integer.valueOf(osversion.split("\\.")[1]) < 15) {
                    isSelfException = true;
                    throw new Exception("Der aktuelle Chrome/Chromium und ChromeDriver wird von dieser macOS-Version nicht mehr unterst\u00fctzt!\nDowngraden Sie ChromeDriver auf Version 116 oder installieren Sie Chromium-legacy von https://github.com/blueboxd/chromium-legacy/releases/tag/stable");
                }
                if (osname.toLowerCase().contains("mac")) {
                    OnlineUtils.downloadFromURL_getStatusPercent(CHROMIUM_DONWLOAD_MAC64.replace("<version>", runningChromeDriverVersion), toDownloadTmp, externalLogger, externalProgressMonitor);
                    break block42;
                }
                if (runningChromeDriverMainVersion > 109 && osname.toLowerCase().contains("win") && (osversion.toLowerCase().startsWith("6.") || osversion.toLowerCase().startsWith("5.")) && Integer.valueOf(osversion.split("\\.")[1]) < 9) {
                    isSelfException = true;
                    throw new Exception("Der aktuelle Chrome/Chromium und ChromeDriver wird von dieser Windows-Version nicht mehr unterst\u00fctzt!\nInstallieren Sie maximal Version 109 des Chrome-Browser und ChromeDrivers!");
                }
                if (osname.toLowerCase().contains("win") && osarch.toLowerCase().contains("amd64")) {
                    OnlineUtils.downloadFromURL_getStatusPercent(CHROMIUM_DOWNLOAD_WIN64.replace("<version>", runningChromeDriverVersion), toDownloadTmp, externalLogger, externalProgressMonitor);
                    break block42;
                }
                if (osname.toLowerCase().contains("win")) {
                    OnlineUtils.downloadFromURL_getStatusPercent(CHROMIUM_DOWNLOAD_WIN32.replace("<version>", runningChromeDriverVersion), toDownloadTmp, externalLogger, externalProgressMonitor);
                    break block42;
                }
                if (osname.toLowerCase().contains("linux") && (osarch.toLowerCase().contains("arm64") || osarch.toLowerCase().contains("aarch64") || osarch.toLowerCase().contains("armv8") || osarch.toLowerCase().contains("armv9"))) {
                    isSelfException = true;
                    throw new Exception("Chrome/Chromium und ChromeDriver werden unter aarch64-Linux nicht direkt angeboten! Installieren Sie Chromium mit/und passendem chromium-chromedriver \u00fcber die Paketverwaltung.");
                }
                if (osname.toLowerCase().contains("linux") && osarch.contains("386")) {
                    isSelfException = true;
                    throw new Exception("Chrome/Chromium und daher auch ChromeDriver werden unter 32-Bit-Linux nicht mehr angeboten! Verwenden Sie den GeckoDriver oder wechseln Sie zu 64-Bit.");
                }
                if (osname.toLowerCase().contains("linux") && (osarch.toLowerCase().contains("arm") || osarch.toLowerCase().contains("aarch"))) {
                    isSelfException = true;
                    throw new Exception("Chrome/Chromium und ChromeDriver werden unter aarch-Linux nicht direkt angeboten! Installieren Sie Chromium mit/und passendem chromium-chromedriver \u00fcber die Paketverwaltung.");
                }
                if (osname.toLowerCase().contains("linux") && (osarch.contains("64") || osarch.contains("amd64"))) {
                    OnlineUtils.downloadFromURL_getStatusPercent(CHROMIUM_DOWNLOAD_LINUX64.replace("<version>", runningChromeDriverVersion), toDownloadTmp, externalLogger, externalProgressMonitor);
                    break block42;
                }
                if (runningChromeDriverMainVersion < 113) {
                    isSelfException = true;
                    throw new Exception("Der Download des passenden Chromium zum verwendeten ChromeDriver wird nicht unterst\u00fctzt! Bitte aktualisieren Sie den ChromeDriver oder installiern manuell den passenden Chrome-Browser.");
                }
                isSelfException = true;
                throw new Exception("OS konnte nicht ermittelt werden!");
            }
            catch (Exception error) {
                if (isSelfException) {
                    throw new Exception(error.getMessage());
                }
                throw new Exception("Download fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        LogInfo.invoke((Object)LogInfo, "[ChromeDriverUtils] ... Download erfolgreich, beginne entpacken ...");
        MonitorLog.invoke((Object)MonitorLog, "... Download erfolgreich, beginne entpacken ...");
        try {
            if (extractRootPath.exists()) {
                try {
                    FileSysUtils.forceDeleteTarget(extractRootPath);
                }
                catch (Exception delError) {
                    LogError.invoke((Object)LogError, "[ChromeDriverUtils] L\u00f6schen des alternativen Chromium fehlerhaft: " + delError.getMessage());
                }
            }
            if (!extractRootPath.exists()) {
                FileUtils.forceMkdir((File)extractRootPath);
            }
            ZipFileUtils.extractAll(toDownloadTmpFile, extractRootPath, externalLogger);
            if (osname.toLowerCase().contains("mac")) {
                try {
                    String line;
                    String[] cmd;
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    builder.redirectInput();
                    builder.redirectOutput();
                    builder.redirectErrorStream(true);
                    if (osname.toLowerCase().contains("mac") && (osarch.toLowerCase().contains("arm64") || osarch.toLowerCase().contains("aarch64"))) {
                        cmd = new String[]{"codesign", "--force", "--deep", "--sign", "-", extractRootPath + "/chrome-mac-arm64/Google Chrome for Testing.app/Contents/MacOS/Google Chrome for Testing"};
                        builder.command(cmd);
                    } else if (osname.toLowerCase().contains("mac")) {
                        cmd = new String[]{"codesign", "--force", "--deep", "--sign", "-", extractRootPath + "/chrome-mac-x64/Google Chrome for Testing.app/Contents/MacOS/Google Chrome for Testing"};
                        builder.command(cmd);
                    }
                    Process process = builder.start();
                    LogTrace.invoke((Object)LogTrace, "[ChromeDriverUtils] Command-Object: " + process.toString());
                    LogTrace.invoke((Object)LogTrace, "[ChromeDriverUtils] Command InputStream: " + process.getInputStream().toString());
                    InputStream is = process.getInputStream();
                    InputStreamReader r = new InputStreamReader(is);
                    BufferedReader in = new BufferedReader(r);
                    String output = "";
                    int linerun = 0;
                    while ((line = in.readLine()) != null) {
                        if (++linerun > 1) {
                            output = output + "\n";
                        }
                        output = output + line;
                    }
                    in.close();
                    LogTrace.invoke((Object)LogTrace, "[ChromeDriverUtils] Command Input/Output/Error: " + output);
                }
                catch (Exception error) {
                    LogError.invoke((Object)LogError, "[ChromeDriverUtils] Signieren des alternaitven Browser fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
        }
        catch (Exception error) {
            if (extractRootPath.exists()) {
                try {
                    FileSysUtils.forceDeleteTarget(extractRootPath);
                }
                catch (Exception delError) {
                    LogError.invoke((Object)LogError, "[ChromeDriverUtils] L\u00f6schen des alternativen Chromium fehlerhaft: " + delError.getMessage());
                }
            }
            throw new Exception("Entpacken fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        try {
            try {
                FileSysUtils.forceDeleteTarget(toDownloadTmpFile);
            }
            catch (Exception delLater) {
                LogError.invoke((Object)LogError, "[ChromeDriverUtils] L\u00f6schen des alternativen Chromium-Download fehlerhaft: " + delLater.getMessage());
            }
            if (StringCharUtils.isNullOrEmptyOrNothing(rawChromiumBinaryPath)) {
                throw new Exception("Pfad zur Chromium-Binary ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"chromium.binary.path\", <Pfad zur Binary>);'");
            }
            try {
                File chromiumBinary = new File(rawChromiumBinaryPath);
                if (!chromiumBinary.canExecute()) {
                    chromiumBinary.setExecutable(true);
                    LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] Chromium-Binary wurde erfolgreich als ausf\u00fcrbar markiert");
                }
            }
            catch (Exception error1) {
                throw new Exception("Chromium-Binary konnte nicht auf Ausf\u00fchrbarkeit gepr\u00fcft oder gesetzt werden: " + ExceptionUtils.getStackTrace((Throwable)error1));
            }
            LogInfo.invoke((Object)LogInfo, "[ChromeDriverUtils] OK. Chrome/Chromium erfolgreich bezogen und abgelegt unter '" + extractRootPath.getAbsolutePath() + "'");
            MonitorLog.invoke((Object)MonitorLog, "OK. Chrome/Chromium erfolgreich bezogen und abgelegt unter '" + extractRootPath.getAbsolutePath() + "'");
        }
        catch (Exception error) {
            throw new Exception("Einrichten fehlgeschlagen! " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static void secuityCheckOfBrowser(Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        boolean isSelfException = false;
        String osname = System.getProperty("os.name").toLowerCase();
        String osarch = System.getProperty("os.arch").toLowerCase();
        String osversion = System.getProperty("os.version").toLowerCase();
        String checkSumsURL_linux64 = "https://scripting-updates.derrichter.de/browserchecksum_linux64.php?browser=chromium&os=ARCH";
        String checkSumsURL_mac64 = "https://scripting-updates.derrichter.de/browserchecksum_mac64.php?browser=chromium&os=ARCH";
        String checkSumsURL_mac_aarch64 = "https://scripting-updates.derrichter.de/browserchecksum_mac_aarch64.php?browser=chromium&os=ARCH";
        String checkSumsURL_win32 = "https://scripting-updates.derrichter.de/browserchecksum_win32.php?browser=chromium&os=ARCH";
        String checkSumsURL_win64 = "https://scripting-updates.derrichter.de/browserchecksum_win64.php?browser=chromium&os=ARCH";
        String storedCecksum = null;
        String runningChromeDriverVersion = ChromeDriverUtils.getChromeDriverVersion(externalLogger, externalProgressMonitor);
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] runningChromeDriverVersion: " + runningChromeDriverVersion);
        int currentChromiumStableMainVersion = Integer.valueOf(ChromeDriverUtils.getCurrentStableMainVersion(externalLogger, externalProgressMonitor));
        int runningChromeDriverMainVersion = Integer.valueOf(runningChromeDriverVersion.split("\\.")[0]);
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] rawChromiumRootPath: " + rawChromiumRootPath);
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] rawChromiumBinaryPath: " + rawChromiumBinaryPath);
        try {
            LogInfo.invoke((Object)LogInfo, "[ChromeDriverUtils] Sicherheits-Check der Integrit\u00e4t des alternativen Chromium-Browser gegen Manipulation ...");
            MonitorLog.invoke((Object)MonitorLog, "Sicherheits-Check der Integrit\u00e4t des alternativen Chromium-Browser gegen Manipulation ...");
            if (runningChromeDriverMainVersion > 113 && osname.toLowerCase().contains("mac") && osversion.toLowerCase().startsWith("10.") && Integer.valueOf(osversion.split("\\.")[1]) < 13) {
                isSelfException = true;
                throw new Exception("... wird ausgelassen; Der aktuelle Chrome/Chromium und ChromeDriver wird von dieser macOS-Version nicht mehr unterst\u00fctzt!\nDowngraden Sie ChromeDriver auf Version 113 oder installieren Sie Chromium-legacy von https://github.com/blueboxd/chromium-legacy/releases/tag/stable");
            }
            if (runningChromeDriverMainVersion > 116 && osname.toLowerCase().contains("mac") && osversion.toLowerCase().startsWith("10.") && Integer.valueOf(osversion.split("\\.")[1]) < 15) {
                isSelfException = true;
                throw new Exception("... wird ausgelassen; Der aktuelle Chrome/Chromium und ChromeDriver wird von dieser macOS-Version nicht mehr unterst\u00fctzt!\nDowngraden Sie ChromeDriver auf Version 116 oder installieren Sie Chromium-legacy von https://github.com/blueboxd/chromium-legacy/releases/tag/stable");
            }
            if ((osarch.toLowerCase().contains("aarch") || osname.toLowerCase().contains("arm")) && osname.toLowerCase().contains("mac") && new File(rawChromiumRootPath + "/chrome-mac-arm64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources").exists()) {
                LogInfo.invoke((Object)LogInfo, "[ChromeDriverUtils] ... wird ausgelassen, da dieser Chromium scheinbar signiert wurde.");
                MonitorLog.invoke((Object)MonitorLog, "... wird ausgelassen, da dieser Chromium scheinbar signiert wurde.");
                LogDebug.invoke((Object)LogDebug, LogIdent + rawChromiumRootPath + "/chrome-mac-arm64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources is file?: " + String.valueOf(new File(rawChromiumRootPath + "/chrome-mac-arm64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources").isFile()));
                LogDebug.invoke((Object)LogDebug, LogIdent + rawChromiumRootPath + "/chrome-mac-arm64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources is directory?: " + String.valueOf(new File(rawChromiumRootPath + "/chrome-mac-arm64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources").isDirectory()));
            } else if (osname.toLowerCase().contains("mac") && new File(rawChromiumRootPath + "/chrome-mac-x64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources").exists()) {
                LogInfo.invoke((Object)LogInfo, "[ChromeDriverUtils] ... wird ausgelassen, da dieser Chromium scheinbar signiert wurde.");
                MonitorLog.invoke((Object)MonitorLog, "... wird ausgelassen, da dieser Chromium scheinbar signiert wurde.");
                LogDebug.invoke((Object)LogDebug, LogIdent + rawChromiumRootPath + "/chrome-mac-x64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources is file?: " + String.valueOf(new File(rawChromiumRootPath + "/chrome-mac-x64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources").isFile()));
                LogDebug.invoke((Object)LogDebug, LogIdent + rawChromiumRootPath + "/chrome-mac-x64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources is directory?: " + String.valueOf(new File(rawChromiumRootPath + "/chrome-mac-x64/Google Chrome for Testing.app/Contents/_CodeSignature/CodeResources").isDirectory()));
            } else {
                if (runningChromeDriverMainVersion > 109 && osname.toLowerCase().contains("win") && (osversion.toLowerCase().startsWith("6.") || osversion.toLowerCase().startsWith("5.")) && Integer.valueOf(osversion.split("\\.")[1]) < 9) {
                    isSelfException = true;
                    throw new Exception("... wird ausgelassen; Der aktuelle Chrome/Chromium und ChromeDriver wird von dieser Windows-Version nicht mehr unterst\u00fctzt! Installieren Sie maximal Version 109 des Chrome-Browser und ChromeDrivers!");
                }
                long startTime = new Date().getTime();
                String checksum = SecurityUtils.checkBrowserHashWithApacheCommons(rawChromiumRootPath, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] calculated security-checksum for this browser is: " + checksum);
                if (osname.toLowerCase().contains("mac") && (osarch.toLowerCase().contains("arm64") || osarch.toLowerCase().contains("aarch64"))) {
                    storedCecksum = IOUtils.toString((URL)new URL(checkSumsURL_mac_aarch64.replace("ARCH", "macos_aarch64")), (String)"UTF-8");
                } else if (osname.toLowerCase().contains("mac")) {
                    storedCecksum = IOUtils.toString((URL)new URL(checkSumsURL_mac64.replace("ARCH", "macos64")), (String)"UTF-8");
                } else if (osname.toLowerCase().contains("win") && osarch.toLowerCase().contains("amd64")) {
                    storedCecksum = IOUtils.toString((URL)new URL(checkSumsURL_win64.replace("ARCH", "win64")), (String)"UTF-8");
                } else if (osname.toLowerCase().contains("win")) {
                    storedCecksum = IOUtils.toString((URL)new URL(checkSumsURL_win32.replace("ARCH", "win32")), (String)"UTF-8");
                } else {
                    if (osname.toLowerCase().contains("linux") && osarch.contains("386")) {
                        throw new Exception("... wird ausgelassen; Chrome/Chromium und daher auch ChromeDriver werden unter 32-Bit-Linux nicht mehr angeboten! Verwenden Sie den GeckoDriver oder wechseln Sie zu 64-Bit.");
                    }
                    if (osname.toLowerCase().contains("linux") && (osarch.toLowerCase().contains("arm") || osarch.toLowerCase().contains("aarch"))) {
                        throw new Exception("... wird ausgelassen; Chrome/Chromium und ChromeDriver werden unter aarch-Linux nicht direkt angeboten! Installieren Sie Chromium mit/und passendem chromium-chromedriver \u00fcber die Paketverwaltung.");
                    }
                    if (osname.toLowerCase().contains("linux") && (osarch.contains("64") || osarch.toLowerCase().contains("amd64"))) {
                        storedCecksum = IOUtils.toString((URL)new URL(checkSumsURL_linux64.replace("ARCH", "linux64")), (String)"UTF-8");
                    } else {
                        throw new Exception("OS konnte nicht ermittelt werden!");
                    }
                }
                LogTrace.invoke((Object)LogTrace, "[ChromeDriverUtils] stored security-checksums for this browser are: " + storedCecksum);
                long endTime = new Date().getTime();
                long runtime = (endTime - startTime) / 1000L;
                if (checksum == null) {
                    LogWarn.invoke((Object)LogWarn, "[ChromeDriverUtils] Pr\u00fcfsummen-Berechnung abgebrochen! (Pfad war falsch oder existiert nicht)");
                    MonitorLog.invoke((Object)MonitorLog, "Pr\u00fcfsummen-Berechnung abgebrochen! (Pfad war falsch oder existiert nicht)");
                    return;
                }
                if (storedCecksum.contains(checksum)) {
                    LogInfo.invoke((Object)LogInfo, "[ChromeDriverUtils] OK. Ergebnis der Berechnung: " + checksum.toUpperCase() + " (Dauer: " + String.valueOf(runtime) + " Sek.)");
                    MonitorLog.invoke((Object)MonitorLog, "OK. Ergebnis der Berechnung: " + checksum.toUpperCase() + " (Dauer: " + String.valueOf(runtime) + " Sek.)");
                } else if (runningChromeDriverMainVersion > currentChromiumStableMainVersion) {
                    LogInfo.invoke((Object)LogInfo, "[ChromeDriverUtils] Browser hat Pr\u00fcfsummen-Test nicht bestanden. Wird aber ignoriert, da es sich wohl um eine Testversion handelt...");
                    MonitorLog.invoke((Object)MonitorLog, "Browser hat Pr\u00fcfsummen-Test nicht bestanden. Wird aber ignoriert, da es sich wohl um eine Testversion handelt...");
                } else {
                    LogWarn.invoke((Object)LogWarn, "[ChromeDriverUtils] Browser hat Pr\u00fcfsummen-Test nicht bestanden! Wird daher nun neu geladen ...");
                    MonitorLog.invoke((Object)MonitorLog, "Browser hat Pr\u00fcfsummen-Test nicht bestanden! Wird daher nun neu geladen...");
                    ChromeDriverUtils.getChromiumBrowser(externalLogger, externalProgressMonitor);
                }
            }
        }
        catch (Exception err) {
            if (isSelfException) {
                throw new Exception(err.getMessage());
            }
            throw new Exception("Checksum-Test fehlgeschlagen! " + err.getMessage());
        }
    }

    public static String getChromeDriverVersion(Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String osname = System.getProperty("os.name");
        String osarch = System.getProperty("os.arch");
        String osversion = System.getProperty("os.version");
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] OS-Info: " + osname + " " + osversion + " " + osarch);
        if (StringCharUtils.isNullOrEmptyOrNothing(rawChromeDriverBinaryPath)) {
            throw new Exception("Pfad zur ChromeDriver-Binary ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"chromedriver.binary.path\", <Pfad zur Binary>);'");
        }
        File chromeDriverBinary = new File(rawChromeDriverBinaryPath);
        if (!chromeDriverBinary.exists()) {
            if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "macos" + File.separator + "chromedriver")) {
                rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("macos", "macos64");
            } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "macos64" + File.separator + "chromedriver")) {
                rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("macos64", "macos");
            } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "macos-arm" + File.separator + "chromedriver")) {
                rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("macos-arm", "macos-aarch64");
            } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "macos-aarch64" + File.separator + "chromedriver")) {
                rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("macos-aarch64", "macos-arm");
            } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "windows" + File.separator + "chromedriver.exe")) {
                rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("windows", "win32");
            } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "win32" + File.separator + "chromedriver.exe")) {
                rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("win32", "windows");
            } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "win64" + File.separator + "chromedriver.exe")) {
                File chromeDriverPath = new File(rawChromeDriverBinaryPath);
                if (!chromeDriverPath.exists()) {
                    rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("win64", "win32");
                }
            } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "linux-arm" + File.separator + "chromedriver")) {
                rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("linux-arm", "linux-aarch64");
            } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "linux-aarch64" + File.separator + "chromedriver")) {
                rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("linux-aarch64", "linux-arm");
            }
            chromeDriverBinary = new File(rawChromeDriverBinaryPath);
            if (!chromeDriverBinary.exists() && Files.isSymbolicLink(chromeDriverBinary.toPath())) {
                throw new Exception("Pfad zur ChromeDriver-Binary scheint nicht korrekt. Bitte \u00fcberpr\u00fcfen Sie diesen:\n" + rawChromeDriverBinaryPath + "\nBitte beachten Sie: Setzen Sie den Symbolic-Link richtig oder installieren Sie Chromium mit/und passendem chromium-chromedriver \u00fcber die Paketverwaltung!");
            }
            if (!chromeDriverBinary.exists() && osname.toLowerCase().contains("linux") && (osarch.toLowerCase().contains("arm") || osarch.toLowerCase().contains("aarch"))) {
                throw new Exception("Pfad zur ChromeDriver-Binary scheint nicht korrekt. Bitte \u00fcberpr\u00fcfen Sie diesen:\n" + rawChromeDriverBinaryPath + "\nBitte beachten Sie: Installieren Sie Chromium mit/und passendem chromium-chromedriver \u00fcber die Paketverwaltung!");
            }
            if (!chromeDriverBinary.exists()) {
                throw new Exception("Pfad zur ChromeDriver-Binary scheint nicht korrekt. Bitte \u00fcberpr\u00fcfen Sie diesen:\n" + rawChromeDriverBinaryPath);
            }
        }
        LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] Pfad zur ChromeDriver-Binary: " + chromeDriverBinary.getAbsolutePath());
        try {
            if (!chromeDriverBinary.canExecute()) {
                chromeDriverBinary.setExecutable(true);
                LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] ChromeDriver-Binary wurde erfolgreich als ausf\u00fcrbar markiert");
            }
        }
        catch (Exception error1) {
            throw new Exception("ChromeDriver-Binary konnte nicht auf Ausf\u00fchrbarkeit gepr\u00fcft oder gesetzt werden: " + ExceptionUtils.getStackTrace((Throwable)error1));
        }
        String output = "";
        try {
            String line;
            String[] cmd;
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.redirectInput();
            builder.redirectOutput();
            builder.redirectErrorStream(true);
            if (osname.toLowerCase().contains("win")) {
                cmd = new String[]{"cmd", "/c", chromeDriverBinary.getAbsolutePath(), "--version"};
                builder.command(cmd);
            } else {
                cmd = new String[]{chromeDriverBinary.getAbsolutePath(), "--version"};
                builder.command(cmd);
            }
            Process process = builder.start();
            LogTrace.invoke((Object)LogTrace, "[ChromeDriverUtils] Version-Object: " + process.toString());
            LogTrace.invoke((Object)LogTrace, "[ChromeDriverUtils] Version-Command InputStream: " + process.getInputStream().toString());
            InputStream is = process.getInputStream();
            InputStreamReader r = new InputStreamReader(is);
            BufferedReader in = new BufferedReader(r);
            while ((line = in.readLine()) != null) {
                output = output + line + "\n";
            }
            in.close();
        }
        catch (Exception error) {
            throw new Exception("ChromeDriver-Version konnte nicht ermittelt werden! Stellen Sie sicher die passende ChromeDriver-Binary f\u00fcr ihr System installiert ist\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        LogTrace.invoke((Object)LogTrace, "[ChromeDriverUtils] Version-Command Input/Output/Error: " + output);
        String[] chromeDriverVerRAWarray = output.substring(output.indexOf("ChromeDriver")).split(" ");
        return chromeDriverVerRAWarray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendCommandForDownloadChromeHeadLess(HttpCommandExecutor driverCommandExecutor, SessionId sessionId, String downloadPath, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        try {
            Json json = new Json();
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("cmd", "Page.setDownloadBehavior");
            HashMap<String, String> cmdParamsMap = new HashMap<String, String>();
            cmdParamsMap.put("behavior", "allow");
            cmdParamsMap.put("downloadPath", downloadPath);
            LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] Put Download-Pfad '" + downloadPath + "' with Download-behavior=allow");
            paramsMap.put("params", cmdParamsMap);
            String content = json.toJson(paramsMap);
            LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] The request content is :: {}" + content);
            URL remoteServerUri = null;
            try {
                Field field = HttpCommandExecutor.class.getDeclaredField("remoteServer");
                field.setAccessible(true);
                remoteServerUri = (URL)field.get(driverCommandExecutor);
            }
            catch (Exception e) {
                LogError.invoke((Object)LogError, "[ChromeDriverUtils] The HttpCommandExecutor has been modified please check with the framework team" + e);
                LogError.invoke((Object)LogError, "[ChromeDriverUtils] This will cause all the file validations to fail");
                return;
            }
            CloseableHttpClient httpclient = null;
            httpclient = HttpClients.createDefault();
            URIBuilder builder = new URIBuilder(remoteServerUri.toURI());
            builder.setPath("session/" + sessionId.toString() + "/chromium/send_command");
            HttpPost sendCommandPost = new HttpPost(builder.build());
            sendCommandPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            StringEntity entity = new StringEntity(content, ContentType.APPLICATION_JSON);
            sendCommandPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)sendCommandPost);
            int statusCode = response.getStatusLine().getStatusCode();
            LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] The Response Status code is {}" + statusCode);
            if (statusCode <= 200 && statusCode >= 300) {
                LogDebug.invoke((Object)LogDebug, "[ChromeDriverUtils] Un-Successfull status code received");
            }
            if (httpclient == null) return;
            try {
                httpclient.close();
                return;
            }
            catch (IOException e) {
                LogError.invoke((Object)LogError, "[ChromeDriverUtils] Error Occured while closing the http client" + e);
            }
            return;
            catch (IOException e) {
                LogError.invoke((Object)LogError, "[ChromeDriverUtils] Error Occured while enabling download file setting for chrome headless mode");
                LogError.invoke((Object)LogError, "[ChromeDriverUtils] This will cause all the file validations to fail" + e);
                if (httpclient == null) return;
                try {
                    httpclient.close();
                    return;
                }
                catch (IOException e2) {
                    LogError.invoke((Object)LogError, "[ChromeDriverUtils] Error Occured while closing the http client" + e2);
                }
                return;
            }
            catch (URISyntaxException e2) {
                LogError.invoke((Object)LogError, "[ChromeDriverUtils] this should never ever occur");
                if (httpclient == null) return;
                {
                    catch (Throwable throwable) {
                        if (httpclient == null) throw throwable;
                        try {
                            httpclient.close();
                            throw throwable;
                        }
                        catch (IOException e3) {
                            LogError.invoke((Object)LogError, "[ChromeDriverUtils] Error Occured while closing the http client" + e3);
                        }
                        throw throwable;
                    }
                }
                try {
                    httpclient.close();
                    return;
                }
                catch (IOException e4) {
                    LogError.invoke((Object)LogError, "[ChromeDriverUtils] Error Occured while closing the http client" + e4);
                }
                return;
            }
        }
        catch (Exception error) {
            throw new Exception(error);
        }
    }
}

