/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.check;

import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.BuildInfo;

public class SeleniumVersion {
    static final String LogIdent = "[WebSync:SeleniumVersionCheck] ";

    public static void check(String minSeleniumVer, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        boolean isSelfException = false;
        MonitorLog.invoke((Object)MonitorLog, "\u00dcberpr\u00fcfe Selenium-Version ...");
        LogInfo.invoke((Object)LogInfo, "[WebSync:SeleniumVersionCheck] \u00dcberpr\u00fcfe Selenium-Version ...");
        try {
            String seleniumVer = null;
            try {
                Class<?> seleniumClass = Class.forName("org.openqa.selenium.BuildInfo");
                BuildInfo seleniumInfo = new BuildInfo();
                seleniumVer = seleniumInfo.getReleaseLabel();
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Selenium-Version konnte nicht ermittelt werden. Stellen Sie sicher, dass Selenium mindestens in der Version " + minSeleniumVer + " installiert ist");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:SeleniumVersionCheck] minSeleniumVer: " + minSeleniumVer);
            LogDebug.invoke((Object)LogDebug, "[WebSync:SeleniumVersionCheck] seleniumVer: " + seleniumVer);
            String[] minSeleniumArray = minSeleniumVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:SeleniumVersionCheck] minSeleniumArray[0]: " + minSeleniumArray[0] + " / in parseFloat: " + Float.parseFloat(minSeleniumArray[0]) + "    und    minSeleniumArray[1]: " + minSeleniumArray[1] + " / in parseFloat: " + Float.parseFloat(minSeleniumArray[1]) + "    und    minSeleniumArray[2]: " + minSeleniumArray[2] + " / in parseFloat: " + Float.parseFloat(minSeleniumArray[2]));
            String[] SeleniumVerArray = seleniumVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:SeleniumVersionCheck] SeleniumVerArray[0]: " + SeleniumVerArray[0] + " / in parseFloat: " + Float.parseFloat(SeleniumVerArray[0]) + "    und    SeleniumVerArray[1]: " + SeleniumVerArray[1] + " / in parseFloat: " + Float.parseFloat(SeleniumVerArray[1]) + "    und    SeleniumVerArray[2]: " + SeleniumVerArray[2] + " / in parseFloat: " + Float.parseFloat(SeleniumVerArray[2]));
            if (Float.parseFloat(SeleniumVerArray[0]) < Float.parseFloat(minSeleniumArray[0]) || Float.parseFloat(SeleniumVerArray[0]) == Float.parseFloat(minSeleniumArray[0]) && Float.parseFloat(SeleniumVerArray[1]) < Float.parseFloat(minSeleniumArray[1]) || Float.parseFloat(SeleniumVerArray[0]) == Float.parseFloat(minSeleniumArray[0]) && Float.parseFloat(SeleniumVerArray[1]) == Float.parseFloat(minSeleniumArray[1]) && Float.parseFloat(SeleniumVerArray[2]) < Float.parseFloat(minSeleniumArray[2])) {
                isSelfException = true;
                throw new Exception("Fehler: Selenium-Version zu niedrig. Mindestens Version " + minSeleniumVer + " wird ben\u00f6tigt. (Ihre Version ist " + seleniumVer + ")");
            }
            MonitorLog.invoke((Object)MonitorLog, "OK: Selenium-Version " + seleniumVer + " installiert und aktiv");
            LogInfo.invoke((Object)LogInfo, "[WebSync:SeleniumVersionCheck] OK: Selenium-Version " + seleniumVer + " installiert und aktiv");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("(SeleniumVersion): " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

