/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.check;

import de.derrichter.finance.websync.utils.StringCharUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class PhantomJSVersion {
    static final String LogIdent = "[WebSync:PhantomJSVersionCheck] ";

    public static void Check(String minPhantomJSVer, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        boolean isSelfException = false;
        MonitorLog.invoke((Object)MonitorLog, "\u00dcberpr\u00fcfe PhantomJS-Version ...");
        LogInfo.invoke((Object)LogInfo, "[WebSync:PhantomJSVersionCheck] \u00dcberpr\u00fcfe PhantomJS-Version ...");
        try {
            String rawPhantomJSBinaryPath = System.getProperty("phantomjs.binary.path");
            if (StringCharUtils.isNullOrEmptyOrNothing(rawPhantomJSBinaryPath)) {
                isSelfException = true;
                throw new Exception("Pfad zur PhantomJS-Binary ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"phantomjs.binary.path\", <Pfad zur Binary>);'");
            }
            File phantomJSBinary = new File(rawPhantomJSBinaryPath);
            if (!phantomJSBinary.exists()) {
                isSelfException = true;
                throw new Exception("Pfad zur PhantomJS-Binary scheint nicht korrekt. Bitte \u00fcberpr\u00fcfen Sie diesen.");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSVersionCheck] Pfad zur PhantomJS-Binary: " + phantomJSBinary.getAbsolutePath());
            try {
                if (!phantomJSBinary.canExecute()) {
                    phantomJSBinary.setExecutable(true);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSVersionCheck] PhantomJS-Binary wurde erfolgreich als ausf\u00fcrbar markiert");
                }
            }
            catch (Exception error1) {
                isSelfException = true;
                throw new Exception("PhantomJS-Binary konnte nicht auf Ausf\u00fchrbarkeit gepr\u00fcft oder gesetzt werden: " + ExceptionUtils.getStackTrace((Throwable)error1));
            }
            String osname = System.getProperty("os.name");
            String osarch = System.getProperty("os.arch");
            System.out.println("OS-Info: " + osname + " " + osarch);
            String phantomJSVer = null;
            String output = "";
            try {
                String line;
                String[] cmd;
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.redirectInput();
                builder.redirectOutput();
                builder.redirectErrorStream(true);
                if (osname.contains("Win")) {
                    cmd = new String[]{"cmd", "/c", phantomJSBinary.getAbsolutePath(), "--version"};
                    builder.command(cmd);
                } else {
                    cmd = new String[]{phantomJSBinary.getAbsolutePath(), "--version"};
                    builder.command(cmd);
                }
                Process process = builder.start();
                LogTrace.invoke((Object)LogTrace, "[WebSync:PhantomJSVersionCheck] Version-Object: " + process.toString());
                LogTrace.invoke((Object)LogTrace, "[WebSync:PhantomJSVersionCheck] Version-Command InputStream: " + process.getInputStream().toString());
                InputStream is = process.getInputStream();
                InputStreamReader r = new InputStreamReader(is);
                BufferedReader in = new BufferedReader(r);
                while ((line = in.readLine()) != null) {
                    output = output + line + "\n";
                }
                in.close();
            }
            catch (Exception error) {
                throw new Exception("PhantomJS-Version konnte nicht ermittelt werden! Stellen Sie sicher die passende PhantomJS-Binary f\u00fcr ihr System, mindestens in der Version " + minPhantomJSVer + " installiert ist\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:PhantomJSVersionCheck] Version-Command Input/Output/Error: " + output);
            phantomJSVer = StringCharUtils.shrinkString(output.substring(output.indexOf("2\\.")));
            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSVersionCheck] minPhantomJSVer: " + minPhantomJSVer);
            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSVersionCheck] PhantomJSVer: " + phantomJSVer);
            String[] minPhantomJSArray = minPhantomJSVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSVersionCheck] minPhantomJSArray[0]: " + minPhantomJSArray[0] + " / in parseFloat: " + Float.parseFloat(minPhantomJSArray[0]) + "    und    minPhantomJSArray[1]: " + minPhantomJSArray[1] + " / in parseFloat: " + Float.parseFloat(minPhantomJSArray[1]) + "    und    minPhantomJSArray[2]: " + minPhantomJSArray[2] + " / in parseFloat: " + Float.parseFloat(minPhantomJSArray[2]));
            String[] phantomJSVerArray = phantomJSVer.split("\\.");
            String[] phantomJSVerArray3temp = phantomJSVerArray[2].split("-");
            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSVersionCheck] PhantomJSVerArray[0]: " + phantomJSVerArray[0] + " / in parseFloat: " + Float.parseFloat(phantomJSVerArray[0]) + "    und    PhantomJSVerArray[1]: " + phantomJSVerArray[1] + " / in parseFloat: " + Float.parseFloat(phantomJSVerArray[1]) + "    und    PhantomJSVerArray[2]: " + phantomJSVerArray[2] + " / in parseFloat: " + Float.parseFloat(phantomJSVerArray3temp[2]));
            if (Float.parseFloat(phantomJSVerArray[0]) < Float.parseFloat(minPhantomJSArray[0]) || Float.parseFloat(phantomJSVerArray[0]) == Float.parseFloat(minPhantomJSArray[0]) && Float.parseFloat(phantomJSVerArray[1]) < Float.parseFloat(minPhantomJSArray[1]) || Float.parseFloat(phantomJSVerArray[0]) == Float.parseFloat(minPhantomJSArray[0]) && Float.parseFloat(phantomJSVerArray[1]) == Float.parseFloat(minPhantomJSArray[1]) && Float.parseFloat(phantomJSVerArray3temp[0]) < Float.parseFloat(minPhantomJSArray[2])) {
                isSelfException = true;
                throw new Exception("PhantomJS-Version zu niedrig. Mindestens Version " + minPhantomJSVer + " wird ben\u00f6tigt. (Ihre Version ist " + phantomJSVer + ")");
            }
            MonitorLog.invoke((Object)MonitorLog, "OK: PhantomJS-Version " + phantomJSVer + " installiert und aktiv");
            LogInfo.invoke((Object)LogInfo, "[WebSync:PhantomJSVersionCheck] OK: PhantomJS-Version " + phantomJSVer + " installiert und aktiv");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("(PhantomJSVersion): " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

