/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.check;

import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.Version;

public class POIVersion {
    static final String LogIdent = "[WebSync:POIVersionCheck] ";

    public static void check(String minPOIVer, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        boolean isSelfException = false;
        MonitorLog.invoke((Object)MonitorLog, "\u00dcberpr\u00fcfe POI-Version ...");
        LogInfo.invoke((Object)LogInfo, "[WebSync:POIVersionCheck] \u00dcberpr\u00fcfe POI-Version ...");
        try {
            String poiVer = null;
            try {
                Class<?> POIClass = Class.forName("org.apache.poi.Version");
                poiVer = Version.getVersion();
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("POI-Version konnte nicht ermittelt werden. Stellen Sie sicher, dass POI mindestens in der Version " + minPOIVer + " installiert ist");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:POIVersionCheck] minPOIVer: " + minPOIVer);
            LogDebug.invoke((Object)LogDebug, "[WebSync:POIVersionCheck] POIVer: " + poiVer);
            String[] minPOIArray = minPOIVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:POIVersionCheck] minPOIArray[0]: " + minPOIArray[0] + " / in parseFloat: " + Float.parseFloat(minPOIArray[0]) + "    und    minPOIArray[1]: " + minPOIArray[1] + " / in parseFloat: " + Float.parseFloat(minPOIArray[1]) + "    und    minPOIArray[2]: " + minPOIArray[2] + " / in parseFloat: " + Float.parseFloat(minPOIArray[2]));
            String[] poiVerArray = poiVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:POIVersionCheck] POIVerArray[0]: " + poiVerArray[0] + " / in parseFloat: " + Float.parseFloat(poiVerArray[0]) + "    und    POIVerArray[1]: " + poiVerArray[1] + " / in parseFloat: " + Float.parseFloat(poiVerArray[1]) + "    und    POIVerArray[2]: " + poiVerArray[2] + " / in parseFloat: " + Float.parseFloat(poiVerArray[2]));
            if (Float.parseFloat(poiVerArray[0]) < Float.parseFloat(minPOIArray[0]) || Float.parseFloat(poiVerArray[0]) == Float.parseFloat(minPOIArray[0]) && Float.parseFloat(poiVerArray[1]) < Float.parseFloat(minPOIArray[1]) || Float.parseFloat(poiVerArray[0]) == Float.parseFloat(minPOIArray[0]) && Float.parseFloat(poiVerArray[1]) == Float.parseFloat(minPOIArray[1]) && Float.parseFloat(poiVerArray[2]) < Float.parseFloat(minPOIArray[2])) {
                isSelfException = true;
                throw new Exception("Fehler: POI-Version zu niedrig. Mindestens Version " + minPOIVer + " wird ben\u00f6tigt. (Ihre Version ist " + poiVer + ")");
            }
            MonitorLog.invoke((Object)MonitorLog, "OK: POI-Version " + poiVer + " installiert und aktiv");
            LogInfo.invoke((Object)LogInfo, "[WebSync:POIVersionCheck] OK: POI-Version " + poiVer + " installiert und aktiv");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("(POIVersion): " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

