/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.check;

import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pdfbox.util.Version;

public class PDFBoxVersion {
    static final String LogIdent = "[WebSync:PDFBoxVersionCheck] ";

    public static void check(String minPDFBoxVer, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        boolean isSelfException = false;
        MonitorLog.invoke((Object)MonitorLog, "\u00dcberpr\u00fcfe PDFBox-Version ...");
        LogInfo.invoke((Object)LogInfo, "[WebSync:PDFBoxVersionCheck] \u00dcberpr\u00fcfe PDFBox-Version ...");
        try {
            String pdfBoxVer = null;
            try {
                Class<?> PDFBoxClass = Class.forName("org.apache.pdfbox.util.Version");
                pdfBoxVer = Version.getVersion();
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("PDFBox-Version konnte nicht ermittelt werden. Stellen Sie sicher, dass PDFBox mindestens in der Version " + minPDFBoxVer + " installiert ist");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:PDFBoxVersionCheck] minPDFBoxVer: " + minPDFBoxVer);
            LogDebug.invoke((Object)LogDebug, "[WebSync:PDFBoxVersionCheck] PDFBoxVer: " + pdfBoxVer);
            String[] minPDFBoxArray = minPDFBoxVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:PDFBoxVersionCheck] minPDFBoxArray[0]: " + minPDFBoxArray[0] + " / in parseFloat: " + Float.parseFloat(minPDFBoxArray[0]) + "    und    minPDFBoxArray[1]: " + minPDFBoxArray[1] + " / in parseFloat: " + Float.parseFloat(minPDFBoxArray[1]) + "    und    minPDFBoxArray[2]: " + minPDFBoxArray[2] + " / in parseFloat: " + Float.parseFloat(minPDFBoxArray[2]));
            String[] pdfBoxVerArray = pdfBoxVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:PDFBoxVersionCheck] PDFBoxVerArray[0]: " + pdfBoxVerArray[0] + " / in parseFloat: " + Float.parseFloat(pdfBoxVerArray[0]) + "    und    PDFBoxVerArray[1]: " + pdfBoxVerArray[1] + " / in parseFloat: " + Float.parseFloat(pdfBoxVerArray[1]) + "    und    PDFBoxVerArray[2]: " + pdfBoxVerArray[2] + " / in parseFloat: " + Float.parseFloat(pdfBoxVerArray[2]));
            if (Float.parseFloat(pdfBoxVerArray[0]) < Float.parseFloat(minPDFBoxArray[0]) || Float.parseFloat(pdfBoxVerArray[0]) == Float.parseFloat(minPDFBoxArray[0]) && Float.parseFloat(pdfBoxVerArray[1]) < Float.parseFloat(minPDFBoxArray[1]) || Float.parseFloat(pdfBoxVerArray[0]) == Float.parseFloat(minPDFBoxArray[0]) && Float.parseFloat(pdfBoxVerArray[1]) == Float.parseFloat(minPDFBoxArray[1]) && Float.parseFloat(pdfBoxVerArray[2]) < Float.parseFloat(minPDFBoxArray[2])) {
                isSelfException = true;
                throw new Exception("Fehler: PDFBox-Version zu niedrig. Mindestens Version " + minPDFBoxVer + " wird ben\u00f6tigt. (Ihre Version ist " + pdfBoxVer + ")");
            }
            MonitorLog.invoke((Object)MonitorLog, "OK: PDFBox-Version " + pdfBoxVer + " installiert und aktiv");
            LogInfo.invoke((Object)LogInfo, "[WebSync:PDFBoxVersionCheck] OK: PDFBox-Version " + pdfBoxVer + " installiert und aktiv");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("(PDFBoxVersion): " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

