/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.check;

import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class JavaVersion {
    private static final String logIdent = "[WebSync:JavaCheck] ";
    static String osArtString = System.getProperty("os.name");
    static String javaHomeString = System.getProperty("java.home");
    static String javaVenString = System.getProperty("java.vendor");
    static String javaSysCodePage = System.getProperty("file.encoding");
    static String javaVer = null;
    static String javaVerDate = null;
    static String javaVendorVersion = null;
    static String javaVmSpecificationVer = null;
    static String javaVmVersion = null;
    static String javaSpecificationVersion = null;
    static String javaClassVersion = null;
    static String toHaveCodepage = null;

    public static void check(String minJavaVer, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        boolean isSelfException = false;
        MonitorLog.invoke((Object)MonitorLog, "\u00dcberpr\u00fcfe Java-Version und den verwendeten Zeichensatz ...");
        LogInfo.invoke((Object)LogInfo, "[WebSync:JavaCheck] \u00dcberpr\u00fcfe Java-Version und den verwendeten Zeichensatz ...");
        try {
            toHaveCodepage = osArtString.toLowerCase().contains("mac") ? "UTF-8" : (osArtString.contains("Win") ? "Cp1252, ISO-8859-15" : "UTF-8, ISO-8859-15");
            boolean makeCodepageInfo = false;
            try {
                Class<?> javaClass = Class.forName("java.lang.Class");
                javaVer = System.getProperty("java.version");
                javaVerDate = System.getProperty("java.version.date");
                javaVendorVersion = System.getProperty("java.vendor.version");
                javaVmSpecificationVer = System.getProperty("java.vm.specification.version");
                javaVmVersion = System.getProperty("java.vm.version");
                javaSpecificationVersion = System.getProperty("java.specification.version");
                javaClassVersion = System.getProperty("java.class.version");
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Java-Version konnte nicht ermittelt werden. Stellen Sie sicher dass Java mindestens in der Version " + minJavaVer + " installiert ist\n" + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] minJavaVer: " + minJavaVer);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] original Java-Version: " + javaVer);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] original Java-Versionsdate: " + javaVerDate);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] original Java Vendor-Version: " + javaVendorVersion);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] original Java VM-Specification-Version: " + javaVmSpecificationVer);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] original Java VM-Version: " + javaVmVersion);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] original Java Specification-Version: " + javaSpecificationVersion);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] original Java Class-Version: " + javaClassVersion);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] toHaveCodepage: " + toHaveCodepage);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] javaSysCodePage: " + javaSysCodePage);
            String[] minJavaArray = minJavaVer.split("\\.");
            LogTrace.invoke((Object)LogTrace, "[WebSync:JavaCheck] minJavaArray size: " + minJavaArray.length);
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] minJavaArray[0]: " + minJavaArray[0] + " / in parseFloat: " + Float.parseFloat(minJavaArray[0]) + "    und    minJavaArray[1]: " + minJavaArray[1] + " / in parseFloat: " + Float.parseFloat(minJavaArray[1]) + "    und    minJavaArray[2]: " + minJavaArray[2] + " / in parseFloat: " + Float.parseFloat(minJavaArray[2]));
            if (javaVer.endsWith("-ea")) {
                javaVer = javaVer.replace("-ea", "");
            }
            String[] javaVerArray = javaVer.split("\\.");
            LogTrace.invoke((Object)LogTrace, "[WebSync:JavaCheck] isJavaVerArray size: " + javaVerArray.length);
            String javaVerArrayContent2 = null;
            if (javaVerArray.length > 2) {
                javaVerArrayContent2 = javaVerArray[2];
            }
            if (javaVerArray.length > 2 && javaVerArray[2].contains("_")) {
                javaVerArray[2] = javaVerArray[2].split("_")[1];
                LogTrace.invoke((Object)LogTrace, "[WebSync:JavaCheck] javaVerArray[2] after split _: " + javaVerArray[2]);
            } else if (javaVerArray.length > 2 && javaVerArray[2].contains("-")) {
                javaVerArrayContent2 = javaVerArray[2].split("-")[0];
                LogTrace.invoke((Object)LogTrace, "[WebSync:JavaCheck] javaVerArray[2] after split - [0]: " + javaVerArray[2].split("-")[0]);
                LogTrace.invoke((Object)LogTrace, "[WebSync:JavaCheck] javaVerArray[2] after split - [1]: " + javaVerArray[2].split("-")[1]);
                if (javaVerArrayContent2.equals("0")) {
                    javaVerArrayContent2 = javaVerArray[2].split("-")[1];
                }
                javaVerArray[2] = javaVerArrayContent2;
            } else if (javaVerArray.length == 1 && StringUtils.isNumeric((CharSequence)javaVerArray[0])) {
                javaVerArray = new String(javaVerArray[0] + ".0.0").split("\\.");
            } else if (javaVerArray.length == 1 && javaVerArray[0].contains("_")) {
                javaVerArray = new String(javaVerArray[0].split("_")[0] + ".0.0").split("\\.");
            } else if (javaVerArray.length == 2 && StringUtils.isNumeric((CharSequence)javaVerArray[0]) && StringUtils.isNumeric((CharSequence)javaVerArray[1])) {
                javaVerArray = new String(javaVerArray[0] + javaVerArray[1] + ".0").split("\\.");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:JavaCheck] javaVerArray[0]: " + javaVerArray[0] + " / in parseFloat: " + Float.parseFloat(javaVerArray[0]) + "    und    javaVerArray[1]: " + javaVerArray[1] + " / in parseFloat: " + Float.parseFloat(javaVerArray[1]) + "    und    javaVerArray[2]: " + javaVerArray[2] + " / in parseFloat: " + Float.parseFloat(javaVerArray[2]));
            if (Float.parseFloat(javaVerArray[0]) < Float.parseFloat(minJavaArray[0]) || Float.parseFloat(javaVerArray[0]) == Float.parseFloat(minJavaArray[0]) && Float.parseFloat(javaVerArray[1]) < Float.parseFloat(minJavaArray[1]) || Float.parseFloat(javaVerArray[0]) == Float.parseFloat(minJavaArray[0]) && Float.parseFloat(javaVerArray[1]) == Float.parseFloat(minJavaArray[1]) && Float.parseFloat(javaVerArray[2]) < Float.parseFloat(minJavaArray[2])) {
                isSelfException = true;
                throw new Exception("Achtung: Java-Version zu niedrig. Mindestens Version " + minJavaVer + " wird ben\u00f6tigt. (aktuell verwendete Umgebung durch Jameica ist die Version " + javaVer + ")");
            }
            if (javaSysCodePage.indexOf(toHaveCodepage) != -1 || toHaveCodepage.indexOf(javaSysCodePage) != -1) {
                MonitorLog.invoke((Object)MonitorLog, "OK: Java-Version " + javaVer + " von '" + javaVenString + "' installiert, aktiv und verwendet Zeichensatz '" + javaSysCodePage + "' (Home: " + javaHomeString + ")");
                LogInfo.invoke((Object)LogInfo, "[WebSync:JavaCheck] Java-Version " + javaVer + " von '" + javaVenString + "' installiert, aktiv und verwendet Zeichensatz '" + javaSysCodePage + "' (Home: " + javaHomeString + ")");
            } else {
                MonitorLog.invoke((Object)MonitorLog, "ACHTUNG: Java-Version " + javaVer + " ist zwar OK aber verwendet falschen Zeichensatz '" + javaSysCodePage + "' (Richtig w\u00e4re '" + toHaveCodepage + "')");
                LogWarn.invoke((Object)LogWarn, "[WebSync:JavaCheck] ACHTUNG: Java-Version " + javaVer + " ist zwar OK aber verwendet falschen Zeichensatz '" + javaSysCodePage + "' (Richtig w\u00e4re '" + toHaveCodepage + "')");
                makeCodepageInfo = true;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("(JavaVersion): " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

