/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.check;

import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Version;

public class HTMLUnitVersion {
    static final String LogIdent = "[WebSync:HTMLUnitVersionCheck] ";

    public static void check(String minHTMLUnitVer, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        boolean isSelfException = false;
        MonitorLog.invoke((Object)MonitorLog, "\u00dcberpr\u00fcfe HTMLUnit-Version ...");
        LogInfo.invoke((Object)LogInfo, "[WebSync:HTMLUnitVersionCheck] \u00dcberpr\u00fcfe HTMLUnit-Version ...");
        try {
            String htmlUnitVer = null;
            try {
                Class<?> htmlUnitClass = Class.forName("org.htmlunit.Version");
                htmlUnitVer = Version.getProductVersion();
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("HTMLUnit-Version konnte nicht ermittelt werden. Stellen Sie sicher dass HTMLUnit mindestens in der Version " + minHTMLUnitVer + " installiert ist");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:HTMLUnitVersionCheck] minHTMLUnitVer: " + minHTMLUnitVer);
            LogDebug.invoke((Object)LogDebug, "[WebSync:HTMLUnitVersionCheck] HTMLUnitVer: " + htmlUnitVer);
            String[] minHTMLUnitArray = minHTMLUnitVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:HTMLUnitVersionCheck] minHTMLUnitArray[0]: " + minHTMLUnitArray[0] + " / in parseFloat: " + Float.parseFloat(minHTMLUnitArray[0]) + "    und    minHTMLUnitArray[1]: " + minHTMLUnitArray[1] + " / in parseFloat: " + Float.parseFloat(minHTMLUnitArray[1]));
            String[] htmlUnitVerArray = htmlUnitVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:HTMLUnitVersionCheck] HTMLUnitVerArray[0]: " + htmlUnitVerArray[0] + " / in parseFloat: " + Float.parseFloat(htmlUnitVerArray[0]) + "    und    HTMLUnitVerArray[1]: " + htmlUnitVerArray[1] + " / in parseFloat: " + Float.parseFloat(htmlUnitVerArray[1]));
            if (Float.parseFloat(htmlUnitVerArray[0]) < Float.parseFloat(minHTMLUnitArray[0]) || Float.parseFloat(htmlUnitVerArray[0]) == Float.parseFloat(minHTMLUnitArray[0]) && Float.parseFloat(htmlUnitVerArray[1]) < Float.parseFloat(minHTMLUnitArray[1])) {
                isSelfException = true;
                throw new Exception("HTMLUnit-Version zu niedrig. Mindestens Version " + minHTMLUnitVer + " wird ben\u00f6tigt. (Ihre Version ist " + htmlUnitVer + ")");
            }
            MonitorLog.invoke((Object)MonitorLog, "OK: HTMLUnit-Version " + htmlUnitVer + " installiert und aktiv");
            LogInfo.invoke((Object)LogInfo, "[WebSync:HTMLUnitVersionCheck] OK: HTMLUnit-Version " + htmlUnitVer + " installiert und aktiv");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("(HTMLUnitVersion): " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

