/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils.check;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.ChromeDriverUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ChromeDriverVersion {
    static final String LogIdent = "[WebSync:ChromeDriverVersionCheck] ";

    public static void check(String minChromeDriverVer, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        boolean isSelfException = false;
        MonitorLog.invoke((Object)MonitorLog, "\u00dcberpr\u00fcfe ChromeDriver-Version ...");
        LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverVersionCheck] \u00dcberpr\u00fcfe ChromeDriver-Version ...");
        try {
            String chromeDriverVer;
            try {
                chromeDriverVer = StringCharUtils.shrinkString(ChromeDriverUtils.getChromeDriverVersion(externalLogger, externalProgressMonitor));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverVersionCheck] minChromeDriverVer: " + minChromeDriverVer);
            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverVersionCheck] ChromeDriverVer: " + chromeDriverVer);
            String[] minChromeDriverArray = minChromeDriverVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverVersionCheck] minChromeDriverArray[0]: " + minChromeDriverArray[0] + " / in parseFloat: " + Float.parseFloat(minChromeDriverArray[0]) + "    und    minChromeDriverArray[1]: " + minChromeDriverArray[1] + " / in parseFloat: " + Float.parseFloat(minChromeDriverArray[1]));
            String[] chromeDriverVerArray = chromeDriverVer.split("\\.");
            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverVersionCheck] ChromeDriverVerArray[0]: " + chromeDriverVerArray[0] + " / in parseFloat: " + Float.parseFloat(chromeDriverVerArray[0]) + "    und    ChromeDriverVerArray[1]: " + chromeDriverVerArray[1] + " / in parseFloat: " + Float.parseFloat(chromeDriverVerArray[1]));
            if (Float.parseFloat(chromeDriverVerArray[0]) < Float.parseFloat(minChromeDriverArray[0]) || Float.parseFloat(chromeDriverVerArray[0]) == Float.parseFloat(minChromeDriverArray[0]) && Float.parseFloat(chromeDriverVerArray[1]) < Float.parseFloat(minChromeDriverArray[1])) {
                isSelfException = true;
                throw new Exception("ChromeDriver-Version zu niedrig. Mindestens Version " + minChromeDriverVer + " wird ben\u00f6tigt. (Ihre Version ist " + chromeDriverVer + ")");
            }
            MonitorLog.invoke((Object)MonitorLog, "OK: ChromeDriver-Version " + chromeDriverVer + " installiert und aktiv");
            LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverVersionCheck] OK: ChromeDriver-Version " + chromeDriverVer + " installiert und aktiv");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("(ChromeDriverVersion): " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

