/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.X7875_NewUnix;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class ZipFileUtils {
    private static final List<String> DEFAULT_EXCLUDES = Collections.singletonList(".DS_Store");
    private static final int O400 = 256;
    private static final int O200 = 128;
    private static final int O100 = 64;
    private static final int O040 = 32;
    private static final int O020 = 16;
    private static final int O010 = 8;
    private static final int O004 = 4;
    private static final int O002 = 2;
    private static final int O001 = 1;
    private static final String LogIdent = "[ZipFileUtils] ";

    public static void extractAll(File sourceZip, File outputDir, Class<?> ExternalLogger) throws Exception {
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        LogTrace.invoke((Object)LogTrace, "[ZipFileUtils] sourceZip to unpack: " + sourceZip.getAbsolutePath());
        LogTrace.invoke((Object)LogTrace, "[ZipFileUtils] outputDirPath to unpack: " + outputDir.getAbsolutePath());
        if (!outputDir.exists()) {
            FileUtils.forceMkdir((File)outputDir);
        }
        try (ZipFile zipFile = new ZipFile(sourceZip);){
            ArrayList<ZipArchiveEntry> zipArchiveEntries = Collections.list(zipFile.getEntries());
            for (ZipArchiveEntry zipArchiveEntry : zipArchiveEntries) {
                if (System.getProperty("os.name").contains("Win") && zipArchiveEntry.isUnixSymlink()) continue;
                ZipFileUtils.extract(zipArchiveEntry, zipFile, outputDir, ExternalLogger);
            }
        }
        catch (Exception error) {
            throw new Exception("unzip error: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static void extract(String zipArchiveEntryName, File sourceZip, File outputDir, Class<?> externalLogger) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try (ZipFile zipFile = new ZipFile(sourceZip);){
            ZipArchiveEntry zipArchiveEntry = zipFile.getEntry(zipArchiveEntryName);
            ZipFileUtils.extract(zipArchiveEntry, zipFile, outputDir, externalLogger);
        }
    }

    private static void extract(ZipArchiveEntry zipArchiveEntry, ZipFile zipFile, File outputDir, Class<?> externalLogger) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        File extractedFile = new File(outputDir, zipArchiveEntry.getName());
        FileUtils.forceMkdir((File)extractedFile.getParentFile());
        if (zipArchiveEntry.isUnixSymlink()) {
            if (ZipFileUtils.isPosixFileStore(outputDir)) {
                LogTrace.invoke((Object)LogTrace, "[ZipFileUtils] Extracting [l] " + zipArchiveEntry.getName());
                String symlinkTarget = zipFile.getUnixSymlink(zipArchiveEntry);
                File symPath = new File(symlinkTarget);
                if (symPath.exists()) {
                    Files.delete(extractedFile.toPath());
                }
                Files.deleteIfExists(extractedFile.toPath());
                Files.createSymbolicLink(extractedFile.toPath(), symPath.toPath(), new FileAttribute[0]);
            } else {
                LogTrace.invoke((Object)LogTrace, "[ZipFileUtils] Skipping ! [l] " + zipArchiveEntry.getName());
            }
        } else if (zipArchiveEntry.isDirectory()) {
            LogTrace.invoke((Object)LogTrace, "[ZipFileUtils] Extracting [d] " + zipArchiveEntry.getName());
            FileUtils.forceMkdir((File)extractedFile);
        } else {
            if (extractedFile.exists()) {
                FileUtils.forceDelete((File)extractedFile);
            }
            LogTrace.invoke((Object)LogTrace, "[ZipFileUtils] Extracting [f] " + zipArchiveEntry.getName());
            try (InputStream in = zipFile.getInputStream(zipArchiveEntry);
                 FileOutputStream out = new FileOutputStream(extractedFile);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        ZipFileUtils.updatePermissions(extractedFile, zipArchiveEntry.getUnixMode());
    }

    private static void updatePermissions(File file, int unixMode) throws IOException {
        Set<PosixFilePermission> permissions;
        if (!Files.isSymbolicLink(file.toPath()) && ZipFileUtils.isPosixFileStore(file) && !(permissions = ZipFileUtils.getPosixPermissionsAsSet(unixMode)).isEmpty()) {
            Files.setPosixFilePermissions(file.toPath(), permissions);
        }
    }

    public static void compressDirectory(File rootDir, boolean includeAsRoot, File output, Class<?> externalLogger) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!rootDir.isDirectory()) {
            throw new IOException("Provided file is not a directory");
        }
        try (FileOutputStream archiveStream = new FileOutputStream(output);
             ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)archiveStream);){
            String rootName = "";
            if (includeAsRoot) {
                ZipFileUtils.insertDirectory(rootDir, rootDir.getName(), archive);
                rootName = rootDir.getName() + "/";
            }
            Collection fileCollection = FileUtils.listFilesAndDirs((File)rootDir, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE);
            for (File file : fileCollection) {
                String relativePath = ZipFileUtils.getRelativePath(rootDir, file);
                String entryName = rootName + relativePath;
                if (relativePath.isEmpty() || "/".equals(relativePath)) continue;
                ZipFileUtils.insertObject(file, entryName, archive, externalLogger);
            }
            archive.finish();
        }
        catch (IOException | ArchiveException e) {
            throw new IOException(e);
        }
    }

    private static void insertObject(File file, String entryName, ArchiveOutputStream archive, Class<?> externalLogger) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (Files.isSymbolicLink(file.toPath())) {
            ZipFileUtils.insertSymlink(file, entryName, Files.readSymbolicLink(file.toPath()).toString(), archive);
        } else if (file.isDirectory()) {
            ZipFileUtils.insertDirectory(file, entryName, archive);
        } else if (file.isFile()) {
            ZipFileUtils.insertFile(file, entryName, archive, externalLogger);
        }
    }

    private static void insertSymlink(File file, String entryName, String linkTarget, ArchiveOutputStream archive) throws IOException {
        if (!Files.isSymbolicLink(file.toPath())) {
            throw new IOException("Provided file is not a symlink");
        }
        ZipArchiveEntry newEntry = new ZipArchiveEntry(entryName);
        ZipFileUtils.setExtraFields(file.toPath(), 40960, newEntry);
        archive.putArchiveEntry((ArchiveEntry)newEntry);
        archive.write(linkTarget.getBytes());
        archive.closeArchiveEntry();
    }

    private static void insertDirectory(File dir, String entryName, ArchiveOutputStream archive) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("Provided file is not a directory");
        }
        ZipArchiveEntry newEntry = new ZipArchiveEntry(entryName + "/");
        ZipFileUtils.setExtraFields(dir.toPath(), 16384, newEntry);
        archive.putArchiveEntry((ArchiveEntry)newEntry);
        archive.closeArchiveEntry();
    }

    private static void insertFile(File file, String entryName, ArchiveOutputStream archive, Class<?> externalLogger) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        if (DEFAULT_EXCLUDES.contains(file.getName())) {
            LogTrace.invoke((Object)LogTrace, "[ZipFileUtils] Skipping ! [l] {} " + entryName);
            return;
        }
        if (!file.isFile()) {
            throw new IOException("Provided file is not a file");
        }
        ZipArchiveEntry newEntry = new ZipArchiveEntry(entryName);
        ZipFileUtils.setExtraFields(file.toPath(), 32768, newEntry);
        archive.putArchiveEntry((ArchiveEntry)newEntry);
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        IOUtils.copy((InputStream)input, (OutputStream)archive);
        input.close();
        archive.closeArchiveEntry();
    }

    private static void setExtraFields(Path filePath, int fileType, ZipArchiveEntry entry) throws IOException {
        if (ZipFileUtils.isPosixFileStore(filePath)) {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(filePath, new LinkOption[0]);
            entry.setUnixMode(fileType | ZipFileUtils.getPosixPermissionsAsInt(perms));
            X5455_ExtendedTimestamp x5455 = ZipFileUtils.getX5455(filePath);
            X7875_NewUnix x7875 = ZipFileUtils.getX7875(filePath);
            if (x5455 != null && x7875 != null) {
                entry.setExtraFields(new ZipExtraField[]{x5455, x7875});
            }
        }
    }

    private static X5455_ExtendedTimestamp getX5455(Path filePath) throws IOException {
        Map<String, Object> fileAttr;
        X5455_ExtendedTimestamp x5455 = null;
        if (ZipFileUtils.isPosixFileStore(filePath) && (fileAttr = ZipFileUtils.getFileAttributes(filePath)).get("lastModifiedTime") != null && fileAttr.get("lastAccessTime") != null) {
            x5455 = new X5455_ExtendedTimestamp();
            x5455.setModifyJavaTime(new Date(((FileTime)fileAttr.get("lastModifiedTime")).toMillis()));
            x5455.setAccessJavaTime(new Date(((FileTime)fileAttr.get("lastAccessTime")).toMillis()));
        }
        return x5455;
    }

    private static X7875_NewUnix getX7875(Path filePath) throws IOException {
        Map<String, Object> fileAttr;
        X7875_NewUnix x7875 = null;
        if (ZipFileUtils.isPosixFileStore(filePath) && (fileAttr = ZipFileUtils.getFileAttributes(filePath)).get("gid") != null && fileAttr.get("uid") != null) {
            x7875 = new X7875_NewUnix();
            x7875.setGID(Long.valueOf(fileAttr.get("gid").toString()).longValue());
            x7875.setUID(Long.valueOf(fileAttr.get("uid").toString()).longValue());
        }
        return x7875;
    }

    private static Map<String, Object> getFileAttributes(Path path) throws IOException {
        return Files.readAttributes(path, "unix:*", LinkOption.NOFOLLOW_LINKS);
    }

    private static String getRelativePath(File base, File path) {
        return base.toPath().relativize(path.toPath()).toString().replace("\\", "/");
    }

    public static boolean isPosixFileStore(File file) throws IOException {
        return ZipFileUtils.isPosixFileStore(file.toPath());
    }

    public static boolean isPosixFileStore(Path path) throws IOException {
        return Files.isSymbolicLink(path) || Files.getFileStore(path).supportsFileAttributeView("posix");
    }

    public static int getPosixPermissionsAsInt(Set<PosixFilePermission> permissionSet) {
        int result = 0;
        if (permissionSet.contains((Object)PosixFilePermission.OWNER_READ)) {
            result |= 0x100;
        }
        if (permissionSet.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            result |= 0x80;
        }
        if (permissionSet.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            result |= 0x40;
        }
        if (permissionSet.contains((Object)PosixFilePermission.GROUP_READ)) {
            result |= 0x20;
        }
        if (permissionSet.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            result |= 0x10;
        }
        if (permissionSet.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            result |= 8;
        }
        if (permissionSet.contains((Object)PosixFilePermission.OTHERS_READ)) {
            result |= 4;
        }
        if (permissionSet.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            result |= 2;
        }
        if (permissionSet.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            result |= 1;
        }
        return result;
    }

    public static Set<PosixFilePermission> getPosixPermissionsAsSet(int mode) {
        HashSet<PosixFilePermission> permissionSet = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) == 256) {
            permissionSet.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) == 128) {
            permissionSet.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) == 64) {
            permissionSet.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) == 32) {
            permissionSet.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) == 16) {
            permissionSet.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) == 8) {
            permissionSet.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) == 4) {
            permissionSet.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) == 2) {
            permissionSet.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) == 1) {
            permissionSet.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissionSet;
    }
}

