/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TarFileUtils {
    private static final String LogIdent = "[TarFileUtils] ";
    private static final int INTERNAL_BUFFER_SIZE = 4096;

    public static void extractAll(String tarFilePath, String outputDirPath, Class<?> ExternalLogger) throws Exception {
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        LogTrace.invoke((Object)LogTrace, "[TarFileUtils] tarFilePath to unpack: " + tarFilePath);
        LogTrace.invoke((Object)LogTrace, "[TarFileUtils] outputDirPath to unpack: " + outputDirPath);
        if (!new File(outputDirPath).exists()) {
            FileUtils.forceMkdir((File)new File(outputDirPath));
        }
        TarArchiveEntry entry = null;
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new FileInputStream(tarFilePath));){
            while ((entry = (TarArchiveEntry)tis.getNextEntry()) != null) {
                String osname;
                LogTrace.invoke((Object)LogTrace, "[TarFileUtils] Extracting [l] " + entry.getName());
                File entryDestination = new File(outputDirPath, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                } else {
                    entryDestination.getParentFile().mkdirs();
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryDestination));
                    TarFileUtils.copyStream((InputStream)tis, out, false, true);
                }
                if ((osname = System.getProperty("os.name")).contains("Win")) continue;
                Files.setPosixFilePermissions(entryDestination.getCanonicalFile().toPath(), TarFileUtils.getPosixFilePermission(entry.getMode()));
            }
        }
        catch (Exception e) {
            String errorMsg = null;
            errorMsg = entry != null ? "Unable to untar " + entry.getName() + " from " + tarFilePath + ".Target directory '" + outputDirPath + "' is in inconsistent state." : "Could not read data from " + tarFilePath;
            throw new Exception(errorMsg + ": " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyStream(InputStream input, OutputStream output, boolean closeInputStream, boolean closeOutputStream, long maxSize) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        try {
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
                if (maxSize <= 0L || (count += (long)n) <= maxSize) continue;
                throw new IOException("Unable to copy input stream. Max size of " + maxSize + " bytes reached.");
            }
        }
        finally {
            if (closeInputStream) {
                TarFileUtils.closeStream(input);
            }
            if (closeOutputStream) {
                TarFileUtils.closeStream(output);
            }
        }
        return count;
    }

    public static long copyStream(InputStream input, OutputStream output, boolean closeInputStream, boolean closeOutputStream) throws IOException {
        return TarFileUtils.copyStream(input, output, closeInputStream, closeOutputStream, -1L);
    }

    public static long copyStream(InputStream input, OutputStream output) throws IOException {
        return TarFileUtils.copyStream(input, output, true, true, -1L);
    }

    public static boolean closeStream(Closeable closeable) {
        return TarFileUtils.closeStream(closeable, null);
    }

    public static boolean closeStream(Closeable closeable, String message) {
        if (closeable == null) {
            return true;
        }
        boolean closed = false;
        try {
            closeable.close();
            closed = true;
        }
        catch (IOException e) {
            System.out.println("Could not close a stream: " + e.getMessage());
        }
        return closed;
    }

    private static Set<PosixFilePermission> getPosixFilePermission(int permissions) {
        HashSet<PosixFilePermission> filePermissions = new HashSet<PosixFilePermission>();
        if ((permissions & 0x100) > 0) {
            filePermissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((permissions & 0x80) > 0) {
            filePermissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((permissions & 0x40) > 0) {
            filePermissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((permissions & 0x20) > 0) {
            filePermissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((permissions & 0x10) > 0) {
            filePermissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((permissions & 8) > 0) {
            filePermissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((permissions & 4) > 0) {
            filePermissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((permissions & 2) > 0) {
            filePermissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((permissions & 1) > 0) {
            filePermissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return filePermissions;
    }
}

