/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import de.derrichter.finance.websync.utils.TarFileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TarBzip2FileUtils {
    private static final String LogIdent = "[TarBzip2FileUtils] ";
    private static final int INTERNAL_BUFFER_SIZE = 4096;

    public static void extractAll(String bzip2FilePath, String outputDirPath, Class<?> ExternalLogger) throws Exception {
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        LogTrace.invoke((Object)LogTrace, "[TarBzip2FileUtils] bzip2FilePath to unpack: " + bzip2FilePath);
        LogTrace.invoke((Object)LogTrace, "[TarBzip2FileUtils] outputDirPath and file to unpack: " + outputDirPath + File.separator + "bzip2-tempfile.tar");
        if (!new File(outputDirPath).exists()) {
            FileUtils.forceMkdir((File)new File(outputDirPath));
        }
        String bzip2TempFile = outputDirPath + File.separator + "bzip2-tempfile.tar";
        File tarFile = new File(bzip2TempFile);
        try {
            InputStream fin = Files.newInputStream(Paths.get(bzip2FilePath, new String[0]), new OpenOption[0]);
            BufferedInputStream in = new BufferedInputStream(fin);
            OutputStream out = Files.newOutputStream(Paths.get(bzip2TempFile, new String[0]), new OpenOption[0]);
            BZip2CompressorInputStream bzIn = new BZip2CompressorInputStream((InputStream)in);
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = bzIn.read(buffer))) {
                out.write(buffer, 0, n);
            }
            out.close();
            bzIn.close();
        }
        catch (Exception error) {
            throw new Exception("bzip2 unpack error: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        TarFileUtils.extractAll(bzip2TempFile, outputDirPath, ExternalLogger);
        try {
            FileUtils.forceDelete((File)tarFile);
        }
        catch (Exception delLater) {
            FileUtils.forceDeleteOnExit((File)tarFile);
        }
    }
}

