/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.htmlunit.html.HtmlPage;

public class SysUtils {
    public static final String SUPPORT_TEMP_PATH = System.getProperty("java.io.tmpdir") + File.separator + "finance.websync.supportpack" + File.separator;

    public static Date getDate(int year, int month, int day) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        Date dateRepresentation = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        return formatter.parse(formatter.format(dateRepresentation));
    }

    public static int getWeekDay(Date time) {
        Calendar cal = Calendar.getInstance();
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        return cal.get(7);
    }

    public static int getDay(Date time) {
        Calendar cal = Calendar.getInstance();
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        return cal.get(5);
    }

    public static int getMonth(Date time) {
        Calendar cal = Calendar.getInstance();
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        return cal.get(2);
    }

    public static int getYear(Date time) {
        Calendar cal = Calendar.getInstance();
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        return cal.get(1);
    }

    public static int getHour(Date time) {
        Calendar cal = Calendar.getInstance();
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        return cal.get(10);
    }

    public static int getMinutes(Date time) {
        Calendar cal = Calendar.getInstance();
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        return cal.get(12);
    }

    public static int getSeconds(Date time) {
        Calendar cal = Calendar.getInstance();
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        return cal.get(13);
    }

    public static Date setHour(Date time, int hours) {
        System.out.println("Entwickler's Datum-Check [date for cal]: " + String.valueOf(time));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        System.out.println("Entwickler's Datum-Check [cal toSetHour Time]: " + String.valueOf(cal));
        cal.set(11, hours);
        System.out.println("Entwickler's Datum-Check [cal Time after set Hour]: " + String.valueOf(cal));
        Date dateRepresentation = cal.getTime();
        System.out.println("Entwickler's Datum-Check [dateRepresentation from cal]: " + String.valueOf(dateRepresentation));
        return dateRepresentation;
    }

    public static Date setMinutes(Date time, int minutes) {
        System.out.println("Entwickler's Datum-Check [date for cal]: " + String.valueOf(time));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        System.out.println("Entwickler's Datum-Check [cal toSetMinutes Time]: " + String.valueOf(cal));
        cal.set(12, minutes);
        System.out.println("Entwickler's Datum-Check [cal Time after set Minutes]: " + String.valueOf(cal));
        Date dateRepresentation = cal.getTime();
        System.out.println("Entwickler's Datum-Check [dateRepresentation from cal]: " + String.valueOf(dateRepresentation));
        return dateRepresentation;
    }

    public static Date setSeconds(Date time, int seconds) {
        System.out.println("Entwickler's Datum-Check [date for cal]: " + String.valueOf(time));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        System.out.println("Entwickler's Datum-Check [cal toSetSeconds Time]: " + String.valueOf(cal));
        cal.set(13, seconds);
        System.out.println("Entwickler's Datum-Check [cal Time after set Seconds]: " + String.valueOf(cal));
        Date dateRepresentation = cal.getTime();
        System.out.println("Entwickler's Datum-Check [dateRepresentation from cal]: " + String.valueOf(dateRepresentation));
        return dateRepresentation;
    }

    public static Date setDateTimeToZero(Date time) {
        System.out.println("Entwickler's Datum-Check [date for cal]: " + String.valueOf(time));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        Date givenDate = new Date(time.getTime());
        cal.setTime(givenDate);
        System.out.println("Entwickler's Datum-Check [cal toSetSeconds Time]: " + String.valueOf(cal));
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        System.out.println("Entwickler's Datum-Check [cal Time after set Seconds]: " + String.valueOf(cal));
        Date dateRepresentation = cal.getTime();
        System.out.println("Entwickler's Datum-Check [dateRepresentation from cal]: " + String.valueOf(dateRepresentation));
        return dateRepresentation;
    }

    public static Double getDoubleFromZahl(String s) {
        return Double.parseDouble(s.replace(".", "").replace(",", "."));
    }

    public static String[] parse(String line) {
        if (line == null || line.length() == 0) {
            return new String[0];
        }
        ArrayList<String> out = new ArrayList<String>();
        String rest = line.trim();
        int lastpos = 0;
        while (rest.length() > 0) {
            boolean zulang;
            if (rest.length() < 28) {
                out.add(rest);
                rest = "";
                continue;
            }
            int pos = rest.indexOf(32, lastpos + 1);
            boolean bl = zulang = pos > 28 || pos == -1;
            if (lastpos == 0 && zulang) {
                out.add(rest.substring(0, 27));
                rest = rest.substring(27).trim();
                continue;
            }
            if (!zulang) {
                lastpos = pos;
                continue;
            }
            out.add(rest.substring(0, lastpos));
            rest = rest.substring(lastpos + 1).trim();
            lastpos = 0;
        }
        return out.toArray(new String[0]);
    }

    public static void writePage(HtmlPage page, String s) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter("/tmp/" + s + ".txt"));
        out.write(page.getUrl() + "\n");
        out.write("===============================================\n");
        out.write(page.asNormalizedText() + "\n");
        out.write("===============================================\n");
        out.close();
        out = new BufferedWriter(new FileWriter("/tmp/" + s + ".xml"));
        out.write(page.asXml());
        out.close();
    }
}

