/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.html.HtmlRadioButtonInput;

public class StringCharUtils {
    private static final String LogIdent = "[WebSync:StringCharUtils] ";

    public static String shrinkWhitespaces(String item) {
        item = item.trim();
        item = item.replaceAll("^ +", "");
        item = item.replaceAll(" +", " ");
        item = item.replaceAll(" +$", "");
        return item;
    }

    public static String shrinkString(String item) {
        if (StringCharUtils.isNullOrEmpty(item)) {
            item = "";
        }
        item = item.trim();
        item = item.replaceAll("\\s+", " ");
        item = item.replaceAll("\\t\\n\\x0B\\f\\r", "");
        item = item.replaceAll("\u0080", "");
        return item;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNullOrEmptyOrNothing(String str) {
        return str == null || str.length() == 0 || str.matches("\\s+");
    }

    public static String HEXtoChar(String original) {
        String StringfromHEX = original.replaceAll("\\\\", "").replaceAll("x1E9E", "\u00df");
        StringfromHEX = StringfromHEX.replaceAll("&#x20;", " ");
        StringfromHEX = StringfromHEX.replaceAll("x20", " ");
        StringfromHEX = StringfromHEX.replaceAll("&#x21;", "!");
        StringfromHEX = StringfromHEX.replaceAll("x21", "!");
        StringfromHEX = StringfromHEX.replaceAll("&#x2c;", ",");
        StringfromHEX = StringfromHEX.replaceAll("x2c", ",");
        StringfromHEX = StringfromHEX.replaceAll("&#x2d;", "-");
        StringfromHEX = StringfromHEX.replaceAll("x2d", "-");
        StringfromHEX = StringfromHEX.replaceAll("&#x2e;", ".");
        StringfromHEX = StringfromHEX.replaceAll("x2e", ".");
        StringfromHEX = StringfromHEX.replaceAll("&#xC4;", "\u00c4");
        StringfromHEX = StringfromHEX.replaceAll("xC4", "\u00c4");
        StringfromHEX = StringfromHEX.replaceAll("&#xE4;", "\u00e4");
        StringfromHEX = StringfromHEX.replaceAll("xE4", "\u00e4");
        StringfromHEX = StringfromHEX.replaceAll("&#xD6;", "\u00d6");
        StringfromHEX = StringfromHEX.replaceAll("xD6", "\u00d6");
        StringfromHEX = StringfromHEX.replaceAll("&#xF6;", "\u00f6");
        StringfromHEX = StringfromHEX.replaceAll("xF6", "\u00f6");
        StringfromHEX = StringfromHEX.replaceAll("&#xDC;", "\u00dc");
        StringfromHEX = StringfromHEX.replaceAll("xDC", "\u00dc");
        StringfromHEX = StringfromHEX.replaceAll("&#xFC;", "\u00fc");
        StringfromHEX = StringfromHEX.replaceAll("xFC", "\u00fc");
        StringfromHEX = StringfromHEX.replaceAll("&#xDF;", "\u00df");
        StringfromHEX = StringfromHEX.replaceAll("xDF", "\u00df");
        StringfromHEX = StringfromHEX.replaceAll("&#x1e9e;", "\u00df");
        StringfromHEX = StringfromHEX.replaceAll("x1e9e", "\u00df");
        return StringfromHEX;
    }

    public static String OctaltoChar(String original) {
        String stringfromHEX = original;
        stringfromHEX = stringfromHEX.replaceAll("\\\\212", String.valueOf('\u008a'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\213", String.valueOf('\u008b'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\214", String.valueOf('\u008c'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\216", String.valueOf('\u008e'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\231", String.valueOf('\u0099'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\232", String.valueOf('\u009a'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\233", String.valueOf('\u009b'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\236", String.valueOf('\u009e'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\237", String.valueOf('\u009f'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\241", String.valueOf('\u00a1'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\242", String.valueOf('\u00a2'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\243", String.valueOf('\u00a3'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\244", String.valueOf('\u00a4'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\245", String.valueOf('\u00a5'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\247", String.valueOf('\u00a7'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\251", String.valueOf('\u00a9'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\253", String.valueOf('\u00ab'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\256", String.valueOf('\u00ae'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\260", String.valueOf('\u00b0'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\265", String.valueOf('\u00b5'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\273", String.valueOf('\u00bb'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\274", String.valueOf('\u00bc'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\275", String.valueOf('\u00bd'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\276", String.valueOf('\u00be'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\277", String.valueOf('\u00bf'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\300", String.valueOf('\u00c0'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\301", String.valueOf('\u00c1'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\302", String.valueOf('\u00c2'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\303", String.valueOf('\u00c3'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\304", String.valueOf('\u00c4'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\305", String.valueOf('\u00c5'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\306", String.valueOf('\u00c6'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\307", String.valueOf('\u00c7'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\310", String.valueOf('\u00c8'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\311", String.valueOf('\u00c9'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\312", String.valueOf('\u00ca'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\313", String.valueOf('\u00cb'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\314", String.valueOf('\u00cc'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\315", String.valueOf('\u00cd'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\316", String.valueOf('\u00ce'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\317", String.valueOf('\u00cf'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\320", String.valueOf('\u00d0'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\321", String.valueOf('\u00d1'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\322", String.valueOf('\u00d2'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\323", String.valueOf('\u00d3'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\324", String.valueOf('\u00d4'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\325", String.valueOf('\u00d5'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\326", String.valueOf('\u00d6'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\330", String.valueOf('\u00d8'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\331", String.valueOf('\u00d9'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\332", String.valueOf('\u00da'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\333", String.valueOf('\u00db'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\334", String.valueOf('\u00dc'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\335", String.valueOf('\u00dd'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\336", String.valueOf('\u00de'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\337", String.valueOf('\u00df'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\340", String.valueOf('\u00e0'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\341", String.valueOf('\u00e1'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\342", String.valueOf('\u00e2'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\343", String.valueOf('\u00e3'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\344", String.valueOf('\u00e4'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\345", String.valueOf('\u00e5'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\346", String.valueOf('\u00e6'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\347", String.valueOf('\u00e7'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\350", String.valueOf('\u00e8'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\351", String.valueOf('\u00e9'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\352", String.valueOf('\u00ea'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\353", String.valueOf('\u00eb'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\354", String.valueOf('\u00ec'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\355", String.valueOf('\u00ed'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\356", String.valueOf('\u00ee'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\357", String.valueOf('\u00ef'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\360", String.valueOf('\u00f0'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\361", String.valueOf('\u00f1'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\362", String.valueOf('\u00f2'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\363", String.valueOf('\u00f3'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\364", String.valueOf('\u00f4'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\365", String.valueOf('\u00f5'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\366", String.valueOf('\u00f6'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\367", String.valueOf('\u00f7'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\370", String.valueOf('\u00f8'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\371", String.valueOf('\u00f9'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\372", String.valueOf('\u00fa'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\373", String.valueOf('\u00fb'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\374", String.valueOf('\u00fc'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\375", String.valueOf('\u00fd'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\376", String.valueOf('\u00fe'));
        stringfromHEX = stringfromHEX.replaceAll("\\\\377", String.valueOf('\u00ff'));
        return stringfromHEX;
    }

    public static List<String> getCurrencys() {
        ArrayList<String> iso4217 = new ArrayList<String>();
        iso4217.add("AED");
        iso4217.add("AFN");
        iso4217.add("ALL");
        iso4217.add("AMD");
        iso4217.add("ANG");
        iso4217.add("AOA");
        iso4217.add("ARS");
        iso4217.add("AUD");
        iso4217.add("AWG");
        iso4217.add("AZN");
        iso4217.add("BAM");
        iso4217.add("BBD");
        iso4217.add("BDT");
        iso4217.add("BGN");
        iso4217.add("BHD");
        iso4217.add("BIF");
        iso4217.add("BMD");
        iso4217.add("BND");
        iso4217.add("BOB");
        iso4217.add("BOV");
        iso4217.add("BRL");
        iso4217.add("BSD");
        iso4217.add("BTN");
        iso4217.add("BWP");
        iso4217.add("BYN");
        iso4217.add("BYR");
        iso4217.add("BZD");
        iso4217.add("CAD");
        iso4217.add("CDF");
        iso4217.add("CHE");
        iso4217.add("CHF");
        iso4217.add("CHW");
        iso4217.add("CLF");
        iso4217.add("CLP");
        iso4217.add("CNY");
        iso4217.add("COP");
        iso4217.add("COU");
        iso4217.add("CRC");
        iso4217.add("CUC");
        iso4217.add("CUP");
        iso4217.add("CVE");
        iso4217.add("CZK");
        iso4217.add("DJF");
        iso4217.add("DKK");
        iso4217.add("DOP");
        iso4217.add("DZD");
        iso4217.add("EGP");
        iso4217.add("ERN");
        iso4217.add("ETB");
        iso4217.add("EUR");
        iso4217.add("FJD");
        iso4217.add("FKP");
        iso4217.add("GBP");
        iso4217.add("GEL");
        iso4217.add("GHS");
        iso4217.add("GIP");
        iso4217.add("GMD");
        iso4217.add("GNF");
        iso4217.add("GTQ");
        iso4217.add("GYD");
        iso4217.add("HKD");
        iso4217.add("HNL");
        iso4217.add("HRK");
        iso4217.add("HTG");
        iso4217.add("HUF");
        iso4217.add("IDR");
        iso4217.add("ILS");
        iso4217.add("INR");
        iso4217.add("IQD");
        iso4217.add("IRR");
        iso4217.add("ISK");
        iso4217.add("JMD");
        iso4217.add("JOD");
        iso4217.add("JPY");
        iso4217.add("KES");
        iso4217.add("KGS");
        iso4217.add("KHR");
        iso4217.add("KMF");
        iso4217.add("KPW");
        iso4217.add("KRW");
        iso4217.add("KWD");
        iso4217.add("KYD");
        iso4217.add("KZT");
        iso4217.add("LAK");
        iso4217.add("LBP");
        iso4217.add("LKR");
        iso4217.add("LRD");
        iso4217.add("LSL");
        iso4217.add("LYD");
        iso4217.add("MAD");
        iso4217.add("MDL");
        iso4217.add("MGA");
        iso4217.add("MKD");
        iso4217.add("MMK");
        iso4217.add("MNT");
        iso4217.add("MOP");
        iso4217.add("MRU");
        iso4217.add("MUR");
        iso4217.add("MVR");
        iso4217.add("MWK");
        iso4217.add("MXN");
        iso4217.add("MXV");
        iso4217.add("MYR");
        iso4217.add("MZN");
        iso4217.add("NAD");
        iso4217.add("NGN");
        iso4217.add("NIO");
        iso4217.add("NOK");
        iso4217.add("NPR");
        iso4217.add("NZD");
        iso4217.add("OMR");
        iso4217.add("PAB");
        iso4217.add("PEN");
        iso4217.add("PGK");
        iso4217.add("PHP");
        iso4217.add("PKR");
        iso4217.add("PLN");
        iso4217.add("PYG");
        iso4217.add("QAR");
        iso4217.add("RON");
        iso4217.add("RSD");
        iso4217.add("RUB");
        iso4217.add("RWF");
        iso4217.add("SAR");
        iso4217.add("SBD");
        iso4217.add("SCR");
        iso4217.add("SDG");
        iso4217.add("SEK");
        iso4217.add("SGD");
        iso4217.add("SHP");
        iso4217.add("SLL");
        iso4217.add("SOS");
        iso4217.add("SRD");
        iso4217.add("SSP");
        iso4217.add("STN");
        iso4217.add("SVC");
        iso4217.add("SYP");
        iso4217.add("SZL");
        iso4217.add("THB");
        iso4217.add("TJS");
        iso4217.add("TMT");
        iso4217.add("TND");
        iso4217.add("TOP");
        iso4217.add("TRY");
        iso4217.add("TTD");
        iso4217.add("TWD");
        iso4217.add("TZS");
        iso4217.add("UAH");
        iso4217.add("UGX");
        iso4217.add("USD");
        iso4217.add("UYI");
        iso4217.add("UYU");
        iso4217.add("UZS");
        iso4217.add("VEF");
        iso4217.add("VND");
        iso4217.add("VUV");
        iso4217.add("WST");
        iso4217.add("XAF");
        iso4217.add("XCD");
        iso4217.add("XOF");
        iso4217.add("XPF");
        iso4217.add("XSU");
        iso4217.add("YER");
        iso4217.add("ZAR");
        iso4217.add("ZMW");
        iso4217.add("ZWL");
        return iso4217;
    }

    public static String parseAndFormatAmount(String unformatedAmount, Class<?> ExternalLogger) throws Exception {
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        String getLogMethod = "[StringCharUtils:formatAmount] ";
        String formatedAmount = unformatedAmount.replaceAll("\\<.*?\\>", "");
        formatedAmount = formatedAmount.replaceAll("[^0-9-.,]+", "");
        if ((formatedAmount = StringCharUtils.shrinkString(formatedAmount)).trim().endsWith("-")) {
            formatedAmount = "-" + formatedAmount.replace("-", "");
        }
        if (formatedAmount.length() <= 4 && !formatedAmount.contains("-") || formatedAmount.length() <= 5 && formatedAmount.contains("-")) {
            formatedAmount = formatedAmount.replaceAll(",", ".");
        } else if (formatedAmount.length() > 4) {
            String lastChar = formatedAmount.substring(formatedAmount.length() - 4);
            String restChar = formatedAmount.substring(0, formatedAmount.length() - 4);
            if (!lastChar.contains(",") && !lastChar.contains(".")) {
                restChar = restChar.replaceAll(",", "");
            } else {
                if (!lastChar.contains(",") && lastChar.startsWith(".")) {
                    lastChar = lastChar.replaceAll("\\.", "");
                }
                lastChar = lastChar.replaceAll(",", ".");
                restChar = restChar.replaceAll(",", "").replaceAll("\\.", "");
            }
            formatedAmount = restChar + lastChar;
        }
        LogDebug.invoke((Object)LogDebug, getLogMethod + "formatAmount-Method in: " + unformatedAmount + " | out: " + formatedAmount);
        return formatedAmount.trim();
    }

    public static String getSubString(String text, int idxStart, int idxEnd) {
        if (StringCharUtils.isNullOrEmpty(text)) {
            return "";
        }
        if (idxStart == -1) {
            return "";
        }
        if (idxStart >= 0 && idxEnd > idxStart) {
            return text.substring(idxStart, idxEnd);
        }
        if (idxStart >= 0 && idxEnd == -1) {
            return text.substring(idxStart);
        }
        return "fail";
    }

    public static double mathRound(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static InputStream base64ImagetoInputStream(String base64String, Class<?> externalLogger) throws Exception {
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String base64Text = base64String.replaceFirst("^.*,", "").trim();
        LogTrace.invoke((Object)LogTrace, "[WebSync:StringCharUtils] base64Text: " + base64Text);
        String imageType = base64String.substring(base64String.indexOf("/") + 1, base64String.indexOf(";"));
        LogTrace.invoke((Object)LogTrace, "[WebSync:StringCharUtils] imageType: " + imageType);
        BufferedImage bufferedImage = null;
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] imageByte = decoder.decode(base64Text);
        ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
        bufferedImage = ImageIO.read(bis);
        bis.close();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, imageType, outputStream);
        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(outputStream.toByteArray());
        outputStream.close();
        return imageInputStream;
    }

    public static ArrayList<HtmlRadioButtonInput> deepCopyArrayListWithHtmlRadioButtonInputs(ArrayList<HtmlRadioButtonInput> orig) throws Exception {
        ArrayList<HtmlRadioButtonInput> copy = new ArrayList<HtmlRadioButtonInput>();
        for (int i = 0; i < orig.size(); ++i) {
            copy.add((HtmlRadioButtonInput)orig.get(i).cloneNode(true));
        }
        return copy;
    }

    public static ArrayList<?> deepCopyArrayList(ArrayList<?> orig) throws Exception {
        ArrayList<Object> copy = new ArrayList<Object>();
        for (int i = 0; i < orig.size(); ++i) {
            copy.add(StringCharUtils.deepCopyObject(orig.get(i)));
        }
        return copy;
    }

    public static ArrayList<ArrayList> deepCopyMatrixArrayList(ArrayList<ArrayList> orig) throws Exception {
        ArrayList<ArrayList> copy = new ArrayList<ArrayList>();
        for (int i = 0; i < orig.size(); ++i) {
            copy.add(new ArrayList());
            for (int j = 0; j < orig.get(i).size(); ++j) {
                copy.get(i).add(StringCharUtils.deepCopyObject(orig.get(i).get(j)));
            }
        }
        return copy;
    }

    public static Object deepCopyObject(Object oldObj) throws Exception {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(oldObj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception error) {
            throw new Exception("Exception in ObjectCloner: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        finally {
            oos.close();
            ois.close();
        }
    }

    public static boolean equalLists(ArrayList<?> one, ArrayList<?> two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null || one != null && two == null || one.size() != two.size()) {
            return false;
        }
        return one.equals(two);
    }

    public static String formatedArrayListForLog(ArrayList logArray) {
        DecimalFormat df = new DecimalFormat("0000");
        String logListe = new String();
        for (int i = 0; i < logArray.size(); ++i) {
            try {
                logListe = logListe + "\n" + "| " + df.format(i) + " |  " + StringCharUtils.shrinkString(logArray.get(i).toString());
                continue;
            }
            catch (NullPointerException error) {
                logListe = "\n" + logListe + "| " + df.format(i) + " |  ArrayListObject #" + i + " is NULL!";
            }
        }
        return logListe;
    }

    public static String[] csvfile2array(Reader dataString, char strDelimiter) {
        CSVReader reader = new CSVReaderBuilder(dataString).withCSVParser((ICSVParser)new CSVParserBuilder().withQuoteChar('\"').withSeparator(strDelimiter).build()).build();
        String[] nextLine = null;
        try {
            while ((nextLine = reader.readNext()) != null) {
                System.out.println(nextLine[0] + nextLine[1] + "etc...");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CsvValidationException error) {
            error.printStackTrace();
        }
        return nextLine;
    }

    public static String readFile(String fileLoc) throws IOException {
        FileReader fr = new FileReader(fileLoc);
        BufferedReader br = new BufferedReader(fr);
        String data = br.readLine();
        StringBuffer buff = new StringBuffer();
        while (data != null) {
            buff.append(data + System.getProperty("line.separator"));
            data = br.readLine();
        }
        br.close();
        fr.close();
        return buff.toString();
    }

    public static String[][] data2matrixArray(String dataString, char strQuote, char strSeparator, Class<?> externalLogger) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        LogDebug.invoke((Object)LogDebug, "[WebSync:StringCharUtils] Funktion data2matrixArray wurde aufgerufen ...");
        String[][] matrixStringArray = null;
        try {
            StringReader readerdata = new StringReader(dataString);
            CSVReader datareader = new CSVReaderBuilder((Reader)readerdata).withCSVParser((ICSVParser)new CSVParserBuilder().withQuoteChar(strQuote).withSeparator(strSeparator).build()).build();
            List matrixDataArray = datareader.readAll();
            LogDebug.invoke((Object)LogDebug, "[WebSync:StringCharUtils] matrixDataArray: " + matrixDataArray);
            try {
                matrixStringArray = new String[matrixDataArray.size()][];
                for (int arrayrowcount = 0; arrayrowcount < matrixDataArray.size(); ++arrayrowcount) {
                    Object[] nextLine = (String[])matrixDataArray.get(arrayrowcount);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:StringCharUtils] DataReader-NextLine Nr. " + arrayrowcount + " enth\u00e4lt das String-Array: " + Arrays.toString(nextLine));
                    matrixStringArray[arrayrowcount] = new String[nextLine.length];
                    for (int arraycolumncount = 0; arraycolumncount < nextLine.length; ++arraycolumncount) {
                        matrixStringArray[arrayrowcount][arraycolumncount] = nextLine[arraycolumncount];
                    }
                }
                datareader.close();
            }
            catch (Exception e) {
                throw new Exception("[WebSync:StringCharUtils] Fehler beim Zusammenf\u00fcgen der Zeilen des Kontoabrufs in ein Matrix-Array: " + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        catch (Exception error) {
            throw new Exception("[WebSync:StringCharUtils] Allgemeiner Fehler beim Umwandeln des Kontoabrufs in ein Array: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return matrixStringArray;
    }

    public static String extractUrl(String text) {
        String containedUrl = null;
        String urlRegex = "((https?|ftp|gopher|telnet|file):((//)|(\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)";
        Pattern pattern = Pattern.compile(urlRegex, 2);
        Matcher urlMatcher = pattern.matcher(text);
        while (urlMatcher.find()) {
            containedUrl = text.substring(urlMatcher.start(0), urlMatcher.end(0));
        }
        return containedUrl;
    }

    public static List<String> extractUrls(String text) {
        ArrayList<String> containedUrls = new ArrayList<String>();
        String urlRegex = "((https?|ftp|gopher|telnet|file):((//)|(\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)";
        Pattern pattern = Pattern.compile(urlRegex, 2);
        Matcher urlMatcher = pattern.matcher(text);
        while (urlMatcher.find()) {
            containedUrls.add(text.substring(urlMatcher.start(0), urlMatcher.end(0)));
        }
        return containedUrls;
    }

    public static String formMessageText(String logIdent, String contentStringToParse, Class<?> ExternalLogger) throws Exception {
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String getLogMethod = "[StringCharUtils:formErrorMessage] ";
        try {
            LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "ErrorText (unformatiert): " + contentStringToParse);
            String formErrorText = StringCharUtils.unescapeHtml4(contentStringToParse);
            formErrorText = formErrorText.replace("\n\u00d7", "").replace("x\n", "").replace(" x \n", "").replace("\u00d7\n", "").replace("\nOK", "");
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkString(formErrorText);
            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "ErrorText (formatiert): " + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String unescapeHtml4(String contentStringToParse) {
        contentStringToParse = contentStringToParse.replace("&AMP;", "&amp;");
        contentStringToParse = contentStringToParse.replace("&ACUTE;", "&acute;");
        contentStringToParse = contentStringToParse.replace("&AUML;", "&auml;");
        contentStringToParse = contentStringToParse.replace("&OUML;", "&ouml;");
        contentStringToParse = contentStringToParse.replace("&UUML;", "&uuml;");
        contentStringToParse = contentStringToParse.replace("&LOWCAST;", "&lowast;");
        contentStringToParse = contentStringToParse.replace("&MINUS;", "&minus;");
        contentStringToParse = contentStringToParse.replace("&SIM;", "&sim;");
        contentStringToParse = contentStringToParse.replace("&PLUS;", "&plus;");
        contentStringToParse = contentStringToParse.replace("&QUEST;", "&quest;");
        return StringEscapeUtils.unescapeHtml4((String)contentStringToParse);
    }

    public static String replaceDoubleQuotesInDoubleQuotes(String dataString, String delimiter) throws Exception {
        String replString;
        String origString;
        dataString = dataString.replace("\";\"*", "\";\"\\*");
        dataString = dataString.replace("*\";\"", "\\*\";\"");
        dataString = dataString.replace("\";\"+", "\";\"\\+");
        dataString = dataString.replace("+\";\"", "\\+\";\"");
        dataString = dataString.replace("\"*", "'*");
        dataString = dataString.replace("*\"", "*'");
        dataString = dataString.replace("\"+", "'+");
        dataString = dataString.replace("+\"", "+'");
        Pattern pattern = Pattern.compile("(\\\"\\\")(?:[^\\n\\r\\t\\f" + delimiter + "\\\"])");
        Matcher matcher = pattern.matcher(dataString);
        boolean moreOccurences = matcher.find();
        while (moreOccurences) {
            origString = matcher.group();
            replString = origString.replaceAll("\"\"", "\"'");
            dataString = dataString.replaceAll(origString, replString);
            moreOccurences = matcher.find();
        }
        pattern = Pattern.compile("(?:[^\\n\\r\\t\\f\\\"" + delimiter + "])(\\\")(?:[^\\n\\r\\t\\f" + delimiter + "\\\"])");
        matcher = pattern.matcher(dataString);
        moreOccurences = matcher.find();
        while (moreOccurences) {
            origString = matcher.group();
            replString = origString.replaceAll("\"", "'");
            dataString = dataString.replaceAll(origString, replString);
            moreOccurences = matcher.find();
        }
        pattern = Pattern.compile("(?:[^\\n\\r\\t\\f\\\"" + delimiter + "])(\\\"\\\")");
        matcher = pattern.matcher(dataString);
        moreOccurences = matcher.find();
        while (moreOccurences) {
            origString = matcher.group();
            replString = origString.replaceAll("\"\"", "'\"");
            dataString = dataString.replaceAll(origString, replString);
            moreOccurences = matcher.find();
        }
        return dataString;
    }

    public static String createMD5Hash(String identString, Class<?> ExternalLogger) throws NoSuchAlgorithmException, Exception {
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        MessageDigest HashAlgorithm = MessageDigest.getInstance("MD5");
        HashAlgorithm.reset();
        HashAlgorithm.update(identString.getBytes());
        byte[] digest = HashAlgorithm.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            stringBuffer.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
        }
        LogDebug.invoke((Object)LogDebug, "[WebSync:StringCharUtils] createMD5Hash digested: " + digest);
        LogDebug.invoke((Object)LogDebug, "[WebSync:StringCharUtils] createMD5Hash digested(hex): " + stringBuffer.toString());
        String MD5hash = stringBuffer.toString();
        return MD5hash;
    }

    public static boolean isIbanCountryStructure(String getString) {
        String checkString = StringCharUtils.shrinkString(getString);
        if (checkString.length() == 27 && checkString.startsWith("EG")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("AL")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("DZ")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("AD")) {
            return true;
        }
        if (checkString.length() == 25 && checkString.startsWith("AO")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("AZ")) {
            return true;
        }
        if (checkString.length() == 22 && checkString.startsWith("BH")) {
            return true;
        }
        if (checkString.length() == 16 && checkString.startsWith("BE")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("BJ")) {
            return true;
        }
        if (checkString.length() == 20 && checkString.startsWith("BA")) {
            return true;
        }
        if (checkString.length() == 29 && checkString.startsWith("BR")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("VG")) {
            return true;
        }
        if (checkString.length() == 22 && checkString.startsWith("BG")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("BF")) {
            return true;
        }
        if (checkString.length() == 16 && checkString.startsWith("BI")) {
            return true;
        }
        if (checkString.length() == 19 && checkString.startsWith("CR")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("CI")) {
            return true;
        }
        if (checkString.length() == 18 && checkString.startsWith("DK")) {
            return true;
        }
        if (checkString.length() == 22 && checkString.startsWith("DE")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("DO")) {
            return true;
        }
        if (checkString.length() == 20 && checkString.startsWith("EE")) {
            return true;
        }
        if (checkString.length() == 18 && checkString.startsWith("FO")) {
            return true;
        }
        if (checkString.length() == 18 && checkString.startsWith("FI")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("FR")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("GA")) {
            return true;
        }
        if (checkString.length() == 22 && checkString.startsWith("GE")) {
            return true;
        }
        if (checkString.length() == 23 && checkString.startsWith("GI")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("GR")) {
            return true;
        }
        if (checkString.length() == 18 && checkString.startsWith("GL")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("GT")) {
            return true;
        }
        if (checkString.length() == 26 && checkString.startsWith("IR")) {
            return true;
        }
        if (checkString.length() == 22 && checkString.startsWith("IE")) {
            return true;
        }
        if (checkString.length() == 26 && checkString.startsWith("IS")) {
            return true;
        }
        if (checkString.length() == 23 && checkString.startsWith("IL")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("IT")) {
            return true;
        }
        if (checkString.length() == 30 && checkString.startsWith("JO")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("CM")) {
            return true;
        }
        if (checkString.length() == 25 && checkString.startsWith("CV")) {
            return true;
        }
        if (checkString.length() == 20 && checkString.startsWith("KZ")) {
            return true;
        }
        if (checkString.length() == 29 && checkString.startsWith("QA")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("CG")) {
            return true;
        }
        if (checkString.length() == 20 && checkString.startsWith("XK")) {
            return true;
        }
        if (checkString.length() == 21 && checkString.startsWith("HR")) {
            return true;
        }
        if (checkString.length() == 30 && checkString.startsWith("KW")) {
            return true;
        }
        if (checkString.length() == 21 && checkString.startsWith("LV")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("LB")) {
            return true;
        }
        if (checkString.length() == 21 && checkString.startsWith("LI")) {
            return true;
        }
        if (checkString.length() == 20 && checkString.startsWith("LT")) {
            return true;
        }
        if (checkString.length() == 20 && checkString.startsWith("LU")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("MG")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("ML")) {
            return true;
        }
        if (checkString.length() == 31 && checkString.startsWith("MT")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("MR")) {
            return true;
        }
        if (checkString.length() == 30 && checkString.startsWith("MU")) {
            return true;
        }
        if (checkString.length() == 19 && checkString.startsWith("MK")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("MD")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("MC")) {
            return true;
        }
        if (checkString.length() == 22 && checkString.startsWith("ME")) {
            return true;
        }
        if (checkString.length() == 25 && checkString.startsWith("MZ")) {
            return true;
        }
        if (checkString.length() == 18 && checkString.startsWith("NL")) {
            return true;
        }
        if (checkString.length() == 15 && checkString.startsWith("NO")) {
            return true;
        }
        if (checkString.length() == 20 && checkString.startsWith("AT")) {
            return true;
        }
        if (checkString.length() == 23 && checkString.startsWith("TL")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("PK")) {
            return true;
        }
        if (checkString.length() == 29 && checkString.startsWith("PS")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("PL")) {
            return true;
        }
        if (checkString.length() == 25 && checkString.startsWith("PT")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("RO")) {
            return true;
        }
        if (checkString.length() == 27 && checkString.startsWith("SM")) {
            return true;
        }
        if (checkString.length() == 25 && checkString.startsWith("ST")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("SA")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("SE")) {
            return true;
        }
        if (checkString.length() == 21 && checkString.startsWith("CH")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("SN")) {
            return true;
        }
        if (checkString.length() == 22 && checkString.startsWith("RS")) {
            return true;
        }
        if (checkString.length() == 31 && checkString.startsWith("SC")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("SK")) {
            return true;
        }
        if (checkString.length() == 19 && checkString.startsWith("SI")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("ES")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("CZ")) {
            return true;
        }
        if (checkString.length() == 24 && checkString.startsWith("TN")) {
            return true;
        }
        if (checkString.length() == 26 && checkString.startsWith("TR")) {
            return true;
        }
        if (checkString.length() == 29 && checkString.startsWith("UA")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("HU")) {
            return true;
        }
        if (checkString.length() == 23 && checkString.startsWith("AE")) {
            return true;
        }
        if (checkString.length() == 22 && checkString.startsWith("GB")) {
            return true;
        }
        if (checkString.length() == 28 && checkString.startsWith("CY")) {
            return true;
        }
        return checkString.length() == 27 && checkString.startsWith("CF");
    }

    public static String ibanAddSpaces(String value) {
        int i;
        int length = value.length();
        int lastPossibleBlock = length - 4;
        StringBuilder sb = new StringBuilder(length + (length - 1) / 4);
        for (i = 0; i < lastPossibleBlock; i += 4) {
            sb.append(value, i, i + 4);
            sb.append(' ');
        }
        sb.append(value, i, length);
        return sb.toString();
    }

    public static String banknumAddSpacesLikeIBAN(String value) {
        int pos = value.length();
        String newNumb = value.substring(pos - 2, pos);
        for (int i = (pos -= 2) - 4; i > -4; i -= 4) {
            if (i < 0) {
                i = 0;
            }
            newNumb = value.substring(i, pos) + " " + newNumb;
            pos = i;
            if (i <= 0) break;
        }
        return newNumb;
    }

    public static String banknumAddCharLikeIBAN(String value, String chr) {
        int pos = value.length();
        String newNumb = value.substring(pos - 2, pos);
        for (int i = (pos -= 2) - 4; i > -4; i -= 4) {
            if (i < 0) {
                i = 0;
            }
            newNumb = value.substring(i, pos) + chr + newNumb;
            pos = i;
            if (i <= 0) break;
        }
        return newNumb;
    }

    public static String creditCardAddSpaces(String value) {
        String newNumb = "";
        for (int i = 0; i < 16; i += 4) {
            int pos = i + 4;
            newNumb = newNumb + value.substring(i, pos);
            if (i >= 16) break;
            if (pos >= 16) continue;
            newNumb = newNumb + " ";
        }
        return newNumb;
    }

    protected static void searchAndReplaceInBinaryData(byte[] data, String firstChar, String pattern, Charset charset, String newString) {
        byte[] replacements = newString.getBytes(charset);
        byte[] first = firstChar.getBytes(charset);
        Pattern test = Pattern.compile(pattern);
        for (int i = 0; i < data.length - replacements.length; ++i) {
            String text;
            if (data[i] != first[0] || data[i + 1] != first[1] || data[i + 2] != first[2] || data[i + 3] != first[3] || !test.matcher(text = new String(data, i, replacements.length, charset)).matches()) continue;
            System.arraycopy(replacements, 0, data, i, replacements.length);
            i += replacements.length;
        }
    }

    public static class MatrixArrayListDateComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            if (!(obj1 instanceof ArrayList) || !(obj2 instanceof ArrayList)) {
                throw new ClassCastException("compared objects must be instances of ArrayList");
            }
            Date date1 = (Date)((ArrayList)obj1).get(0);
            Date date2 = (Date)((ArrayList)obj2).get(0);
            return date2.compareTo(date1);
        }
    }

    public static class ArrayListStringComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            if (!(obj1 instanceof String) || !(obj2 instanceof String)) {
                throw new ClassCastException("compared objects must be instances of String");
            }
            String string1 = (String)obj1;
            String string2 = (String)obj2;
            return string1.compareTo(string2);
        }
    }
}

