/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import de.derrichter.finance.websync.utils.StringCharUtils;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class StatementWorker {
    private static final String LogIdent = "[WebSync:StatementWorker] ";

    public static ArrayList sortBankArrayList(ArrayList transactionDataList, boolean reverse, String institutCharacteristics, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        try {
            if (reverse) {
                Collections.reverse(transactionDataList);
                LogTrace.invoke((Object)LogTrace, "[WebSync:StatementWorker] reversed-transactionDataList enth\u00e4lt nun das MatrixArray:\n" + StringCharUtils.formatedArrayListForLog(transactionDataList));
            }
            ArrayList<ArrayList> copyUnsortedDataList = StringCharUtils.deepCopyMatrixArrayList(transactionDataList);
            if (!institutCharacteristics.contains("inclInterBalace")) {
                Collections.sort(copyUnsortedDataList, new StringCharUtils.MatrixArrayListDateComparator());
            }
            ArrayList allDataDates = new ArrayList();
            for (int i = 0; i < copyUnsortedDataList.size(); ++i) {
                if (i == 0) {
                    allDataDates.add(copyUnsortedDataList.get(i).get(0));
                    continue;
                }
                if (((Date)copyUnsortedDataList.get(i).get(0)).getTime() == ((Date)copyUnsortedDataList.get(i - 1).get(0)).getTime()) continue;
                allDataDates.add(copyUnsortedDataList.get(i).get(0));
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:StatementWorker] Liste eindeutiger Beleg-Datum im Auszug:\n" + StringCharUtils.formatedArrayListForLog(allDataDates));
            ArrayList<Object> dayArray = new ArrayList<Object>();
            ArrayList<Object> newFullArray = new ArrayList<Object>();
            for (int i = 0; i < allDataDates.size(); ++i) {
                for (int arrayNr = 0; arrayNr < transactionDataList.size(); ++arrayNr) {
                    if (((Date)((ArrayList)transactionDataList.get(arrayNr)).get(0)).getTime() != ((Date)allDataDates.get(i)).getTime()) continue;
                    LogTrace.invoke((Object)LogTrace, "[WebSync:StatementWorker] Transaktion " + arrayNr + "; " + ((Date)((ArrayList)transactionDataList.get(arrayNr)).get(0)).getTime() + " = " + ((Date)allDataDates.get(i)).getTime() + "; Adde Umsatz " + ((ArrayList)transactionDataList.get(arrayNr)).get(2) + "\tvom " + ((ArrayList)transactionDataList.get(arrayNr)).get(0) + "\t" + ((ArrayList)transactionDataList.get(arrayNr)).get(6));
                    dayArray.add(StringCharUtils.deepCopyObject(transactionDataList.get(arrayNr)));
                }
                newFullArray.addAll(dayArray);
                dayArray.removeAll(dayArray);
            }
            transactionDataList.removeAll(transactionDataList);
            transactionDataList.addAll(newFullArray);
            LogTrace.invoke((Object)LogTrace, "[WebSync:StatementWorker] Liste aller abgeholten Ums\u00e4tze: (schon fertig formatiert und sortiert, bereit zur Verarbeitung):\n" + StringCharUtils.formatedArrayListForLog(transactionDataList));
        }
        catch (Exception error) {
            throw new Exception("Fehler beim Verarbeiten transactionDataList und Umkehr-Copy-Sortier-Funktion; " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return transactionDataList;
    }

    public static ArrayList createBankArrayListHeader(String institutAlias, String accountNr, double amount, double availableAmount, double unbookedAmount, String fromDateSimple, String toDateSimple, String accountInfo) {
        ArrayList bankArrayListHeader = new ArrayList();
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(0)).add("Automatisch generierter Kontoauszug der Java WebScraping-Bibliothek 'finance.websync' (beinhaltet die sortierterten, fertig formatierten Ums\u00e4tze)");
        bankArrayListHeader.add(new ArrayList());
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(2)).add("Institut:");
        ((ArrayList)bankArrayListHeader.get(2)).add(institutAlias);
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(3)).add("Kontonummer:");
        ((ArrayList)bankArrayListHeader.get(3)).add(accountNr);
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(4)).add("Kontostand:");
        ((ArrayList)bankArrayListHeader.get(4)).add(amount);
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(5)).add("Verf\u00fcgbarer Betrag:");
        ((ArrayList)bankArrayListHeader.get(5)).add(availableAmount);
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(6)).add("davon nicht abgerechnet:");
        ((ArrayList)bankArrayListHeader.get(6)).add(unbookedAmount);
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(7)).add("Abrufzeitraum:");
        ((ArrayList)bankArrayListHeader.get(7)).add(fromDateSimple + " bis " + toDateSimple);
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(8)).add("Auszugsdatum:");
        ((ArrayList)bankArrayListHeader.get(8)).add(new SimpleDateFormat().format(Calendar.getInstance().getTime()));
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(9)).add("Kontoinformation:");
        ((ArrayList)bankArrayListHeader.get(9)).add(accountInfo);
        bankArrayListHeader.add(new ArrayList());
        bankArrayListHeader.add(new ArrayList());
        ((ArrayList)bankArrayListHeader.get(11)).add("Buchungsdatum");
        ((ArrayList)bankArrayListHeader.get(11)).add("Valuta-Datum");
        ((ArrayList)bankArrayListHeader.get(11)).add("Betrag");
        ((ArrayList)bankArrayListHeader.get(11)).add("Saldo");
        ((ArrayList)bankArrayListHeader.get(11)).add("W\u00e4hrung");
        ((ArrayList)bankArrayListHeader.get(11)).add("Umsatzart");
        ((ArrayList)bankArrayListHeader.get(11)).add("Verwendungszweck");
        ((ArrayList)bankArrayListHeader.get(11)).add("IBAN");
        ((ArrayList)bankArrayListHeader.get(11)).add("BIC");
        ((ArrayList)bankArrayListHeader.get(11)).add("Gegenkonto-Name");
        ((ArrayList)bankArrayListHeader.get(11)).add("Gegenkonto-Nummer");
        ((ArrayList)bankArrayListHeader.get(11)).add("Gegenkonto-BLZ");
        ((ArrayList)bankArrayListHeader.get(11)).add("Kommentar");
        ((ArrayList)bankArrayListHeader.get(11)).add("Primanotakennzeichen");
        ((ArrayList)bankArrayListHeader.get(11)).add("Kundenreferenz");
        ((ArrayList)bankArrayListHeader.get(11)).add("End to End-Referenz");
        ((ArrayList)bankArrayListHeader.get(11)).add("Mandatsreferenz");
        ((ArrayList)bankArrayListHeader.get(11)).add("Creditor Identifier");
        ((ArrayList)bankArrayListHeader.get(11)).add("Zeilennummer-Auszug");
        ((ArrayList)bankArrayListHeader.get(11)).add("Boolean-Marker");
        return bankArrayListHeader;
    }
}

