/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import de.derrichter.finance.websync.utils.StringCharUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.zip.CRC32;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SecurityUtils {
    private static String LogIdent = "[SecurityUtils] ";

    public static String checkBrowserHashWithApacheCommons(String fileDir, Class<?> ExternalLogger) throws Exception {
        Method LogWarn = ExternalLogger.getMethod("warn", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        LogTrace.invoke((Object)LogTrace, LogIdent + "starting hash-calculation with apache commons for security check the browser ...");
        LogTrace.invoke((Object)LogTrace, LogIdent + "... calcualating checksum of: " + fileDir);
        long startTime = new Date().getTime();
        File sourcePath = new File(fileDir);
        ArrayList<String> hashStringArray = new ArrayList<String>();
        String hashString = "";
        int filenr = 0;
        boolean isSelfException = false;
        try {
            if (!sourcePath.exists()) {
                LogWarn.invoke((Object)LogWarn, LogIdent + "Abbruch: angegebener Pfad existiert nicht!");
                return null;
            }
            if (sourcePath.isDirectory()) {
                Object[] fullFileList = (File[])SecurityUtils.listedFilesFromDirRecursivelySorted(sourcePath).clone();
                Arrays.sort(fullFileList);
                LogTrace.invoke((Object)LogTrace, LogIdent + String.valueOf(fullFileList.length) + " regular files in this browser-root");
                for (Object checkfile : fullFileList) {
                    if (!((File)checkfile).isFile() || FileUtils.isSymlink((File)checkfile) || ((File)checkfile).getAbsolutePath().endsWith("/_CodeSignature/CodeResources") || ((File)checkfile).getName().endsWith(".log") || ((File)checkfile).getName().startsWith(".DS_") || ((File)checkfile).getName().equals("settings.dat") || !((File)checkfile).getAbsolutePath().equals(((File)checkfile).getCanonicalPath())) continue;
                    String hash = DigestUtils.sha1Hex((InputStream)new FileInputStream((File)checkfile));
                    long checksum = FileUtils.checksumCRC32((File)checkfile);
                    ++filenr;
                    hashStringArray.add(new String(hash + checksum));
                }
                LogTrace.invoke((Object)LogTrace, LogIdent + String.valueOf(hashStringArray.size()) + " regular files to calculate (others are exluded)");
                LogTrace.invoke((Object)LogTrace, LogIdent + "now sorting the unique hashchecksum-strings ...");
                Collections.sort(hashStringArray, new StringCharUtils.ArrayListStringComparator());
                hashString = "";
                for (String hash : hashStringArray) {
                    hashString = hashString + hash;
                }
            } else {
                isSelfException = true;
                throw new Exception("Abbruch: angegebener Pfad ist kein Verzeichnis!");
            }
            hashString = StringCharUtils.createMD5Hash(hashString, ExternalLogger);
            long endTime = new Date().getTime();
            long runtime = (endTime - startTime) / 1000L;
            LogTrace.invoke((Object)LogTrace, LogIdent + "hash of " + fileDir + " is: " + hashString);
            LogTrace.invoke((Object)LogTrace, LogIdent + "checkBrowserHashWithApacheCommons hash-calculation runtime needs: " + String.valueOf(runtime) + " seconds");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkBrowserHashWithApacheCommons fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return hashString;
    }

    public static String hashWithApacheCommons(String fileDir, String algo, Class<?> ExternalLogger) throws Exception {
        Method digestString;
        Method digestInputStream;
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        LogTrace.invoke((Object)LogTrace, LogIdent + "starting " + algo + " hash-calculation with apache commons ...");
        LogTrace.invoke((Object)LogTrace, LogIdent + "... calcualating checksum of: " + fileDir);
        long startTime = new Date().getTime();
        try {
            digestInputStream = DigestUtils.class.getMethod(algo + "Hex", InputStream.class);
            digestString = DigestUtils.class.getMethod(algo + "Hex", String.class);
        }
        catch (NoSuchMethodException metherr) {
            throw new Exception("hashWithApacheCommons fehlerhaft: Algorithmus nicht unterst\u00fctzt");
        }
        File sourcePath = new File(fileDir);
        String hashString = "";
        try {
            if (sourcePath.isDirectory()) {
                File[] fullFileList;
                for (File checkfile : fullFileList = SecurityUtils.listedFilesFromDirRecursivelySorted(sourcePath)) {
                    if (!checkfile.isFile()) continue;
                    String hash = (String)digestInputStream.invoke((Object)digestInputStream, new FileInputStream(checkfile));
                    hashString = hashString + hash;
                }
                hashString = (String)digestString.invoke((Object)digestString, hashString);
            } else {
                hashString = (String)digestInputStream.invoke((Object)digestInputStream, new FileInputStream(sourcePath));
            }
            long endTime = new Date().getTime();
            long runtime = (endTime - startTime) / 1000L;
            LogTrace.invoke((Object)LogTrace, LogIdent + algo + "-hash of " + fileDir + " is: " + hashString);
            LogTrace.invoke((Object)LogTrace, LogIdent + "hashWithApacheCommons " + algo + " hash-calculation runtime needs: " + String.valueOf(runtime) + " seconds");
        }
        catch (Exception error) {
            throw new Exception("hashWithApacheCommons fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return hashString;
    }

    public static String checksumWithApacheCommons(String fileDir, Class<?> ExternalLogger) throws Exception {
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        LogTrace.invoke((Object)LogTrace, LogIdent + "starting crc32 checksum-calculation with apache commons ...");
        LogTrace.invoke((Object)LogTrace, LogIdent + "... calcualating checksum of: " + fileDir);
        long startTime = new Date().getTime();
        File sourcePath = new File(fileDir);
        String checksumString = "";
        try {
            if (sourcePath.isDirectory()) {
                File[] fullFileList;
                for (File checkfile : fullFileList = SecurityUtils.listedFilesFromDirRecursivelySorted(sourcePath)) {
                    if (!checkfile.isFile()) continue;
                    long checksum = FileUtils.checksumCRC32((File)checkfile);
                    checksumString = checksumString + String.valueOf(checksum);
                }
                CRC32 crc = new CRC32();
                crc.update(checksumString.getBytes());
                checksumString = String.valueOf(crc.getValue());
            } else {
                long checksum = FileUtils.checksumCRC32((File)sourcePath);
                checksumString = String.valueOf(checksum);
            }
            long endTime = new Date().getTime();
            long runtime = (endTime - startTime) / 1000L;
            LogTrace.invoke((Object)LogTrace, LogIdent + "crc32-checksum of " + fileDir + " is: " + checksumString);
            LogTrace.invoke((Object)LogTrace, LogIdent + "checksumWithApacheCommons crc32 checksum-calculation runtime needs: " + String.valueOf(runtime) + " seconds");
        }
        catch (Exception error) {
            throw new Exception("checksumWithApacheCommons fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return checksumString;
    }

    protected static File[] listedFilesFromDir(File currentDir) {
        File[] fileList = currentDir.listFiles();
        return fileList;
    }

    protected static File[] listedFilesFromDirRecursivelySorted(File currentDir) {
        File[] fileList = currentDir.listFiles();
        Object[] fullFileList = new File[]{};
        for (File checkfile : fileList) {
            if (checkfile.isDirectory()) {
                Object[] subDir = SecurityUtils.listedFilesFromDirRecursivelySorted(checkfile);
                fullFileList = (File[])ArrayUtils.addAll((Object[])fullFileList, (Object[])subDir);
                continue;
            }
            if (checkfile.isFile()) {
                Object[] subFile = new File[]{checkfile};
                fullFileList = (File[])ArrayUtils.addAll((Object[])fullFileList, (Object[])subFile);
                continue;
            }
            System.out.println(LogIdent + "ignore while is not a directory or regular file: " + checkfile.getAbsolutePath());
        }
        Arrays.sort(fullFileList);
        return fullFileList;
    }
}

