/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;

public class OnlineUtils {
    private static final String LogIdent = "[OnlineUtils] ";
    private static String URL;
    private static String outputFile;

    public static void setURL(String url) {
        URL = url;
    }

    public static void setOutputFileName(String name) {
        outputFile = name;
    }

    public static void resetURL() {
        URL = null;
    }

    public static void resetOutputFileName() {
        outputFile = null;
    }

    public static void downloadFromURL(String downloadURL, String targetPath, Class<?> ExternalLogger) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        URL = downloadURL;
        outputFile = targetPath;
        if (URL != null || outputFile != null) {
            try {
                LogInfo.invoke((Object)LogInfo, "[OnlineUtils] Downloading File from URL: " + URL);
                FileOutputStream toDownload = new FileOutputStream(outputFile);
                toDownload.getChannel().transferFrom(Channels.newChannel(new URL(downloadURL).openStream()), 0L, Long.MAX_VALUE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        } else {
            throw new Exception("[OnlineUtils] Empty args !");
        }
    }

    public static void downloadFromURLandVerifyWithChecksum(String downloadURL, String targetPath, String digest, Class<?> externalLogger) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        String digestfile = ".sha1";
        if (digest.equals("SHA-256")) {
            digestfile = ".sha256";
        } else if (digest.equals("SHA-512")) {
            digestfile = ".sha512";
        } else if (digest.equals("MD5")) {
            digestfile = ".md5";
        }
        OnlineUtils.downloadFromURL(downloadURL, targetPath, externalLogger);
        OnlineUtils.downloadFromURL(downloadURL + digestfile, targetPath + digestfile, externalLogger);
        MessageDigest toCheckDigest = MessageDigest.getInstance(digest);
        String localChecksum = FileSysUtils.getFileChecksum(toCheckDigest, new File(targetPath));
        LogInfo.invoke((Object)LogInfo, "[OnlineUtils] localChecksum from downloaded file local:\t" + localChecksum);
        String onlineChecksum = FileUtils.readFileToString((File)new File(targetPath + digestfile), (String)"UTF-8");
        LogInfo.invoke((Object)LogInfo, "[OnlineUtils] onlineChecksum from online file:\t\t" + onlineChecksum);
        if (!localChecksum.equals(onlineChecksum)) {
            FileSysUtils.forceDeleteTarget(new File(targetPath));
            FileSysUtils.forceDeleteTarget(new File(targetPath + digestfile));
            throw new Exception("fail! local checksum from component is different to online checksum! File was deleted!");
        }
        LogInfo.invoke((Object)LogInfo, "[OnlineUtils] ok. component '" + targetPath + "' downloaded/write/installed and verifed checksum successful.");
    }

    public static void downloadFromURL_getStatusPercent(String downloadURL, String targetPath, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        block14: {
            Method LogInfo = ExternalLogger.getMethod("info", String.class);
            Method MonitorLog = ExternalProgressMonitor.getMethod("log", String.class);
            URL = downloadURL;
            outputFile = targetPath;
            if (URL != null || outputFile != null) {
                try {
                    LogInfo.invoke((Object)LogInfo, "[OnlineUtils] Downloading File from URL: " + URL);
                    URL url = new URL(URL);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    int filesize = connection.getContentLength();
                    float totalDataRead = 0.0f;
                    try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());){
                        FileOutputStream fos = new FileOutputStream(outputFile);
                        try (BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);){
                            int i;
                            byte[] data = new byte[1024];
                            int outputPercent = 10;
                            while ((i = in.read(data, 0, 1024)) >= 0) {
                                bout.write(data, 0, i);
                                float Percent = (totalDataRead += (float)i) * 100.0f / (float)filesize;
                                Double d = StringCharUtils.mathRound(Percent, 0);
                                int cutPercent = d.intValue();
                                if (cutPercent != outputPercent) continue;
                                LogInfo.invoke((Object)LogInfo, "[OnlineUtils] Downloading Percent: " + cutPercent + "%");
                                MonitorLog.invoke((Object)MonitorLog, "Download-Fortschritt: " + cutPercent + "%");
                                outputPercent += 10;
                            }
                            break block14;
                        }
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            throw new Exception("[OnlineUtils] Empty args !");
        }
    }

    public static void downloadFromURL_getStatusPercent(String downloadURL, String targetPath, Class<?> ExternalLogger) throws Exception {
        block14: {
            Method LogInfo = ExternalLogger.getMethod("info", String.class);
            URL = downloadURL;
            outputFile = targetPath;
            if (URL != null || outputFile != null) {
                try {
                    LogInfo.invoke((Object)LogInfo, "[OnlineUtils] Downloading File from URL: " + URL);
                    URL url = new URL(URL);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    int filesize = connection.getContentLength();
                    float totalDataRead = 0.0f;
                    try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());){
                        FileOutputStream fos = new FileOutputStream(outputFile);
                        try (BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);){
                            int i;
                            byte[] data = new byte[1024];
                            int outputPercent = 10;
                            while ((i = in.read(data, 0, 1024)) >= 0) {
                                bout.write(data, 0, i);
                                float Percent = (totalDataRead += (float)i) * 100.0f / (float)filesize;
                                Double d = StringCharUtils.mathRound(Percent, 0);
                                int cutPercent = d.intValue();
                                if (cutPercent != outputPercent) continue;
                                LogInfo.invoke((Object)LogInfo, "[OnlineUtils] Downloading Percent: " + cutPercent + "%");
                                outputPercent += 10;
                            }
                            break block14;
                        }
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            throw new Exception("[OnlineUtils] Empty args !");
        }
    }

    public static JSONObject getJson(URL url) throws Exception {
        String json = IOUtils.toString((URL)url, (Charset)Charset.forName("UTF-8"));
        return new JSONObject(json);
    }
}

