/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import de.derrichter.finance.websync.utils.StringCharUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FileSysUtils {
    public static File lastFileModified(String dir) {
        File fl = new File(dir);
        File[] files = fl.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        long lastMod = Long.MIN_VALUE;
        File choice = null;
        for (File file : files) {
            if (file.lastModified() <= lastMod) continue;
            choice = file;
            lastMod = file.lastModified();
        }
        return choice;
    }

    public static File getTheNewestFile(String filePath, String ext) {
        File theNewestFile = null;
        File dir = new File(filePath);
        WildcardFileFilter fileFilter = new WildcardFileFilter("*." + ext);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files.length > 0) {
            Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            theNewestFile = files[0];
        }
        return theNewestFile;
    }

    public static File[] getTheNewestFiles(String filePath, String ext, int filesCount) {
        File dir = new File(filePath);
        WildcardFileFilter fileFilter = new WildcardFileFilter("*." + ext);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        File[] filesReturn = null;
        if (filesCount == 0) {
            return null;
        }
        if (files.length > 0) {
            Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            filesReturn = new File[filesCount];
            if (files.length <= filesCount) {
                filesCount = files.length - 1;
            }
            for (int f = 0; f < filesCount; ++f) {
                filesReturn[f] = files[f];
            }
        }
        return filesReturn;
    }

    public static String getUsersDesktop() {
        String userDesktopPath = System.getProperty("user.home") + File.separator + "Arbeitsplatz" + File.separator;
        File usersDesktop = new File(userDesktopPath);
        if (!usersDesktop.exists() && !usersDesktop.isDirectory()) {
            userDesktopPath = System.getProperty("user.home") + File.separator + "Schreibtisch" + File.separator;
            usersDesktop = new File(userDesktopPath);
        }
        if (!usersDesktop.exists() && !usersDesktop.isDirectory()) {
            userDesktopPath = System.getProperty("user.home") + File.separator + "Desktop" + File.separator;
            usersDesktop = new File(userDesktopPath);
        }
        return userDesktopPath;
    }

    public static void fileEncodingConverter(String[] a) {
        String inFile = a[0];
        String inCharsetName = a[1];
        String outFile = a[2];
        String outCharsetName = a[3];
        try {
            System.out.println("FileEncodingConverter: java.lang.System.getProperty(\"file.encoding\"): " + System.getProperty("file.encoding"));
            if (System.getProperty("file.encoding").equals("MacRoman")) {
                inCharsetName = "Cp1258";
            }
            System.out.println("FileEncodingConverter: inFile: " + inFile);
            System.out.println("FileEncodingConverter: inCharsetName: " + inCharsetName);
            System.out.println("FileEncodingConverter: outFile: " + outFile);
            System.out.println("FileEncodingConverter: outCharsetName: " + outCharsetName);
            File file = new File(inFile);
            String content = FileUtils.readFileToString((File)file, (String)inCharsetName);
            FileUtils.write((File)new File(outFile), (CharSequence)content, (String)outCharsetName);
            System.out.println("FileEncodingConverter: Number of input bytes: " + new File(inFile).length());
            System.out.println("FileEncodingConverter: Number of output bytes: " + new File(outFile).length());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static void copyDirectory(File sourceDir, File targetDir) throws IOException {
        if (sourceDir.isDirectory()) {
            FileSysUtils.copyDirectoryRecursively(sourceDir, targetDir);
        } else {
            Files.copy(sourceDir.toPath(), targetDir.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void copyDirectoryRecursively(File source, File target) throws IOException {
        if (!target.exists()) {
            target.mkdir();
        }
        for (String child : source.list()) {
            FileSysUtils.copyDirectory(new File(source, child), new File(target, child));
        }
    }

    public static void forceDeleteTarget(File target) throws IOException, InterruptedException {
        int round = 0;
        String lastErrorText = null;
        String stacktrace = null;
        do {
            if (!target.exists()) continue;
            if (target.isDirectory()) {
                try {
                    Files.walkFileTree(target.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException error) {
                    try (Stream<Path> dirStream = Files.walk(target.toPath(), new FileVisitOption[0]);){
                        dirStream.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
                        lastErrorText = error.getMessage();
                        stacktrace = ExceptionUtils.getStackTrace((Throwable)error);
                    }
                }
            }
            int waiter = 0;
            if (target.exists()) {
                Files.delete(target.toPath());
            }
            Files.deleteIfExists(target.toPath());
            if (target.exists()) {
                try {
                    FileDeleteStrategy.FORCE.delete(target);
                }
                catch (Exception delLater) {
                    lastErrorText = delLater.getMessage();
                    stacktrace = ExceptionUtils.getStackTrace((Throwable)delLater);
                }
                do {
                    Thread.sleep(100L);
                } while (target.exists() && ++waiter < 10);
            }
            if (target.exists()) {
                try {
                    FileUtils.forceDelete((File)target);
                    do {
                        Thread.sleep(100L);
                    } while (target.exists() && ++waiter < 15);
                }
                catch (Exception delLater) {
                    lastErrorText = delLater.getMessage();
                    stacktrace = ExceptionUtils.getStackTrace((Throwable)delLater);
                }
            }
            if (!target.exists() || !target.isDirectory()) continue;
            try {
                FileUtils.cleanDirectory((File)target);
                FileUtils.deleteDirectory((File)target);
                do {
                    Thread.sleep(100L);
                } while (target.exists() && ++waiter < 20);
            }
            catch (Exception delLater) {
                lastErrorText = delLater.getMessage();
                stacktrace = ExceptionUtils.getStackTrace((Throwable)delLater);
            }
        } while (target.exists() && ++round < 3);
        if (target.exists()) {
            FileUtils.forceDeleteOnExit((File)target);
            throw new IOException("Not possible to delete target! (planned to delete on exit); Delete this target, plz => '" + target + "'  [ErrorMsg: " + lastErrorText + "]\nStacktrace: " + stacktrace);
        }
    }

    public static String getFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static void replaceKeyWithRadndomInBinary(String binaryPath, String identStringWithSeparator, int followCharCount) throws Exception {
        int i;
        byte[] data;
        String identString = "";
        String separatorString = "";
        if (identStringWithSeparator.contains("_")) {
            identString = identStringWithSeparator.split("_")[0];
            separatorString = "_";
        } else if (identStringWithSeparator.contains("-")) {
            identString = identStringWithSeparator.split("-")[0];
            separatorString = "-";
        } else if (identStringWithSeparator.contains("\\.")) {
            identString = identStringWithSeparator.split("\\.")[0];
            separatorString = ".";
        }
        File file = new File(binaryPath);
        int length = (int)file.length();
        try (FileInputStream in = new FileInputStream(file);
             ByteArrayOutputStream bs = new ByteArrayOutputStream(length);){
            byte[] buffer = new byte[128000];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                bs.write(buffer, 0, len);
            }
            in.close();
            bs.close();
            data = bs.toByteArray();
        }
        Random rand = new Random();
        String allowedChar = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String cryptedString = "";
        for (i = 0; i < identString.length(); ++i) {
            cryptedString = cryptedString + allowedChar.charAt(rand.nextInt(allowedChar.length()));
        }
        cryptedString = cryptedString + separatorString;
        for (i = 0; i < followCharCount; ++i) {
            cryptedString = cryptedString + allowedChar.charAt(rand.nextInt(allowedChar.length()));
        }
        System.out.println("Random-Key: " + cryptedString);
        StringCharUtils.searchAndReplaceInBinaryData(data, identString + separatorString, identString + separatorString + ".{" + String.valueOf(followCharCount) + "}", StandardCharsets.US_ASCII, cryptedString);
        try (FileOutputStream out = new FileOutputStream(file);
             ByteArrayInputStream bs = new ByteArrayInputStream(data);){
            byte[] buffer = new byte[128000];
            int len = 0;
            while ((len = bs.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            bs.close();
            out.flush();
            out.close();
        }
    }
}

