/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DmgFileUtils {
    static final String LogIdent = "[DmgFileUtils] ";

    public static void mountDmgImage(String sourceDmg, Class<?> ExternalLogger) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        LogDebug.invoke((Object)LogDebug, "[DmgFileUtils] Mounting the DMG-Image: " + sourceDmg);
        try {
            String str;
            String[] command = new String[]{"/usr/bin/hdiutil", "attach", sourceDmg};
            String sendback = "";
            Process proc = Runtime.getRuntime().exec(command);
            InputStream istr = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(istr));
            while ((str = br.readLine()) != null) {
                sendback = sendback + str;
            }
            int resultCode = proc.waitFor();
            br.close();
            if (resultCode != 0) {
                throw new Exception("failed to open system profiler");
            }
            LogDebug.invoke((Object)LogDebug, "[DmgFileUtils] Command/Output: " + sendback);
        }
        catch (Exception error) {
            LogError.invoke((Object)LogError, "[DmgFileUtils] Mounten des DMG-Image fehlgeschlagen: ! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static void umountDmgImage(String volume, Class<?> ExternalLogger) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        LogDebug.invoke((Object)LogDebug, "[DmgFileUtils] Unmounting the DMG-Image-Volume: " + volume);
        try {
            String str;
            String[] command = new String[]{"/usr/bin/hdiutil", "detach", volume};
            String sendback = "";
            Process proc = Runtime.getRuntime().exec(command);
            InputStream istr = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(istr));
            while ((str = br.readLine()) != null) {
                sendback = sendback + str;
            }
            int resultCode = proc.waitFor();
            br.close();
            if (resultCode != 0) {
                throw new Exception("failed to open system profiler");
            }
            LogDebug.invoke((Object)LogDebug, "[DmgFileUtils] Command/Output: " + sendback);
        }
        catch (Exception error) {
            LogError.invoke((Object)LogError, "[DmgFileUtils] Auswerfen des DMG-Image-Volume fehlgeschlagen: ! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

