/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.weltsparen;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static final String COOKIE_DETECT_PATH = "#usercentrics-root,#uc-center-container";
    static final String COOKIE_ACCEPT_PATH = "button[data-testid='uc-accept-all-button']";
    static String LOADER_CATCHSTRING = "progress-circle";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//*[contains(@class,'loadingPlaceholder') or contains(@class,'fa-loading') or contains(@class,'fa-loading') or contains(@class,'spinner')]";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[2];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//div[contains(@class,'alert') or contains(@id,'ErrorNotice') or contains(@class,'MuiAlert-message')]";
        WebUtils.xpathSearchString[1] = "//p[contains(@class,'Mui-error')]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Dummy";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String logIdent = "[WebSync:WeltSparen] ";
        String longName = "WeltSparen - Raisin GmbH";
        String getLogMethod = "[checkSeleniumResponseHasError] ";
        if (responsePageAsString.contains("Das Referenzkonto - \u00fcblicherweise Ihr Hausbankkonto - ist das Konto, auf das Auszahlungen von Ihrem WeltSpar-Konto ausschlie\u00dflich erfolgen k\u00f6nnen. Dies dient dem maximalen Schutz Ihrer Gelder. Es muss ein Girokonto auf Ihren Namen")) {
            String formErrorText = "Es muss ein Girokonto, auf Ihren Namen lautend, als Referenzkonto auf das Auszahlungen von Ihrem WeltSpar-Konto erfolgen k\u00f6nnen, angegeben werden! Loggen Sie sich im Online-Banking ein und geben Sie Ihr Referenzkonto an.";
            LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "errorText: " + formErrorText);
            DialogWarn.invoke((Object)DialogWarn, "Meldung der WeltSparen - Raisin GmbH:\n\n\n" + formErrorText, "institutlogo-weltsparen.png");
            throw new Exception(formErrorText);
        }
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-weltsparen.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static WebDriver checkForMTAN(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalDialogInterface, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[checkSeleniumResponseHasError] ";
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(15L));
        WebDriverWait wait2 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        boolean isSelfException = false;
        String tanArt = "mobileTAN";
        String detectTANformPath = "//*[not(self::html) and not(self::body) and not(self::script) and (contains(.,'eine mTAN einzutragen') or contains(.,' mit einer mTAN') or contains(.,'Zwei-Faktor-Authentifizierung'))]";
        String secTextPath = "(//div[contains(.,'an Ihre ') and contains(.,' Mobil')])[last()] | //div[contains(@class,'styles_otpWrapper')]//span";
        String tanInputPath = "//input[@id='otp-code']";
        String submitTanPath = "(//button[contains(@class,'styles_primary') or contains(.,'Best\u00e4tigen')])[2] | //button[contains(.,'Best\u00e4tigen')]";
        String checkWrongTANPath = "//div[contains(.,'eingegebene mTAN ist nicht korrekt')]";
        boolean retryInput = false;
        LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "Gefundene Abfrage mit xPathExpression des " + tanArt + "-Verfahren: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath))));
            LogInfo.invoke((Object)LogInfo, "[WebSync:WeltSparen] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
            MonitorLog.invoke((Object)MonitorLog, tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
            try {
                do {
                    wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)secTextPath)));
                    String secText = seleniumWebDriver.findElement(By.xpath((String)secTextPath)).getText().trim();
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-weltsparen.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:WeltSparen] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.clear();
                    new Actions(seleniumWebDriver).click(tanInput).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    Thread.sleep(1000L);
                    JavascriptExecutor jsExecutor = (JavascriptExecutor)seleniumWebDriver;
                    jsExecutor.executeScript("window.scrollTo(0, document.body.scrollHeight);", new Object[0]);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTAN", submitTanPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        Thread.sleep(1000L);
                        WebElement checkWrongTAN = seleniumWebDriver.findElement(By.xpath((String)checkWrongTANPath));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "checkWrongTAN: " + checkWrongTAN);
                        DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der WeltSparen - Raisin GmbH:\n\n\nDie eingegebene " + tanArt + " ist falsch.", "institutlogo-weltsparen.png");
                        retryInput = true;
                    }
                    catch (NoSuchElementException | TimeoutException wrongTAN) {
                        retryInput = false;
                    }
                    String pageAfter2FLoginResponse = seleniumWebDriver.getPageSource();
                    if (retryInput) continue;
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfter2FLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (retryInput);
            }
            catch (Exception secError) {
                if (isSelfException) {
                    throw new Exception(secError.getMessage());
                }
                throw new Exception("Sicherheitsverfahren '" + tanArt + "' fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)secError));
            }
        }
        catch (TimeoutException noSecondSec) {
            LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ..." + noSecondSec.getMessage());
        }
        return seleniumWebDriver;
    }
}

