/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.weltsparen;

import de.derrichter.finance.websync.institute.weltsparen.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        WebDriverWait wait15 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(15L));
        boolean isSelfException = false;
        try {
            double availableAmount;
            double amount;
            WebElement acceptNews = null;
            try {
                acceptNews = seleniumWebDriver.findElement(By.id((String)"newsletterOptInModal"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (acceptNews != null) {
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "closeNewsletter", "//span[@id='newsletterModalCrossIcon']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Newsletter-Anfrage konnte nicht geschlossen werden: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            String profileButtonPath = "//header//button[last()]";
            wait15.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)profileButtonPath)));
            WebElement profileButton = seleniumWebDriver.findElement(By.xpath((String)profileButtonPath));
            profileButton.click();
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "read amount ...");
                String amountTextPath = "(//span[contains(@class,'AmountLabel')])[1]";
                String availableAmountTextPath = "(//span[contains(@class,'AmountLabel')])[2]";
                String amountText = seleniumWebDriver.findElement(By.xpath((String)amountTextPath)).getText();
                LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "amountText: " + amountText);
                LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "amountText html: " + seleniumWebDriver.findElement(By.xpath((String)amountTextPath)).getAttribute("outerHTML"));
                String availableAmountText = seleniumWebDriver.findElement(By.xpath((String)availableAmountTextPath)).getText();
                LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "availableAmountText: " + availableAmountText);
                LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "availableAmountText html: " + seleniumWebDriver.findElement(By.xpath((String)availableAmountTextPath)).getAttribute("outerHTML"));
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
            }
            catch (Exception error1) {
                isSelfException = true;
                throw new Exception("Auslesen des Kontostands fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error1));
            }
            try {
                seleniumWebDriver.get("https://www.weltsparen.de/account-transactions/");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageDownlodsResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageDownlodsResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der WeltSparen - Raisin GmbH\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\nVerf\u00fcgbarer Betrag:;" + availableAmount + "\n\n";
            boolean haveNewTrans = false;
            try {
                Thread.sleep(2000L);
                if (seleniumWebDriver.findElement(By.xpath((String)"//*[not(self::html) and not(self::body) and not(self::script) and (contains(.,'es gibt keine Daten') or contains(.,'Keine Ums\u00e4tze vorhanden'))]")) != null) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] xpath //*[not(self::html) and not(self::body) and not(self::script) and (contains(.,'es gibt keine Daten') or contains(.,'Keine Ums\u00e4tze vorhanden'))] wurde gefunden; Es sollten KEINE Transaktionen vorhanden sein ...");
                    transData = transData + "Datum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                }
            }
            catch (Exception waiterror) {
                haveNewTrans = true;
                LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] xpath //*[not(self::html) and not(self::body) and not(self::script) and (contains(.,'es gibt keine Daten') or contains(.,'Keine Ums\u00e4tze vorhanden'))] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
                seleniumWebDriver = WebUtils.checkForMTAN(seleniumWebDriver, externalLogger, externalDialogInterface, externalProgressMonitor);
                wait15.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//div[contains(@class,'transactions')] | //button[contains(.,'Ums\u00e4tze exportieren')]")));
            }
            File downloadedFile = null;
            String doctext = null;
            String doctype = "";
            boolean localTest = false;
            if (localTest) {
                haveNewTrans = true;
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                downloadedFile = new File(docFixTempFilePath);
            }
            if (haveNewTrans) {
                boolean downloadedFileIsFalse = false;
                int downloadCount = 1;
                do {
                    if (!localTest) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadButton", "//button[contains(.,'Ums\u00e4tze exportieren')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                    doctype = FilenameUtils.getExtension((String)downloadedFile.getAbsolutePath()).toUpperCase();
                    if (doctype.toLowerCase().equals("txt") || doctype.toLowerCase().equals("htm") || doctype.toLowerCase().equals("html") || doctype.toLowerCase().equals("asp") || doctype.toLowerCase().equals("js")) {
                        LogWarn.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / Falscher Dateityp, versuche es nochmals ...");
                        ++downloadCount;
                        downloadedFileIsFalse = true;
                    } else {
                        downloadedFileIsFalse = false;
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                } while (downloadedFileIsFalse);
                String fileResponse = "";
                String fileencoding = "UTF-8";
                fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "raw-fileResponse witout file-encoding convert: \n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                if (!fileencoding.equals("UTF-8")) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:WeltSparen] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                    byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                    doctext = new String(filebytes, System.getProperty("file.encoding"));
                } else {
                    doctext = fileResponse;
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + doctype + "-Rechnung (text):\n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
                if (!localTest) {
                    FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedFile);
                }
                transData = doctext;
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transData: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n");
            String[] dataResponse = new String[]{transData, String.valueOf(amount)};
            String[][] matrixArrayDataCSV = StringCharUtils.data2matrixArray(transData.replace("\"", ""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            int transDateCount = 1;
            for (int i = 0; i < matrixArrayDataCSV.length; ++i) {
                if (matrixArrayDataCSV[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "matrixArrayDataCSV: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayDataCSV[i][0].split("-");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] matrixArrayDataCSV: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayDataCSV[i][0].split("-");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[0], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[2], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] valutadatum = matrixArrayDataCSV[i][1].split("-");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(valutadatum[0], 10), Integer.parseInt(valutadatum[1], 10) - 1, Integer.parseInt(valutadatum[2], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    Double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataCSV[i][5], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (matrixArrayDataCSV[i][5].contains("-")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("Abbuchung"));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("Gutschrift"));
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][4])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayDataCSV[i][4]));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][3]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][2])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][2]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    String iban = matrixArrayDataCSV[i][3];
                    String gegenkontoNummer = "";
                    String gegenkontoBLZ = "";
                    if (!StringCharUtils.isNullOrEmptyOrNothing(iban) && StringCharUtils.isIbanCountryStructure(iban) && iban.startsWith("DE")) {
                        gegenkontoNummer = iban.substring(12, 22);
                        gegenkontoBLZ = iban.substring(4, 12);
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(iban)) {
                        gegenkontoNummer = iban;
                        if (!StringCharUtils.isIbanCountryStructure(iban)) {
                            iban = "";
                        }
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoNummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + StringCharUtils.shrinkString(((ArrayList)transactionDataList.get(arrayRowCount)).get(12).toString()));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    ++transDateCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("WeltSparen", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

