/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.weltsparen;

import de.derrichter.finance.websync.institute.weltsparen.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        WebDriverWait wait2 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        boolean loginElementsPresent = false;
        int round = 1;
        try {
            do {
                block23: {
                    String accountVerifire;
                    block22: {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:WeltSparen] " + getLogMethod + "Weltsparen-Login aufrufen ... (GET " + "https://www.weltsparen.de/login" + ")");
                        try {
                            seleniumWebDriver.get("https://www.weltsparen.de/login");
                            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:WeltSparen] ", "WeltSparen - Raisin GmbH", "institutlogo-weltsparen.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                        Thread.sleep(1000L);
                        accountVerifire = "//*[@data-testid='available-balance']";
                        try {
                            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"email")));
                            WebElement inputUser = seleniumWebDriver.findElement(By.id((String)"email"));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "inputUser: " + inputUser);
                            WebElement inputPasswd = seleniumWebDriver.findElement(By.id((String)"password"));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "inputPasswd: " + inputPasswd);
                            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:WeltSparen] ", "WeltSparen - Raisin GmbH", "institutlogo-weltsparen.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                            inputUser.click();
                            inputUser.sendKeys(new CharSequence[]{responseLogin});
                            inputPasswd.click();
                            inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                            loginElementsPresent = true;
                        }
                        catch (Exception error) {
                            if (round <= 3) {
                                try {
                                    wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)accountVerifire)));
                                    break;
                                }
                                catch (Exception inputPasswd) {
                                    LogWarn.invoke((Object)LogWarn, "[WebSync:WeltSparen] " + getLogMethod + "Der Login konnte nicht gestartet werden weil die Felder fehlen? Error: " + error.getMessage() + "; Versuche es daher nochmals...");
                                    MonitorLog.invoke((Object)MonitorLog, "Der Login konnte nicht gestartet werden weil die Felder fehlen?:");
                                    MonitorLog.invoke((Object)MonitorLog, "Fehlermeldung: " + error.getMessage());
                                    MonitorLog.invoke((Object)MonitorLog, "...versuche es daher nochmals...");
                                    ++round;
                                    loginElementsPresent = false;
                                    break block22;
                                }
                            }
                            isSelfException = true;
                            throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                    }
                    JavascriptExecutor js = (JavascriptExecutor)seleniumWebDriver;
                    js.executeScript("window.scrollTo(0, document.body.scrollHeight)", new Object[0]);
                    if (loginElementsPresent) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[@data-testid='loginButton']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            if (round <= 3) {
                                try {
                                    wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)accountVerifire)));
                                    break;
                                }
                                catch (Exception exception) {
                                    LogWarn.invoke((Object)LogWarn, "[WebSync:WeltSparen] " + getLogMethod + "Der Login konnte nicht gestartet werden weil der Button fehlt? Error: " + error.getMessage() + "; Versuche es daher nochmals...");
                                    MonitorLog.invoke((Object)MonitorLog, "Der Login konnte nicht gestartet werden weil der Button fehlt?:");
                                    MonitorLog.invoke((Object)MonitorLog, "Fehlermeldung: " + error.getMessage());
                                    MonitorLog.invoke((Object)MonitorLog, "...versuche es daher nochmals...");
                                    ++round;
                                    loginElementsPresent = false;
                                    break block23;
                                }
                            }
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                    }
                }
                try {
                    wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//*[@id='friendly-captcha-widget']")));
                    Thread.sleep(3500L);
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "friendlyCaptchaButton", "//button[@class='frc-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                Thread.sleep(2000L);
                loginElementsPresent = false;
            } while (false);
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:WeltSparen] ", "WeltSparen - Raisin GmbH", "institutlogo-weltsparen.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            seleniumWebDriver = WebUtils.checkForMTAN(seleniumWebDriver, externalLogger, externalDialogInterface, externalProgressMonitor);
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:WeltSparen] ", "WeltSparen - Raisin GmbH", "institutlogo-weltsparen.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "after login: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            if (pageAfterLoginResponse.contains("LoginFormControl")) {
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            return seleniumWebDriver;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:WeltSparen] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:WeltSparen] " + getLogMethod + "Abmelden aufrufen ...");
            try {
                String profileButtonPath = "//header//button[last()]";
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)profileButtonPath)));
                WebElement profileButton = seleniumWebDriver.findElement(By.xpath((String)profileButtonPath));
                profileButton.click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "logoutButton", "//section//a[contains(.,'Abmelden')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String successLogoutXpath = "//*[contains(.,'Bei WeltSparen anmelden')]";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:WeltSparen] " + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:WeltSparen] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPage);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:WeltSparen] " + getLogMethod + "Logout bei der '" + "WeltSparen - Raisin GmbH" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:WeltSparen] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

