/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.volkswagenfinancialservices;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static String LOADER_CATCHSTRING = "c-spinner";
    static String LOADER_EXCLUSIONS = "DummyLoaderExclution";
    static String LOADER_PATH = "//*[@class='c-spinner']";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[1];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//p[@class='c-error-message']";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "die von Ihnen eingegebenen Suchkriterien konnte keine Transaktion gefunden werden";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, String blz, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String getLogMethod = "[checkSeleniumResponseHasError] ";
        if (responsePageAsString.contains("Wir arbeiten f\u00fcr Sie") && responsePageAsString.contains("Zurzeit steht Ihnen das Online-Banking leider nicht zur Verf")) {
            String formWarnText = StringCharUtils.formMessageText(WebUtils.getLogIdent(blz), seleniumWebDriver.findElement(By.xpath((String)"//div[@id='maintenance-message']")).getText(), externalLogger);
            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "errorText: " + formWarnText);
            DialogWarn.invoke((Object)DialogWarn, "Meldung der " + WebUtils.getLongName(blz) + ":\n\n\n" + formWarnText, WebUtils.getLogoPath(blz));
            throw new Exception("Webseite ist im Moment nicht verf\u00fcgbar, vermutlich aufgrund von Wartungsarbeiten. Meldung der Bank wurde angezeigt");
        }
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, WebUtils.getLogIdent(blz), WebUtils.getLongName(blz), WebUtils.getLogoPath(blz), xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static String getShortName(String blz) throws Exception {
        String shortName;
        block7: {
            shortName = null;
            try {
                if (blz.equals("DEMOMODE")) {
                    shortName = "VWBank_DEMO";
                    break block7;
                }
                if (blz.equals("27020001")) {
                    shortName = "AudiBank";
                    break block7;
                }
                if (blz.equals("27020800")) {
                    shortName = "SeatBank";
                    break block7;
                }
                if (blz.equals("27020003")) {
                    shortName = "SkodaBank";
                    break block7;
                }
                if (blz.equals("27020000")) {
                    shortName = "VWBank";
                    break block7;
                }
                throw new Exception("Unbekannte BLZ angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'shortName' fehlerhaft: " + logerror.getMessage());
            }
        }
        return shortName;
    }

    public static String getLongName(String blz) throws Exception {
        String longName;
        block7: {
            longName = null;
            try {
                if (blz.equals("DEMOMODE")) {
                    longName = "Volkswagen Finacial DEMO";
                    break block7;
                }
                if (blz.equals("27020001")) {
                    longName = "Audi Bank";
                    break block7;
                }
                if (blz.equals("27020800")) {
                    longName = "Seat Bank";
                    break block7;
                }
                if (blz.equals("27020003")) {
                    longName = "Skoda Bank";
                    break block7;
                }
                if (blz.equals("27020000")) {
                    longName = "Volkswagen Bank";
                    break block7;
                }
                throw new Exception("Unbekannte BLZ angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'longName' fehlerhaft: " + logerror.getMessage());
            }
        }
        return longName;
    }

    public static String getLogIdent(String blz) throws Exception {
        String logIdent;
        block7: {
            logIdent = null;
            try {
                if (blz.equals("DEMOMODE")) {
                    logIdent = "[WebSync:VWBank DEMO] ";
                    break block7;
                }
                if (blz.equals("27020001")) {
                    logIdent = "[WebSync:AudiBank] ";
                    break block7;
                }
                if (blz.equals("27020800")) {
                    logIdent = "[WebSync:SeatBank] ";
                    break block7;
                }
                if (blz.equals("27020003")) {
                    logIdent = "[WebSync:SkodaBank] ";
                    break block7;
                }
                if (blz.equals("27020000")) {
                    logIdent = "[WebSync:VWBank] ";
                    break block7;
                }
                throw new Exception("Unbekannte BLZ angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'logIdent' fehlerhaft: " + logerror.getMessage());
            }
        }
        return logIdent;
    }

    public static String getLogoPath(String blz) throws Exception {
        String logoPath;
        block7: {
            logoPath = null;
            try {
                if (blz.equals("DEMOMODE")) {
                    logoPath = "institutlogo-volkswagenbank.png";
                    break block7;
                }
                if (blz.equals("27020001")) {
                    logoPath = "institutlogo-audibank.png";
                    break block7;
                }
                if (blz.equals("27020800")) {
                    logoPath = "institutlogo-seatbank.png";
                    break block7;
                }
                if (blz.equals("27020003")) {
                    logoPath = "institutlogo-skodabank.png";
                    break block7;
                }
                if (blz.equals("27020000")) {
                    logoPath = "institutlogo-volkswagenbank.png";
                    break block7;
                }
                throw new Exception("Unbekannte BLZ angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'logoPath' fehlerhaft: " + logerror.getMessage());
            }
        }
        return logoPath;
    }

    public static boolean PushTan(WebDriver seleniumWebDriver, String blz, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[WebLogin-2FA] ";
        boolean isSelfException = false;
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        String tanArt = "pushTAN";
        String pushTanFormPath = "//*[contains(.,'Best\u00e4tigung mit pushTAN')]";
        String getTanPath = "//button[@id='submit_button']";
        try {
            try {
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Gefundene Abfrage mit xPathExpression des " + tanArt + "-Verfahren: " + wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)pushTanFormPath))));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "callTAN", getTanPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                WebElement waiterCheck = null;
                MonitorLog.invoke((Object)MonitorLog, "Warte auf PushTan Freigabe ...");
                int tanRounds = 0;
                Thread.sleep(3000L);
                boolean waitPushTan = true;
                do {
                    try {
                        waiterCheck = seleniumWebDriver.findElement(By.xpath((String)pushTanFormPath));
                    }
                    catch (NoSuchElementException | TimeoutException noBestSign) {
                        waitPushTan = false;
                    }
                    if (waitPushTan) {
                        LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + getLogMethod + "Warte weiter auf PushTan Freigabe (weitere 3 Sekunden) ...");
                        Thread.sleep(3000L);
                        ++tanRounds;
                    }
                    if (tanRounds < 79) continue;
                    isSelfException = true;
                    throw new Exception("PushTan Authentifizierung auch nach 4 Minuten nicht abgeschlossen. Warten auf PushTan Freigabe abgebrochen");
                } while (waitPushTan);
            }
            catch (NoSuchElementException | TimeoutException noSecondSec) {
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ..." + noSecondSec.getMessage());
                return false;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            isSelfException = true;
            throw new Exception("Warten auf PushTan Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return true;
    }

    public static boolean PhotoTan(WebDriver seleniumWebDriver, String blz, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method DialogAskImageTan = externalDialogInterface.getMethod("askImageTAN", String.class, InputStream.class, String.class, String.class);
        String getLogMethod = "[WebLogin-2FA] ";
        boolean isSelfException = false;
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        String tanArt = "photoTAN";
        String detectTANformPath = "//*[contains(.,'Bitte scannen Sie die photoTAN')]";
        String secTextPath = "(//div[@class='u-mt-xsmall'])[last()]";
        String tanInputPath = "//input[@id='photo-tan']";
        String submitTanPath = "//button[@id='submit_button']";
        String imageToScanPath = "//img[@id='photo-tan-cronto-image']";
        try {
            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Gefundene Abfrage mit xPathExpression des " + tanArt + "-Verfahren: " + wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath))));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                String secText = seleniumWebDriver.findElement(By.xpath((String)secTextPath)).getText().trim();
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)imageToScanPath)));
                String base64ImageData = seleniumWebDriver.findElement(By.xpath((String)imageToScanPath)).getAttribute("src").trim();
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "base64ImageData: " + base64ImageData);
                InputStream streamImage = StringCharUtils.base64ImagetoInputStream(base64ImageData, externalLogger);
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "streamImage (InputStream): " + streamImage);
                String userTanInput = null;
                try {
                    userTanInput = (String)DialogAskImageTan.invoke((Object)DialogAskImageTan, tanArt, streamImage, secText, WebUtils.getLogoPath(blz));
                }
                catch (InvocationTargetException error) {
                    isSelfException = true;
                    if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                        throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                    }
                    LogError.invoke((Object)LogError, WebUtils.getLogIdent(blz) + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                    throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                }
                WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "tanInput: " + tanInput);
                tanInput.click();
                tanInput.sendKeys(new CharSequence[]{userTanInput});
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTAN", submitTanPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
            }
            catch (NoSuchElementException | TimeoutException noSecondSec) {
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ..." + noSecondSec.getMessage());
                return false;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, WebUtils.getLogIdent(blz) + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage());
        }
        return true;
    }
}

