/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.volkswagenfinancialservices;

import de.derrichter.finance.websync.institute.volkswagenfinancialservices.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String blz, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        String getLogMethod = "[getTransData] ";
        try {
            double amount;
            String accountPath;
            block83: {
                String amountText;
                try {
                    String messagePath = "//*[@id='mailboxtermsconditions-submitButton' or @id='welcome-process-form' or @id='personalDataEditLink' or contains(.,'Aktualisierung Ihrer Kontaktdaten')]";
                    boolean hasAbortButton = false;
                    do {
                        LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + "Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                        wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)messagePath)));
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                        String formWarnText = "";
                        List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)(messagePath + "//ancestor::body//h4")));
                        for (WebElement headline : allHeadlines) {
                            String headlinetext = headline.getText();
                            formWarnText = formWarnText + StringCharUtils.formMessageText(WebUtils.getLogIdent(blz), headlinetext, externalLogger) + " ";
                        }
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "warnText: " + formWarnText);
                        DialogWarn.invoke((Object)DialogWarn, "Meldung der " + WebUtils.getLongName(blz) + ":\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://banking.vwfs.de/PBODE-FE-UI/#/login" + "\nan und best\u00e4tigen Sie diese Meldung(en).", WebUtils.getLogoPath(blz));
                        LogWarn.invoke((Object)LogWarn, WebUtils.getLogIdent(blz) + "Meldung(en) der Bank: " + formWarnText);
                        MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                        try {
                            wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//button[@id='abort_button']")));
                            hasAbortButton = true;
                        }
                        catch (NoSuchElementException | TimeoutException notAborterr) {
                            hasAbortButton = false;
                            isSelfException = true;
                            throw new Exception(formWarnText.trim());
                        }
                        if (!hasAbortButton) continue;
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", "//button[@id='abort_button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, "", true, externalLogger);
                    } while (hasAbortButton);
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + "Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
                }
                boolean counterClosed = false;
                try {
                    LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + "Abmelde-Counter wird geschlossen...");
                    wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//button[@id='logoutTimerCloseButton']")));
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "counterClose", "//button[@id='logoutTimerCloseButton']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    counterClosed = true;
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + "Kein Abmelde-Counter zum Schlie\u00dfen vorhanden?!");
                }
                if (counterClosed) {
                    LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + "Abmelde-Counter wurde geschlossen");
                }
                String accountsURL = "https://banking.vwfs.de/PBODE-FE-UI/#/accountoverview";
                if (blz.equals("DEMOMODE")) {
                    accountsURL = "https://banking.vwfs.de/Demo/#/accountoverview";
                }
                LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + getLogMethod + "Konto\u00fcbersicht aufrufen um Finanzcockpit zu \u00fcberspringen... (GET " + accountsURL + ")");
                try {
                    seleniumWebDriver.get(accountsURL);
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, "", true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "accountspage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAccountsResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAccountsResponse, seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String searchNr = StringCharUtils.banknumAddCharLikeIBAN(kontonummer, " ");
                accountPath = "//strong[contains(text(),'" + kontonummer.substring(0, 4) + "') and contains(text(),'" + kontonummer.substring(4, 6) + "') and contains(text(),'" + kontonummer.substring(8) + "')]//ancestor::li";
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "xPath zur Kontonummer '" + searchNr + "' oder Konto-Detailslink: " + accountPath);
                try {
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Auf vorhandene Kontonummer pr\u00fcfen...");
                    wait.until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.xpath((String)accountPath)));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "OK: Kontonummer mit xPath '" + accountPath + "' gefunden");
                }
                catch (Exception linkerror) {
                    isSelfException = true;
                    throw new Exception("Angegebene Kontonummer oder Kontodetails-Link nicht gefunden, pr\u00fcfen Sie Ihre Angaben oder melden Sie den Fehler im Forum");
                }
                amount = Double.NaN;
                try {
                    wait.until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.xpath((String)("(" + accountPath + "//strong)[1]"))));
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    amountText = seleniumWebDriver.findElement(By.xpath((String)("(" + accountPath + "//strong)[1]"))).getText();
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "Ausgelesener nicht formatierter RAW-Saldo aus der Seite:\n" + amountText);
                }
                catch (Exception error2) {
                    isSelfException = true;
                    throw new Exception("Auslesen des Saldo fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)error2));
                }
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Ausgelesener und formatierter Saldo aus der Seite: " + amount);
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 25);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "kontoDetailsLink", accountPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String accdetailResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(accdetailResponse, seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 30);
                String filterButtonPath = accountPath + "//*[contains(@id,'filterButton')]";
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterLink", filterButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Filter-Sektion (is-open?): " + ((WebElement)seleniumWebDriver.findElements(By.xpath((String)filterButtonPath)).get(0)).getAttribute("outerHTML"));
                try {
                    wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"range-from")));
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    if (((WebElement)seleniumWebDriver.findElements(By.xpath((String)filterButtonPath)).get(0)).getAttribute("outerHTML").contains("is-open")) break block83;
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Aufruf des Filter-Tab wohl fehlgeschlagen, versuche es nochmals...");
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterLink", filterButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
            }
            SeleniumUtils.showFormatedListOfAllWebElementsInLog(seleniumWebDriver, "//input", externalLogger);
            WebElement fromAndToDateField = null;
            fromAndToDateField = seleniumWebDriver.findElement(By.xpath((String)(accountPath + "//input[@id='range']")));
            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "fromAndToDateField: " + fromAndToDateField);
            try {
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "in fromDateField will type: " + fromDateSimple);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "in toDateField will type: " + toDateSimple);
                Actions dummy = new Actions(seleniumWebDriver);
                dummy.doubleClick(fromAndToDateField).build().perform();
                if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                    fromAndToDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "a"})});
                } else {
                    fromAndToDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                }
                fromAndToDateField.sendKeys(new CharSequence[]{fromDateSimple + " bis " + toDateSimple});
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Anfordern-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterCloseButton", "//*[@id='close_button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String dataPageResponse = seleniumWebDriver.getPageSource();
            LocalDateTime dateNow = LocalDateTime.now();
            LocalDateTime maxSyncDate = dateNow.minus(7884000000L, ChronoUnit.MILLIS);
            String[] dateValues = fromDateSimple.split("\\.");
            LocalDateTime syncDate = LocalDateTime.of(Integer.parseInt(dateValues[2]), Integer.parseInt(dateValues[1]), Integer.parseInt(dateValues[0]), 0, 0);
            LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "zus\u00e4tzliches Warten auf Aktualisierung da w\u00e4hrend dieser der Download-Button aktiv ist auch wenn keine Daten gefunden werden und dieser dann wieder inaktiv wird!");
            if (syncDate.isBefore(maxSyncDate)) {
                Thread.sleep(5000L);
            } else {
                Thread.sleep(1500L);
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 45);
            String downloadButtonPath = accountPath + "//*[contains(@id,'exportButton')]";
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)downloadButtonPath)));
            WebElement downloadButton = seleniumWebDriver.findElement(By.xpath((String)downloadButtonPath));
            boolean downloadButtonIsEnabled = true;
            String downloadButtonHTML = downloadButton.getAttribute("outerHTML");
            LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "downloadButtonHTML: " + downloadButtonHTML);
            if (downloadButtonHTML.contains("disabled")) {
                downloadButtonIsEnabled = false;
            }
            LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "downloadButton (after Search) is enabled: " + String.valueOf(downloadButtonIsEnabled));
            if (downloadButtonIsEnabled) {
                try {
                    LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + getLogMethod + "click the download button and start the transactions-csv-download ...");
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadButton", downloadButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    if (syncDate.isBefore(maxSyncDate)) {
                        Thread.sleep(10000L);
                    } else {
                        Thread.sleep(3000L);
                    }
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String downloadResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(downloadResponse, seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 55);
            String csvResponse = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der " + WebUtils.getLongName(blz) + "\n\n\nDatum des Auszugs:;" + new Date() + "\nZeitraum:;" + fromDateSimple + " bis " + toDateSimple + "\nAnzahl der Transaktionen:;0\nKontostand:;" + amount + "\n\nBuchungsdatum;Valutadatum;Transaktion;Absender / Empf\u00e4nger;Verwendungszweck;Betrag\nIm gew\u00e4hltem Abrufzeitraum sind keine Transaktionen vorhanden";
            if (downloadButtonIsEnabled) {
                File downloadedFile = null;
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                do {
                    Thread.sleep(500L);
                    int waiter = 0;
                    do {
                        if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                        Thread.sleep(1000L);
                        ++waiter;
                    } while (downloadedFile == null && waiter < 30);
                    if (downloadedFile != null && downloadedFile.exists()) continue;
                    isSelfException = true;
                    throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                String fileResponse = "";
                String fileencoding = "UTF-8";
                LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                if (!fileencoding.equals("UTF-8")) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "fileResponse: \n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                    byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                    csvResponse = new String(filebytes, System.getProperty("file.encoding"));
                } else {
                    csvResponse = fileResponse;
                }
                FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 65);
            LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + csvResponse + "\n======================= END DATA =======================\n");
            if (csvResponse.contains("<html") || csvResponse.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[] DataResponse = new String[]{csvResponse, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(csvResponse, '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] CheckColumn = matrixArrayData[i][1].split("\\.");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + "matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + e.toString());
                    continue;
                }
                try {
                    double Betrag;
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][9])) {
                        String[] arrayvaluta = matrixArrayData[i][9].substring(0, 10).split("\\.");
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][11])) {
                        Betrag = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][11]).replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll(" \u20ac", "").replaceAll(" &euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim());
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][10])) {
                        Betrag = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][10]).replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll(" \u20ac", "").replaceAll(" &euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim());
                        Betrag *= -1.0;
                    } else {
                        isSelfException = true;
                        throw new Exception("Der Betrag konnte nich ausgelesen da beide Felder leer sind");
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][2]);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    String purpValue = null;
                    String bankName = null;
                    String bankBic = null;
                    String bankIBAN = null;
                    String bankBLZ = null;
                    String bankNumber = null;
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][3])) {
                        String[] purbAndBank = matrixArrayData[i][3].split("   ");
                        purpValue = purbAndBank[0].trim();
                        if (purbAndBank.length > 1) {
                            LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "Uebrig bleibt: " + purbAndBank[1]);
                            if (purbAndBank[1].contains("BIC:")) {
                                String[] bankNameAndNumbers = purbAndBank[1].split("BIC:");
                                bankName = bankNameAndNumbers[0].trim();
                                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "Uebrig bleibt: " + bankNameAndNumbers[1]);
                                if (!StringCharUtils.isNullOrEmptyOrNothing(bankNameAndNumbers[1]) && bankNameAndNumbers[1].contains("IBAN:")) {
                                    String[] BankNumbers = bankNameAndNumbers[1].split("IBAN:");
                                    bankBic = BankNumbers[0].trim();
                                    bankIBAN = BankNumbers[1].trim();
                                    bankBLZ = BankNumbers[1].trim().substring(4, 12);
                                    bankNumber = BankNumbers[1].trim().substring(12);
                                }
                            }
                        }
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(purpValue)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(purpValue.replaceAll("\\<.*?\\>", "")) + " " + StringCharUtils.shrinkString(matrixArrayData[i][4].replaceAll("\\<.*?\\>", "")) + " " + StringCharUtils.shrinkString(matrixArrayData[i][5].replaceAll("\\<.*?\\>", "")) + " " + StringCharUtils.shrinkString(matrixArrayData[i][6].replaceAll("\\<.*?\\>", "")) + " " + StringCharUtils.shrinkString(matrixArrayData[i][7].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(bankIBAN)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(bankIBAN);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(bankBic)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(bankBic);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(bankName)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(bankName);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(bankNumber)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(bankNumber);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(bankBLZ)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(bankBLZ);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][8])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(bankBLZ);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader(WebUtils.getShortName(blz), kontonummer, amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

