/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.volkswagenfinancialservices;

import de.derrichter.finance.websync.institute.volkswagenfinancialservices.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String blz, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        try {
            String loginURL = "https://banking.vwfs.de/PBODE-FE-UI/#/login";
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + getLogMethod + WebUtils.getShortName(blz) + "-Login aufrufen ... (GET " + loginURL + ")");
            try {
                seleniumWebDriver.get(loginURL);
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, "", true, externalLogger);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"username")));
                WebElement inputUser = seleniumWebDriver.findElement(By.id((String)"username"));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "inputUser: " + inputUser);
                WebElement inputPasswd = seleniumWebDriver.findElement(By.id((String)"password"));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(blz) + getLogMethod + "inputPasswd: " + inputPasswd);
                inputUser.sendKeys(new CharSequence[]{responseLogin});
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                Thread.sleep(1000L);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            int rounds = 0;
            do {
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[@id='login-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageLogin2Response = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageLogin2Response, seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                Thread.sleep(1000L);
                try {
                    WebElement loginErrorContent = seleniumWebDriver.findElement(By.xpath((String)"//div[@class='c-notification-container' and contains(.,'Es ist ein Fehler aufgetreten') and contains(.,'ber den Button') and not(contains(@style,'display: none;'))]"));
                    LogError.invoke((Object)LogError, WebUtils.getLogIdent(blz) + getLogMethod + " Fehler beim Login, Button muss nochal gedr\u00fcckt werden...");
                }
                catch (NoSuchElementException notFind) {
                    break;
                }
            } while (++rounds < 3);
            if (WebUtils.PushTan(seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + getLogMethod + WebUtils.getShortName(blz) + "-2FA-Login mit PushTAN durchlaufen");
            } else if (WebUtils.PhotoTan(seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + getLogMethod + WebUtils.getShortName(blz) + "-2FA-Login mit PhotoTAN durchlaufen");
            } else {
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "Login-Dialog noch vorhanden ... bei der Seite mit dem vermeintlich angebotenen Sicherheitsverfahren handelt es sich um diese im XML-Format: \n" + seleniumWebDriver.getPageSource());
                isSelfException = true;
                throw new Exception("Angebotenes Sicherheitsverfahren nicht erkannt oder bekannt. Bitte informieren Sie im Forum den Entwickler");
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//*[contains(@id,'tan')]"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            catch (NoSuchElementException | TimeoutException throwable) {
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, WebUtils.getLogIdent(blz) + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String blz, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        try {
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + getLogMethod + "Abmelden von der Onlinebanking-Website ...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "logoutButton", "(//span[contains(text(),'LOGOUT')]//parent::button)", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                String logoutPageXML = seleniumWebDriver.getPageSource();
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String postLogoutPageXML = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPageXML, seleniumWebDriver, blz, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            if (!(postLogoutPageXML.contains("Ihre Abmeldung war erfolgreich") || postLogoutPageXML.contains("erfolgreich") && postLogoutPageXML.contains("abgemeldet"))) {
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(blz) + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(blz) + getLogMethod + "Logout bei der '" + WebUtils.getLongName(blz) + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                LogError.invoke((Object)LogError, WebUtils.getLogIdent(blz) + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, WebUtils.getLogIdent(blz) + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

