/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.tfbank;

import de.derrichter.finance.websync.institute.tfbank.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        try {
            String transData;
            double availableAmount;
            double amount;
            block42: {
                try {
                    String detectPath = "//div[contains(@class,'modal-dialog-centered')]";
                    String messagePath = detectPath + "//*[@class='modal-title']";
                    String closePath = detectPath + "//button[contains(@class,'close')]";
                    boolean hasAbortButton = false;
                    do {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:TFBank] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] " + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                        String formWarnText = "";
                        List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)messagePath));
                        for (WebElement headline : allHeadlines) {
                            String headlinetext = headline.getText();
                            formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:TFBank] ", headlinetext, externalLogger) + " ";
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] " + getLogMethod + "warnText: " + formWarnText);
                        if (!formWarnText.contains("Freigabeverfahren verwalten")) {
                            DialogWarn.invoke((Object)DialogWarn, "Meldung der TF Bank AB:\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://meine.tfbank.de/login" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-tfbank.png");
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                        try {
                            wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closePath)));
                        }
                        catch (NoSuchElementException | TimeoutException notAborterr) {
                            hasAbortButton = false;
                            isSelfException = true;
                            throw new Exception("Im Onlinebanking muss auf folgende Meldung reagiert werden: " + formWarnText.trim());
                        }
                        hasAbortButton = true;
                        LogWarn.invoke((Object)LogWarn, "[WebSync:TFBank] Meldung(en) der Bank: " + formWarnText);
                        MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                    } while (hasAbortButton);
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:TFBank] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
                }
                amount = Double.NaN;
                availableAmount = Double.NaN;
                try {
                    String amountText = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'overview d-flex')]//following::div[contains(.,'\u20ac')]")).getText().trim();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "amountText: " + amountText);
                    amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Auslesen des 'Kontostand' fehlgeschlagen: " + error.getMessage());
                }
                availableAmount = amount;
                LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] " + getLogMethod + "Amount: " + amount);
                LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] " + getLogMethod + "availableAmount: " + availableAmount);
                LogInfo.invoke((Object)LogInfo, "[WebSync:TFBank] " + getLogMethod + "Transaktions\u00fcbersicht-Seite aufrufen ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountMenu", "//div[contains(@class,'menu-item')]/div[contains(.,'Konto')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "transactionsLink", "(//div[contains(@class,'menu-open')]//div[contains(.,'Transaktions\u00fcbersicht')])[last()]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String dataPageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(dataPageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                boolean haveNewTrans = false;
                String noTransPath = "//div[contains(.,'noch keine get\u00e4tigten Transaktionen')]";
                try {
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)noTransPath)));
                    WebElement lastDate = seleniumWebDriver.findElement(By.xpath((String)noTransPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] keine aktuelle Transaktionen vorhanden: " + noTransPath);
                    haveNewTrans = false;
                }
                catch (Exception waiterror) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] xpath " + noTransPath + "NICHT gefunden; Es sollten (aktuelle) Transaktionen vorhanden sein...");
                    haveNewTrans = true;
                }
                String monthSelectorPath = "//div[contains(@class,'transactions')]//select";
                String transDetailsPath = "//div[contains(@class,'transactions')]//tbody/tr";
                transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der TF Bank AB\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\n";
                try {
                    if (haveNewTrans) {
                        String betragPath = ".//td[2]";
                        String purpPath = ".//td[3]";
                        String bookingDatePath = ".//td[1]";
                        String artPath = ".//td[3]";
                        Select mounthSelector = new Select(seleniumWebDriver.findElement(By.xpath((String)monthSelectorPath)));
                        List mounthList = mounthSelector.getOptions();
                        for (WebElement month : mounthList) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] " + getLogMethod + "current Option to select: " + month.getAccessibleName() + " | " + month.getText());
                            if ((month.getAccessibleName().contains("hle einen Monat") || month.getText().contains("hle einen Monat")) && mounthList.size() > 1) continue;
                            LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] " + getLogMethod + "current Option is selected?: " + month.isSelected());
                            if (!month.isSelected()) {
                                mounthSelector.selectByVisibleText(month.getText());
                                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                                LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] " + getLogMethod + "current Option after select is selected?: " + month.isSelected());
                            }
                            List transactions = null;
                            int transCount = 0;
                            try {
                                LogDebug.invoke((Object)LogDebug, "[WebSync:TFBank] " + getLogMethod + "Gefundene Monats-Ums\u00e4tze: " + wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)transDetailsPath))));
                                transactions = seleniumWebDriver.findElements(By.xpath((String)transDetailsPath));
                                transCount = transactions.size();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            LogInfo.invoke((Object)LogInfo, "[WebSync:TFBank] " + getLogMethod + "Anzahl der gefundenen Transaktionen auf der Monats-Seite: " + String.valueOf(transCount));
                            if (transactions != null) {
                                for (WebElement transaction : transactions) {
                                    String purpPathText = "";
                                    String betragPathText = "";
                                    String bookingDatePathText = "";
                                    String artPathText = "";
                                    artPathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)artPath)).getText());
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "artPathText: " + artPathText);
                                    bookingDatePathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)bookingDatePath)).getText());
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "bookingDatePathText: " + bookingDatePathText);
                                    purpPathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)purpPath)).getText());
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "purpPathText: " + purpPathText);
                                    betragPathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)betragPath)).getText());
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "betragPathText: " + betragPathText);
                                    transData = transData + bookingDatePathText + ";" + artPathText + ";" + purpPathText + ";" + betragPathText + ";\n";
                                }
                                continue;
                            }
                            transData = transData + "Keine Transaktionen im Monat " + month.getAccessibleName() + "\n";
                        }
                        break block42;
                    }
                    transData = transData + "\n\nKeine neuen Transaktionen vorhanden";
                }
                catch (TimeoutException notFounderr) {
                    isSelfException = true;
                    throw new Exception("Transaktionen aus Seite auslesen fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)notFounderr));
                }
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transDatas (Statement): \n\n====================== BEGIN STATEMENT DATA ======================\n" + transData + "\n\n\n\n======================= END STATEMENT DATA =======================\n");
            String[] dataResponse = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", ""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].trim().split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][0].trim().split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][3], externalLogger));
                    if (matrixArrayData[i][1].contains("Sofortgeld")) {
                        betrag *= -1.0;
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][1]));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    String purp = matrixArrayData[i][2];
                    if (!StringCharUtils.isNullOrEmptyOrNothing(purp)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(purp.replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:TFBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("TFBank", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

