/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.suresse;

import de.derrichter.finance.websync.institute.suresse.JsonUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonPull {
    public static ArrayList getTransData(Map.Entry<HttpClient, JSONObject> mashupHttpJson, String iban, String optionalOption, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        if (StringCharUtils.isNullOrEmptyOrNothing(iban) || iban.length() < 4) {
            throw new Exception("Die IBAN/Kontonummer wurde nicht gesetzt");
        }
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        try {
            String transData = "KONTONUMMER;DATUM DES VORGANGS;VALUTADATUM;BESCHREIBUNG;BETRAG;KONTRAHENT;KONTO DES KONTRAHENTEN;KOMMUNIKATION;REFERENZ;ORIGINAL BETRAG; ORIGINAL W\u00c4HRUNG\n";
            JSONObject userObject = mashupHttpJson.getValue().getJSONObject("user");
            String principalID = userObject.optString("userId");
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "OK. Authentication successful! principalID: " + principalID);
            HttpRequest accountsRequest = HttpRequest.newBuilder(URI.create("https://secure.suressedirektbank.de" + "/xclde/webapi/b2crestapi/1/principaltocashaccountlinks?principalIdentification=<principalID>&retrieveAvailableAccountBalance=true".replace("<principalID>", principalID))).header("content-type", "application/json").GET().build();
            HttpResponse<String> accountsResponse = mashupHttpJson.getKey().send(accountsRequest, HttpResponse.BodyHandlers.ofString());
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + accountsResponse);
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + accountsResponse.headers());
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "Accounts-Response: " + accountsResponse.body());
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "givenAccountNumber: " + iban);
            JSONObject jsonObject = new JSONObject(accountsResponse.body());
            jsonObject = jsonObject.getJSONObject("PrincipalToCashAccountLinkOrder");
            JSONArray accountsList = jsonObject.getJSONArray("goalList");
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            try {
                JsonUtils.checkJsonResponse(jsonObject, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Kontenaufruf: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String currentBalance = "";
            String availableBalance = "";
            try {
                for (int account = 0; account < accountsList.length(); ++account) {
                    if (!accountsList.getJSONObject(account).optString("accountNumber").equals(iban)) continue;
                    currentBalance = accountsList.getJSONObject(account).optString("currentBalance");
                    availableBalance = accountsList.getJSONObject(account).optString("availableBalance");
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "currentBalance: " + currentBalance);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "availableBalance: " + availableBalance);
                }
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Kontostand' fehlgeschlagen: " + error.getMessage());
            }
            amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(currentBalance, externalLogger));
            availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableBalance, externalLogger));
            LogDebug.invoke((Object)LogDebug, "[WebSync:Suresse] " + getLogMethod + "Amount: " + amount);
            LogDebug.invoke((Object)LogDebug, "[WebSync:Suresse] " + getLogMethod + "availableAmount: " + availableAmount);
            HttpRequest transactionsRequest = HttpRequest.newBuilder(URI.create("https://secure.suressedirektbank.de" + "/xclde/webapi/b2crestapi/1/accountingmovements?accountNumber=<givenAccountNumber>&start=0&maxResults=500&creditOperation=Y&debitOperation=Y".replace("<givenAccountNumber>", iban))).header("content-type", "application/json").GET().build();
            HttpResponse<String> transactionsResponse = mashupHttpJson.getKey().send(transactionsRequest, HttpResponse.BodyHandlers.ofString());
            jsonObject = new JSONObject(transactionsResponse.body());
            jsonObject = jsonObject.getJSONObject("AccountingMovementOrder");
            try {
                JsonUtils.checkJsonResponse(jsonObject, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Transaktionsaubruf: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + transactionsResponse);
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + transactionsResponse.headers());
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "Transactions-Response: " + transactionsResponse.body());
            JSONArray transactionsList = jsonObject.getJSONArray("goalList");
            LogDebug.invoke((Object)LogDebug, "[WebSync:Suresse] " + getLogMethod + "Transaktionen (Anzahl): " + String.valueOf(transactionsList.length()));
            for (int transaction = 0; transaction < transactionsList.length(); ++transaction) {
                String bookingDateData = transactionsList.getJSONObject(transaction).optString("operationDate");
                String valutaDateData = transactionsList.getJSONObject(transaction).optString("valueDate");
                String artData = transactionsList.getJSONObject(transaction).optString("standardWording");
                String amountData = transactionsList.getJSONObject(transaction).optString("movementAmount");
                String currencyData = transactionsList.getJSONObject(transaction).optString("movementCurrency");
                String purpData = transactionsList.getJSONObject(transaction).optString("communicationPart1");
                String purp2Data = transactionsList.getJSONObject(transaction).optString("communicationPart2");
                String counterNameData = transactionsList.getJSONObject(transaction).optString("counterpartyName");
                String counterAccountData = transactionsList.getJSONObject(transaction).optString("operationCounterparty");
                String transactionIDData = transactionsList.getJSONObject(transaction).optString("operationReference");
                String originalAmountData = transactionsList.getJSONObject(transaction).optString("orderAmount");
                String originalCurrencyData = transactionsList.getJSONObject(transaction).optString("orderCurrency");
                LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "bookingDate: " + bookingDateData);
                LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "valutaDate: " + valutaDateData);
                LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "amount: " + amountData);
                LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "purp: " + purpData);
                LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "purp2: " + purp2Data);
                if (!counterAccountData.equals(iban)) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "counterName: " + counterNameData);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "counterAccount: " + counterAccountData);
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionID: " + transactionIDData);
                artData = artData.replace("ININTCRE", "Zinsabrechnung");
                artData = artData.replace("ININTPRO", "Zinsabrechnung");
                artData = artData.replace("PGCTSTCR", "\u00dcberweisung");
                artData = artData.replace("PGCTSTDB", "\u00dcberweisung");
                transData = transData + iban + ";" + bookingDateData + ";" + valutaDateData + ";" + artData + ";" + amountData + ";" + counterNameData + ";" + counterAccountData + ";" + purpData + purp2Data + ";" + transactionIDData + ";" + originalAmountData + ";" + originalCurrencyData + "\n";
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "formated apiResponse: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n");
            if (transData.contains("<html") || transData.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[] dataResponse = new String[]{transData, String.valueOf(amount)};
            transData = transData.replace("\u26aa", "");
            transData = transData.replace("\u26ab", "");
            transData = transData.replace("\u26ac", "");
            transData = transData.replace("\u26ad", "");
            transData = transData.replace("\u26ae", "");
            transData = transData.replace("\u26af", "");
            transData = transData.replace("\\/", "/");
            transData = transData.replace("\\", "");
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = matrixArrayData.length - 1; i >= 0; --i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    float testnumber = Float.parseFloat(matrixArrayData[i][1]);
                    testnumber = Float.parseFloat(matrixArrayData[i][2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + e.toString());
                    continue;
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "MatrixArrayData to Read: Zeile Nr.: " + i + " wird ausgelesen: " + ArrayUtils.toString((Object)matrixArrayData[i]));
                try {
                    transactionDataList.add(new ArrayList());
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(matrixArrayData[i][1].substring(0, 4), 10), Integer.parseInt(matrixArrayData[i][1].substring(4, 6), 10) - 1, Integer.parseInt(matrixArrayData[i][1].substring(6, 8), 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(matrixArrayData[i][2].substring(0, 4), 10), Integer.parseInt(matrixArrayData[i][2].substring(4, 6), 10) - 1, Integer.parseInt(matrixArrayData[i][2].substring(6, 8), 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][4], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add("EUR");
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][3]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][7])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][7]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][3]);
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    if (!matrixArrayData[i][6].trim().replace("\\s", "").equals(iban)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][6]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][5])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][5]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    String kommentar = "";
                    if (!matrixArrayData[i][10].equals("EUR")) {
                        kommentar = "Urspr\u00fcnglicher Betrag/W\u00e4hrung: " + String.valueOf(matrixArrayData[i][9]) + String.valueOf(matrixArrayData[i][10]);
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(kommentar);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][8])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][8]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][5])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][5]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][8]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception err) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)err));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("Suresse", iban, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

