/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.suresse;

import de.derrichter.finance.websync.institute.suresse.JsonUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;

public class JsonAuth {
    public static Map.Entry<HttpClient, JSONObject> getSession(String givenUsername, String givenPassword, HttpClient javaHttpClient, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        if (StringCharUtils.isNullOrEmptyOrNothing(givenUsername) || givenUsername.length() < 4) {
            throw new Exception("Die Login-Benutzername (Kundennummer) wurde nicht gesetzt");
        }
        String getLogMethod = "[getSession] ";
        boolean isSelfException = false;
        try {
            String sessionData = "{\"language\":\"de\",\"securityContext\":{\"businessChannel\":\"B2C\",\"company\":7,\"authenticationType\":\"PWD\",\"communicationMode\":\"URL\",\"deviceType\":\"DSK\",\"project\":\"SOPRABANKING\"},\"user\":{\"loginName\":\"" + givenUsername + "\"}}";
            HttpRequest sessionRequest = HttpRequest.newBuilder(URI.create("https://secure.suressedirektbank.de/xclde/webapi/login/1/usersession")).header("content-type", "application/json").POST(HttpRequest.BodyPublishers.ofString(sessionData)).build();
            HttpResponse<String> sessionResponse = javaHttpClient.send(sessionRequest, HttpResponse.BodyHandlers.ofString());
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "Session-Request:");
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + sessionResponse);
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + sessionResponse.headers());
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + sessionResponse.body());
            String authData = "{\"dataMap\":{\"code\":\"" + givenPassword + "\"}}";
            HttpRequest authRequest = HttpRequest.newBuilder(URI.create("https://secure.suressedirektbank.de/xclde/webapi/login/1/usersession/authenticate")).header("content-type", "application/json").POST(HttpRequest.BodyPublishers.ofString(authData)).build();
            HttpResponse<String> authResponse = javaHttpClient.send(authRequest, HttpResponse.BodyHandlers.ofString());
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + "Authentication:");
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + authResponse);
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + authResponse.headers());
            LogTrace.invoke((Object)LogTrace, "[WebSync:Suresse] " + getLogMethod + authResponse.body());
            JSONObject jsonObject = new JSONObject(authResponse.body());
            jsonObject = jsonObject.getJSONObject("UserSessionImpl");
            try {
                JsonUtils.checkJsonResponse(jsonObject, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Authentifizieren: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            return new AbstractMap.SimpleEntry<HttpClient, JSONObject>(javaHttpClient, jsonObject);
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(givenUsername, "*******").replace(givenPassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:Suresse] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(givenUsername, "*******").replace(givenPassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(givenUsername, "*******").replace(givenPassword, "*******"));
        }
    }

    public static void closeSession(HttpClient javaHttpClient, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[closeSession] ";
        boolean isSelfException = false;
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:Suresse] " + getLogMethod + "Abmelden aufrufen...");
            HttpRequest logoutRequest = HttpRequest.newBuilder(URI.create("https://secure.suressedirektbank.de/xclde/webapi/login/1/usersession/close")).header("content-type", "application/json").POST(HttpRequest.BodyPublishers.ofString("")).build();
            HttpResponse<String> logoutResponse = javaHttpClient.send(logoutRequest, HttpResponse.BodyHandlers.ofString());
            JSONObject jsonObject = new JSONObject(logoutResponse.body());
            jsonObject = jsonObject.getJSONObject("UserSessionImpl");
            LogDebug.invoke((Object)LogDebug, "[WebSync:Suresse] " + getLogMethod + "End Session (Logout):\n");
            LogDebug.invoke((Object)LogDebug, "[WebSync:Suresse] " + getLogMethod + logoutResponse);
            LogDebug.invoke((Object)LogDebug, "[WebSync:Suresse] " + getLogMethod + logoutResponse.headers());
            LogDebug.invoke((Object)LogDebug, "[WebSync:Suresse] " + getLogMethod + logoutResponse.body());
            try {
                JsonUtils.checkJsonResponse(jsonObject, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Beenden der Session: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Suresse] " + getLogMethod + "Logout bei der '" + "Suresse Direkt Bank" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:Suresse] " + getLogMethod + "Session-Logout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("Session-Logout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

