/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.santanderconsumerbank;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;

public class WebUtils {
    static final String COOKIE_DETECT_PATH = "#usercentrics-root,#uc-center-container";
    static final String COOKIE_ACCEPT_PATH = "button[data-testid='uc-accept-all-button']";
    static String LOADER_CATCHSTRING = "LoadingOverlay";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//div[contains(@class,'LoadingOverlay') or contains(@class,'pageLoader')]";
    static String LOADER_TEXT = "LoadingOverlay";
    protected static String[] xpathSearchString = new String[5];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//*[contains(@class,'iconWarning')]//parent::p";
        WebUtils.xpathSearchString[1] = "//*[contains(.,'504 Gateway Time-out')]";
        WebUtils.xpathSearchString[2] = "//*[contains(@class,'MuiAlert-message')]";
        WebUtils.xpathSearchString[3] = "//*[contains(@class,'headline-error')]//parent::div";
        WebUtils.xpathSearchString[4] = "//p[contains(.,'Die Verifizierung ist fehlgeschlagen')]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Bitte tragen Sie die korrekte 6-stellige mobileTAN ein";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        String logIdent = "[WebSync:Santander] ";
        String longName = "Santander Consumer Bank AG";
        String errorMessage = null;
        if (responsePageAsString.contains("id=\"wartungsSeite\"") && responsePageAsString.contains("Geplante Wartungsarbeiten")) {
            errorMessage = "Geplante Wartungsarbeiten\n\nManchmal muss man auch in der digitalen Welt manuell Hand anlegen.\n\nDie Webseite steht aufgrund von Wartungsarbeiten aktuell nicht zur Verf\u00fcgung. Wir bitten um Ihr Verst\u00e4ndnis.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der Santander Consumer Bank AG:\n\n\n" + errorMessage, "institutlogo-santanderconsumerbank.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (responsePageAsString.contains("Die Sitzung wurde zu Ihrer Sicherheit beendet")) {
            errorMessage = "Es ist ein Sitzungsfehler aufgetreten.\n\nDer Bank-Server hat die Sitzung zu Ihrer Sicherheit beendet.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der Santander Consumer Bank AG:\n\n\n" + errorMessage, "institutlogo-santanderconsumerbank.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-santanderconsumerbank.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static List<String> getCurrencys() {
        ArrayList<String> iso4217 = new ArrayList<String>();
        iso4217.add("[(AED)");
        iso4217.add("[(AFN)");
        iso4217.add("[(ALL)");
        iso4217.add("[(AMD)");
        iso4217.add("[(ANG)");
        iso4217.add("[(AOA)");
        iso4217.add("[(ARS)");
        iso4217.add("[(AUD)");
        iso4217.add("[(AWG)");
        iso4217.add("[(AZN)");
        iso4217.add("[(BAM)");
        iso4217.add("[(BBD)");
        iso4217.add("[(BDT)");
        iso4217.add("[(BGN)");
        iso4217.add("[(BHD)");
        iso4217.add("[(BIF)");
        iso4217.add("[(BMD)");
        iso4217.add("[(BND)");
        iso4217.add("[(BOB)");
        iso4217.add("[(BOV)");
        iso4217.add("[(BRL)");
        iso4217.add("[(BSD)");
        iso4217.add("[(BTN)");
        iso4217.add("[(BWP)");
        iso4217.add("[(BYN)");
        iso4217.add("[(BYR)");
        iso4217.add("[(BZD)");
        iso4217.add("[(CAD)");
        iso4217.add("[(CDF)");
        iso4217.add("[(CHE)");
        iso4217.add("[(CHF)");
        iso4217.add("[(CHW)");
        iso4217.add("[(CLF)");
        iso4217.add("[(CLP)");
        iso4217.add("[(CNY)");
        iso4217.add("[(COP)");
        iso4217.add("[(COU)");
        iso4217.add("[(CRC)");
        iso4217.add("[(CUC)");
        iso4217.add("[(CUP)");
        iso4217.add("[(CVE)");
        iso4217.add("[(CZK)");
        iso4217.add("[(DJF)");
        iso4217.add("[(DKK)");
        iso4217.add("[(DOP)");
        iso4217.add("[(DZD)");
        iso4217.add("[(EGP)");
        iso4217.add("[(ERN)");
        iso4217.add("[(ETB)");
        iso4217.add("[(FJD)");
        iso4217.add("[(FKP)");
        iso4217.add("[(GBP)");
        iso4217.add("[(GEL)");
        iso4217.add("[(GHS)");
        iso4217.add("[(GIP)");
        iso4217.add("[(GMD)");
        iso4217.add("[(GNF)");
        iso4217.add("[(GTQ)");
        iso4217.add("[(GYD)");
        iso4217.add("[(HKD)");
        iso4217.add("[(HNL)");
        iso4217.add("[(HRK)");
        iso4217.add("[(HTG)");
        iso4217.add("[(HUF)");
        iso4217.add("[(IDR)");
        iso4217.add("[(ILS)");
        iso4217.add("[(INR)");
        iso4217.add("[(IQD)");
        iso4217.add("[(IRR)");
        iso4217.add("[(ISK)");
        iso4217.add("[(JMD)");
        iso4217.add("[(JOD)");
        iso4217.add("[(JPY)");
        iso4217.add("[(KES)");
        iso4217.add("[(KGS)");
        iso4217.add("[(KHR)");
        iso4217.add("[(KMF)");
        iso4217.add("[(KPW)");
        iso4217.add("[(KRW)");
        iso4217.add("[(KWD)");
        iso4217.add("[(KYD)");
        iso4217.add("[(KZT)");
        iso4217.add("[(LAK)");
        iso4217.add("[(LBP)");
        iso4217.add("[(LKR)");
        iso4217.add("[(LRD)");
        iso4217.add("[(LSL)");
        iso4217.add("[(LYD)");
        iso4217.add("[(MAD)");
        iso4217.add("[(MDL)");
        iso4217.add("[(MGA)");
        iso4217.add("[(MKD)");
        iso4217.add("[(MMK)");
        iso4217.add("[(MNT)");
        iso4217.add("[(MOP)");
        iso4217.add("[(MRU)");
        iso4217.add("[(MUR)");
        iso4217.add("[(MVR)");
        iso4217.add("[(MWK)");
        iso4217.add("[(MXN)");
        iso4217.add("[(MXV)");
        iso4217.add("[(MYR)");
        iso4217.add("[(MZN)");
        iso4217.add("[(NAD)");
        iso4217.add("[(NGN)");
        iso4217.add("[(NIO)");
        iso4217.add("[(NOK)");
        iso4217.add("[(NPR)");
        iso4217.add("[(NZD)");
        iso4217.add("[(OMR)");
        iso4217.add("[(PAB)");
        iso4217.add("[(PEN)");
        iso4217.add("[(PGK)");
        iso4217.add("[(PHP)");
        iso4217.add("[(PKR)");
        iso4217.add("[(PLN)");
        iso4217.add("[(PYG)");
        iso4217.add("[(QAR)");
        iso4217.add("[(RON)");
        iso4217.add("[(RSD)");
        iso4217.add("[(RUB)");
        iso4217.add("[(RWF)");
        iso4217.add("[(SAR)");
        iso4217.add("[(SBD)");
        iso4217.add("[(SCR)");
        iso4217.add("[(SDG)");
        iso4217.add("[(SEK)");
        iso4217.add("[(SGD)");
        iso4217.add("[(SHP)");
        iso4217.add("[(SLL)");
        iso4217.add("[(SOS)");
        iso4217.add("[(SRD)");
        iso4217.add("[(SSP)");
        iso4217.add("[(STN)");
        iso4217.add("[(SVC)");
        iso4217.add("[(SYP)");
        iso4217.add("[(SZL)");
        iso4217.add("[(THB)");
        iso4217.add("[(TJS)");
        iso4217.add("[(TMT)");
        iso4217.add("[(TND)");
        iso4217.add("[(TOP)");
        iso4217.add("[(TRY)");
        iso4217.add("[(TTD)");
        iso4217.add("[(TWD)");
        iso4217.add("[(TZS)");
        iso4217.add("[(UAH)");
        iso4217.add("[(UGX)");
        iso4217.add("[(USD)");
        iso4217.add("[(UYI)");
        iso4217.add("[(UYU)");
        iso4217.add("[(UZS)");
        iso4217.add("[(VEF)");
        iso4217.add("[(VND)");
        iso4217.add("[(VUV)");
        iso4217.add("[(WST)");
        iso4217.add("[(XAF)");
        iso4217.add("[(XCD)");
        iso4217.add("[(XOF)");
        iso4217.add("[(XPF)");
        iso4217.add("[(XSU)");
        iso4217.add("[(YER)");
        iso4217.add("[(ZAR)");
        iso4217.add("[(ZMW)");
        iso4217.add("[(ZWL)");
        return iso4217;
    }
}

