/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.santanderconsumerbank;

import de.derrichter.finance.websync.institute.santanderconsumerbank.WebUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPush {
    private static String secAuthMeth = "";

    public static String getSecAuthMeth() {
        return secAuthMeth;
    }

    public static void setSecAuthMeth(String value) {
        secAuthMeth = value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void transfer(WebDriver seleniumWebDriver, String kontonummer, String gegenkontoName, String gegenkontoIBAN, String gegenkontoBIC, String betrag, String verwendungszweck, String termin, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        Method DialogAskMTAN = externalDialogInterface.getMethod("askMTANforTransaction", String.class, String.class, String.class);
        Method DialogAskBankingApp = externalDialogInterface.getMethod("askBankingAppforTransaction", String.class, String.class, String.class);
        String getLogMethod = "[sendTrans] ";
        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Originale Auftragsdaten wie vom Programm \u00fcbergeben (Auftragskonto, IBAN, BIC und Betrag sind aber schon getrimmt)");
        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Auftragskonto (IBAN):             " + kontonummer);
        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Gegenkonto (IBAN):                " + gegenkontoIBAN);
        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Gegenkonto (BIC):                 " + gegenkontoBIC);
        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Auftragsdaten (Betrag):           " + betrag);
        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Auftragsdaten (Verwendungszweck): " + verwendungszweck);
        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Auftragsdaten (Termin):           " + termin);
        kontonummer = kontonummer.replaceAll("\\s+", "").trim();
        gegenkontoIBAN = gegenkontoIBAN.replaceAll("\\s+", "").trim();
        gegenkontoBIC = gegenkontoBIC.replaceAll("\\s+", "").trim();
        betrag = betrag.replaceAll("\\s+", "").trim();
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        boolean isSelfException = false;
        try {
            block110: {
                Object resIbanField;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "getSecAuthMeth() from WebAuth: " + WebPush.getSecAuthMeth());
                String currentURL = seleniumWebDriver.getCurrentUrl();
                String currentURLmain = currentURL.substring(0, currentURL.lastIndexOf("#/") + 2);
                String bankingAccessURL = currentURLmain + "settings-service/online-banking-access";
                try {
                    seleniumWebDriver.get(bankingAccessURL);
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "bankingAccessPage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String disableButtonPath = "//button[contains(.,'Deaktivieren')]";
                try {
                    String detectPath = "//div[contains(@class,'stepsModal__wrapper')]";
                    String messagePath = detectPath + "//div[contains(@class,'initialScreen')]";
                    String closePath = "//div[contains(@class,'close')]";
                    SeleniumUtils.checkAndCloseInfoMessage(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "https://meine.santander.de/olb", "institutlogo-santanderconsumerbank.png", detectPath, messagePath, closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "santanderSignSettings", "(//div[contains(.,'SantanderSign verwalten')])[last()]/ancestor::a", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "SantanderSign wohl aktiv: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)disableButtonPath))));
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        WebPush.setSecAuthMeth("bankingApp");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "SantanderSign ist wohl aktiv, daher das deaktivieren abbrechen...");
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cancelButton", "//button[contains(.,'Abbrechen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    }
                    catch (Exception error) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "SantanderSign ist wohl NICHT aktiv, daher das Aktivieren abbrechen und Fenster schlie\u00dfen ...");
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "closeButton", "//button[contains(@class,'closeButton')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        WebPush.setSecAuthMeth("mobileTAN");
                    }
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    WebPush.setSecAuthMeth("mobileTAN");
                }
                catch (Exception error) {
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "getSecAuthMeth() from WebPush: " + WebPush.getSecAuthMeth());
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 25);
                MonitorLog.invoke((Object)MonitorLog, "SEPA-\u00dcberweisungsformular aufrufen, ausf\u00fcllen und Authentifizierung anfordern ...");
                currentURL = seleniumWebDriver.getCurrentUrl();
                currentURLmain = currentURL.substring(0, currentURL.lastIndexOf("#/") + 2);
                String newTransferURL = currentURLmain + "financial-transactions/transfer/edit";
                try {
                    seleniumWebDriver.get(newTransferURL);
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "newTransferSite: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                pageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountSelect", "//li[contains(.,'" + StringCharUtils.banknumAddCharLikeIBAN(kontonummer, " ") + "')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Das Auftragskonto wird von der Bank nicht angeboten und wird somit wohl nicht unterst\u00fctzt! W\u00e4hlen Sie ein anderes Auftragskonto");
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 35);
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "\u00dcbergebener Original-Betrag: " + betrag);
                String inputBetrag = betrag.replaceAll("[^0-9-.,]+", "");
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Betrag-Wert zur Eingabe die gleich erfolgt: " + inputBetrag);
                String resNamePath = "//input[@name='beneficiary']";
                String resIbanPath = "//input[@name='iban']";
                String resAmountPath = "//input[@name='amount']";
                String resPurposePath = "//textarea[@id='purpose']";
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)resNamePath)));
                try {
                    JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
                    WebElement resNameField = seleniumWebDriver.findElement(By.xpath((String)resNamePath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "resNameField: " + resNameField);
                    jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{resNameField});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    if (resNameField.isEnabled()) {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resNameField", resNamePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        resNameField.sendKeys(new CharSequence[]{gegenkontoName});
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    }
                    resIbanField = seleniumWebDriver.findElement(By.xpath((String)resIbanPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "resIban: " + resIbanPath);
                    jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{resIbanField});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    if (resIbanField.isEnabled()) {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resIbanField", resIbanPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        resIbanField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                        resIbanField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                        resIbanField.sendKeys(new CharSequence[]{gegenkontoIBAN});
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, false, externalLogger);
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        resIbanField.sendKeys(new CharSequence[]{Keys.TAB});
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    } else if (!resIbanField.getAttribute("value").equals(StringCharUtils.ibanAddSpaces(gegenkontoIBAN))) {
                        isSelfException = true;
                        throw new Exception("Dieses Konto unterst\u00fctzt das Gegenkonto als Empf\u00e4nger nicht. Fest vorgegebene IBAN ist: " + resIbanField.getAttribute("value") + " (" + resNameField.getAttribute("value") + ")");
                    }
                    WebElement resAmountField = seleniumWebDriver.findElement(By.xpath((String)resAmountPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "resAmount: " + resAmountPath);
                    jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{resAmountField});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    if (!resIbanField.isEnabled()) {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resAmountField", resAmountPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    } else {
                        resAmountField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                        resAmountField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                        resAmountField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                    }
                    resAmountField.sendKeys(new CharSequence[]{inputBetrag});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    WebElement resPurposeField = seleniumWebDriver.findElement(By.xpath((String)resPurposePath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "resPurposeField: " + resPurposePath);
                    jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{resPurposeField});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resPurposeField", resPurposePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception clickError) {
                        if (!clickError.getMessage().contains("ElementClickInterceptedException")) throw new Exception(clickError.getMessage());
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resPurposeField", resPurposePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    resPurposeField.sendKeys(new CharSequence[]{verwendungszweck});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (Exception error) {
                    if (isSelfException) {
                        throw new Exception(error.getMessage());
                    }
                    isSelfException = true;
                    throw new Exception("Fehler beim Setzen der Auftrags-Werte (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 45);
                try {
                    List errorTextObjects = seleniumWebDriver.findElements(By.xpath((String)"//p[contains(@class,'isSublineError')]"));
                    if (errorTextObjects.size() <= 0) {
                        throw new NoSuchElementException("");
                    }
                    String formatedMessageText = "";
                    resIbanField = errorTextObjects.iterator();
                    while (true) {
                        if (!resIbanField.hasNext()) {
                            DialogError.invoke((Object)DialogError, "(Werte im \u00dcberweisungsformular sind fehlerhaft)\n\nFehlermeldung(en) der Santander Consumer Bank AG:\n\n" + formatedMessageText, "institutlogo-santanderconsumerbank.png");
                            isSelfException = true;
                            throw new Exception("(Werte im \u00dcberweisungsformular sind fehlerhaft) Fehlermeldung(en) des Servers: " + formatedMessageText.trim());
                        }
                        WebElement errorTextObject = (WebElement)resIbanField.next();
                        String errorText = errorTextObject.getText();
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "errorTextObject (getText): " + errorText);
                        if (StringCharUtils.isNullOrEmptyOrNothing(errorText)) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "diese xPathExpression ist aber beim Auslesen mit Selenium leer und liefert keinen Text ... versuche noch alternativ den CSS-InnerHTML ...");
                            errorText = errorTextObject.getAttribute("innerHTML");
                            errorText = errorText.replaceAll("\\<.*?\\>", "").trim();
                            if (StringCharUtils.isNullOrEmptyOrNothing(errorText)) {
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "diese xPathExpression ist aber scheinbar wirklich leer und liefert keinen Text ...");
                            } else {
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "diese xPathExpression enth\u00e4lt den innerHTML (ohne HTML-Tags!) also nur Text: " + errorText);
                            }
                        }
                        formatedMessageText = formatedMessageText + "\n" + errorText;
                    }
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "OK. \u00dcberweisung-Form wurde wohl plausibel ausgef\u00fcllt, keine Fehler gefunden...");
                }
                catch (Exception error) {
                    if (!isSelfException) throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    throw new Exception(error.getMessage());
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "\u00dcberweisung-Form wird abgesendet und die Daten gepr\u00fcft ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "sendButton", "//button[contains(@class,'transfer__primaryBtn')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                pageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                TakesScreenshot screenshotObject = null;
                String screenShotBASE64 = null;
                String tempScreenshotPath = null;
                String currentSourceToView = null;
                try {
                    try {
                        WebElement beginning = seleniumWebDriver.findElement(By.xpath((String)"//h2[contains(.,'\u00dcberpr\u00fcfen')]"));
                        JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
                        jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{beginning});
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    }
                    catch (Exception error) {
                        LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "Scrollen zum Anfang des Formulars fehlgeschlagen: " + error.getMessage());
                    }
                    screenshotObject = (TakesScreenshot)seleniumWebDriver;
                    File screenShotFile = (File)screenshotObject.getScreenshotAs(OutputType.FILE);
                    tempScreenshotPath = System.getProperty("java.io.tmpdir") + File.separator + "syncWebClient_ScreenCaptureTmp" + File.separator + "santander" + String.valueOf(new Date().getTime()) + "-transfer.png";
                    FileUtils.moveFile((File)screenShotFile, (File)new File(tempScreenshotPath));
                    String screenShotRawBASE64 = (String)screenshotObject.getScreenshotAs(OutputType.BASE64);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "screenShotRawBASE64: " + screenShotRawBASE64);
                    screenShotBASE64 = "data:image/png;base64," + screenShotRawBASE64;
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "screenShotBASE64: " + screenShotBASE64);
                    currentSourceToView = tempScreenshotPath;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Sichtkontrollseite konnte nicht erstellt werden; Errorseite vermutlich erstellt: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String wrongPurpEntryPath = "//p[contains(.,'als Verwendungszweck die 16-stellige Kreditkartennummer')]";
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 55);
                if (WebPush.getSecAuthMeth().equals("mobileTAN")) {
                    String userTanInput;
                    block109: {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "Auftrag wird abgesendet und somit die mobileTAN angefordert ...");
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "sendButton", "//button[contains(@class,'transfer__primaryBtn')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        pageResponse = seleniumWebDriver.getPageSource();
                        try {
                            WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                        try {
                            seleniumWebDriver.findElement(By.xpath((String)wrongPurpEntryPath));
                            String formatedMessageText = "Bitte geben Sie als Verwendungszweck die 16-stellige Kreditkartennummer an.";
                            DialogError.invoke((Object)DialogError, "(Werte im \u00dcberweisungsformular sind fehlerhaft)\n\nFehlermeldung(en) der Santander Consumer Bank AG:\n\n\n" + formatedMessageText, "institutlogo-santanderconsumerbank.png");
                            isSelfException = true;
                            throw new Exception("(Werte im \u00dcberweisungsformular sind fehlerhaft) Fehlermeldung(en) des Servers: " + formatedMessageText.trim());
                        }
                        catch (NoSuchElementException | TimeoutException notFounderr) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "OK. \u00dcberweisung-Form wurde wohl passend ausgef\u00fcllt, kein bekannter Hinweis-Text gefunden...");
                        }
                        catch (Exception error) {
                            if (!isSelfException) throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            throw new Exception(error.getMessage());
                        }
                        userTanInput = null;
                        try {
                            String userInfoText = "Sie bekommen in K\u00fcrze eine mTAN (mobileTAN) per SMS auf Ihr Mobiltelefon zugeschickt.\nBitte geben Sie diese ein, um die Transaktion zu best\u00e4tigen.\n\nEmpf\u00e4nger: " + gegenkontoName + "\nEmpf\u00e4nger IBAN: " + gegenkontoIBAN + "\nAuftragsdatum: " + new SimpleDateFormat("dd.MM.yyyy").format(new Date().getTime()) + "\nBetrag: " + betrag + "" + System.getProperty("line.separator");
                            userTanInput = (String)DialogAskMTAN.invoke((Object)DialogAskMTAN, userInfoText, currentSourceToView, "institutlogo-santanderconsumerbank.png");
                            if (!currentSourceToView.contains("syncWebClient")) break block109;
                        }
                        catch (InvocationTargetException error) {
                            try {
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", "//button[contains(.,'Abbrechen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                }
                                catch (Exception abort) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)abort));
                                }
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "yesButton", "//button[contains(.,'Ja')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                }
                                catch (Exception abort) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)abort));
                                }
                                isSelfException = true;
                                if (ExceptionUtils.getRootCauseStackTrace((Throwable)error)[0].contains("OperationCanceledException")) {
                                    throw new Exception("Angabe der mTAN vom Benutzer abgebrochen (OperationCanceledException)");
                                }
                                LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "DialogAskMTAN fehlerhaft:" + ExceptionUtils.getStackTrace((Throwable)error));
                                throw new Exception("DialogAskMTAN fehlerhaft: " + error.getMessage());
                                catch (Exception error2) {
                                    try {
                                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", "//button[contains(.,'Abbrechen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                    }
                                    catch (Exception abort) {
                                        isSelfException = true;
                                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)abort));
                                    }
                                    try {
                                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "yesButton", "//button[contains(.,'Ja')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                    }
                                    catch (Exception abort) {
                                        isSelfException = true;
                                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)abort));
                                    }
                                    isSelfException = true;
                                    throw new Exception("Angabe der mTAN vom Benutzer abgebrochen oder DialogAskMTAN fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error2));
                                }
                            }
                            catch (Throwable throwable) {
                                if (!currentSourceToView.contains("syncWebClient")) throw throwable;
                                try {
                                    FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
                                    throw throwable;
                                }
                                catch (Exception error3) {
                                    LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error3.getMessage());
                                }
                                throw throwable;
                            }
                        }
                        try {
                            FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
                        }
                        catch (Exception error) {
                            LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error.getMessage());
                        }
                    }
                    MonitorLog.invoke((Object)MonitorLog, "Authentifiziere Auftrag mit angegebener mTAN ...");
                    String tanInputPath = "//input[@id='otp-input']";
                    String submitTanPath = "//button[contains(@class,'SigningOverlay')][2]";
                    String detectTANformPath = "//div[contains(@class,'SigningOverlay')]//p[contains(.,'SMS')]";
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "mobileTAN als aktivtives 2FA-Sicherheitsverfahren erkannt ...");
                    WebElement tanInput1 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[1]")));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput1: " + tanInput1);
                    WebElement tanInput2 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[2]")));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput2: " + tanInput2);
                    WebElement tanInput3 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[3]")));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput3: " + tanInput3);
                    WebElement tanInput4 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[4]")));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput4: " + tanInput4);
                    WebElement tanInput5 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[5]")));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput5: " + tanInput5);
                    WebElement tanInput6 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[6]")));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput6: " + tanInput6);
                    new Actions(seleniumWebDriver).click(tanInput1).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    tanInput1.sendKeys(new CharSequence[]{userTanInput.substring(0, 1)});
                    new Actions(seleniumWebDriver).click(tanInput2).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    tanInput2.sendKeys(new CharSequence[]{userTanInput.substring(1, 2)});
                    new Actions(seleniumWebDriver).click(tanInput3).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    tanInput3.sendKeys(new CharSequence[]{userTanInput.substring(2, 3)});
                    new Actions(seleniumWebDriver).click(tanInput4).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    tanInput4.sendKeys(new CharSequence[]{userTanInput.substring(3, 4)});
                    new Actions(seleniumWebDriver).click(tanInput5).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    tanInput5.sendKeys(new CharSequence[]{userTanInput.substring(4, 5)});
                    new Actions(seleniumWebDriver).click(tanInput6).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    tanInput6.sendKeys(new CharSequence[]{userTanInput.substring(5, 6)});
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTAN", submitTanPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    pageResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                }
                if (!WebPush.getSecAuthMeth().equals("bankingApp")) {
                    isSelfException = true;
                    throw new Exception("Beim Login erkanntes 2FA-Verfahren nicht bekannt (Bitte dem Entwickler im Forum melden)");
                }
                try {
                    String userInfoText = "Mit einem Klick auf 'Ausf\u00fchren' wird der Auftrag abgesendet und somit die Authentifizierung per Banking-App angefragt.\nBitte best\u00e4tigen Sie die Daten.\n\nEmpf\u00e4nger: " + gegenkontoName + "\nEmpf\u00e4nger IBAN: " + gegenkontoIBAN + "\nAuftragsdatum: " + new SimpleDateFormat("dd.MM.yyyy").format(new Date().getTime()) + "\nBetrag: " + betrag + "" + System.getProperty("line.separator");
                    DialogAskBankingApp.invoke((Object)DialogAskBankingApp, userInfoText, currentSourceToView, "institutlogo-santanderconsumerbank.png");
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "Auftrag wird abgesendet und somit die Banking-APP-Freigabe angefordert ...");
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "sendButton", "//button[contains(@class,'transfer__primaryBtn')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)wrongPurpEntryPath));
                        String formatedMessageText = "Bitte geben Sie als Verwendungszweck die 16-stellige Kreditkartennummer an.";
                        DialogError.invoke((Object)DialogError, "(Werte im \u00dcberweisungsformular sind fehlerhaft)\n\nFehlermeldung(en) der Santander Consumer Bank AG:\n\n\n" + formatedMessageText, "institutlogo-santanderconsumerbank.png");
                        isSelfException = true;
                        throw new Exception("(Werte im \u00dcberweisungsformular sind fehlerhaft) Fehlermeldung(en) des Servers: " + formatedMessageText.trim());
                    }
                    catch (NoSuchElementException | TimeoutException notFounderr) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "OK. \u00dcberweisung-Form wurde wohl passend ausgef\u00fcllt, kein bekannter Hinweis-Text gefunden...");
                    }
                    catch (Exception error) {
                        if (!isSelfException) throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception(error.getMessage());
                    }
                    try {
                        String detectTANformPath = "//div[contains(@class,'SigningOverlay')]//p[contains(.,'SantanderSign')]";
                        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Banking-App als abfragendes 2FA-Sicherheitsverfahren erkannt");
                        WebElement waiterCheck = null;
                        MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                        int rounds = 0;
                        Thread.sleep(3000L);
                        boolean waitAppAuth = true;
                        do {
                            try {
                                waiterCheck = seleniumWebDriver.findElement(By.xpath((String)detectTANformPath));
                            }
                            catch (NoSuchElementException | TimeoutException noBestSign) {
                                waitAppAuth = false;
                            }
                            if (waitAppAuth) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                                Thread.sleep(3000L);
                                ++rounds;
                            }
                            if (rounds < 39) continue;
                            isSelfException = true;
                            throw new Exception("Banking-App Authentifizierung auch nach 120 Sekunden nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                        } while (waitAppAuth);
                    }
                    catch (Exception error) {
                        if (isSelfException) {
                            throw new Exception(error.getMessage());
                        }
                        isSelfException = true;
                        throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    pageResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    if (!currentSourceToView.contains("syncWebClient")) break block110;
                }
                catch (InvocationTargetException error) {
                    try {
                        if (isSelfException) {
                            throw new Exception(error.getMessage());
                        }
                        isSelfException = true;
                        if (ExceptionUtils.getRootCauseStackTrace((Throwable)error)[0].contains("OperationCanceledException")) {
                            throw new Exception("Anfrage der Banking-APP-Freigabe vom Benutzer abgebrochen (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "DialogAskBankingApp fehlerhaft:" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("DialogAskBankingApp fehlerhaft: " + error.getMessage());
                        catch (Exception error4) {
                            if (isSelfException) {
                                throw new Exception(error4.getMessage());
                            }
                            isSelfException = true;
                            throw new Exception("Anfrage der Banking-APP-Freigabe vom Benutzer abgebrochen oder DialogAskBankingApp fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error4));
                        }
                    }
                    catch (Throwable throwable) {
                        if (!currentSourceToView.contains("syncWebClient")) throw throwable;
                        try {
                            FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
                            throw throwable;
                        }
                        catch (Exception error5) {
                            LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error5.getMessage());
                        }
                        throw throwable;
                    }
                }
                try {
                    FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
                }
                catch (Exception error) {
                    LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error.getMessage());
                }
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 70);
            String successTrans = "//p[contains(.,'Ihr Auftrag wird ausgef\u00fchrt')]";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Auftrag wohl erfolgreich: " + wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successTrans))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                throw new Exception("Erfolgreiche Ausf\u00fchrung des Auftrags konnte nicht best\u00e4tigt werden! Bitte online pr\u00fcfen. Wenn doch ausgef\u00fchrt, Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe." + ExceptionUtils.getStackTrace((Throwable)notFounderr));
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "mainButton", "//button[contains(@class,'MuiButton-root')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 85);
            return;
        }
        catch (Exception error) {
            if (!isSelfException) throw new Exception("Exception beim Ausf\u00fchren des Auftrags: " + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception(error.getMessage());
        }
    }
}

