/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.santanderconsumerbank;

import com.browserup.bup.BrowserUpProxy;
import com.browserup.bup.proxy.CaptureType;
import com.browserup.harreader.model.Har;
import com.browserup.harreader.model.HarEntry;
import com.browserup.harreader.model.HarLog;
import com.browserup.harreader.model.HarPage;
import de.derrichter.finance.websync.institute.santanderconsumerbank.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.Land.SEPALand;
import de.jost_net.OBanToo.SEPA.SEPAException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String iban, String unterkonto, String fromDateSimple, String toDateSimple, BrowserUpProxy browserupProxy, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        String dateNowSimple = null;
        if (!StringCharUtils.isNullOrEmptyOrNothing(toDateSimple)) {
            dateNowSimple = toDateSimple;
        } else {
            toDateSimple = dateNowSimple = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
        }
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        iban = iban.replaceAll("\\s+", "").trim();
        Boolean isCreditcard = false;
        unterkonto = unterkonto.replaceAll("\\s+", "").trim();
        if (unterkonto.length() == 16) {
            try {
                float testnumber = Float.parseFloat(unterkonto);
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] Unterkonto entspricht den Kriterien einer Kreditkartennummer ... setze Boolean-Variable");
                isCreditcard = true;
            }
            catch (NumberFormatException testnumber) {
                // empty catch block
            }
        }
        try {
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "institutlogo-santanderconsumerbank.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            String detectPath = "//div[contains(@class,'stepsModal__wrapper')]";
            String messagePath = detectPath + "//div[contains(@class,'initialScreen')]";
            String closePath = "//div[contains(@class,'close')]";
            SeleniumUtils.checkAndCloseInfoMessage(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "https://meine.santander.de/olb", "institutlogo-santanderconsumerbank.png", detectPath, messagePath, closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
            String currentURL = seleniumWebDriver.getCurrentUrl();
            String currentURLmain = currentURL.substring(0, currentURL.lastIndexOf("#/") + 2);
            String maimURL = currentURLmain + "global-position";
            try {
                seleniumWebDriver.get(maimURL);
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "mainPage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String accountnr = "";
            if (isCreditcard.booleanValue()) {
                try {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kartennummer enthalten ist ...");
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "checkSubAccountNr (formated): " + StringCharUtils.creditCardAddSpaces(unterkonto));
                    accountnr = unterkonto;
                    wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//span[contains(.,'" + StringCharUtils.creditCardAddSpaces(unterkonto) + "')]"))));
                }
                catch (NoSuchElementException | TimeoutException noCreditCard) {
                    isSelfException = true;
                    throw new Exception("Abbruch: Ihre angegebene Kartennummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
                }
            }
            try {
                if (StringCharUtils.isNullOrEmptyOrNothing(iban)) {
                    isSelfException = true;
                    throw new Exception("Abbruch: IBAN nicht angegeben. Bitte eintragen");
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die IBAN enthalten ist ...");
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "checkAccountNr (formated): " + StringCharUtils.banknumAddSpacesLikeIBAN(iban));
                accountnr = iban;
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//span[contains(.,'" + StringCharUtils.banknumAddSpacesLikeIBAN(iban) + "')]"))));
            }
            catch (NoSuchElementException | TimeoutException noCreditCard) {
                isSelfException = true;
                throw new Exception("Abbruch: Ihre angegebene IBAN ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "OK - IBAN auf der Startseite vorhanden");
            if (isCreditcard.booleanValue()) {
                browserupProxy.enableHarCaptureTypes((Set)CaptureType.getNonBinaryContentCaptureTypes());
                browserupProxy.newHar("response data of transactions for account " + accountnr);
            }
            currentURL = seleniumWebDriver.getCurrentUrl();
            currentURLmain = currentURL.substring(0, currentURL.lastIndexOf("#/") + 2);
            String accountURL = currentURLmain + "global-position/" + accountnr + "/";
            try {
                seleniumWebDriver.get(accountURL);
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "accountPage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            SeleniumUtils.checkAndCloseInfoMessage(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "https://meine.santander.de/olb", "institutlogo-santanderconsumerbank.png", detectPath, messagePath, closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            String amountText = "";
            try {
                amountText = seleniumWebDriver.findElement(By.xpath((String)"//*[contains(@class,'OverallSalda') or contains(@class,'amount') or contains(@class,'kartenAmount')]")).getText();
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "amountText: " + amountText);
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'aktuellen Kontosaldos' fehlgeschlagen: " + error.getMessage());
            }
            try {
                String availableAmountText = null;
                try {
                    availableAmountText = seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Verf\u00fcgbarer Betrag')]//following-sibling::p")).getAttribute("outerHTML");
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "availableAmountText: " + availableAmountText);
                    availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
                }
                catch (NoSuchElementException noCredit) {
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "kontoDetailsButton", "//button[contains(@class,'detailsButton')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        String creditText = seleniumWebDriver.findElement(By.xpath((String)"//span[contains(.,'Dispokredit')]//following-sibling::span")).getText();
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "creditText: " + creditText);
                        double credit = Double.parseDouble(StringCharUtils.parseAndFormatAmount(creditText, externalLogger));
                        availableAmount = credit + amount;
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "availableAmount with credit: " + String.valueOf(availableAmount));
                    }
                    catch (NoSuchElementException noCreditdetails) {
                        availableAmount = amount;
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "availableAmount is amount: " + String.valueOf(availableAmount));
                    }
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "closeKontoDetails", "//button[contains(@class,'btnClose')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                }
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Verf\u00fcgbarer Betrag' fehlgeschlagen: " + error.getMessage() + "; Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String transactionsData = "";
            String apiTransData = "";
            String csvTransData = "";
            String pdfsTransData = "";
            String transDataHeader = "Buchungsdatum;Wertstellung;Betrag(EUR);Saldo(EUR);Verwendungszweck;Fremdbetrag;Fremdw\u00e4hrung;Wechselkurs;Umsatzart\n";
            String lastTransDateString = dateNowSimple;
            int transCount = 0;
            if (isCreditcard.booleanValue()) {
                String apiResponseData = "";
                String wantedDomain = "api.santander.de";
                String wantedURLsection = "transactions";
                LogEntries logs = seleniumWebDriver.manage().logs().get("performance");
                int status = -1;
                int spacesToIndentEachLevel = 8;
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "List of wanted entries from the api:");
                for (LogEntry entry : logs) {
                    try {
                        String messageUrl;
                        String allowMethod;
                        JSONObject json = new JSONObject(entry.getMessage());
                        JSONObject message = json.getJSONObject("message");
                        String method = message.getString("method");
                        if (method == null || !"Network.responseReceived".equals(method)) continue;
                        JSONObject params = message.getJSONObject("params");
                        JSONObject response = params.getJSONObject("response");
                        JSONObject headers = response.getJSONObject("headers");
                        try {
                            allowMethod = headers.getString("Access-Control-Allow-Methods");
                        }
                        catch (Exception notFound) {
                            allowMethod = "MashupDummy";
                        }
                        if (!(messageUrl = response.getString("url")).contains(wantedDomain) || !messageUrl.contains(wantedURLsection) || !allowMethod.equals("GET")) continue;
                        status = response.getInt("status");
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "returned response headers for " + messageUrl + " (status-code: " + status + "):\n" + response.toString(spacesToIndentEachLevel));
                    }
                    catch (JSONException e) {
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Auslesen des JSON-Objekts fehlgeschlagen!" + ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
                Har har = browserupProxy.getHar();
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "HAR-Response Object: " + har);
                try {
                    HarLog log = har.getLog();
                    List entries = log.getEntries();
                    List pages = log.getPages();
                    for (HarPage page : pages) {
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + page.getTitle());
                    }
                    for (HarEntry entry : entries) {
                        String entryUrl = entry.getRequest().getUrl();
                        int entryStatus = entry.getResponse().getStatus();
                        if (!entryUrl.contains(wantedDomain) || !entryUrl.contains(wantedURLsection) || !String.valueOf(entry.getRequest().getMethod()).equals("GET")) continue;
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "    response url: " + entryUrl);
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "    response status: " + entryStatus);
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "    response content data (unformated): " + entry.getResponse().getContent().getText());
                        apiResponseData = StringCharUtils.shrinkString(entry.getResponse().getContent().getText());
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "apiResponseData: " + apiResponseData);
                        if (entryStatus == 200) continue;
                        isSelfException = true;
                        throw new Exception("API-Response der Transaktionen fehlerhaft mit Status-Code: " + entryStatus + "; Bitte versuchen Sie es sp\u00e4ter nochmals; Error-Response: " + apiResponseData);
                    }
                }
                catch (Exception harerror) {
                    if (isSelfException) {
                        throw new Exception(harerror.getMessage());
                    }
                    isSelfException = true;
                    throw new Exception("Auslesen des 'HAR-Objekts' fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)harerror));
                }
                browserupProxy.endHar();
                if (!StringCharUtils.isNullOrEmptyOrNothing(apiResponseData)) {
                    JSONObject jsonResponseObject = new JSONObject(apiResponseData);
                    JSONObject jsonObject = jsonResponseObject.getJSONObject("transactions");
                    JSONArray jsonTransArray = jsonObject.getJSONArray("pending");
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "jsonResponse enh\u00e4lt '" + jsonTransArray.length() + "' Transaktionen");
                    if (jsonTransArray.length() == 0) {
                        apiTransData = "\nIm Abrufzeitraum sind keine Transaktionen vorhanden";
                    }
                    for (int dataround = 0; dataround < jsonTransArray.length(); ++dataround) {
                        String transactionRawDate = jsonTransArray.getJSONObject(dataround).optString("transactionDate");
                        String transactionDate = transactionRawDate.substring(8, 10) + "." + transactionRawDate.substring(5, 7) + "." + transactionRawDate.substring(0, 4);
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionRawDate (JSON): " + transactionRawDate + " : transactionDate: " + transactionDate);
                        String euroAmount = "";
                        String foreignCurrencyName = "";
                        String foreignAmount = "";
                        String foreignExchange = "";
                        boolean isAuslandsumsatz = false;
                        euroAmount = jsonTransArray.getJSONObject(dataround).getJSONObject("transactionAmount").optString("amount");
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "amount (JSON): " + euroAmount);
                        if (!jsonTransArray.getJSONObject(dataround).getJSONObject("originalAmount").optString("currency").equals("EUR")) {
                            foreignCurrencyName = jsonTransArray.getJSONObject(dataround).getJSONObject("originalAmount").optString("currency");
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "foreignCurrencyName (JSON): " + foreignCurrencyName);
                            foreignAmount = jsonTransArray.getJSONObject(dataround).getJSONObject("originalAmount").optString("amount");
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "foreignAmount (JSON): " + foreignAmount);
                            foreignExchange = jsonTransArray.getJSONObject(dataround).optString("exchangeRate");
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "foreignExchange (JSON): " + foreignExchange);
                            isAuslandsumsatz = true;
                        }
                        String transPurpCollection = "";
                        try {
                            String cardAcceptorId = StringCharUtils.shrinkString(jsonTransArray.getJSONObject(dataround).optString("cardAcceptorId").replace(";", ",").replace("\"", ""));
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "cardAcceptorId (JSON): " + cardAcceptorId);
                            if (!StringCharUtils.isNullOrEmpty(cardAcceptorId)) {
                                transPurpCollection = transPurpCollection + cardAcceptorId;
                            }
                        }
                        catch (NoSuchElementException cardAcceptorId) {
                            // empty catch block
                        }
                        try {
                            String cardAcceptorLocation = StringCharUtils.shrinkString(jsonTransArray.getJSONObject(dataround).optString("cardAcceptorLocation").replace(";", ",").replace("\"", ""));
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "cardAcceptorLocation (JSON): " + cardAcceptorLocation);
                            if (!StringCharUtils.isNullOrEmpty(cardAcceptorLocation)) {
                                transPurpCollection = transPurpCollection + " " + cardAcceptorLocation;
                            }
                        }
                        catch (NoSuchElementException cardAcceptorLocation) {
                            // empty catch block
                        }
                        String transactionDetails = StringCharUtils.shrinkString(jsonTransArray.getJSONObject(dataround).optString("transactionDetails").replace(";", ",").replace("\"", ""));
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDetails (JSON): " + transactionDetails);
                        if (!euroAmount.contains("-") && StringCharUtils.isNullOrEmptyOrNothing(transPurpCollection) && transactionDetails.equals("Zahlung")) {
                            transPurpCollection = "Zahlung Lastschrift";
                        } else if (transactionDetails.equals("Ihr Tankrabatt")) {
                            transPurpCollection = "Ihr Tankrabatt";
                        }
                        if (StringCharUtils.isNullOrEmpty(transPurpCollection)) {
                            transPurpCollection = transactionDetails;
                        }
                        String cardNumber = jsonTransArray.getJSONObject(dataround).optString("pan");
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "cardNumber alias pan (JSON): " + cardNumber);
                        String umsatzartText = null;
                        umsatzartText = isAuslandsumsatz ? "Kauf Fremdw\u00e4hrung" : (euroAmount.contains("-") ? "Kauf EURO" : "Gutschrift/Einzahlung/Zahlung Lastschrift");
                        apiTransData = apiTransData + transactionDate + ";" + transactionDate + ";" + euroAmount + ";;" + transPurpCollection + ";" + foreignAmount + ";" + foreignCurrencyName + ";" + foreignExchange + ";" + umsatzartText + "\n";
                        lastTransDateString = transactionDate;
                        ++transCount;
                    }
                    apiTransData = StringCharUtils.unescapeHtml4(apiTransData);
                }
            } else {
                try {
                    String resetFilterLinkPath = "//button[contains(.,'Filter zur\u00fccksetzen')]";
                    seleniumWebDriver.findElement(By.xpath((String)resetFilterLinkPath));
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterButton", resetFilterLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception resetFilterLinkPath) {
                    // empty catch block
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterButton", "//span[contains(.,'Filter')]//ancestor::a", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String startDateInputPath = "//input[@name='start_date']";
                String endDateInputPath = "//input[@name='end_date']";
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)startDateInputPath)));
                WebElement fromDateField = seleniumWebDriver.findElement(By.xpath((String)startDateInputPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "fromDateField: " + fromDateField);
                WebElement toDateField = seleniumWebDriver.findElement(By.xpath((String)endDateInputPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "toDateField: " + toDateField);
                try {
                    new Actions(seleniumWebDriver).click(fromDateField).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    fromDateField.sendKeys(new CharSequence[]{fromDateSimple});
                    fromDateField.sendKeys(new CharSequence[]{Keys.ENTER});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    new Actions(seleniumWebDriver).click(toDateField).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    toDateField.sendKeys(new CharSequence[]{toDateSimple});
                    toDateField.sendKeys(new CharSequence[]{Keys.ENTER});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Anfordern-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitButton", "//button[contains(@class,'containedPrimary')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterSearchResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterSearchResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                boolean hasCSVdata = false;
                try {
                    seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Auswahl keine Daten')]"));
                    csvTransData = transDataHeader + "\nIm Abrufzeitraum sind keine Transaktionen vorhanden";
                }
                catch (NoSuchElementException finderror) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] xpath //p[contains(.,'Auswahl keine Daten')] NICHT gefunden; Es sollte ein CSV-Download m\u00f6glich sein ...");
                    hasCSVdata = true;
                }
                if (hasCSVdata) {
                    File downloadedFile = null;
                    String doctext = null;
                    String fileType = "";
                    boolean localTest = false;
                    if (localTest) {
                        String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                        downloadedFile = new File(docFixTempFilePath);
                    }
                    boolean downloadedFileIsFalse = false;
                    int downloadCount = 1;
                    do {
                        if (!localTest) {
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "csvExport", "//a[@download='transactions.csv']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                            do {
                                Thread.sleep(500L);
                                int waiter = 0;
                                do {
                                    if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                    Thread.sleep(1000L);
                                    ++waiter;
                                } while (downloadedFile == null && waiter < 30);
                                if (downloadedFile != null && downloadedFile.exists()) continue;
                                isSelfException = true;
                                throw new Exception("Download eines Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                            } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                        fileType = FilenameUtils.getExtension((String)downloadedFile.getAbsolutePath()).toUpperCase();
                        if (fileType.toLowerCase().equals("txt") || fileType.toLowerCase().equals("htm") || fileType.toLowerCase().equals("html") || fileType.toLowerCase().equals("asp") || fileType.toLowerCase().equals("js")) {
                            LogWarn.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / falscher Dateityp, versuche es nochmals ...");
                            ++downloadCount;
                            downloadedFileIsFalse = true;
                        } else {
                            downloadedFileIsFalse = false;
                        }
                        if (downloadCount < 4) continue;
                        isSelfException = true;
                        throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                    } while (downloadedFileIsFalse);
                    String fileResponse = "";
                    String fileencoding = "UTF-8";
                    fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "raw-fileResponse witout file-encoding convert:\n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                    if (!fileencoding.equals("UTF-8")) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                        byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                        doctext = new String(filebytes, System.getProperty("file.encoding"));
                    } else {
                        doctext = fileResponse;
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + fileType + "-Rechnung (text):\n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
                    if (!localTest) {
                        FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "deleting downloaded transactions-file ...");
                        FileSysUtils.forceDeleteTarget(downloadedFile);
                    }
                    csvTransData = doctext;
                }
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 25);
            boolean localPDFTest = false;
            if (isCreditcard.booleanValue()) {
                currentURL = seleniumWebDriver.getCurrentUrl();
                currentURLmain = currentURL.substring(0, currentURL.lastIndexOf("#/") + 2);
                String postboxURL = currentURLmain + "postbox";
                try {
                    seleniumWebDriver.get(postboxURL);
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "postboxPage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "postboxButton", "//button[contains(.,'Kreditkartendokumente')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                pdfsTransData = "Gesammelte Transaktionen von Rechnung(en) f\u00fcr eine Karte der Santander Consumer Bank AG\n\n\nKartennummer:;" + unterkonto + "\nDatum des Auszugs:;" + new Date() + "\nKontostand:;" + amount + "\nVerf\u00fcgbarer Betrag:;" + availableAmount + "\n\n" + transDataHeader;
                String nextBillToReadAsText = "";
                int billDateCount = 0;
                LocalDateTime dateNow = LocalDateTime.now();
                int billYear = dateNow.getYear();
                int currentMonth = dateNow.getMonthValue();
                try {
                    boolean haveNextSite = false;
                    block86: do {
                        String billLinksPath;
                        boolean haveNextPDFs = false;
                        try {
                            billLinksPath = "//span[contains(.,'xxxx xxxx xx" + unterkonto.substring(10, 12) + " " + unterkonto.substring(12, 16) + "')]";
                        }
                        catch (Exception error1) {
                            throw new Exception("Kreditkartennummer konnte nicht gelesen werden. Falsche L\u00e4nge. Pr\u00e4fen Sie die Einstellungen");
                        }
                        List billLinks = null;
                        List billDates = null;
                        int billRound = 0;
                        try {
                            if (seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Es sind keine ')]")) != null) {
                                pdfsTransData = pdfsTransData + "\nIm Abrufzeitraum sind keine PDF-Abrechnungen vorhanden";
                            }
                        }
                        catch (Exception waiterror) {
                            haveNextPDFs = true;
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] xpath //p[contains(.,'Es sind keine ')] NICHT gefunden; Es sollten PDF-Abrechnungen vorhanden sein ...");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] Lese alle Rechnungs-Links um Anzahl zu erhalten ...");
                            billLinks = seleniumWebDriver.findElements(By.xpath((String)billLinksPath));
                            SeleniumUtils.showFormatedListOfAllWebElementsInLog(seleniumWebDriver, billLinksPath, externalLogger);
                            MonitorLog.invoke((Object)MonitorLog, "Es werden alle notwendigen PDF-Abrechnungen abgerufen ... bitte warten ...");
                            if (billLinks.size() == 0) {
                                haveNextPDFs = false;
                                LogWarn.invoke((Object)LogWarn, "[WebSync:Santander] Die Liste der Links zu den Abrechnungen hat aber keine Eintr\u00e4ge, daher kein weiterer Abruf (eventuell Linkaufbau neu?) ...");
                                break;
                            }
                            String billDatesPath = "//div[contains(@class,'DateWrapper__wrapper') and contains(.,'xxxx xxxx xx" + unterkonto.substring(10, 12) + " " + unterkonto.substring(12, 16) + "')]//p[contains(@class,'DateWrapper__')]";
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] Lese alle Datumsangaben der Rechnungen gesondert, da diese nicht im Rechnungsnamen angegeben sind; Anzahl muss gleich sein ...");
                            billDates = seleniumWebDriver.findElements(By.xpath((String)billDatesPath));
                            SeleniumUtils.showFormatedListOfAllWebElementsInLog(seleniumWebDriver, billDatesPath, externalLogger);
                        }
                        while (haveNextPDFs) {
                            int blockCount;
                            int endIdxCard;
                            int startIdxCard;
                            double MonitorPercent = 30.0 + 34.0 / (double)billLinks.size() * (double)(billRound + 1);
                            MonitorSetPercent.invoke((Object)MonitorSetPercent, (int)MonitorPercent);
                            File downloadedBill = null;
                            String fileType = "";
                            if (localPDFTest) {
                                haveNextPDFs = true;
                                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.pdf";
                                downloadedBill = new File(docFixTempFilePath);
                            } else {
                                String billDateText = ((WebElement)billDates.get(billRound)).getText().replaceAll("\\s+", "").trim();
                                nextBillToReadAsText = ((WebElement)billLinks.get(billRound)).getText();
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Datum der letzten aktuellen Transaktion: " + lastTransDateString);
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Datum der Rechnung (Kreditkartenabrechnung) aus Listeneintrag die nun verarbeitet wird: " + billDateText + " [" + nextBillToReadAsText + "]");
                                int billMonth = 999;
                                if (billDateText.startsWith("Jan")) {
                                    billMonth = 1;
                                } else if (billDateText.startsWith("Feb")) {
                                    billMonth = 2;
                                } else if (billDateText.startsWith("Mar")) {
                                    billMonth = 3;
                                } else if (billDateText.startsWith("Apr")) {
                                    billMonth = 4;
                                } else if (billDateText.startsWith("Mai")) {
                                    billMonth = 5;
                                } else if (billDateText.startsWith("Jun")) {
                                    billMonth = 6;
                                } else if (billDateText.startsWith("Jul")) {
                                    billMonth = 7;
                                } else if (billDateText.startsWith("Aug")) {
                                    billMonth = 8;
                                } else if (billDateText.startsWith("Sep")) {
                                    billMonth = 9;
                                } else if (billDateText.startsWith("Okt")) {
                                    billMonth = 10;
                                } else if (billDateText.startsWith("Nov")) {
                                    billMonth = 11;
                                } else if (billDateText.startsWith("Dez")) {
                                    billMonth = 12;
                                }
                                if (billDateCount > 0 && billMonth == 12 || billDateCount == 0 && billMonth == 12 && currentMonth == 1) {
                                    --billYear;
                                }
                                int billDay = Integer.valueOf(billDateText.substring(3));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Datum der Rechnung (Kreditkartenabrechnung) laut dem soeben manuell hinzugef\u00fcgtem Jahr: " + billDay + "." + billMonth + "." + billYear);
                                Date billDate = SysUtils.getDate(billYear, billMonth - 1, billDay);
                                ++billDateCount;
                                String[] lastTransDateStringArray = lastTransDateString.split("\\.");
                                Date lastTransDate = SysUtils.getDate(Integer.parseInt(lastTransDateStringArray[2], 10), Integer.parseInt(lastTransDateStringArray[1], 10) - 1, Integer.parseInt(lastTransDateStringArray[0], 10));
                                Date fromDate = new SimpleDateFormat("dd.MM.yyyy").parse(fromDateSimple);
                                if (billDate.getTime() < fromDate.getTime() && !localPDFTest) {
                                    LogDebug.invoke((Object)LogDebug, "billDateText=" + billDay + "." + billMonth + "." + billYear + "(" + billDateText + ");fromDateSimple=" + fromDateSimple + " --- billdate '" + String.valueOf(billDate.getTime()) + "' soll nun kleiner sein als fromDate: '" + String.valueOf(fromDate.getTime()));
                                    LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] Rechnung (" + ((WebElement)billLinks.get(billRound)).getText() + " vom billDateText=" + billDay + "." + billMonth + "." + billYear + "(" + billDateText + ")) liegt au\u00dferhalb des Abrufdatum ... daher kein weiterer Abruf mehr");
                                    haveNextPDFs = false;
                                    haveNextSite = false;
                                    continue block86;
                                }
                                if (billDate.getTime() > lastTransDate.getTime()) {
                                    LogDebug.invoke((Object)LogDebug, "billDateText=billDateText=" + billDay + "." + billMonth + "." + billYear + "(" + billDateText + "); lastTransDateString=" + lastTransDateString + " --- billdate '" + String.valueOf(billDate.getTime()) + "' soll nun gr\u00f6\u00dfer sein als lastTransDate: '" + String.valueOf(lastTransDate.getTime()));
                                    LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] Rechnung (" + ((WebElement)billLinks.get(billRound)).getText() + "vom billDateText=" + billDay + "." + billMonth + "." + billYear + "(" + billDateText + ")) liegt innerhalb des Abrufbereich der neuesten Transaktionen... daher wird diese ausgelassen");
                                    if (billRound < billLinks.size() - 1 || localPDFTest) {
                                        ++billRound;
                                        continue;
                                    }
                                    haveNextPDFs = false;
                                    continue block86;
                                }
                            }
                            boolean downloadedFileIsFalse = false;
                            int downloadCount = 1;
                            do {
                                if (!localPDFTest) {
                                    try {
                                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                        ((WebElement)billLinks.get(billRound)).click();
                                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                    }
                                    catch (Exception error) {
                                        isSelfException = true;
                                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                    }
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Warte auf die Fertigstellung des Downloads einer Abrechnung ...");
                                    do {
                                        Thread.sleep(500L);
                                        int waiter = 0;
                                        do {
                                            if ((downloadedBill = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                            Thread.sleep(1000L);
                                            ++waiter;
                                        } while (downloadedBill == null && waiter < 30);
                                        if (downloadedBill != null && downloadedBill.exists()) continue;
                                        if (downloadCount < 4) {
                                            try {
                                                ((WebElement)billLinks.get(billRound)).click();
                                                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                                                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                            }
                                            catch (Exception error) {
                                                isSelfException = true;
                                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                            }
                                            ++downloadCount;
                                            Thread.sleep(500L);
                                            waiter = 0;
                                            downloadedBill = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"));
                                            continue;
                                        }
                                        isSelfException = true;
                                        throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                                    } while (downloadedBill.getAbsolutePath().endsWith(".crdownload"));
                                }
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "downloaded file: " + downloadedBill.getAbsolutePath());
                                fileType = downloadedBill.getName().substring(downloadedBill.getAbsolutePath().lastIndexOf("\\.") + 1).toUpperCase();
                                if (fileType.toLowerCase().equals("txt") || fileType.toLowerCase().equals("htm") || fileType.toLowerCase().equals("html") || fileType.toLowerCase().equals("asp") || fileType.toLowerCase().equals("js")) {
                                    LogWarn.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "wrong downloaded file: " + downloadedBill.getAbsolutePath() + " / Falscher Dateityp, versuche es nochmals ...");
                                    ++downloadCount;
                                    downloadedFileIsFalse = true;
                                } else {
                                    downloadedFileIsFalse = false;
                                }
                                if (downloadCount < 4) continue;
                                isSelfException = true;
                                throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                            } while (downloadedFileIsFalse);
                            MemoryUsageSetting memUsageSetting = MemoryUsageSetting.setupTempFileOnly();
                            PDDocument pdf = Loader.loadPDF((File)downloadedBill);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "[PDDocument.load FILE]: " + pdf);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Erzeuge einen Kontoauszug-StreamDump aus PDF ...");
                            String pdfContentDump = "";
                            try {
                                int pageIndex = pdf.getNumberOfPages();
                                for (int page = 0; page < pageIndex; ++page) {
                                    InputStream contents = pdf.getPage(page).getContents();
                                    BufferedReader buffer = new BufferedReader(new InputStreamReader(contents));
                                    pdfContentDump = pdfContentDump + "####### Page Nr.: " + String.valueOf(page + 1) + " #######\n\n" + buffer.lines().collect(Collectors.joining("\n")) + "\n\n\n\n\n";
                                    contents.close();
                                }
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("Beim Lesen der PDF hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            int billDateIdxStart = pdfContentDump.indexOf("[(Rechnungsdatum)]TJ") + 3;
                            billDateIdxStart = pdfContentDump.indexOf("[(", billDateIdxStart) + 2;
                            int billDateIdxEnd = pdfContentDump.indexOf(")]TJ", billDateIdxStart);
                            String billDateText = pdfContentDump.substring(billDateIdxStart, billDateIdxEnd).replace(")-12(", "");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Rechnungsdatum dieser PDF-Rechnung (billDateText): " + billDateText);
                            long billDate = new SimpleDateFormat("dd.MM.yyyy").parse(billDateText).getTime();
                            long fromDate = new SimpleDateFormat("dd.MM.yyyy").parse(fromDateSimple).getTime();
                            if (billDate < fromDate) {
                                LogDebug.invoke((Object)LogDebug, "BillDateText=" + billDateText + ";fromDateSimple=" + fromDateSimple + " - Billdate '" + String.valueOf(billDate) + "' soll nun kleiner sein als fromDate: '" + String.valueOf(fromDate));
                                LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] Rechnung (Konto\u00fcbersicht) liegt au\u00dferhalb des Abrufdatum ... daher kein weiterer Abruf mehr");
                                continue block86;
                            }
                            String footerString = "(NEUER)-269(SALDO)-269(IN)-269(EURO)";
                            int contentDumpIdxStart = pdfContentDump.indexOf("SALDOVORTRAG") - 2;
                            int contentDumpIdxEnd = pdfContentDump.indexOf(footerString);
                            if (contentDumpIdxEnd <= -1) {
                                footerString = "(NEUER SALDO IN EURO)";
                                contentDumpIdxEnd = pdfContentDump.indexOf(footerString);
                            }
                            if (contentDumpIdxEnd <= -1) {
                                isSelfException = true;
                                throw new Exception("Dump-Ende konnte nicht gefunden werden! (" + contentDumpIdxEnd + "); Bitte dem Entwickler im Forum melden");
                            }
                            contentDumpIdxEnd = pdfContentDump.indexOf("ET", contentDumpIdxEnd);
                            String contentDump = pdfContentDump.substring(contentDumpIdxStart, contentDumpIdxEnd);
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "getDataExportByDump: soeben abgeholte und per Dump-Parser geladene PDF-Rechnung (pdfContentDump): \n" + contentDump);
                            while (contentDump.contains("[(VISA")) {
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "contentDump - Datenzeile von Visa-Kreditkarte gefunden und wird entfernt ...");
                                startIdxCard = contentDump.indexOf("[(VISA") - 1;
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "contentDump - startIdxCard: " + String.valueOf(startIdxCard));
                                endIdxCard = contentDump.indexOf(" Td", startIdxCard) + 3;
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "contentDump - endIdxCard: " + String.valueOf(endIdxCard));
                                contentDump = contentDump.substring(0, startIdxCard) + contentDump.substring(endIdxCard);
                            }
                            while (contentDump.contains("[(MASTERCARD")) {
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "contentDump - Datenzeile von Mastercard-Kreditkarte gefunden und wird entfernt ...");
                                startIdxCard = contentDump.indexOf("[(MASTERCARD") - 1;
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "contentDump - startIdxCard: " + String.valueOf(startIdxCard));
                                endIdxCard = contentDump.indexOf(" Td", startIdxCard) + 3;
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "contentDump - endIdxCard: " + String.valueOf(endIdxCard));
                                contentDump = contentDump.substring(0, startIdxCard) + contentDump.substring(endIdxCard);
                            }
                            int blockCountLog = blockCount = contentDump.split("6\\.3749 |6\\.375 ").length - 1;
                            String hasZinsLogText = "";
                            if (contentDump.contains("[(FINANZIERUNGSGEB\\334HR)]TJ") || contentDump.contains("[(FINANZIERUNGSGEB\u00dcHR)]TJ")) {
                                ++blockCountLog;
                                hasZinsLogText = " (inkl. Zinsumsatz)";
                            }
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Anzahl der in dieser PDF enhaltenen Umsatz-Bl\u00f6cke: " + String.valueOf(blockCountLog) + hasZinsLogText);
                            String[] blocks = new String[blockCount];
                            int actPos = 0;
                            for (int find = 0; find < blockCount; ++find) {
                                String dateBlock;
                                String valutaBlock;
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "####### Data-Block #" + find + " Begin #######");
                                int blockIdxStart = contentDump.indexOf("6.37", actPos);
                                String checkStart = contentDump.substring(blockIdxStart, blockIdxStart + 7);
                                if (!checkStart.contains("6.3749 ") && !checkStart.contains("6.375 ")) {
                                    blockIdxStart = contentDump.indexOf("6.37", blockIdxStart + 7);
                                }
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - blockIdxStart: " + String.valueOf(blockIdxStart));
                                blockIdxStart = contentDump.lastIndexOf("[(", blockIdxStart);
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - blockIdxStart: " + String.valueOf(blockIdxStart));
                                int blockIdxEnd = contentDump.indexOf("6.37", blockIdxStart) + 6;
                                String checkEnd = contentDump.substring(blockIdxEnd, blockIdxEnd + 7);
                                if (!checkEnd.contains("6.3749 ") && !checkEnd.contains("6.375 ")) {
                                    blockIdxEnd = contentDump.indexOf("6.37", blockIdxEnd + 7);
                                }
                                if (find + 1 == blockCount) {
                                    blockIdxEnd = contentDump.indexOf(footerString, blockIdxEnd);
                                } else {
                                    checkEnd = contentDump.substring(blockIdxEnd = contentDump.indexOf("6.37", blockIdxEnd), blockIdxEnd + 7);
                                    if (!checkEnd.contains("6.3749 ") && !checkEnd.contains("6.375 ")) {
                                        blockIdxEnd = contentDump.indexOf("6.37", blockIdxEnd + 7);
                                    }
                                }
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - blockIdxEnd: " + String.valueOf(blockIdxEnd));
                                blockIdxEnd = contentDump.lastIndexOf(" Td", blockIdxEnd) + 3;
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - blockIdxEnd: " + String.valueOf(blockIdxEnd));
                                blocks[find] = contentDump.substring(blockIdxStart, blockIdxEnd);
                                actPos = blockIdxEnd;
                                if (blocks[find].contains("[(ZWISCHENSUMME)]TJ")) {
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Transactionblock #" + String.valueOf(find) + " >> Dump-Block RAW before cut:\n" + blocks[find]);
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " Zwischensumme vorhanden, daher Ausschneiden dieser Daten-Zeilen ...");
                                    int endIdxCut = blocks[find].indexOf("[(ZWISCHENSUMME)]TJ") - 1;
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - startIdxCut: " + String.valueOf(endIdxCut));
                                    blocks[find] = blocks[find].substring(0, endIdxCut);
                                }
                                if (blocks[find].contains("[(S)-21(A)-72(L)-14(D)-53(O)-89(\\334)-90(B)-38(E)-39(R)-19(T)-58(R)-19(A)-72(G)]TJ")) {
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " Seitenwechsel vorhanden, daher Ausschneiden des Seitenheaders ...");
                                    int startIdxCut = blocks[find].indexOf("[(S)-21(A)-72(L)-14(D)-53(O)-89(\\334)-90(B)-38(E)-39(R)-19(T)-58(R)-19(A)-72(G)]TJ") - 1;
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - startIdxCut: " + String.valueOf(startIdxCut));
                                    int endIdxCut = blocks[find].indexOf("[(S)-21(A)-72(L)-14(D)-53(O)-89(\\334)-90(B)-38(E)-39(R)-19(T)-58(R)-19(A)-72(G)]TJ", startIdxCut + 80);
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - endIdxCut: " + String.valueOf(endIdxCut));
                                    endIdxCut = blocks[find].indexOf(" Td", endIdxCut) + 3;
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - endIdxCut: " + String.valueOf(endIdxCut));
                                    endIdxCut = blocks[find].indexOf(" Td", endIdxCut) + 3;
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - endIdxCut: " + String.valueOf(endIdxCut));
                                    int endIdxCutHabenCheck = blocks[find].indexOf(" Td", endIdxCut) + 3;
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - endIdxCutHabenCheck: " + String.valueOf(endIdxCutHabenCheck));
                                    if (endIdxCutHabenCheck > endIdxCut && blocks[find].substring(endIdxCut, endIdxCutHabenCheck).contains("[(H)]TJ")) {
                                        endIdxCut = endIdxCutHabenCheck;
                                    }
                                    blocks[find] = blocks[find].substring(0, startIdxCut) + blocks[find].substring(endIdxCut);
                                }
                                boolean hasZins = false;
                                String zinsBetragText = "";
                                if (blocks[find].contains("[(FINANZIERUNGSGEB\\334HR)]TJ") || blocks[find].contains("[(FINANZIERUNGSGEB\u00dcHR)]TJ")) {
                                    hasZins = true;
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " Zinsen alias Finanzierungsgeb\u00fchr vorhanden, daher auslassen der letzten Datenzeilen mit dieser und merken des Betrags ...");
                                    int startIdxCut = blocks[find].indexOf("[(FINANZIERUNGSGEB\\334HR)]TJ") - 1;
                                    if (startIdxCut <= -1) {
                                        startIdxCut = blocks[find].indexOf("[(FINANZIERUNGSGEB\u00dcHR)]TJ") - 1;
                                    }
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Data-Block #" + find + " - startIdxCut: " + String.valueOf(startIdxCut));
                                    int zinsBetragIdxStart = blocks[find].indexOf("[(", startIdxCut + 29) + 2;
                                    int zinsBetragIdxEnd = blocks[find].indexOf(")]TJ", zinsBetragIdxStart);
                                    String zinsBetragBlock = blocks[find].substring(zinsBetragIdxStart, zinsBetragIdxEnd);
                                    if (StringCharUtils.isNullOrEmptyOrNothing(zinsBetragBlock)) {
                                        isSelfException = true;
                                        throw new Exception("Dump-Snippet 'Zinsen' konnte nicht ausgelesen werden! (NULL); Bitte dem Entwickler im Forum melden");
                                    }
                                    zinsBetragBlock = StringCharUtils.shrinkString(zinsBetragBlock);
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Parser found interest in Transactionblock #" + String.valueOf(find) + " zinsBetragBlock: " + zinsBetragBlock);
                                    zinsBetragText = "-" + zinsBetragBlock;
                                    blocks[find] = blocks[find].substring(0, startIdxCut);
                                }
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Transactionblock #" + String.valueOf(find) + " Dump-Block:\n" + blocks[find]);
                                boolean isAuslandsumsatz = false;
                                String[] rowArray = blocks[find].split("\\[\\(");
                                int rowCount = rowArray.length - 1;
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Transactionblock #" + String.valueOf(find) + " enth\u00e4lt '" + rowCount + "' Datenzeilen");
                                if (WebUtils.getCurrencys().parallelStream().anyMatch(new String("[(" + blocks[find] + ")")::contains)) {
                                    isAuslandsumsatz = true;
                                }
                                if (isAuslandsumsatz) {
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "und wurde als Auslandsumsatz eingestuft");
                                }
                                boolean isHabenUmsatz = false;
                                if (blocks[find].contains("[(H)]TJ")) {
                                    isHabenUmsatz = true;
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "und dies ist ein positiver HABEN-Umsatz");
                                }
                                if (StringCharUtils.isNullOrEmptyOrNothing(valutaBlock = blocks[find].substring(2, 6))) {
                                    isSelfException = true;
                                    throw new Exception("Dump-Snippet 'Buchungsdatum(Valuta)' konnte nicht gefunden werden! (NULL); Bitte dem Entwickler im Forum melden");
                                }
                                valutaBlock = StringCharUtils.shrinkString(valutaBlock);
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Parser found in Transactionblock #" + String.valueOf(find) + " valutaBlock: " + valutaBlock);
                                String valutaTagText = valutaBlock.substring(0, 2);
                                String valutaMonatText = valutaBlock.substring(2, 4);
                                String valutaJahrText = null;
                                String billMonthText = billDateText.substring(3, 5);
                                String billYearText = billDateText.substring(6, 10);
                                String yearBevoreBill = String.valueOf(Integer.parseInt(billYearText) - 1);
                                valutaJahrText = Integer.valueOf(valutaMonatText) > 7 && Integer.valueOf(billMonthText) < 3 ? yearBevoreBill : billYearText;
                                String valutaText = valutaTagText + "." + valutaMonatText + "." + valutaJahrText;
                                int purp1BlockIdxStart = blocks[find].indexOf("[(", 8) + 2;
                                int purp1blockIdxEnd = blocks[find].indexOf(")]TJ", purp1BlockIdxStart);
                                String purp1Block = blocks[find].substring(purp1BlockIdxStart, purp1blockIdxEnd);
                                purp1Block = purp1Block.replaceAll("\\)\\-\\d{3}\\(", " ");
                                String purp1Text = purp1Block.replace(";", ",").trim();
                                int nextStep = blocks[find].indexOf("[(", purp1blockIdxEnd) + 2;
                                if (isAuslandsumsatz && rowCount == 7 && !isHabenUmsatz) {
                                    purp1BlockIdxStart = blocks[find].indexOf("[(", purp1blockIdxEnd + 4) + 2;
                                    purp1blockIdxEnd = blocks[find].indexOf(")]TJ", purp1BlockIdxStart);
                                    purp1Block = blocks[find].substring(purp1BlockIdxStart, purp1blockIdxEnd);
                                    purp1Block = purp1Block.replaceAll("\\)\\-\\d{3}\\(", " ");
                                    purp1Text = purp1Text + " " + purp1Block.replace(";", ",").trim();
                                    nextStep = blocks[find].indexOf("[(", purp1blockIdxEnd) + 2;
                                }
                                if (StringCharUtils.isNullOrEmptyOrNothing(purp1Text)) {
                                    isSelfException = true;
                                    throw new Exception("Dump-Snippet 'Einreicher/Unternehmen/Verwendungszweck1' konnte nicht gefunden werden! (NULL); Bitte dem Entwickler im Forum melden");
                                }
                                purp1Block = StringCharUtils.shrinkString(purp1Text);
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Parser found in Transactionblock #" + String.valueOf(find) + " purp1Block: " + purp1Text);
                                purp1Text = StringCharUtils.OctaltoChar(purp1Text);
                                String purp2Text = "";
                                if (blocks[find].contains("29.668") || isAuslandsumsatz || rowCount == 6 && !isHabenUmsatz && !isAuslandsumsatz) {
                                    int purp2blockIdxEnd = blocks[find].indexOf(")]TJ", nextStep);
                                    String purp2Block = blocks[find].substring(nextStep, purp2blockIdxEnd);
                                    purp2Block = purp2Block.replaceAll("\\)\\-\\d{3}\\(", " ");
                                    purp2Text = purp2Block.replace(";", ",").trim();
                                    nextStep = blocks[find].indexOf("[(", purp2blockIdxEnd) + 2;
                                    if (rowCount == 6 && !isHabenUmsatz && !isAuslandsumsatz) {
                                        int purp2BlockIdxStart = blocks[find].indexOf("[(", purp2blockIdxEnd + 4) + 2;
                                        purp2blockIdxEnd = blocks[find].indexOf(")]TJ", purp2BlockIdxStart);
                                        purp2Block = blocks[find].substring(purp2BlockIdxStart, purp2blockIdxEnd);
                                        purp2Block = purp2Block.replaceAll("\\)\\-\\d{3}\\(", " ");
                                        purp2Text = purp2Text + " " + purp2Block.replace(";", ",").trim();
                                        nextStep = blocks[find].indexOf("[(", purp2blockIdxEnd) + 2;
                                    }
                                    if (StringCharUtils.isNullOrEmptyOrNothing(purp2Text)) {
                                        isSelfException = true;
                                        throw new Exception("Dump-Snippet 'Ort/Verwendungszweck2' konnte nicht gefunden werden! (NULL); Bitte dem Entwickler im Forum melden");
                                    }
                                    purp2Block = StringCharUtils.shrinkString(purp2Text);
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Parser found in Transactionblock #" + String.valueOf(find) + " purp2Block: " + purp2Text);
                                    purp2Text = StringCharUtils.OctaltoChar(purp2Text);
                                }
                                String currencyText = "EUR";
                                String betragAusText = "";
                                String kursAusText = "";
                                if (isAuslandsumsatz) {
                                    int auslandsBlockEnd = blocks[find].indexOf(")]TJ", nextStep);
                                    if (rowCount == 6 || rowCount == 7) {
                                        String auslandsArrayString = blocks[find].substring(nextStep, auslandsBlockEnd).replace(")-269(", " ").replace(")-813(", " ");
                                        auslandsArrayString = auslandsArrayString.replaceAll("\\)\\-53\\d{1}\\(", " ");
                                        String[] auslandsArray = auslandsArrayString.split("\\)-6\\d{2}\\(");
                                        betragAusText = auslandsArray[0];
                                        kursAusText = auslandsArray[1];
                                    } else if (rowCount == 8) {
                                        String currencyAusText = blocks[find].substring(nextStep, auslandsBlockEnd);
                                        nextStep = blocks[find].indexOf("[(", auslandsBlockEnd) + 2;
                                        auslandsBlockEnd = blocks[find].indexOf(")]TJ", nextStep);
                                        betragAusText = currencyAusText + " " + blocks[find].substring(nextStep, auslandsBlockEnd);
                                        nextStep = blocks[find].indexOf("[(", auslandsBlockEnd) + 2;
                                        auslandsBlockEnd = blocks[find].indexOf(")]TJ", nextStep);
                                        kursAusText = blocks[find].substring(nextStep, auslandsBlockEnd);
                                    } else {
                                        isSelfException = true;
                                        throw new Exception("Aktueller Dump-Block scheint Auslandsumsatz zu sein hat aber falsche Anzahl Datenzeilen. Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe..");
                                    }
                                    if (StringCharUtils.isNullOrEmptyOrNothing(betragAusText)) {
                                        isSelfException = true;
                                        throw new Exception("Dump-Snippet 'Ausl. Betrag' konnte nicht gefunden werden! (NULL); Bitte dem Entwickler im Forum melden");
                                    }
                                    betragAusText = StringCharUtils.shrinkString(betragAusText);
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Parser found in Transactionblock #" + String.valueOf(find) + " betragAusText: " + betragAusText);
                                    if (StringCharUtils.isNullOrEmptyOrNothing(kursAusText)) {
                                        isSelfException = true;
                                        throw new Exception("Dump-Snippet 'Kurs' konnte nicht gefunden werden! (NULL); Bitte dem Entwickler im Forum melden");
                                    }
                                    kursAusText = StringCharUtils.shrinkString(kursAusText);
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Parser found in Transactionblock #" + String.valueOf(find) + " kursAusText: " + kursAusText);
                                    nextStep = blocks[find].indexOf("[(", auslandsBlockEnd) + 2;
                                }
                                if (StringCharUtils.isNullOrEmptyOrNothing(dateBlock = blocks[find].substring(nextStep, nextStep + 4))) {
                                    isSelfException = true;
                                    throw new Exception("Dump-Snippet 'Buchungsdatum(Valuta)' konnte nicht gefunden werden! (NULL); Bitte dem Entwickler im Forum melden");
                                }
                                dateBlock = StringCharUtils.shrinkString(dateBlock);
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Parser found in Transactionblock #" + String.valueOf(find) + " dateBlock: " + dateBlock);
                                String dateTagText = dateBlock.substring(0, 2);
                                String dateMonatText = dateBlock.substring(2, 4);
                                String dateJahrText = null;
                                dateJahrText = Integer.valueOf(dateMonatText) > 7 && Integer.valueOf(billMonthText) < 3 ? yearBevoreBill : billYearText;
                                String dateText = dateTagText + "." + dateMonatText + "." + dateJahrText;
                                nextStep = blocks[find].indexOf("[(", nextStep + 4) + 2;
                                String betragSaldo = "";
                                if (!isHabenUmsatz) {
                                    betragSaldo = "-";
                                } else {
                                    nextStep = blocks[find].indexOf("[(", nextStep + 2) + 2;
                                }
                                int betragblockIdxEnd = blocks[find].indexOf(")]TJ", nextStep);
                                String betragBlock = blocks[find].substring(nextStep, betragblockIdxEnd);
                                if (StringCharUtils.isNullOrEmptyOrNothing(betragBlock)) {
                                    isSelfException = true;
                                    throw new Exception("Dump-Snippet 'Einreicher' konnte nicht gefunden werden! (NULL); Bitte dem Entwickler im Forum melden");
                                }
                                betragBlock = StringCharUtils.shrinkString(betragBlock);
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Parser found in Transactionblock #" + String.valueOf(find) + " betragBlock: " + betragBlock);
                                String betragText = betragSaldo + betragBlock;
                                String umsatzartText = null;
                                umsatzartText = isAuslandsumsatz ? "Kauf Fremdw\u00e4hrung" : (betragSaldo.equals("-") ? "Kauf EURO" : "Gutschrift/Einzahlung/Zahlung Lastschrift");
                                pdfsTransData = pdfsTransData + dateText + ";" + valutaText + ";" + betragText + ";;" + purp1Text + " " + purp2Text + ";" + betragAusText + ";" + currencyText + ";" + kursAusText + ";" + umsatzartText + "\n";
                                ++transCount;
                                if (hasZins) {
                                    dateText = billDateText;
                                    valutaText = billDateText;
                                    umsatzartText = "Zinsen/Finanzierungsgeb\u00fchr";
                                    purp1Text = "Finanzierungsgeb\u00fchr";
                                    purp2Text = "";
                                    betragText = zinsBetragText;
                                    currencyText = "EUR";
                                    betragAusText = "";
                                    kursAusText = "";
                                    pdfsTransData = pdfsTransData + dateText + ";" + valutaText + ";" + betragText + ";;" + purp1Text + " " + purp2Text + ";" + betragAusText + ";" + currencyText + ";" + kursAusText + ";" + umsatzartText + "\n";
                                    ++transCount;
                                }
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "####### Data-Block #" + find + " END #######");
                            }
                            pdf.close();
                            if (!localPDFTest) {
                                FileUtils.copyFileToDirectory((File)downloadedBill, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "deleting downloaded pdf-bill file ...");
                                FileSysUtils.forceDeleteTarget(downloadedBill);
                            }
                            if (localPDFTest) continue block86;
                            if (billRound >= billLinks.size() - 1 || localPDFTest) {
                                haveNextPDFs = false;
                                try {
                                    if (seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'kkb-postbox-list__paging')]")) != null) {
                                        String pagePosition = seleniumWebDriver.findElement(By.xpath((String)"//span[contains(@class,'kkb-postbox-list__position')]")).getText();
                                        LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "currentPagePosition: " + pagePosition);
                                        if (!pagePosition.substring(0, 1).equals(pagePosition.substring(pagePosition.length() - 1))) {
                                            haveNextSite = true;
                                            try {
                                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "nextPageButton", "//*[@id='general/arrow-right']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                                continue;
                                            }
                                            catch (Exception error) {
                                                isSelfException = true;
                                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                            }
                                        }
                                        haveNextSite = false;
                                        continue;
                                    }
                                    haveNextSite = false;
                                }
                                catch (NoSuchElementException finderror) {
                                    haveNextSite = false;
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] xpath //div[contains(@class,'kkb-postbox-list__paging')] NICHT gefunden; Es sollten keine weiteren Seiten vorhanden sein");
                                }
                                continue;
                            }
                            ++billRound;
                        }
                    } while (haveNextSite);
                }
                catch (IOException ioerror) {
                    LogWarn.invoke((Object)LogWarn, "[WebSync:Santander] " + getLogMethod + nextBillToReadAsText + " konnte nicht gelesen werden! Bitte im Onlinebanking den Zugriff pr\u00fcfen (IOException: Error: End-of-File)! Der PDF-Abruf wird daher hier beendet!");
                    MonitorLog.invoke((Object)MonitorLog, "Fehler-Warnung!: " + nextBillToReadAsText + " konnte nicht gelesen werden! Bitte im Onlinebanking den Zugriff pr\u00fcfen (IOException: Error: End-of-File)! Der PDF-Abruf wird daher hier beendet!");
                }
            }
            apiTransData = transDataHeader + StringEscapeUtils.unescapeHtml4((String)apiTransData);
            csvTransData = StringEscapeUtils.unescapeHtml4((String)csvTransData);
            pdfsTransData = StringEscapeUtils.unescapeHtml4((String)pdfsTransData);
            if (localPDFTest) {
                transactionsData = pdfsTransData;
            } else {
                transactionsData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Santander Consumer Bank AG\n\n\nDatum des Auszugs:;" + new Date() + "\nZeitraum:;" + fromDateSimple + " bis " + toDateSimple + "\nAnzahl der Transaktionen:;" + transCount + "\nKontostand:;" + amount + "\n\n";
                transactionsData = isCreditcard != false ? transactionsData + apiTransData + "\n\n\n" + pdfsTransData : transactionsData + csvTransData.substring(csvTransData.indexOf("Buchungsdatum;Wertstellung;Betrag"));
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 65);
            LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "TransData: \n\n====================== BEGIN DATA ======================\n" + transactionsData + "\n======================= END DATA =======================\n");
            if (transactionsData.contains("<html") || transactionsData.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen.");
            }
            String[] dataResponse = new String[]{transactionsData, Double.toString(amount)};
            String[][] dataResponseMatrixArray = null;
            dataResponseMatrixArray = StringCharUtils.data2matrixArray(transactionsData.replace("\"", ""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < dataResponseMatrixArray.length; ++i) {
                if (dataResponseMatrixArray[i] == null || StringCharUtils.isNullOrEmptyOrNothing(dataResponseMatrixArray[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = dataResponseMatrixArray[i][0].trim().split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] dataResponseMatrixArray[" + i + "]: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = dataResponseMatrixArray[i][0].trim().substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = dataResponseMatrixArray[i][1].trim().substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(dataResponseMatrixArray[i][2], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    double saldo = Double.NaN;
                    try {
                        saldo = Double.parseDouble(StringCharUtils.parseAndFormatAmount(dataResponseMatrixArray[i][3], externalLogger));
                    }
                    catch (NumberFormatException noSaldo) {
                        saldo = 0.0;
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(saldo);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    String originalPurpText = dataResponseMatrixArray[i][4];
                    String shrinkedPurpText = StringCharUtils.shrinkString(originalPurpText).replace(" IBAN ", " IBAN+").replace(" BIC ", " BIC+").replace("SVWZ +", "SVWZ+").replace("SVWZ+ ", "SVWZ+").replace("EREF +", "EREF+").replace("EREF+ ", "EREF+").replace("KREF +", "KREF+").replace("KREF+ ", "KREF+").replace("CREF +", "KREF+").replace("CREF+ ", "KREF+").replace("MREF +", "MREF+").replace("MREF+ ", "MREF+").replace("CRED+ ", "CRED+").replace("CRED +", "CRED+");
                    String umsatzart = "";
                    if (isCreditcard.booleanValue()) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(dataResponseMatrixArray[i][8]));
                    } else {
                        umsatzart = shrinkedPurpText.startsWith("\u00dcBERWEISUNG") ? "\u00dcBERWEISUNG" : (shrinkedPurpText.startsWith("ECHTZEIT-\u00dcBERWEISUNG") ? "ECHTZEIT-\u00dcBERWEISUNG" : (shrinkedPurpText.startsWith("TERMIN-\u00dcBERWEISUNG") ? "TERMIN-\u00dcBERWEISUNG" : (shrinkedPurpText.startsWith("TERMIN\u00dcBERWEISUNG") ? "TERMIN\u00dcBERWEISUNG" : (shrinkedPurpText.startsWith("ECHTZEIT-\u00dcBERWEISUNG") ? "ECHTZEIT-\u00dcBERWEISUNG" : (shrinkedPurpText.startsWith("SEPA-LASTSCHRIFT") ? "SEPA-LASTSCHRIFT" : (shrinkedPurpText.startsWith("LASTSCHRIFT") ? "LASTSCHRIFT" : (shrinkedPurpText.startsWith("DAUERAUFTRAG") ? "DAUERAUFTRAG" : (shrinkedPurpText.startsWith("SEPA-DAUERAUFTRAG") ? "SEPA-DAUERAUFTRAG" : (shrinkedPurpText.contains("Zins") ? "Zinszahlung" : (shrinkedPurpText.contains("zinsen") ? "Zinszahlung" : (shrinkedPurpText.contains("BONUS") ? "Bonuszahlung" : (!String.valueOf(betrag).contains("-") ? "Zahlung / \u00dcberweisung" : "Abrechnung"))))))))))));
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(umsatzart);
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(shrinkedPurpText)) {
                        String finalPurpText = shrinkedPurpText;
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(finalPurpText.replaceAll("\\<.*?\\>", "")).trim());
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String transactionid = "";
                    String gegenkontoName = "";
                    String gegenkontoNummer = "";
                    String gegenkontoBLZ = "";
                    String gegenkontoIBAN = "";
                    String gegenkontoBIC = "";
                    if (shrinkedPurpText.contains("\u00dcBERWEISUNG AN ") || shrinkedPurpText.contains("\u00dcBERWEISUNG VON ") || shrinkedPurpText.contains("LASTSCHRIFT VON ") || shrinkedPurpText.contains("LASTSCHRIFT AN ") || shrinkedPurpText.contains("DAUERAUFTRAG VON ") || shrinkedPurpText.contains("DAUERAUFTRAG AN ")) {
                        int gegenkontoNameIDXstart = 0;
                        if (shrinkedPurpText.contains("\u00dcBERWEISUNG ")) {
                            gegenkontoNameIDXstart = shrinkedPurpText.indexOf("\u00dcBERWEISUNG ") + 12;
                        } else if (shrinkedPurpText.contains("LASTSCHRIFT ")) {
                            gegenkontoNameIDXstart = shrinkedPurpText.indexOf("LASTSCHRIFT ") + 12;
                        } else if (shrinkedPurpText.contains("DAUERAUFTRAG ")) {
                            gegenkontoNameIDXstart = shrinkedPurpText.indexOf("DAUERAUFTRAG ") + 13;
                        }
                        gegenkontoNameIDXstart = shrinkedPurpText.indexOf(" ", gegenkontoNameIDXstart) + 1;
                        gegenkontoName = shrinkedPurpText.contains(" IBAN+") ? StringCharUtils.shrinkString(shrinkedPurpText.substring(gegenkontoNameIDXstart, shrinkedPurpText.indexOf(" IBAN+"))) : StringCharUtils.shrinkString(shrinkedPurpText.substring(gegenkontoNameIDXstart));
                        if (gegenkontoName.lastIndexOf(" ") == gegenkontoName.length() - 19) {
                            transactionid = StringCharUtils.shrinkString(gegenkontoName.substring(gegenkontoName.lastIndexOf(" ") + 1));
                            gegenkontoName = StringCharUtils.shrinkString(gegenkontoName.substring(0, gegenkontoName.lastIndexOf(" ")));
                        }
                    }
                    if (shrinkedPurpText.contains(" IBAN+")) {
                        gegenkontoIBAN = StringCharUtils.shrinkString(StringCharUtils.getSubString(shrinkedPurpText, shrinkedPurpText.indexOf(" IBAN+") + 6, shrinkedPurpText.indexOf(" ", shrinkedPurpText.indexOf(" IBAN+") + 6)).replace(" ", ""));
                        IBAN ibanObject = null;
                        try {
                            ibanObject = new IBAN(gegenkontoIBAN);
                        }
                        catch (SEPAException error) {
                            gegenkontoNummer = gegenkontoIBAN;
                            LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "new IBAN error (set iban as useraccount-nr): " + error.getMessage());
                        }
                        if (ibanObject != null) {
                            SEPALand land = ibanObject.getLand();
                            if (land.getBankIdentifierLength() == null) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] length of bank identifier unknown for this country, set iban as useraccount-nr");
                                gegenkontoNummer = gegenkontoIBAN;
                            } else {
                                gegenkontoNummer = ibanObject.getKonto();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Kontonummer aus IBAN: " + gegenkontoNummer);
                                gegenkontoBLZ = ibanObject.getBLZ();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "BLZ aus IBAN: " + gegenkontoBLZ);
                            }
                        }
                    }
                    if (shrinkedPurpText.contains(" BIC+")) {
                        gegenkontoBIC = StringCharUtils.getSubString(shrinkedPurpText, shrinkedPurpText.indexOf(" BIC+") + 5, shrinkedPurpText.indexOf(" ", shrinkedPurpText.indexOf(" BIC+") + 5));
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoIBAN);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoBIC);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoName);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoNummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (isCreditcard.booleanValue() && !StringCharUtils.isNullOrEmptyOrNothing(dataResponseMatrixArray[i][6]) && !dataResponseMatrixArray[i][6].equals("EUR")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Urspr\u00fcnglicher Betrag: " + dataResponseMatrixArray[i][5].trim() + "\nUrspr\u00fcngliche W\u00e4hrung: " + dataResponseMatrixArray[i][6].trim() + "\nWechselkurs: " + dataResponseMatrixArray[i][7].trim());
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    String krefText = "";
                    if (shrinkedPurpText.contains("KREF+")) {
                        krefText = StringCharUtils.shrinkString(StringCharUtils.getSubString(shrinkedPurpText, shrinkedPurpText.indexOf("KREF+") + 5, shrinkedPurpText.indexOf(" ", shrinkedPurpText.indexOf("KREF+") + 5)));
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(krefText);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    String erefText = "";
                    if (shrinkedPurpText.contains("EREF+")) {
                        erefText = StringCharUtils.shrinkString(StringCharUtils.getSubString(shrinkedPurpText, shrinkedPurpText.indexOf("EREF+") + 5, shrinkedPurpText.indexOf(" ", shrinkedPurpText.indexOf("EREF+") + 5)));
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(erefText);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    String mrefText = "";
                    if (shrinkedPurpText.contains("MREF+")) {
                        mrefText = StringCharUtils.shrinkString(StringCharUtils.getSubString(shrinkedPurpText, shrinkedPurpText.indexOf("MREF+") + 5, shrinkedPurpText.indexOf(" ", shrinkedPurpText.indexOf("MREF+") + 5)));
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(mrefText);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(transactionid);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "needTransDateAndOrValutaFusion", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("Santander", iban, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

