/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.santanderconsumerbank;

import de.derrichter.finance.websync.institute.santanderconsumerbank.WebPush;
import de.derrichter.finance.websync.institute.santanderconsumerbank.WebUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait2 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        try {
            boolean noBookmark = true;
            int round = 0;
            do {
                LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "Santander" + "-Login aufrufen ... (GET " + "https://meine.santander.de/olb" + ")");
                try {
                    seleniumWebDriver.get("https://meine.santander.de/olb");
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
                }
                try {
                    seleniumWebDriver.findElement(By.xpath((String)"//*[contains(.,'ein Lesezeichen aufgerufen haben')]"));
                    noBookmark = false;
                    MonitorLog.invoke((Object)MonitorLog, "Login fehlgeschlagen ... Aufruf von Lesezeichen wurde unterstellt ... beginne von vorne ...");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Login fehlgeschlagen ... Aufruf von Lesezeichen wurde unterstellt ... beginne von vorne ...");
                }
                catch (NoSuchElementException | TimeoutException notMobileTan) {
                    noBookmark = true;
                }
                if (!noBookmark) continue;
                SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "institutlogo-santanderconsumerbank.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                try {
                    String userXpath = "//input[contains(@id,'alias')]";
                    String passXpath = "//input[contains(@id,'password')]";
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)userXpath)));
                    WebElement inputUsername = seleniumWebDriver.findElement(By.xpath((String)userXpath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "inputUsername: " + inputUsername);
                    WebElement inputPasswd = seleniumWebDriver.findElement(By.xpath((String)passXpath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "inputPassword: " + inputPasswd);
                    SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "institutlogo-santanderconsumerbank.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                    wait.until((Function)ExpectedConditions.elementToBeClickable((WebElement)inputUsername));
                    inputUsername.click();
                    inputUsername.sendKeys(new CharSequence[]{responseLogin});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(1000L);
                    SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "institutlogo-santanderconsumerbank.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                    wait.until((Function)ExpectedConditions.elementToBeClickable((WebElement)inputPasswd));
                    inputPasswd.click();
                    inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "institutlogo-santanderconsumerbank.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[contains(.,'Einloggen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                Thread.sleep(2000L);
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "institutlogo-santanderconsumerbank.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                try {
                    seleniumWebDriver.findElement(By.xpath((String)"//*[contains(.,'ein Lesezeichen aufgerufen haben')]"));
                    noBookmark = false;
                    MonitorLog.invoke((Object)MonitorLog, "Login fehlgeschlagen ... Aufruf von Lesezeichen wurde unterstellt ... beginne von vorne ...");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Login fehlgeschlagen ... Aufruf von Lesezeichen wurde unterstellt ... beginne von vorne ...");
                }
                catch (NoSuchElementException | TimeoutException notMobileTan) {
                    noBookmark = true;
                }
                if (++round < 2) continue;
                isSelfException = true;
                throw new Exception("Fehlerhinweis auf Lesezeichen nicht erfolgreich umgangen, setze Auth-Daten zur\u00fcck. Bitte nochmals versuchen");
            } while (!noBookmark);
            int loginWaiter = 0;
            boolean successfulLogin = false;
            String tanArt = null;
            String detectTANformPath = null;
            String detectSuccessfulLogin = "(//*[contains(.,'Abmelden')])[1]";
            String secTextPath = null;
            String tanInputPath = null;
            String submitTanPath = null;
            try {
                while (true) {
                    try {
                        SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Santander] ", "Santander Consumer Bank AG", "institutlogo-santanderconsumerbank.png", "#usercentrics-root,#uc-center-container", "button[data-testid='uc-accept-all-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                        wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectSuccessfulLogin)));
                        successfulLogin = true;
                    }
                    catch (NoSuchElementException | TimeoutException throwable) {
                        // empty catch block
                    }
                    try {
                        detectTANformPath = "//div[contains(@class,'SigningOverlay')]//p[contains(.,'SMS')]";
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "mobileTAN als aktivtives 2FA-Sicherheitsverfahren erkannt ...");
                        tanArt = "mobileTAN";
                        secTextPath = "//div[contains(@class,'SigningOverlay')]//p[contains(.,'SMS')]";
                        tanInputPath = "//input[@id='otp-input']";
                        submitTanPath = "//button[contains(@class,'SigningOverlay')][2]";
                    }
                    catch (NoSuchElementException | TimeoutException throwable) {
                        // empty catch block
                    }
                    try {
                        detectTANformPath = "//div[contains(@class,'SigningOverlay')]//p[contains(.,'SantanderSign')]";
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Banking-App als aktivtives 2FA-Sicherheitsverfahren erkannt");
                        tanArt = "bankingApp";
                    }
                    catch (NoSuchElementException | TimeoutException throwable) {
                        // empty catch block
                    }
                    if (tanArt != null) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Durchf\u00fcren des " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
                        if (tanArt.equals("bankingApp")) {
                            try {
                                WebElement waiterCheck = null;
                                MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                                int rounds = 0;
                                Thread.sleep(3000L);
                                boolean waitAppAuth = true;
                                do {
                                    try {
                                        waiterCheck = seleniumWebDriver.findElement(By.xpath((String)detectTANformPath));
                                    }
                                    catch (NoSuchElementException | TimeoutException noBestSign) {
                                        waitAppAuth = false;
                                    }
                                    if (waitAppAuth) {
                                        LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                                        Thread.sleep(3000L);
                                        ++rounds;
                                    }
                                    if (rounds < 79) continue;
                                    isSelfException = true;
                                    throw new Exception("Banking-App Authentifizierung auch nach 4 Minuten nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                                } while (waitAppAuth);
                            }
                            catch (Exception error) {
                                if (isSelfException) {
                                    throw new Exception(error.getMessage());
                                }
                                isSelfException = true;
                                throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            WebPush.setSecAuthMeth(tanArt);
                            tanArt = null;
                            loginWaiter = 27;
                        } else if (tanArt.equals("mobileTAN")) {
                            String secText = seleniumWebDriver.findElement(By.xpath((String)("(" + secTextPath + ")[1]"))).getText().trim();
                            String userTanInput = null;
                            boolean retryInput = false;
                            do {
                                try {
                                    userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-santanderconsumerbank.png");
                                }
                                catch (InvocationTargetException error) {
                                    isSelfException = true;
                                    if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                                        throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                                    }
                                    LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                                    throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                                }
                                WebElement tanInput1 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[1]")));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput1: " + tanInput1);
                                WebElement tanInput2 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[2]")));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput2: " + tanInput2);
                                WebElement tanInput3 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[3]")));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput3: " + tanInput3);
                                WebElement tanInput4 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[4]")));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput4: " + tanInput4);
                                WebElement tanInput5 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[5]")));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput5: " + tanInput5);
                                WebElement tanInput6 = seleniumWebDriver.findElement(By.xpath((String)("(" + tanInputPath + ")[6]")));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "tanInput6: " + tanInput6);
                                new Actions(seleniumWebDriver).click(tanInput1).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                                tanInput1.sendKeys(new CharSequence[]{userTanInput.substring(0, 1)});
                                new Actions(seleniumWebDriver).click(tanInput2).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                                tanInput2.sendKeys(new CharSequence[]{userTanInput.substring(1, 2)});
                                new Actions(seleniumWebDriver).click(tanInput3).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                                tanInput3.sendKeys(new CharSequence[]{userTanInput.substring(2, 3)});
                                new Actions(seleniumWebDriver).click(tanInput4).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                                tanInput4.sendKeys(new CharSequence[]{userTanInput.substring(3, 4)});
                                new Actions(seleniumWebDriver).click(tanInput5).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                                tanInput5.sendKeys(new CharSequence[]{userTanInput.substring(4, 5)});
                                new Actions(seleniumWebDriver).click(tanInput6).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                                tanInput6.sendKeys(new CharSequence[]{userTanInput.substring(5, 6)});
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTAN", submitTanPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                String pageAfter2FLoginResponse = seleniumWebDriver.getPageSource();
                                try {
                                    WebElement checkWrongTAN = seleniumWebDriver.findElement(By.xpath((String)"//p[contains(@class,'MuiFormHelperText-root')]"));
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "checkWrongTAN: " + checkWrongTAN);
                                    DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der Santander Consumer Bank AG:\n\n\nDie eingegebene " + tanArt + " ist falsch.", "institutlogo-santanderconsumerbank.png");
                                    retryInput = true;
                                }
                                catch (NoSuchElementException | TimeoutException wrongTAN) {
                                    retryInput = false;
                                }
                                try {
                                    WebUtils.checkSeleniumResponseHasError(pageAfter2FLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception(error.getMessage());
                                }
                                WebPush.setSecAuthMeth(tanArt);
                                tanArt = null;
                            } while (retryInput);
                            loginWaiter = 27;
                        }
                    }
                    ++loginWaiter;
                    try {
                        WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//input[@id='alias' or @id='password']"));
                        isSelfException = true;
                        throw new Exception("Die Loginseite wird wieder angezeigt. 2FA wurde wohl abgebrochen oder war zu langsam.");
                    }
                    catch (NoSuchElementException | TimeoutException checkLoginField) {
                        if (loginWaiter < 60 && !successfulLogin && tanArt == null) continue;
                        if (loginWaiter >= 60) {
                            throw new Exception("sucessfull-login timeout");
                        }
                        try {
                            WebElement checkLoginField2 = seleniumWebDriver.findElement(By.xpath((String)"//input[@id='alias' or @id='password']"));
                            isSelfException = true;
                            throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
                        }
                        catch (NoSuchElementException | TimeoutException checkLoginField2) {
                        }
                    }
                    break;
                }
            }
            catch (Exception loginWaitError) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "... bei der Seite mit dem vermeintlich angebotenen Sicherheitsverfahren handelt es sich um diese im XML-Format: \n" + seleniumWebDriver.getPageSource());
                if (isSelfException) {
                    throw new Exception(loginWaitError.getMessage());
                }
                isSelfException = true;
                throw new Exception("Angebotenes Sicherheitsverfahren nicht erkannt oder bekannt und Login wohl nicht erfolgreich. Bitte informieren Sie im Forum den Entwickler; Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)loginWaitError));
            }
            return seleniumWebDriver;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        try {
            String currentURL = seleniumWebDriver.getCurrentUrl();
            String currentURLmain = currentURL.substring(0, currentURL.lastIndexOf("#/") + 2);
            String logoutURL = currentURLmain + "logout";
            try {
                seleniumWebDriver.get(logoutURL);
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "logoutPage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            String postLogoutPage = seleniumWebDriver.getPageSource();
            String successLogoutXpath = "//*[contains(.,'Sie haben sich erfolgreich ausgeloggt') or contains(.,'Die Sitzung wurde zu Ihrer Sicherheit beendet')]";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Santander] " + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                try {
                    WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Santander] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPage);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Santander] " + getLogMethod + "Logout bei der '" + "Santander Consumer Bank AG" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:Santander] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

