/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.postbanktask;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static String COOKIE_DETECT_PATH = "#usercentrics-root,#uc-center-container";
    static String COOKIE_ACCEPT_PATH = "button[data-testid='uc-accept-all-button']";
    static String LOADER_CATCHSTRING = "DummyCatchString";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//*[contains(.,'c-spinner')]";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[3];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//div[@role='alert']//*[text()!=''][not(self::span)]";
        WebUtils.xpathSearchString[1] = "//div[contains(@class,'c-modal--alert')]//*[text()!='']";
        WebUtils.xpathSearchString[2] = "(//div[@role='dialog' and contains(.,'aufgrund von Systemarbeiten') and not(contains(@style,'display: none;')) and not(contains(@style,'display:none;'))])[last()]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Dummy";
    }

    protected static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:Postbank] ";
        String longName = "Postbank AG";
        String logoPath = "institutlogo-postbankcreditcard.png";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, logoPath, xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    protected static void authBestSign(WebDriver seleniumWebDriver, boolean authManual, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String logIdent = "[WebSync:Postbank] ";
        boolean isSelfException = false;
        try {
            if (authManual) {
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitBestSign", "//section[@id='container_bestSign']//button[text()='Freigeben']", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            WebElement waiterCheck = null;
            MonitorLog.invoke((Object)MonitorLog, "Warte auf BestSign-Freigabe ...");
            int rounds = 0;
            Thread.sleep(3000L);
            boolean waitBestSign = true;
            String checkContentPath = "//db-banking-2fa-panel[contains(.,'Freigabe mit Ihrem BestSign') or (contains(.,'geben Sie den Auftrag frei') and contains(.,'BestSign'))] | //span[contains(.,'BestSign')] | //div[contains(.,'Ihrer BestSign App')]";
            do {
                if (authManual) {
                    try {
                        LogDebug.invoke((Object)LogTrace, logIdent + "{authManual} bestsignCheck (findElement): " + checkContentPath);
                        waiterCheck = seleniumWebDriver.findElement(By.xpath((String)checkContentPath));
                    }
                    catch (NoSuchElementException | TimeoutException noBestSign) {
                        LogDebug.invoke((Object)LogTrace, logIdent + "{authManual} OK. Nicht gefunden, BestSign wohl abgeschlossen");
                        waitBestSign = false;
                    }
                    if (waitBestSign) {
                        Boolean staleElement = true;
                        while (staleElement.booleanValue()) {
                            try {
                                LogTrace.invoke((Object)LogTrace, logIdent + "{authManual} buttonCheck (outerHTML): " + waiterCheck.getAttribute("outerHTML"));
                                staleElement = false;
                            }
                            catch (StaleElementReferenceException ex) {
                                try {
                                    LogDebug.invoke((Object)LogTrace, logIdent + "{authManual} buttonCheck (get outerHTML) -> StaleElementReferenceException; Daher nun nochmals buttonCheck (findElement): " + checkContentPath);
                                    waiterCheck = seleniumWebDriver.findElement(By.xpath((String)checkContentPath));
                                }
                                catch (NoSuchElementException | TimeoutException notFounderr) {
                                    LogDebug.invoke((Object)LogTrace, logIdent + "{authManual} OK. Nicht gefunden, BestSign wohl abgeschlossen");
                                    waitBestSign = false;
                                }
                                staleElement = true;
                            }
                        }
                        staleElement = true;
                        while (staleElement.booleanValue()) {
                            try {
                                if (!waiterCheck.getAttribute("outerHTML").contains("c-spinner")) {
                                    LogDebug.invoke((Object)LogTrace, logIdent + "{authManual} buttonCheck (get outerHTML contains 'c-spinner') nicht zutreffend, BestSign wohl abgeschlossen, beende BestSign...");
                                    waitBestSign = false;
                                }
                                staleElement = false;
                            }
                            catch (StaleElementReferenceException e) {
                                try {
                                    LogDebug.invoke((Object)LogTrace, logIdent + "{authManual} buttonCheck (get outerHTML) -> StaleElementReferenceException; Daher nun nochmals buttonCheck (findElement): " + checkContentPath);
                                    waiterCheck = seleniumWebDriver.findElement(By.xpath((String)checkContentPath));
                                }
                                catch (NoSuchElementException | TimeoutException notFounderr) {
                                    LogDebug.invoke((Object)LogTrace, logIdent + "{authManual} OK. Nicht gefunden, BestSign wohl abgeschlossen");
                                    waitBestSign = false;
                                }
                                staleElement = true;
                            }
                        }
                    }
                } else {
                    try {
                        LogDebug.invoke((Object)LogTrace, logIdent + "xpathCheck: 'Warte auf BestSign Freigabe' ..." + checkContentPath);
                        waiterCheck = seleniumWebDriver.findElement(By.xpath((String)checkContentPath));
                    }
                    catch (NoSuchElementException | TimeoutException noBestSign) {
                        LogDebug.invoke((Object)LogTrace, logIdent + "OK. Nicht gefunden, BestSign wohl abgeschlossen");
                        waitBestSign = false;
                    }
                }
                if (waitBestSign) {
                    LogInfo.invoke((Object)LogInfo, logIdent + "Warte weiter auf BestSign-Freigabe (weitere 3 Sekunden) ...");
                    Thread.sleep(3000L);
                    ++rounds;
                }
                if (rounds < 60) continue;
                isSelfException = true;
                throw new Exception("BestSign-Authentifizierung auch nach 3 Minuten nicht abgeschlossen. Warten auf BestSign-Freigabe abgebrochen");
            } while (waitBestSign);
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Warten auf BestSign-Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    protected static void authChipTAN(WebDriver seleniumWebDriver, boolean authManual, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        String getLogMethod = "[authChipTAN] ";
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        String loaderCatchString = "DummyCatchString";
        String loaderExclusion = "DummyLoaderExclution";
        String loaderPath = "//*[contains(.,'c-spinner')]";
        String loaderText = "DummyLoaderText";
        String submitButtonPath = "(//section[@id='container_chipTan']//button)[last()]";
        String submitButtonPath2 = "(//section[@id='container_chipTan']//button)[last()-1]";
        boolean isSelfException = false;
        try {
            if (authManual) {
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "requestChipTan", submitButtonPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    WebUtils.waitButtonLoader(seleniumWebDriver, submitButtonPath, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "requestChipTanCode", "//span[contains(.,'chipTAN manuell generieren')]//parent::button", loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                WebUtils.waitButtonLoader(seleniumWebDriver, "//span[contains(.,'chipTAN manuell generieren')]//parent::button", externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String secText = seleniumWebDriver.findElement(By.xpath((String)"//section[@id='container_chipTan']//ol")).getText();
            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] secText: " + secText);
            wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"chipTanInput")));
            WebElement chipTanInput = seleniumWebDriver.findElement(By.id((String)"chipTanInput"));
            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] chipTanInput: " + chipTanInput);
            String userTanInput = null;
            String tanArt = "chipTAN";
            try {
                userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-postbankcreditcard.png");
            }
            catch (InvocationTargetException error) {
                isSelfException = true;
                if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                    throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                }
                LogError.invoke((Object)LogError, "[WebSync:Postbank] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
            }
            chipTanInput.click();
            chipTanInput.sendKeys(new CharSequence[]{userTanInput});
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitChipTan", submitButtonPath2, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                WebUtils.waitButtonLoader(seleniumWebDriver, submitButtonPath, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("chipTan-Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    protected static void authMTAN(WebDriver seleniumWebDriver, boolean authManual, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        String getLogMethod = "[authMTAN] ";
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        String loaderCatchString = "DummyCatchString";
        String loaderExclusion = "DummyLoaderExclution";
        String loaderPath = "//*[contains(.,'c-spinner')]";
        String loaderText = "DummyLoaderText";
        String submitButtonPath = "(//section[@id='container_mobileTan']//button)[last()]";
        boolean isSelfException = false;
        try {
            if (authManual) {
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "requestMTAN", submitButtonPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    WebUtils.waitButtonLoader(seleniumWebDriver, submitButtonPath, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            String secText = seleniumWebDriver.findElement(By.xpath((String)"//section[@id='container_mobileTan']//span[contains(@class,'u-copy-m')]")).getText();
            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] secText: " + secText);
            wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"mobileTanInput")));
            WebElement inputMTAN = seleniumWebDriver.findElement(By.id((String)"mobileTanInput"));
            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] inputMTAN: " + inputMTAN);
            String userTanInput = null;
            String tanArt = "mobileTAN";
            try {
                userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-postbankcreditcard.png");
            }
            catch (InvocationTargetException error) {
                isSelfException = true;
                if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                    throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                }
                LogError.invoke((Object)LogError, "[WebSync:Postbank] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
            }
            inputMTAN.click();
            inputMTAN.sendKeys(new CharSequence[]{userTanInput});
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitMTAN", submitButtonPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                WebUtils.waitButtonLoader(seleniumWebDriver, submitButtonPath, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("mobileTan-Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    protected static void waitButtonLoader(WebDriver seleniumWebDriver, String buttonPath, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String logIdent = "[WebSync:Postbank] ";
        WebElement waiterCheck = null;
        boolean waitButtonLoader = true;
        Thread.sleep(1000L);
        do {
            try {
                waiterCheck = seleniumWebDriver.findElement(By.xpath((String)buttonPath));
            }
            catch (NoSuchElementException | TimeoutException noBestSign) {
                waitButtonLoader = false;
            }
            if (waiterCheck != null) {
                try {
                    LogTrace.invoke((Object)LogTrace, logIdent + "buttonCheck (outerHTML): " + waiterCheck.getAttribute("outerHTML"));
                }
                catch (StaleElementReferenceException ex) {
                    waiterCheck = seleniumWebDriver.findElement(By.xpath((String)buttonPath));
                }
                if (!waiterCheck.getAttribute("outerHTML").contains("c-spinner")) {
                    waitButtonLoader = false;
                }
                if (!waitButtonLoader) continue;
                LogInfo.invoke((Object)LogInfo, logIdent + "Loader 'Button-Spinner' erkannt, warte 1 Sekunde ...");
                Thread.sleep(1000L);
                continue;
            }
            waitButtonLoader = false;
        } while (waitButtonLoader);
    }
}

