/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.postbanktask;

import de.derrichter.finance.websync.institute.postbanktask.WebUtils_oldSite;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlSelect;
import org.w3c.dom.Node;

public class WebPull_oldSite {
    public static ArrayList getTransData(WebClient syncWebClient, String kontonummer, String Unterkonto, String fromDateSimple, String toDateSimple, HtmlPage postLoginPage, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, Class<?> ExternalDialogInterface) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        Method MonitorSetPercent = ExternalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        LogInfo.invoke((Object)LogInfo, "[WebSync:Postbank] Eingestellte Kontoart '" + Unterkonto + "' sollte nun abgerufen werden");
        try {
            HtmlPage page = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
            HtmlPage dataPage = null;
            HtmlAnchor DataPageGetButton = page.getAnchorByText("Ums\u00e4tze");
            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Click " + DataPageGetButton);
            try {
                dataPage = (HtmlPage)DataPageGetButton.click();
                syncWebClient.waitForBackgroundJavaScript(5000L);
                dataPage = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: DataPage (Seite): " + dataPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String dataPageXML = dataPage.asXml();
            try {
                WebUtils_oldSite.checkResponse(dataPageXML, (Page)dataPage, ExternalLogger, ExternalProgressMonitor, ExternalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            HtmlForm formData = null;
            if (!dataPageXML.contains("selectForm:kontoauswahl") && Unterkonto.equals("Spar")) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] Kontowahl wird ausgelassen da dies ein Spar-Konto ist und keine Auswahl gefunden wurde, wahrscheinlich reines SparCard-Konto");
            } else {
                HtmlSelect Kontowahl;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Setzen des Formulars f\u00fcr die Kontoauswahl und Auswahl treffen ...");
                try {
                    formData = (HtmlForm)dataPage.getFirstByXPath("//form[@method='post']");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: formData: " + formData);
                    Kontowahl = formData.getSelectByName("selectForm:kontoauswahl");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: Kontowahl: " + Kontowahl);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim setzen der Kontoauswahl (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                boolean selectKonto = false;
                List list = Kontowahl.getOptions();
                String selectedOptionText = null;
                for (int i = 0; i < list.size(); ++i) {
                    HtmlOption option = (HtmlOption)list.get(i);
                    if ((Unterkonto.length() == 16 || !option.asNormalizedText().contains(kontonummer)) && (Unterkonto.length() != 16 || !option.asNormalizedText().contains(Unterkonto))) continue;
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "Kontoauswahl auf " + option);
                    option.setSelected(true);
                    selectKonto = true;
                    selectedOptionText = option.asNormalizedText();
                }
                if (!selectKonto) {
                    isSelfException = true;
                    if (Unterkonto.length() == 16) {
                        throw new Exception("Kreditkarte ****" + Unterkonto.substring(4, 12) + "**** in der Kontoauswahl nicht gefunden! Kontrollieren Sie bitte Ihre Angaben");
                    }
                    throw new Exception("Konto " + kontonummer + " in der Auswahl nicht gefunden! Kontrollieren Sie bitte Ihre Angaben im Konto (FAQ-Hilfe auf der Projektseite)");
                }
                if (Unterkonto.length() == 16) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "Auswahlcheck f\u00fcr Kreditkarten mit Options-Text: " + selectedOptionText);
                    if (!(selectedOptionText.contains("Kredit") || selectedOptionText.contains("Master") || selectedOptionText.contains("Visa") || selectedOptionText.contains("VISA") || selectedOptionText.contains("MASTER") || selectedOptionText.contains(" Card"))) {
                        isSelfException = true;
                        throw new Exception("Kreditkarten- bzw. Kundennummer passt nicht zu Einstellung Unterkonto (" + Unterkonto + "). Bei der Auswahl handelt es sich anscheinend nicht um eine Kreditkarte");
                    }
                } else if (!selectedOptionText.contains(Unterkonto)) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Auswahlcheck f\u00fcr Konto mit Options-Text: " + selectedOptionText);
                    String isKonto = null;
                    if (selectedOptionText.contains("Tagesgeld")) {
                        isKonto = "Tagesgeld";
                    }
                    if (selectedOptionText.contains("Anlage")) {
                        isKonto = "Anlage/EasyTrade";
                    }
                    if (selectedOptionText.contains("Spar")) {
                        isKonto = "SparCard/Sparbuch";
                    }
                    if (selectedOptionText.contains("karte")) {
                        isKonto = "Kreditkarten";
                    }
                    isSelfException = true;
                    throw new Exception("Kontonummer passt nicht zu Einstellungen (=" + Unterkonto + "). Bei der Konto- bzw. Kundennummer handelt es sich um ein " + isKonto + "-Konto");
                }
            }
            Page csv = null;
            String dataResponse = null;
            if (Unterkonto.length() == 16) {
                String billViewText;
                HtmlPage setBillView;
                HtmlRadioButtonInput setBillViewLink2;
                HtmlRadioButtonInput setBillViewLink;
                String creditDataCurrent;
                DomElement fakeSubmit;
                DomElement fakeSubmitCC = dataPage.createElement("button");
                fakeSubmitCC.setAttribute("type", "submit");
                formData.appendChild((Node)fakeSubmitCC);
                dataPage = (HtmlPage)fakeSubmitCC.click();
                syncWebClient.waitForBackgroundJavaScript(5000L);
                dataPage = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: DataPage Kreditkarte (Submit-Fake-Button Click): " + dataPage);
                dataPageXML = dataPage.asXml();
                String DataPageText = dataPage.asNormalizedText();
                String creditDataSync = "";
                String transViewText = null;
                if (DataPageText.contains("Alter Kontostand")) {
                    int versuche = 0;
                    do {
                        HtmlRadioButtonInput setTransViewLink2;
                        HtmlRadioButtonInput setTransViewLink;
                        if (versuche == 0) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] --> [!] Schon Rechnungsansicht, daher setzen des Formulars f\u00fcr die aktuelle Kreditkartenbuchungen ...");
                        }
                        try {
                            formData = (HtmlForm)dataPage.getFirstByXPath("//form[@method='post']");
                            setTransViewLink = (HtmlRadioButtonInput)formData.getByXPath("//input[@type='radio']").get(0);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: setTransViewLink: " + setTransViewLink);
                            setTransViewLink2 = (HtmlRadioButtonInput)formData.getByXPath("//input[@type='radio']").get(1);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] getTransactionData: setTransViewLink2 (sollte hier nicht verwendet werden): " + setTransViewLink2);
                        }
                        catch (Exception error) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "... dabei ist ein Fehler aufgetreten ...");
                            throw new Exception("Fehler beim Setzen des Kreditkartenrechnung-Formulars oder des Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        HtmlPage TransView = null;
                        HtmlPage setTransView = null;
                        try {
                            setTransViewLink2.setChecked(false);
                            setTransViewLink2.setDefaultChecked(false);
                            setTransViewLink.setChecked(true);
                            setTransViewLink.setDefaultChecked(true);
                            setTransView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] getTransactionData: setTransView ('neue Ums\u00e4tze' mouseDown): " + setTransView);
                            transViewText = setTransView.asNormalizedText();
                            fakeSubmit = setTransView.createElement("button");
                            fakeSubmit.setAttribute("type", "submit");
                            formData.appendChild((Node)fakeSubmit);
                            TransView = (HtmlPage)fakeSubmit.click();
                            syncWebClient.waitForBackgroundJavaScript(5000L);
                            TransView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: setTransView (Submit-Fake-Button Click): " + setTransView);
                            transViewText = TransView.asNormalizedText();
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("Fehler beim Aufruf der aktuellen Kreditkartenbuchungen oder es existiert keine Internertverbindung mit Jameica (siehe Log)\nLog-Eintrag: " + error + "\nund noch die aktuelle Seite:\n" + transViewText);
                        }
                        if (transViewText.contains("Alter Kontostand")) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] --> [!] anscheinend immer noch Rechnungsansicht, daher erneuter Versuch; setzen des Formulars f\u00fcr die aktuelle Kreditkartenbuchungen ...");
                            dataPage = TransView;
                        }
                        if (++versuche != 10) continue;
                        isSelfException = true;
                        throw new Exception("Anzeige mit den aktuellen Kreditkartenbuchungen kann auch nach 10 Versuchen nicht angezeigt werden");
                    } while (transViewText.contains("Alter Kontostand"));
                } else {
                    transViewText = DataPageText;
                }
                if (DataPageText.contains("Diese Funktion steht auf Grund einer technischen St") || transViewText.contains("Diese Funktion steht auf Grund einer technischen St")) {
                    isSelfException = true;
                    throw new Exception("Fehlermeldung des Postbank-Server 'Technische St\u00f6rung' wird angezeigt. Bitte versuchen Sie es nochmals");
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 30);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Lese alle Neuen Ums\u00e4tze aus ...");
                try {
                    int nrIDXstart = transViewText.indexOf("Neue Kreditkarten") + 24;
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "NrIDXstart: " + nrIDXstart);
                    int nrIDXend = transViewText.indexOf("Hinweise ", nrIDXstart);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "NrIDXend: " + nrIDXend);
                    creditDataCurrent = transViewText.substring(nrIDXstart, nrIDXend);
                    creditDataCurrent = creditDataCurrent.replaceAll("\\u000D\\u000A", "\n");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\u000D", "\n");
                    creditDataCurrent = creditDataCurrent.replaceAll(" \t", ";");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\u000A\t\\u000A\t\\u000A\t\\u000A", ";;;");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\u000A\t\\u000A", ";");
                    creditDataCurrent = creditDataCurrent.replaceAll(":\t", ";");
                    creditDataCurrent = creditDataCurrent.replaceAll("\t", "");
                    creditDataCurrent = creditDataCurrent.replaceAll(";;\\u000A;\\u000A", ";;;");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\u000A\\u000A", "\n");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\n;;\\n", ";;;");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\r;;\\r", ";;;");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\n\\r;;\\n\\r", ";;;");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\r\\n;;\\r\\n", ";;;");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\u000A;;\\u000A", ";;;");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\u000D;;\\u000D", ";;;");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\u000D\\u000A;;\\u000D\\u000A", ";;;");
                    creditDataCurrent = creditDataCurrent.replaceAll("\\u000A\\u000D;;\\u000A\\u000D", ";;;");
                }
                catch (Exception error) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "... dabei ist ein Fehler aufgetreten ...");
                    isSelfException = true;
                    throw new Exception("Fehler beim erzeugen des Kontoauszugs f\u00fcr die neuen Ums\u00e4tze) (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                creditDataSync = "Kontoauszug vom " + toDateSimple + "\n" + creditDataCurrent + "\n\n\n";
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Setzen des Formulars f\u00fcr die Kreditkartenrechnung-Liste ...");
                try {
                    formData = (HtmlForm)dataPage.getFirstByXPath("//form[@method='post']");
                    setBillViewLink = (HtmlRadioButtonInput)formData.getByXPath("//input[@type='radio']").get(1);
                    setBillViewLink2 = (HtmlRadioButtonInput)formData.getByXPath("//input[@type='radio']").get(0);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: setBillViewLink: " + setBillViewLink);
                }
                catch (Exception error) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "... dabei ist ein Fehler aufgetreten ...");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Hier mal die Seite zur Analyse: \n" + dataPageXML);
                    isSelfException = true;
                    throw new Exception("Fehler beim Setzen des Kreditkartenrechnung-Formulars oder des Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    setBillViewLink2.setChecked(false);
                    setBillViewLink2.setDefaultChecked(false);
                    setBillViewLink.setChecked(true);
                    setBillViewLink.setDefaultChecked(true);
                    setBillView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: setBillView (Rechnungsliste Click): " + setBillView);
                    fakeSubmit = setBillView.createElement("button");
                    fakeSubmit.setAttribute("type", "submit");
                    formData.appendChild((Node)fakeSubmit);
                    setBillView = (HtmlPage)fakeSubmit.click();
                    syncWebClient.waitForBackgroundJavaScript(5000L);
                    setBillView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: setBillView (Submit-Fake-Button Click): " + setBillView);
                    DataPageText = setBillView.asNormalizedText();
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim Aufruf der Rechnungsansicht oder es existiert keine Internertverbindung mit Jameica (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                if (!DataPageText.contains("Alter Kontostand")) {
                    int versuche = 0;
                    do {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] --> [!] immer noch falsche Ansicht 'neue Ums\u00e4tze', daher setzen des Formulars f\u00fcr die Ansicht 'Bisherige Abrechnungen' ...");
                        try {
                            formData = (HtmlForm)dataPage.getFirstByXPath("//form[@method='post']");
                            setBillViewLink = (HtmlRadioButtonInput)formData.getByXPath("//input[@type='radio']").get(1);
                            setBillViewLink2 = (HtmlRadioButtonInput)formData.getByXPath("//input[@type='radio']").get(0);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: setBillViewLink: " + setBillViewLink);
                        }
                        catch (Exception error) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "... dabei ist ein Fehler aufgetreten ...");
                            isSelfException = true;
                            throw new Exception("Fehler beim Setzen des Kreditkartenrechnung-Formulars oder des Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        try {
                            setBillViewLink2.setChecked(false);
                            setBillViewLink2.setDefaultChecked(false);
                            setBillViewLink.setChecked(true);
                            setBillViewLink.setDefaultChecked(true);
                            setBillView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] getTransactionData: setBillView ('Bisherige Abrechnungen' mouseDown): " + setBillView);
                            fakeSubmit = setBillView.createElement("button");
                            fakeSubmit.setAttribute("type", "submit");
                            formData.appendChild((Node)fakeSubmit);
                            setBillView = (HtmlPage)fakeSubmit.click();
                            syncWebClient.waitForBackgroundJavaScript(5000L);
                            setBillView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: setBillView (Submit-Fake-Button Click): " + setBillView);
                            billViewText = setBillView.asNormalizedText();
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("Fehler beim Aufruf der Liste mit den Kreditkartenrechnungen oder es existiert keine Internertverbindung mit Jameica (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error) + "\nund noch die aktuelle Seite:\n" + transViewText);
                        }
                        if (!billViewText.contains("Alter Kontostand")) {
                            dataPage = setBillView;
                        }
                        if (++versuche != 10) continue;
                        isSelfException = true;
                        throw new Exception("Anzeige der Liste mit den Kreditkartenrechnungen kann auch nach 10 Versuchen nicht angezeigt werden");
                    } while (!billViewText.contains("Alter Kontostand"));
                } else {
                    billViewText = DataPageText;
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Setzen des Formulars f\u00fcr die Rechnungsauswahl und Auswahl treffen ...");
                formData = (HtmlForm)setBillView.getFirstByXPath("//form[@method='post']");
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: formData: " + formData);
                HtmlSelect rechnungswahl = formData.getSelectByName("umsatzanzeigeKreditkarten:kreditkarteRechungen:rechnungenRootTag:selectForm:rechnungen");
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: Rechnungswahl: " + rechnungswahl);
                List list = rechnungswahl.getOptions();
                try {
                    for (int i = 0; i < list.size(); ++i) {
                        String creditDataBill;
                        HtmlAnchor nextBillAnchorInListElement;
                        DomElement nextBillListElement;
                        String lastBillAnchorInListHasID;
                        HtmlAnchor lastBillAnchorInListElement;
                        DomElement lastBillListElement;
                        String ddSelectHasActiveID;
                        int versuche;
                        formData = (HtmlForm)setBillView.getFirstByXPath("//form[@method='post']");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: formData: " + formData);
                        rechnungswahl = formData.getSelectByName("umsatzanzeigeKreditkarten:kreditkarteRechungen:rechnungenRootTag:selectForm:rechnungen");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: Rechnungswahl: " + rechnungswahl);
                        list = rechnungswahl.getOptions();
                        double MonitorPercent = 30.0 + 49.0 / (double)list.size() * (double)(i + 1);
                        MonitorSetPercent.invoke((Object)MonitorSetPercent, (int)MonitorPercent);
                        HtmlOption option = (HtmlOption)list.get(i);
                        HtmlOption lastOption = null;
                        String lastOptionFormText = null;
                        if (i > 0) {
                            lastOption = (HtmlOption)list.get(i - 1);
                            lastOptionFormText = lastOption.asNormalizedText().replace(" (unge\u00f6ffnet)", "");
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Listeneintrag der Rechnungsauswahl gefunden: " + option);
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "dieser Eintrag als reiner Text: " + option.asNormalizedText());
                        String optionFormText = option.asNormalizedText().replace(" (unge\u00f6ffnet)", "");
                        String billDateText = option.asNormalizedText().replace("Rechnung vom ", "").replace(" (unge\u00f6ffnet)", "");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Datum der Rechnung aus Listeneintrag: " + billDateText);
                        String[] BillDateArray = billDateText.split("\\.");
                        Date billDate = SysUtils.getDate(Integer.parseInt(BillDateArray[2], 10), Integer.parseInt(BillDateArray[1], 10) - 1, Integer.parseInt(BillDateArray[0], 10));
                        Date abrufDatum = new SimpleDateFormat("dd.MM.yyyy").parse(fromDateSimple);
                        if (billDate.getTime() < abrufDatum.getTime()) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] Rechnung liegt au\u00dferhalb des Abrufdatum ... daher kein weiterer Abruf mehr; BillDate=" + billDate.getTime() + " soll kleiner sein als AbrufDatum=" + abrufDatum.getTime());
                            break;
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Rechnungsauswahl im Select auf: " + option);
                        option.setSelected(true);
                        HtmlPage billView = null;
                        if (i > 0) {
                            versuche = 0;
                            do {
                                ddSelectHasActiveID = ((DomElement)setBillView.getFirstByXPath("(//dd[@class='select-list noChangeEvent'])[last()]")).getAttribute("aria-activedescendant");
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "DD-Select zeigt im Moment auf ID (aria-activedescendant): " + ddSelectHasActiveID);
                                lastBillListElement = (DomElement)setBillView.getFirstByXPath("//a[contains(text(),'" + lastOption.asNormalizedText() + "')]/parent::li");
                                lastBillAnchorInListElement = (HtmlAnchor)setBillView.getFirstByXPath("(//a[contains(text(),'" + lastOption.asNormalizedText() + "')])[last()]");
                                lastBillAnchorInListHasID = lastBillAnchorInListElement.getAttribute("id");
                                lastBillListElement.setAttribute("class", "select-option");
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] vorheriges Listenelement hat Attribut? [class=\"select-option\"]?: " + lastBillListElement);
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] vorheriger Rechnungslink in Liste hat ID die nun entfernt wird: [id=\"\"]: " + lastBillAnchorInListHasID);
                                lastBillAnchorInListElement.setAttribute("class", "select-option-item");
                                lastBillAnchorInListElement.setAttribute("aria-selected", "false");
                                lastBillAnchorInListElement.removeAttribute("id");
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] vorheriger Rechnungslink in Liste hat Attribut? [class=\"select-option-item\"]? & [aria-selected=\"false\"]? & KEIN [id=\"***\"]?: " + lastBillAnchorInListElement);
                                nextBillListElement = (DomElement)setBillView.getFirstByXPath("//a[contains(text(),'" + optionFormText + "')]/parent::li");
                                nextBillAnchorInListElement = (HtmlAnchor)setBillView.getFirstByXPath("(//a[contains(text(),'" + optionFormText + "')])[last()]");
                                nextBillListElement.setAttribute("class", "select-option state-selected");
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] Listenelement hat Attribut? [class=\"select-option state-selected\"]?: " + nextBillListElement);
                                nextBillAnchorInListElement.setAttribute("class", "select-option-item state-active");
                                nextBillAnchorInListElement.setAttribute("aria-selected", "true");
                                if (!lastBillAnchorInListHasID.equals(ddSelectHasActiveID)) {
                                    lastBillAnchorInListHasID = ddSelectHasActiveID;
                                }
                                nextBillAnchorInListElement.setAttribute("id", lastBillAnchorInListHasID);
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] Rechnungslink in Liste hat Attribute? [class=\"select-option-item state-active\"]? & [aria-selected=\"true\"]? & [id=\"" + lastBillAnchorInListHasID + "\"]?: " + nextBillAnchorInListElement);
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] Rechnungsauswahl (mouseDown) auf Listenelement im Select (Anchor): " + nextBillAnchorInListElement);
                                billView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                                fakeSubmit = setBillView.createElement("button");
                                fakeSubmit.setAttribute("type", "submit");
                                formData.appendChild((Node)fakeSubmit);
                                billView = (HtmlPage)fakeSubmit.click();
                                syncWebClient.waitForBackgroundJavaScript(5000L);
                                billView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: BillView (Submit-Fake-Button Click): " + billView);
                                billViewText = billView.asNormalizedText();
                                if (billViewText.contains("Diese Funktion steht auf Grund einer technischen St")) {
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] --> [!] Angezeigt wird 'technische St\u00f6rung', daher zur\u00fcck und nochmals probieren ...");
                                } else {
                                    setBillView = billView.cloneNode(true);
                                }
                                billView = null;
                                if (++versuche != 10) continue;
                                isSelfException = true;
                                throw new Exception(option.asNormalizedText() + " kann auch nach 10 Versuchen aufgrund einer 'technischen St\u00f6rung' bei der Postbank nicht angezeigt werden");
                            } while (billViewText.contains("Diese Funktion steht auf Grund einer technischen St"));
                        }
                        if (!billViewText.contains(optionFormText + " (Erstmalig ")) {
                            versuche = 0;
                            do {
                                formData = (HtmlForm)setBillView.getFirstByXPath("//form[@method='post']");
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: formData: " + formData);
                                rechnungswahl = formData.getSelectByName("umsatzanzeigeKreditkarten:kreditkarteRechungen:rechnungenRootTag:selectForm:rechnungen");
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: Rechnungswahl: " + rechnungswahl);
                                list = rechnungswahl.getOptions();
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] --> [!] immer noch vorherige Rechnung, daher NOCHMALS setzen des Formulars f\u00fcr die n\u00e4chste " + optionFormText + " ...");
                                try {
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Rechnungsauswahl im Select auf: " + option);
                                    option.setSelected(true);
                                    if (i > 0) {
                                        ddSelectHasActiveID = ((DomElement)setBillView.getFirstByXPath("(//dd[@class='select-list noChangeEvent'])[last()]")).getAttribute("aria-activedescendant");
                                        LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] DD-Select zeigt im Moment auf ID (aria-activedescendant): " + ddSelectHasActiveID);
                                        lastBillListElement = (DomElement)setBillView.getFirstByXPath("//a[contains(text(),'" + lastOption.asNormalizedText() + "')]/parent::li");
                                        lastBillAnchorInListElement = (HtmlAnchor)setBillView.getFirstByXPath("(//a[contains(text(),'" + lastOption.asNormalizedText() + "')])[last()]");
                                        lastBillAnchorInListHasID = lastBillAnchorInListElement.getAttribute("id");
                                        lastBillListElement.setAttribute("class", "select-option");
                                        LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] vorheriges Listenelement hat Attribut? [class=\"select-option\"]?: " + lastBillListElement);
                                        LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] vorheriger Rechnungslink in Liste hat ID die nun entfernt wird: [id=\"\"]: " + lastBillAnchorInListHasID);
                                        lastBillAnchorInListElement.setAttribute("class", "select-option-item");
                                        lastBillAnchorInListElement.setAttribute("aria-selected", "false");
                                        lastBillAnchorInListElement.removeAttribute("id");
                                        LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] vorheriger Rechnungslink in Liste hat Attribut? [class=\"select-option-item\"]? & [aria-selected=\"false\"]? & KEIN [id=\"***\"]?: " + lastBillAnchorInListElement);
                                        nextBillListElement = (DomElement)setBillView.getFirstByXPath("//a[contains(text(),'" + optionFormText + "')]/parent::li");
                                        nextBillAnchorInListElement = (HtmlAnchor)setBillView.getFirstByXPath("(//a[contains(text(),'" + optionFormText + "')])[last()]");
                                        nextBillListElement.setAttribute("class", "select-option state-selected");
                                        LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] Listenelement hat Attribut? [class=\"select-option state-selected\"]?: " + nextBillListElement);
                                        nextBillAnchorInListElement.setAttribute("class", "select-option-item state-active");
                                        nextBillAnchorInListElement.setAttribute("aria-selected", "true");
                                        if (!lastBillAnchorInListHasID.equals(ddSelectHasActiveID)) {
                                            lastBillAnchorInListHasID = ddSelectHasActiveID;
                                        }
                                        nextBillAnchorInListElement.setAttribute("id", lastBillAnchorInListHasID);
                                        LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] Rechnungslink in Liste hat Attribute? [class=\"select-option-item state-active\"]? & [aria-selected=\"true\"]? & [id=\"" + lastBillAnchorInListHasID + "\"]?: " + nextBillAnchorInListElement);
                                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] Rechnungsauswahl (mouseDown) auf Listenelement im Select (Anchor): " + nextBillAnchorInListElement);
                                        billView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                                        fakeSubmit = setBillView.createElement("button");
                                        fakeSubmit.setAttribute("type", "submit");
                                        formData.appendChild((Node)fakeSubmit);
                                        billView = (HtmlPage)fakeSubmit.click();
                                        syncWebClient.waitForBackgroundJavaScript(5000L);
                                        billView = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] getTransactionData: BillView (Submit-Fake-Button Click): " + billView);
                                        billViewText = billView.asNormalizedText();
                                    }
                                }
                                catch (Exception error) {
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "... dabei ist ein Fehler aufgetreten ...");
                                    throw new Exception("Fehler beim setzen der n\u00e4chsten " + optionFormText + " (siehe Log - Bitte nochmals versuchen und dann den Entwickler im Forum informieren)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                if (++versuche == 10) {
                                    throw new Exception("Die n\u00e4chste " + optionFormText + " kann auch nach 10 Versuchen nicht angezeigt werden");
                                }
                                setBillView = billView.cloneNode(true);
                                billView = null;
                            } while (!billViewText.contains(optionFormText + " (Erstmalig "));
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Erzeuge einen Kontoauszug aus " + optionFormText + " ...");
                        try {
                            int NrIDXstart = billViewText.indexOf("Neue Kreditkarten") + 24;
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "NrIDXstart: " + NrIDXstart);
                            int NrIDXend = billViewText.indexOf("Hinweise ", NrIDXstart);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "NrIDXend: " + NrIDXend);
                            creditDataBill = billViewText.substring(NrIDXstart, NrIDXend);
                            creditDataBill = creditDataBill.replaceAll("\\u000D\\u000A", "\n");
                            creditDataBill = creditDataBill.replaceAll("\\u000D", "\n");
                            creditDataBill = creditDataBill.replaceAll(" \t", ";");
                            creditDataBill = creditDataBill.replaceAll("\\u000A\t\\u000A\t\\u000A\t\\u000A", ";;;");
                            creditDataBill = creditDataBill.replaceAll("\\u000A\t\\u000A", ";");
                            creditDataBill = creditDataBill.replaceAll(":\t", ";");
                            creditDataBill = creditDataBill.replaceAll("\t", "");
                            creditDataBill = creditDataBill.replaceAll(";;\\u000A;\\u000A", ";;;");
                            creditDataBill = creditDataBill.replaceAll("\\u000A\\u000A", "\n");
                            creditDataBill = creditDataBill.replaceAll("\\n;;\\n", ";;;");
                            creditDataBill = creditDataBill.replaceAll("\\r;;\\r", ";;;");
                            creditDataBill = creditDataBill.replaceAll("\\n\\r;;\\n\\r", ";;;");
                            creditDataBill = creditDataBill.replaceAll("\\r\\n;;\\r\\n", ";;;");
                            creditDataBill = creditDataBill.replaceAll("\\u000A;;\\u000A", ";;;");
                            creditDataBill = creditDataBill.replaceAll("\\u000D;;\\u000D", ";;;");
                            creditDataBill = creditDataBill.replaceAll("\\u000D\\u000A;;\\u000D\\u000A", ";;;");
                            creditDataBill = creditDataBill.replaceAll("\\u000A\\u000D;;\\u000A\\u000D", ";;;");
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "CreditDataBill (der Kontoauszug f\u00fcr die " + optionFormText + ")\n" + creditDataBill);
                        }
                        catch (Exception error) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "... dabei ist ein Fehler aufgetreten ...");
                            throw new Exception("Fehler beim erzeugen des Kontoauszugs f\u00fcr die " + optionFormText + ") (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        creditDataSync = creditDataSync + optionFormText + "\n" + creditDataBill + "\n\n\n";
                    }
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim setzen der Rechnungsauswahl (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: CreditDataSync (kompletter Kontoauszug): \n" + creditDataSync);
                dataResponse = creditDataSync;
                syncWebClient.getCurrentWindow().setEnclosedPage((Page)setBillView);
            } else {
                String csvResponse;
                HtmlInput AnfangDatumFeld;
                HtmlPage extendedSearch;
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 30);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Erweiterte Suche aufrufen um Datum zu setzen ...");
                formData = (HtmlForm)dataPage.getFirstByXPath("//form[@method='post']");
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: formData: " + formData);
                HtmlAnchor ExtendedSearchButton = dataPage.getAnchorByText("Erweiterte Suche");
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Click " + ExtendedSearchButton);
                try {
                    extendedSearch = (HtmlPage)ExtendedSearchButton.click();
                    extendedSearch = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                    extendedSearch.refresh();
                    syncWebClient.waitForBackgroundJavaScript(5000L);
                    extendedSearch = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: extendedSearch: " + extendedSearch);
                }
                catch (Exception error) {
                    throw new Exception("Fehler beim Aufruf der Erweiterten Suche (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String extendedSearchXML = extendedSearch.asXml();
                if (extendedSearchXML.contains("Erweiterte Suche") || extendedSearchXML.contains("Access Denied Page") || !extendedSearchXML.contains(":salesForm:umsatzFilterOptionenAufklappbarSuchfeldPanel:accordion:vonBisDatum:datumForm:vonGruppe:vonDatum")) {
                    if (!extendedSearchXML.contains("Access Denied Page")) {
                        dataPage = extendedSearch.cloneNode(true);
                    }
                    int versuche = 0;
                    do {
                        if (extendedSearchXML.contains("Access Denied Page")) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] --> [!] Angezeigt wird 'Access Denied Page', daher NOCHMALS zur\u00fcck und klicken auf den Button f\u00fcr die 'Erweiterte Suche' ...");
                        } else {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] --> [!] immer noch 'Einfache Suche', daher NOCHMALS klicken auf den Button f\u00fcr die 'Erweiterte Suche' ...");
                        }
                        extendedSearch = null;
                        formData = (HtmlForm)dataPage.getFirstByXPath("//form[@method='post']");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: formData: " + formData);
                        ExtendedSearchButton = dataPage.getAnchorByText("Erweiterte Suche");
                        try {
                            extendedSearch = (HtmlPage)ExtendedSearchButton.click();
                            extendedSearch = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                            extendedSearch.refresh();
                            syncWebClient.waitForBackgroundJavaScript(5000L);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: extendedSearch: " + extendedSearch);
                            extendedSearchXML = extendedSearch.asXml();
                            if (!extendedSearchXML.contains("Access Denied Page")) {
                                dataPage = extendedSearch.cloneNode(true);
                            }
                        }
                        catch (Exception error) {
                            throw new Exception("Fehler beim Aufruf der 'Erweiterten Suche' (siehe Log - Bitte nochmals versuchen und dann den Entwickler im Forum informieren)\nLog-Eintrag: " + error.getMessage());
                        }
                        if (++versuche != 10) continue;
                        isSelfException = true;
                        throw new Exception("'Erweiterte Suche' kann auch nach 10 Versuchen nicht angezeigt werden");
                    } while (extendedSearchXML.contains("Erweiterte Suche") || extendedSearchXML.contains("Access Denied Page") || !extendedSearchXML.contains(":salesForm:umsatzFilterOptionenAufklappbarSuchfeldPanel:accordion:vonBisDatum:datumForm:vonGruppe:vonDatum"));
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 35);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Setzen des Formulars f\u00fcr die Umsatzanzeige und Werte eintragen ...");
                try {
                    formData = (HtmlForm)extendedSearch.getFirstByXPath("//form[@method='post']");
                    AnfangDatumFeld = (HtmlInput)extendedSearch.getElementByName("umsatzanzeige" + Unterkonto + ":salesForm:umsatzFilterOptionenAufklappbarSuchfeldPanel:accordion:vonBisDatum:datumForm:vonGruppe:vonDatum");
                    AnfangDatumFeld.setValue(fromDateSimple);
                    ((DomElement)extendedSearch.getFirstByXPath("//a[@class='ui-slider-handle ui-state-default ui-corner-all']")).setAttribute("style", "left: 100%;");
                }
                catch (Exception error) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "... dabei ist ein Fehler aufgetreten ...");
                    throw new Exception("Fehler beim Setzen des Umsatz-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Feld mit Anfang-Datum: " + AnfangDatumFeld);
                DomElement FakeSubmit = extendedSearch.createElement("button");
                FakeSubmit.setAttribute("type", "submit");
                formData.appendChild((Node)FakeSubmit);
                extendedSearch = (HtmlPage)FakeSubmit.click();
                extendedSearch = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                ((DomElement)extendedSearch.getFirstByXPath("//a[@class='ui-slider-handle ui-state-default ui-corner-all']")).setAttribute("style", "left: 100%;");
                formData = (HtmlForm)extendedSearch.getFirstByXPath("//form[@method='post']");
                AnfangDatumFeld = (HtmlInput)extendedSearch.getElementByName("umsatzanzeige" + Unterkonto + ":salesForm:umsatzFilterOptionenAufklappbarSuchfeldPanel:accordion:vonBisDatum:datumForm:vonGruppe:vonDatum");
                AnfangDatumFeld.setValue(fromDateSimple);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "aktuell fokusiertes Element: " + extendedSearch.getFocusedElement());
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "setze Fokus auf Anfangs-Datum: " + extendedSearch.setFocusedElement((DomElement)AnfangDatumFeld) + " und ist nun: " + extendedSearch.getFocusedElement());
                AnfangDatumFeld.type('\n');
                extendedSearch.refresh();
                syncWebClient.waitForBackgroundJavaScript(5000L);
                extendedSearch = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                extendedSearchXML = extendedSearch.asXml();
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 40);
                if (extendedSearchXML.contains("keine Ums\u00e4tze")) {
                    int versuche = 0;
                    do {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] immer noch keine Ums\u00e4tze vorhanden, vielleicht nicht aktuell, daher NOCHMALS aufrufen ...");
                        try {
                            DomElement timeRangeSelector = (DomElement)extendedSearch.getFirstByXPath("//a[@class='ui-slider-handle ui-state-default ui-corner-all']");
                            if (timeRangeSelector != null) {
                                timeRangeSelector.setAttribute("style", "left: 100%;");
                            }
                            formData = (HtmlForm)extendedSearch.getFirstByXPath("//form[@method='post']");
                            AnfangDatumFeld = (HtmlInput)extendedSearch.getElementByName("umsatzanzeige" + Unterkonto + ":salesForm:umsatzFilterOptionenAufklappbarSuchfeldPanel:accordion:vonBisDatum:datumForm:vonGruppe:vonDatum");
                            AnfangDatumFeld.setValue(fromDateSimple);
                            FakeSubmit.setAttribute("type", "submit");
                            formData.appendChild((Node)FakeSubmit);
                            extendedSearch = (HtmlPage)FakeSubmit.click();
                            extendedSearch = (HtmlPage)syncWebClient.getCurrentWindow().getEnclosedPage();
                            ((DomElement)extendedSearch.getFirstByXPath("//a[@class='ui-slider-handle ui-state-default ui-corner-all']")).setAttribute("style", "left: 100%;");
                            formData = (HtmlForm)extendedSearch.getFirstByXPath("//form[@method='post']");
                            AnfangDatumFeld = (HtmlInput)extendedSearch.getElementByName("umsatzanzeige" + Unterkonto + ":salesForm:umsatzFilterOptionenAufklappbarSuchfeldPanel:accordion:vonBisDatum:datumForm:vonGruppe:vonDatum");
                            AnfangDatumFeld.setValue(fromDateSimple);
                            AnfangDatumFeld.type('\n');
                            extendedSearch.refresh();
                            syncWebClient.waitForBackgroundJavaScript(5000L);
                            extendedSearch = (HtmlPage)syncWebClient.getCurrentWindow().getTopWindow().getEnclosedPage();
                            MonitorSetPercent.invoke((Object)MonitorSetPercent, 45);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("Fehler beim Aufruf der Ums\u00e4tze (siehe Log - Bitte nochmals versuchen und dann den Entwickler im Forum informieren)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        if (++versuche != 3) continue;
                        LogInfo.invoke((Object)LogInfo, "Nach drei Versuchen keine  Ums\u00e4tze vorhanden, daher wohl war");
                        break;
                    } while (extendedSearchXML.contains("keine Ums\u00e4tze"));
                }
                HtmlAnchor csvExportButton = dataPage.getAnchorByText("CSV herunterladen");
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "CSV laden - Click " + csvExportButton);
                try {
                    csv = csvExportButton.click();
                    syncWebClient.waitForBackgroundJavaScript(5000L);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "getTransactionData: csv: " + csv);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:Postbank] " + getLogMethod + "CSV-Dateiabruf mit Windows-1252 Zeichen-Codierung aufbereiten ...");
                dataResponse = csvResponse = csv.getWebResponse().getContentAsString(Charset.forName("Cp1252"));
                syncWebClient.getCurrentWindow().setEnclosedPage((Page)extendedSearch);
            }
            try {
                WebUtils_oldSite.checkResponse(dataResponse, csv, ExternalLogger, ExternalProgressMonitor, ExternalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + dataResponse + "\n======================= END DATA =======================\n");
            if (dataResponse.contains("<html") || dataResponse.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[][] csvDataRow = StringCharUtils.data2matrixArray(dataResponse, '\"', ';', ExternalLogger);
            double amount = Double.NaN;
            boolean foundAmount = false;
            for (int i = 0; i < csvDataRow.length; ++i) {
                if (csvDataRow[i].length <= 0 || !csvDataRow[i][0].equals("Aktueller Kontostand")) continue;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Saldo des RAW-Kontoauszuges (CSVDataRow): " + csvDataRow[i][1]);
                if (StringCharUtils.isNullOrEmptyOrNothing(csvDataRow[i][1])) {
                    throw new Exception("Guthaben von der Postbank AG nicht angegeben! Fehlt im Kontoauszug");
                }
                amount = Double.parseDouble(StringCharUtils.shrinkString(csvDataRow[i][1]).replaceAll("[A-Za-z]+", "").replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a4", "").replaceAll("\u00a0", "").replaceAll("\u20ac", "").replaceAll("&euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim());
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Amount: " + amount);
                foundAmount = true;
                break;
            }
            if (!foundAmount) {
                throw new Exception("Guthaben von der Postbank AG nicht gefunden! (Bitte dem Entwickler im Forum melden)");
            }
            String[] DataResponse = new String[]{dataResponse, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(dataResponse, '\"', ';', ExternalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] CheckColumn = matrixArrayData[i][0].trim().split("\\.");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].trim().split("\\.");
                    Date fixDate = null;
                    fixDate = Unterkonto.length() == 16 ? SysUtils.getDate(Integer.parseInt(arraydatum[2], 10) + 2000, Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)) : SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(fixDate);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].trim().split("\\.");
                    Date valueDate = null;
                    valueDate = Unterkonto.length() == 16 ? SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10) + 2000, Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)) : SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(valueDate);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double Betrag = Double.NaN;
                    Betrag = Unterkonto.length() == 16 ? Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][5]).replaceAll("[A-Za-z]+", "").replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a4", "").replaceAll("\u00a0", "").replaceAll("\u20ac", "").replaceAll("&euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim()) : Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][6]).replaceAll("[A-Za-z]+", "").replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a4", "").replaceAll("\u00a0", "").replaceAll("\u20ac", "").replaceAll("&euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim());
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    if (Unterkonto.length() == 16) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][7]).replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a4", "").replaceAll("\u00a0", "").replaceAll("\u20ac", "").replaceAll("&euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim()));
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (Unterkonto.length() == 16) {
                        if (String.valueOf(Betrag).indexOf("-") == -1) {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add("Gutschrift / Einzahlung");
                        } else {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add("Abrechnung");
                        }
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][2]);
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (Unterkonto.length() == 16) {
                        String purpvalue = "";
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][2])) {
                            purpvalue = purpvalue + StringCharUtils.shrinkString(matrixArrayData[i][2].replaceAll("\\<.*?\\>", ""));
                        }
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(purpvalue);
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][3].replaceAll("\\<.*?\\>", "").replace("Verwendungszweck", "").replace("Referenz NOTPROVIDED", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][2]);
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (Unterkonto.length() == 16) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][4]) && !matrixArrayData[i][4].equals(matrixArrayData[1][1])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][4]);
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][5]) && !matrixArrayData[i][5].equals(matrixArrayData[1][1])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][5]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (Unterkonto.length() == 16) {
                        String notevalue = "";
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][3])) {
                            notevalue = notevalue + "W\u00e4hrung: " + StringCharUtils.shrinkString(matrixArrayData[i][3].replaceAll("\\<.*?\\>", "") + " ");
                        }
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][4])) {
                            notevalue = notevalue + " Kurs: " + StringCharUtils.shrinkString(matrixArrayData[i][4].replaceAll("\\<.*?\\>", ""));
                        }
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(notevalue));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", ExternalLogger, ExternalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("Postbank", kontonummer, amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

