/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.postbanktask;

import de.derrichter.finance.websync.institute.postbanktask.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    private static String logIdent = "[WebSync:Postbank] ";

    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(20L));
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        String loaderCatchString = "DummyLoaderCatchString";
        String loaderExclusion = "DummyLoaderExclution";
        String loaderPath = "DummyLoaderPath";
        String loaderText = "DummyLoaderText";
        LogInfo.invoke((Object)LogInfo, "[WebSync:Postbank] Eingestellte Kontoart '" + unterkonto + "' sollte nun abgerufen werden");
        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "fromDateSimple: " + fromDateSimple);
        Boolean isTagesgeld = false;
        Boolean isKreditkarte = false;
        Boolean isAnlage = false;
        Boolean isSparCard = false;
        try {
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Postbank] ", "Postbank AG", "institutlogo-postbankcreditcard.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            String modalDetectPath = "//div[@class='modal in show' or @class='modal show' and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
            try {
                String detectPath = modalDetectPath;
                String messagePath = detectPath + "//h2";
                String closePath = detectPath + "//button[@class='close']";
                boolean hasAbortButton = false;
                do {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Postbank] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPath)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                    String formWarnText = "";
                    List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)messagePath));
                    for (WebElement headline : allHeadlines) {
                        String headlinetext = headline.getText();
                        formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:Postbank] ", headlinetext, externalLogger) + " ";
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "warnText: " + formWarnText);
                    if (!formWarnText.contains("Freigabeverfahren verwalten")) {
                        // empty if block
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                    try {
                        wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closePath)));
                    }
                    catch (NoSuchElementException | TimeoutException notAborterr) {
                        hasAbortButton = false;
                        isSelfException = true;
                        throw new Exception("Im Onlinebanking muss auf folgende Meldung reagiert werden: " + formWarnText.trim());
                    }
                    hasAbortButton = true;
                    LogWarn.invoke((Object)LogWarn, "[WebSync:Postbank] Meldung(en) der Bank: " + formWarnText);
                    MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (hasAbortButton);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:Postbank] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
            }
            try {
                String messagePath = "//div[@id='splashPage']";
                String nextButtonPath = "//span[text()='Weiter']//parent::button";
                String readConfirmPath = "//span[text()='Ich habe die Informationen gelesen.' or text()='Als gelesen markieren']//ancestor::div//label";
                boolean hasContinueButton = false;
                do {
                    LogInfo.invoke((Object)LogInfo, logIdent + "Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)messagePath)));
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                    String warnHeader = seleniumWebDriver.findElement(By.xpath((String)(messagePath + "//header"))).getText();
                    String formWarnText = StringCharUtils.formMessageText(logIdent, seleniumWebDriver.findElement(By.xpath((String)(messagePath + "//ancestor::section//section"))).getText(), externalLogger);
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "warnText: " + formWarnText);
                    DialogWarn.invoke((Object)DialogWarn, "Wichtige Meldung der Postbank AG:\n\n\n" + warnHeader + "\n\n" + formWarnText + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://banking.postbank.de/#/login" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-postbankcreditcard.png");
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)nextButtonPath)));
                    }
                    catch (NoSuchElementException | TimeoutException notAborterr) {
                        hasContinueButton = false;
                        isSelfException = true;
                        throw new Exception(warnHeader + " " + formWarnText);
                    }
                    hasContinueButton = true;
                    LogWarn.invoke((Object)LogWarn, logIdent + "Wichtige Meldung der Bank: " + formWarnText);
                    MonitorLog.invoke((Object)MonitorLog, "Wichtige Meldung der Bank: " + formWarnText);
                    try {
                        try {
                            wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)readConfirmPath)));
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "readCheckbox", readConfirmPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                        }
                        catch (NoSuchElementException | TimeoutException haveReadError) {
                            LogInfo.invoke((Object)LogInfo, logIdent + "Keine Checkbox zum Best\u00e4tigen des Lesens der Information vorhanden. OK");
                        }
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "continueButton", nextButtonPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    }
                    catch (Exception clickerror) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)clickerror));
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (hasContinueButton);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogInfo.invoke((Object)LogInfo, logIdent + "Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Check ob in der Konto\u00fcbersicht der Willkommen-Seite die Kontonummer enthalten ist ...");
            String checkKontonummer = null;
            if (unterkonto.equals("Tagesgeld") || unterkonto.equals("Spar") || unterkonto.equals("Anlage")) {
                checkKontonummer = StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer);
            } else if (unterkonto.length() == 16) {
                checkKontonummer = unterkonto.substring(0, 4) + " **** **** " + unterkonto.substring(12, 16);
            } else {
                isSelfException = true;
                throw new Exception("Keine auswertbare Kontokonfiguration erhalten. (Angabe zu Unterkonto oder Kreditkarte)");
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "Formatierte Kontonummer/Kartennummer oder IBAN die gesucht wird: " + checkKontonummer);
            String userAccountPath = "//cirrus-product-list-item[contains(.,'" + checkKontonummer + "')]";
            try {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundene Kontodaten: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)userAccountPath))));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Abbruch: Ihre angegebene Konto- bzw. Kartennummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
            WebElement nextButton = null;
            String nextButtonPath = "//span[text()='Weiter']//parent::button";
            try {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Weiter-Button: " + wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)nextButtonPath))));
                nextButton = seleniumWebDriver.findElement(By.xpath((String)nextButtonPath));
                boolean haveNextButton = true;
                while (haveNextButton) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Click " + nextButton);
                    nextButton.click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(500L);
                    try {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Weiter-Button: " + wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)nextButtonPath))));
                        nextButton = seleniumWebDriver.findElement(By.xpath((String)nextButtonPath));
                    }
                    catch (NoSuchElementException | TimeoutException notFounderr) {
                        isSelfException = true;
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Postbank] Weiter-Button wurde nicht gefunden.  xPathExpression " + nextButtonPath + " ergab kein Ergebnis");
                        haveNextButton = false;
                    }
                }
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                LogInfo.invoke((Object)LogInfo, "[WebSync:Postbank] Weiter-Button wurde nicht gefunden.  xPathExpression " + nextButtonPath + " ergab kein Ergebnis");
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Headless-Browser Exception: (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Postbank] ", "Postbank AG", "institutlogo-postbankcreditcard.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            WebElement accountButton = null;
            try {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Kontoverweis: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)userAccountPath))));
                accountButton = seleniumWebDriver.findElement(By.xpath((String)userAccountPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Click " + accountButton);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountButton", userAccountPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                Thread.sleep(1000L);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Verweis zum Umsatz\u00fcbersicht wurde nicht gefunden.  xPathExpression " + userAccountPath + " ergab kein Ergebnis");
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 30);
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            String dataResponse = "";
            if (unterkonto.equals("Spar")) {
                isSparCard = true;
            }
            if (unterkonto.equals("Tagesgeld")) {
                isTagesgeld = true;
            } else if (unterkonto.length() == 16) {
                isKreditkarte = true;
            } else if (unterkonto.equals("Anlage")) {
                isAnlage = true;
            }
            if (isSparCard.booleanValue() || isAnlage.booleanValue() || isTagesgeld.booleanValue()) {
                String actionButtonPath = "//span[contains(text(),'Kontoaktionen anzeigen')]/parent::span/parent::button";
                WebElement actionButton = null;
                try {
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Kontoaktions-Button: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)actionButtonPath))));
                    actionButton = (WebElement)seleniumWebDriver.findElements(By.xpath((String)actionButtonPath)).get(1);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Click " + actionButton);
                    actionButton.click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (IndexOutOfBoundsException | NoSuchElementException | TimeoutException notFounderr) {
                    isSelfException = true;
                    throw new Exception("Kontoaktions-Button wurde nicht gefunden.  xPathExpression " + actionButtonPath + " ergab kein Ergebnis");
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String downloadButtonPath = "//button[contains(text(),'CSV herunterladen')]";
                WebElement downloadButton = null;
                try {
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Download-Button: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)downloadButtonPath))));
                    downloadButton = (WebElement)seleniumWebDriver.findElements(By.xpath((String)downloadButtonPath)).get(1);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Click " + downloadButton);
                    downloadButton.click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (IndexOutOfBoundsException | NoSuchElementException | TimeoutException notFounderr) {
                    isSelfException = true;
                    throw new Exception("Download-Button wurde nicht gefunden.  xPathExpression " + downloadButtonPath + " ergab kein Ergebnis");
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String downloadResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(downloadResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                File downloadedFile = null;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                do {
                    Thread.sleep(500L);
                    int waiter = 0;
                    do {
                        if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                        Thread.sleep(1000L);
                        ++waiter;
                    } while (downloadedFile == null && waiter < 30);
                    if (downloadedFile != null && downloadedFile.exists()) continue;
                    isSelfException = true;
                    throw new Exception("Download eines Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                String fileResponse = "";
                String fileencoding = "windows-1252";
                fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                LogTrace.invoke((Object)LogTrace, logIdent + getLogMethod + "fileResponse: \n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                if (!fileencoding.equals("UTF-8")) {
                    LogInfo.invoke((Object)LogInfo, logIdent + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                    byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                    dataResponse = new String(filebytes, System.getProperty("file.encoding"));
                } else {
                    dataResponse = fileResponse;
                }
                FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
            } else if (isKreditkarte.booleanValue()) {
                String amountText = null;
                String availableAmountText = null;
                try {
                    String amountPath = "//div[contains(@class,'account-balance')]";
                    String availableAmountPath = "//div[contains(text(),'Kartenlimit')]/following::cirrus-value-or-placeholder-text[contains(text(),'EUR')]";
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "read amount ...");
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)amountPath)));
                    amountText = seleniumWebDriver.findElement(By.xpath((String)amountPath)).getText();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "amountText: " + amountText);
                    amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "amount: " + amount);
                    if (isKreditkarte.booleanValue()) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "read available amount ...");
                        String detailsButtonPath = "//a[contains(.,'Details')]";
                        wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detailsButtonPath)));
                        WebElement accountDetails = seleniumWebDriver.findElement(By.xpath((String)detailsButtonPath));
                        accountDetails.click();
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)availableAmountPath)));
                        availableAmountText = seleniumWebDriver.findElement(By.xpath((String)availableAmountPath)).getText();
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "availableCreditText: " + availableAmountText);
                        availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "availableAmount: " + (availableAmount -= amount));
                        WebElement accountDetailsClose = seleniumWebDriver.findElement(By.xpath((String)(modalDetectPath + "//button[@class='close']")));
                        accountDetailsClose.click();
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        Thread.sleep(500L);
                    } else {
                        availableAmount = amount;
                    }
                }
                catch (Exception amountError) {
                    isSelfException = true;
                    throw new Exception("Auslesen des Kontostands fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)amountError));
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                Date maxDate = sdf.parse(fromDateSimple);
                if (isKreditkarte.booleanValue()) {
                    String moreButtonPath = "//db-button[contains(.,'Weitere Ums\u00e4tze laden')]";
                    String lastDate = "(//cirrus-transaction-row[@data-test='transactionsRow'])[last()]//div[@data-test='transactionRowDate']";
                    boolean more = true;
                    do {
                        try {
                            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Weitere-Button: " + wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)moreButtonPath))));
                            String lastDateText = seleniumWebDriver.findElement(By.xpath((String)lastDate)).getText();
                            Date strDate = sdf.parse(lastDateText);
                            if (strDate.before(maxDate)) {
                                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Abrufzeitraum \u00fcberschritten, stoppe Aufruf weiterer Ums\u00e4tze");
                                more = false;
                                break;
                            }
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "moreButton", moreButtonPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            Thread.sleep(1000L);
                        }
                        catch (NoSuchElementException | TimeoutException notFounderr) {
                            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Weitere-Button-Button wurde nicht (mehr) gefunden.  xPathExpression " + moreButtonPath + " ergab kein Ergebnis");
                            more = false;
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                    } while (more);
                    dataResponse = "Kontoauszug vom " + toDateSimple + "\n\nKarte;" + unterkonto + "\nAktueller Kontostand;" + amountText + "\nAktuell verf\u00fcgbar;" + availableAmountText + "\n\n\nKauf;Buchung;Ort;W\u00e4hrung;Kurs;Betrag EUR\n";
                } else {
                    String filter = "//span[contains(text(),'Filtern')]/parent::button";
                    try {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Filter-Button: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)filter))));
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterButton", filter, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                    }
                    catch (NoSuchElementException | TimeoutException notFounderr) {
                        isSelfException = true;
                        throw new Exception("Filter-Button wurde nicht gefunden.  xPathExpression " + filter + " ergab kein Ergebnis");
                    }
                    String selectorButtonPath = "//*[@id='selectTransactionTimePeriodFilter']";
                    try {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Zeitraum-Select: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"selectTransactionTimePeriodFilter"))));
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "selectorButton", selectorButtonPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                    }
                    catch (NoSuchElementException | TimeoutException notFounderr) {
                        isSelfException = true;
                        throw new Exception("Zeitraum-Select wurde nicht gefunden.  xPathExpression " + selectorButtonPath + " ergab kein Ergebnis");
                    }
                    String filterSelfPath = "//div[contains(text(),'Eigener Zeitraum')]/parent::label/parent::li";
                    try {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Filter-Eintrag: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)filterSelfPath))));
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterSelfEntry", filterSelfPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                    }
                    catch (NoSuchElementException | TimeoutException notFounderr) {
                        isSelfException = true;
                        throw new Exception("Filter-Eintrag wurde nicht gefunden.  xPathExpression " + filterSelfPath + " ergab kein Ergebnis");
                    }
                    String fromInputPath = "//input[contains(@id,'datePicker1Input')]";
                    String toInputPath = "//input[contains(@id,'datePicker2Input')]";
                    String filterButtonPath = "//span[contains(text(),'Filtern')]/parent::button[contains(@class,'c-button--primary')]";
                    seleniumWebDriver = SeleniumUtils.fillDateRangeSearchFields(seleniumWebDriver, logIdent, "Postbank AG", "institutlogo-postbankcreditcard.png", fromDateSimple, toDateSimple, fromInputPath, toInputPath, filterButtonPath, false, loaderCatchString, loaderExclusion, loaderPath, loaderText, externalLogger, externalProgressMonitor, externalDialogInterface);
                    dataResponse = "Kontoauszug vom " + toDateSimple + "\n\nKonto;" + unterkonto + "\nAktueller Kontostand;" + amountText + "\nAktuell verf\u00fcgbar;" + availableAmountText + "\n\n\nBuchung;Wertstellung;Verwendungszweck;IBAN;BIC;Betrag EUR;Umsatzart;Name\n";
                }
                String transDetailsPath = "";
                String closeDetailPath = "";
                String betragPath = "";
                String titlePath = "";
                String purpPath = "";
                String bookingDatePath = "";
                String valutaDatePath = "";
                String namePath = "";
                String ibanPath = "";
                String bicPath = "";
                String artPath = "";
                String curBetragPath = "";
                String curChangePath = "";
                if (isKreditkarte.booleanValue()) {
                    transDetailsPath = "//cirrus-transaction-row";
                    closeDetailPath = modalDetectPath + "//button[@class='close']";
                    titlePath = "//cirrus-transaction-details-page//div[@data-test='leftContent']";
                    betragPath = "//cirrus-transaction-details-page//div[@data-test='rightContent']";
                    purpPath = "//cirrus-transaction-details-page//div[@data-test='remittanceInformation']";
                    bookingDatePath = "//cirrus-transaction-details-page//div[@data-test='receiptDate']";
                    valutaDatePath = "//cirrus-transaction-details-page//div[@data-test='voucherDate']";
                    curBetragPath = "//cirrus-transaction-details-page//div[@data-test='originalAmount']";
                    curChangePath = "//cirrus-transaction-details-page//div[@data-test='conversionRate']";
                } else {
                    transDetailsPath = "//cirrus-transaction-row";
                    closeDetailPath = modalDetectPath + "//button[@class='close']";
                    titlePath = "//cirrus-transaction-details-page//div[@data-test='leftContent']";
                    betragPath = "//div[@class='u-text-negative' or @class='u-text-positive']";
                    purpPath = "//cirrus-transaction-details-page//div[@data-test='remittanceInformation']";
                    bookingDatePath = "//cirrus-transaction-details-page//div[@data-test='receiptDate']";
                    valutaDatePath = "//cirrus-transaction-details-page//div[@data-test='voucherDate']";
                    namePath = "//cirrus-transaction-details-page//div[@data-test='leftContent']";
                    ibanPath = "(//div[@class='c-description-list__desc'])[4]";
                    bicPath = "(//div[@class='c-description-list__desc'])[5]";
                    artPath = "(//div[@class='c-description-list__desc'])[6]";
                }
                try {
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundene Ums\u00e4tze: " + wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)transDetailsPath))));
                    List translinks = seleniumWebDriver.findElements(By.xpath((String)transDetailsPath));
                    LogInfo.invoke((Object)LogInfo, logIdent + getLogMethod + "Anzahl der gefundenen Transaktionen auf der Seite: " + String.valueOf(translinks.size()));
                    for (int i = 0; i < translinks.size(); ++i) {
                        double MonitorPercent = 30.0 + 29.0 / (double)translinks.size() * (double)(i + 1);
                        MonitorSetPercent.invoke((Object)MonitorSetPercent, (int)MonitorPercent);
                        ((WebElement)translinks.get(i)).click();
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)titlePath)));
                        if (isKreditkarte.booleanValue()) {
                            String titlePathText = "";
                            String purpPathText = "";
                            String betragPathText = "";
                            String bookingDatePathText = "";
                            String valutaDatePathText = "";
                            String curBetragPathText = "";
                            String curChangePathText = "";
                            try {
                                bookingDatePathText = seleniumWebDriver.findElement(By.xpath((String)bookingDatePath)).getText();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "bookingDatePathText: " + bookingDatePathText);
                                valutaDatePathText = seleniumWebDriver.findElement(By.xpath((String)valutaDatePath)).getText();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "valutaDatePathText: " + valutaDatePathText);
                                titlePathText = seleniumWebDriver.findElement(By.xpath((String)titlePath)).getText();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "titlePathText: " + titlePathText);
                                try {
                                    purpPathText = seleniumWebDriver.findElement(By.xpath((String)purpPath)).getText();
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "purpPathText: " + purpPathText);
                                }
                                catch (NoSuchElementException | TimeoutException notFound) {
                                    isSelfException = true;
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "Datenfeld f\u00fcr Verwendungszweck nicht vorhanden oder nicht gefunden");
                                }
                                betragPathText = seleniumWebDriver.findElement(By.xpath((String)betragPath)).getText();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "betragPathText: " + betragPathText);
                            }
                            catch (NoSuchElementException | TimeoutException notFound) {
                                isSelfException = true;
                                throw new Exception("Eines der Haupt-Datenfelder konnte nicht gelesen werden: " + notFound.getMessage());
                            }
                            try {
                                curBetragPathText = seleniumWebDriver.findElement(By.xpath((String)curBetragPath)).getText();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "curBetragPathText: " + curBetragPathText);
                                curChangePathText = seleniumWebDriver.findElement(By.xpath((String)curChangePath)).getText();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "curChangePathText: " + curChangePathText);
                            }
                            catch (NoSuchElementException | TimeoutException notFound) {
                                isSelfException = true;
                                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "Datenfelder f\u00fcr Auslandseinsatz nicht vorhanden oder nicht gefunden");
                            }
                            purpPathText = titlePathText.contains("AUSLANDSEINSATZENTG") || titlePathText.contains("JAHRESGEBUEHR") ? titlePathText + "" + purpPathText : titlePathText + " / " + purpPathText;
                            dataResponse = dataResponse + bookingDatePathText + ";" + valutaDatePathText + ";" + purpPathText + ";" + curBetragPathText + ";" + curChangePathText + ";" + betragPathText + "\n";
                        } else {
                            String purpPathText = "";
                            String betragPathText = "";
                            String bookingDatePathText = "";
                            String valutaDatePathText = "";
                            String namePathText = "";
                            String ibanPathText = "";
                            String bicPathText = "";
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "openDetailDialog", "(" + transDetailsPath + ")[" + (i + 1) + "]", loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            bookingDatePathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)bookingDatePath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "bookingDatePathText: " + bookingDatePathText);
                            valutaDatePathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)valutaDatePath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "valutaDatePathText: " + valutaDatePathText);
                            purpPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)purpPath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "purpPathText: " + purpPathText);
                            namePathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)namePath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "namePathText: " + namePathText);
                            ibanPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)ibanPath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "ibanPathText: " + ibanPathText);
                            bicPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)bicPath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "bicPathText: " + bicPathText);
                            betragPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)betragPath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "betragPathText: " + betragPathText);
                            String artPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)artPath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "artPathText: " + artPathText);
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "closeDetailDialog", closeDetailPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            dataResponse = dataResponse + bookingDatePathText + ";" + valutaDatePathText + ";" + artPathText + ";" + purpPathText + ";" + namePathText + ";;" + betragPathText + ";;" + ibanPathText + ";" + bicPathText + "\n";
                        }
                        WebElement closeButton = seleniumWebDriver.findElement(By.xpath((String)closeDetailPath));
                        String transDateText = seleniumWebDriver.findElement(By.xpath((String)valutaDatePath)).getText();
                        Date strDate = sdf.parse(transDateText);
                        if (strDate.before(maxDate)) {
                            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Abrufzeitraum \u00fcberschritten, stoppe Auslesen weiterer Ums\u00e4tze");
                            closeButton.click();
                            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        }
                        closeButton.click();
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    }
                }
                catch (TimeoutException notFounderr) {
                    isSelfException = true;
                    throw new Exception("Vermutlich Titel des Umsatzes nicht gefunden oder anderer Auslesefehler: " + ExceptionUtils.getStackTrace((Throwable)notFounderr));
                }
            } else {
                isSelfException = true;
                throw new Exception("Keine auswertbare Kontokonfiguration erhalten. (Angabe zu Unterkonto oder Kreditkarte)");
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + dataResponse + "\n======================= END DATA =======================\n");
            if (dataResponse.contains("<html") || dataResponse.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[][] dataRow = StringCharUtils.data2matrixArray(dataResponse, '\"', ';', externalLogger);
            boolean foundAmount = false;
            for (int i = 0; i < dataRow.length; ++i) {
                if (dataRow[i].length <= 0 || !dataRow[i][0].equals("Aktueller Kontostand")) continue;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Saldo des RAW-Kontoauszuges (CSVDataRow): " + dataRow[i][1]);
                if (StringCharUtils.isNullOrEmptyOrNothing(dataRow[i][1])) {
                    throw new Exception("Guthaben von der Postbank AG nicht angegeben! Fehlt im Kontoauszug");
                }
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(dataRow[i][1], externalLogger));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "Amount: " + amount);
                foundAmount = true;
                break;
            }
            if (!foundAmount) {
                throw new Exception("Guthaben von der Postbank AG nicht gefunden! (Bitte dem Entwickler im Forum melden)");
            }
            if (unterkonto.equals("Tagesgeld") || unterkonto.equals("Spar") || unterkonto.equals("Anlage")) {
                availableAmount = amount;
            }
            String[] dataResponseArray = new String[]{dataResponse, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(dataResponse, '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] CheckColumn = matrixArrayData[i][0].trim().split("\\.");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].trim().split("\\.");
                    Date fixDate = null;
                    fixDate = SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(fixDate);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].trim().split("\\.");
                    Date valueDate = null;
                    valueDate = SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(valueDate);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.NaN;
                    betrag = isKreditkarte != false ? Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][5], externalLogger)) : Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][6], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    double saldo = Double.NaN;
                    saldo = isKreditkarte != false ? Double.parseDouble("0") : Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][7], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(saldo);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (isKreditkarte.booleanValue()) {
                        if (String.valueOf(betrag).indexOf("-") == -1) {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add("Gutschrift / Einzahlung");
                        } else {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add("Abrechnung");
                        }
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][2]);
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    if (isKreditkarte.booleanValue()) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][2].replaceAll("\\<.*?\\>", "").replace("Verwendungszweck", "").replace("Referenz NOTPROVIDED", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][3].replaceAll("\\<.*?\\>", "").replace("Verwendungszweck", "").replace("Referenz NOTPROVIDED", "")));
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String iban = "";
                    if (isKreditkarte.booleanValue() || isAnlage.booleanValue() || isTagesgeld.booleanValue()) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    } else {
                        iban = StringCharUtils.shrinkString(matrixArrayData[i][8]).replace(" ", "");
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(iban);
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    String bic = "";
                    if (isKreditkarte.booleanValue() || isAnlage.booleanValue() || isTagesgeld.booleanValue()) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    } else {
                        bic = StringCharUtils.shrinkString(matrixArrayData[i][9]).replace(" ", "");
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(bic);
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (isKreditkarte.booleanValue()) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(iban) && !iban.substring(12).equals(kontonummer)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][4]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    if (isKreditkarte.booleanValue() || isAnlage.booleanValue() || isTagesgeld.booleanValue()) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(iban) && !iban.substring(12).equals(kontonummer)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(iban.substring(12));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    if (isKreditkarte.booleanValue() || isAnlage.booleanValue() || isTagesgeld.booleanValue()) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(iban) && !iban.substring(12).equals(kontonummer)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(iban.substring(4, 12));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (isKreditkarte.booleanValue() || isAnlage.booleanValue()) {
                        String noteValue = "";
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][3]) && !StringCharUtils.shrinkString(matrixArrayData[i][3]).equals("-")) {
                            noteValue = noteValue + "W\u00e4hrung: " + StringCharUtils.shrinkString(matrixArrayData[i][3].replaceAll("\\<.*?\\>", "") + " ");
                        }
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][4]) && !StringCharUtils.shrinkString(matrixArrayData[i][4]).equals("1")) {
                            noteValue = noteValue + " Kurs: " + StringCharUtils.shrinkString(matrixArrayData[i][4].replaceAll("\\<.*?\\>", ""));
                        }
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(noteValue));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Postbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("Postbank", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

