/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.postbanktask;

import de.derrichter.finance.websync.institute.postbanktask.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    private static String logIdent = "[[WebSync:Postbank] ] ";

    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait30 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:Postbank] " + getLogMethod + "Postbank" + "-Login aufrufen ... (GET " + "https://banking.postbank.de/#/login" + ")");
            try {
                seleniumWebDriver.get("https://banking.postbank.de/#/login");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            Thread.sleep(2000L);
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Postbank] ", "Postbank AG", "institutlogo-postbankcreditcard.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            try {
                String userIDpath = "//input[contains(@id,'db-input')]";
                wait30.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)userIDpath)));
                WebElement postbankId = seleniumWebDriver.findElement(By.xpath((String)userIDpath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "postbankId: " + postbankId);
                WebElement submitID = seleniumWebDriver.findElement(By.xpath((String)"//button[contains(@class,'db-button')]"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "submitID: " + submitID);
                postbankId.click();
                postbankId.sendKeys(new CharSequence[]{responseLogin});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                String oldBanking = "//button[contains(@data-test-anchor,'migrationwizard')]";
                WebElement oldBankingButton = null;
                try {
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Verweis zum bisherigen Online-Banking: " + wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)oldBanking))));
                    oldBankingButton = seleniumWebDriver.findElement(By.xpath((String)oldBanking));
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogDebug.invoke((Object)LogDebug, "OK. Button zum bisherigen Online-Banking nicht gefunden. xPathExpression " + oldBanking + " ergab kein Ergebnis");
                }
                if (!submitID.isEnabled() || oldBankingButton != null) {
                    isSelfException = true;
                    throw new Exception("Um das Postbank Banking nutzen zu k\u00f6nnen, legen Sie sich bitte hier eine Postbank ID an: https://meine.postbank.de/#/migrationsassistent");
                }
            }
            catch (Exception error) {
                if (isSelfException) {
                    throw new Exception(error.getMessage());
                }
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des PostbankID-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            Thread.sleep(1000L);
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Postbank] ", "Postbank AG", "institutlogo-postbankcreditcard.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            try {
                String loginButtonPath = "//button[contains(@class,'primary')]";
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitUsername", loginButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                WebUtils.waitButtonLoader(seleniumWebDriver, loginButtonPath, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                try {
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Das Standart-Sicherheitsverfahren wird angefragt, Authentifizierungsaufforderung wird angezeigt ..." + wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//span[contains(.,'Um sich mit Ihrer Postbank ID') and contains(.,'legitimieren Sie sich bitte')]"))));
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//span[contains(.,'BestSign')] | //div[contains(.,'Ihrer BestSign App')]")));
                        WebUtils.authBestSign(seleniumWebDriver, false, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (NoSuchElementException | TimeoutException noBestSign) {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Sicherheitsverfahren BestSign wird NICHT angeboten ...");
                    }
                    Thread.sleep(1000L);
                    SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Postbank] ", "Postbank AG", "institutlogo-postbankcreditcard.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"button_chipTan")));
                        WebUtils.authChipTAN(seleniumWebDriver, false, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (NoSuchElementException | TimeoutException noChipTan) {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Sicherheitsverfahren chipTan wird NICHT angeboten ...");
                    }
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"button_mobileTan")));
                        WebUtils.authMTAN(seleniumWebDriver, false, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (NoSuchElementException | TimeoutException noMTan) {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Sicherheitsverfahren mobileTan wird NICHT angeboten ...");
                    }
                }
                catch (NoSuchElementException | TimeoutException defaultMethod) {
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Scheinbar kein Standard-Sicherheitsverfahren eingestellt, mache mit Authentifizierung mit Passwort weiter ...");
                    Thread.sleep(2000L);
                    SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Postbank] ", "Postbank AG", "institutlogo-postbankcreditcard.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                    try {
                        String passPath = "//input[contains(@id,'db-input')]";
                        wait30.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)passPath)));
                        WebElement inputPasswd = seleniumWebDriver.findElement(By.xpath((String)passPath));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "inputPasswd: " + inputPasswd);
                        inputPasswd.click();
                        inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("Fehler beim Setzen des Passwort-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitPassword", "//button[contains(@class,'db-button--primary')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        WebUtils.waitButtonLoader(seleniumWebDriver, "//button[contains(@class,'db-button--primary')]", externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    Thread.sleep(2000L);
                    SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Postbank] ", "Postbank AG", "institutlogo-postbankcreditcard.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                }
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                try {
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//span[contains(.,'BestSign')] | //div[contains(.,'Ihrer BestSign App')]")));
                        WebUtils.authBestSign(seleniumWebDriver, false, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (NoSuchElementException | TimeoutException noBestSign) {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Sicherheitsverfahren BestSign wird NICHT angeboten ...");
                    }
                    Thread.sleep(2000L);
                    SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Postbank] ", "Postbank AG", "institutlogo-postbankcreditcard.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"button_chipTan")));
                        if (seleniumWebDriver.findElement(By.id((String)"button_chipTan")).getAttribute("outerHTML").contains("aria-selected=\"true\"")) {
                            WebUtils.authChipTAN(seleniumWebDriver, true, externalLogger, externalProgressMonitor, externalDialogInterface);
                        } else {
                            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Sicherheitsverfahren chipTan wird angeboten, der Tab ist aber nicht aktiv?! Versuche weiter ...");
                        }
                    }
                    catch (NoSuchElementException | TimeoutException noChipTan) {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Sicherheitsverfahren chipTan wird NICHT angeboten ...");
                    }
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"button_mobileTan")));
                        if (seleniumWebDriver.findElement(By.id((String)"button_mobileTan")).getAttribute("outerHTML").contains("aria-selected=\"true\"")) {
                            WebUtils.authMTAN(seleniumWebDriver, true, externalLogger, externalProgressMonitor, externalDialogInterface);
                        } else {
                            LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Sicherheitsverfahren mobileTan wird angeboten, der Tab ist aber nicht aktiv?! Versuche weiter ...");
                        }
                    }
                    catch (NoSuchElementException | TimeoutException noMTan) {
                        LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Sicherheitsverfahren mobileTan wird NICHT angeboten ...");
                    }
                }
                catch (NoSuchElementException | TimeoutException defaultMethod) {
                    LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Scheinbar war ein Standard-Sicherheitsverfahren eingestellt, mache mit Abruf weiter ...");
                }
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'db-input')]"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            catch (NoSuchElementException | TimeoutException throwable) {
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:Postbank] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(15L));
        try {
            JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
            jse.executeScript("window.scrollTo(document.body.scrollHeight,0)", new Object[0]);
            String logoutXpath = "//button[contains(@id,'logout')]";
            LogInfo.invoke((Object)LogInfo, "[WebSync:Postbank] " + getLogMethod + "Abmelden aufrufen durch klicken ... ");
            try {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Logout-Button: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)logoutXpath))));
                WebElement logoutButton = seleniumWebDriver.findElement(By.xpath((String)logoutXpath));
                logoutButton.click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Logout-Button nicht gefunden! xPathExpression \"" + logoutXpath + "\" ergab kein Ergebnis");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Postbank] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String successLogoutXpath = "//*[contains(.,'Sie haben sich erfolgreich abgemeldet')]";
            try {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, logIdent + getLogMethod + "Logout bei der '" + "Postbank AG" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:Postbank] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

