/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.paypal;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlSelect;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static String COOKIE_DETECT_PATH = "//div[contains(@id,'CookieBanner') and not(contains(@style,'none'))]";
    static String COOKIE_ACCEPT_PATH = "//button[@id='acceptAllButton']";
    static String LOADER_CATCHSTRING = "DummyCatchString";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//div[(contains(@class,'transitioning spinner')) and not(contains(@style,'none')) and not(@aria-busy='true')] | //p[contains(.,'L\u00e4dt...') and not(contains(@class,'hide'))]";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[1];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//p[contains(@class,'notification-critical') and not(contains(@style,'none')) and not(contains(@class,'hide'))]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "DummySearchStringExclusion";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String logIdent = "[WebSync:PayPal] ";
        String longName = "PayPal Pte. Ltd.";
        try {
            try {
                String warnDialogText = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'well-warning')]")).getText();
                DialogWarn.invoke((Object)DialogWarn, "Meldung der PayPal Pte. Ltd.:\n(Diese muss manuell im Onlinebanking best\u00e4tigt werden)\n\n\n" + warnDialogText, "institutlogo-paypal.png");
                warnDialogText = StringCharUtils.shrinkString(warnDialogText.replace(" x ", ""));
                throw new Exception(warnDialogText);
            }
            catch (NoSuchElementException noBestSign) {
                WebUtils.setSerchStrings();
                WebUtils.setSerchExclusionStrings();
                SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-paypal.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    static WebDriver callLoginURLpeformUsername(WebDriver seleniumWebDriver, String responseLogin, String responsePassword, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkIdentRequest] ";
        boolean isSelfException = false;
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "PayPal" + "-Login aufrufen ... (GET " + "https://www.paypal.com/signin?country.x=DE&locale.x=de_DE&langTgl=de" + ")");
            try {
                seleniumWebDriver.get("https://www.paypal.com/signin?country.x=DE&locale.x=de_DE&langTgl=de");
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            Thread.sleep(2000L);
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:PayPal] ", "PayPal Pte. Ltd.", "institutlogo-paypal.png", COOKIE_DETECT_PATH, COOKIE_ACCEPT_PATH, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, externalLogger);
            try {
                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"email")));
                WebElement inputUsername = seleniumWebDriver.findElement(By.id((String)"email"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "inputUsername: " + inputUsername);
                inputUsername.click();
                inputUsername.clear();
                inputUsername.sendKeys(new CharSequence[]{responseLogin});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("LoginForm-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    static WebDriver peformUsernameAndLogin(WebDriver seleniumWebDriver, String responseLogin, String responsePassword, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkIdentRequest] ";
        boolean isSelfException = false;
        try {
            try {
                try {
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//div[@id='splitPasswordSection' and not(contains(@class,'hide'))]")));
                }
                catch (TimeoutException noPassword) {
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[@id='btnNext']", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                }
                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"password")));
                WebElement inputPasswd = seleniumWebDriver.findElement(By.id((String)"password"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "inputPassword: " + inputPasswd);
                inputPasswd.click();
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[@id='btnLogin']", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("LoginForm-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    static boolean checkAndPeformReCaptcha(WebDriver seleniumWebDriver, String responseLogin, String responsePassword, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkCaptchaRequest] ";
        String tanArt = "reCaptcha-Request";
        String detectCaptchaPath = "//iframe[contains(@name,'captcha')]";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Pr\u00fcfen auf Captcha-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectCaptchaPath)));
                LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "reCaptcha-Abfrage erkannt, versuche dieses automatisch zu handeln...");
                MonitorLog.invoke((Object)MonitorLog, "reCaptcha-Abfrage erkannt, versuche dieses automatisch zu handeln...");
            }
            catch (TimeoutException noCaptcha) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + tanArt + " gestartet ... untersuche Abfrage ...");
                return false;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return false;
    }

    static boolean checkOtherCaptchaRequest(WebDriver seleniumWebDriver, String responseLogin, String responsePassword, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkCaptchaRequest] ";
        String tanArt = "Captcha-Request";
        String detectCaptchaPath = "//div[contains(@id,'captcha-standalone') or contains(@id,'signinCaptcha')] | //iframe[contains(@name,'captcha')]";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Pr\u00fcfen auf Captcha-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectCaptchaPath)));
                LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Captcha-Abfrage erkannt, der Login dauert daher etwas...");
                MonitorLog.invoke((Object)MonitorLog, "Captcha-Abfrage erkannt, der Login dauert daher etwas...");
            }
            catch (TimeoutException noCaptcha) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + tanArt + " gestartet ... untersuche Abfrage ...");
                return false;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return false;
    }

    static WebDriver checkIdentRequest(WebDriver seleniumWebDriver, String responseLogin, String responsePassword, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkIdentRequest] ";
        String tanArt = "Ident-Request";
        String detectCaptchaPath = "//div[contains(@id,'captcha-standalone') or contains(@id,'signinCaptcha')] | //iframe[contains(@name,'captcha')]";
        String detectSelectOptionsPath = "//div[contains(@class,'challengesForm')]";
        String selectSMSPath = "//input[@id='sms-challenge-option']";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Pr\u00fcfen auf Captcha-Verfahren der Zwei-Faktor-Authentifizierung ...");
            boolean isCaptcha = true;
            do {
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectCaptchaPath)));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Captcha-Abfrage erkannt, starte Login daher neu...");
                    MonitorLog.invoke((Object)MonitorLog, "Captcha-Abfrage erkannt, starte Login daher neu...");
                    WebUtils.callLoginURLpeformUsername(seleniumWebDriver, responseLogin, responsePassword, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (TimeoutException noCaptcha) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + tanArt + " gestartet ... untersuche Abfrage ...");
                    isCaptcha = false;
                }
            } while (isCaptcha);
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectSelectOptionsPath)));
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "selectSMS", selectSMSPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[contains(@class,'challenge-submit-button')]", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + tanArt + " gestartet ... untersuche Abfrage ...");
            }
            catch (TimeoutException noAuth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + tanArt + " wird NICHT (direkt) abgefragt oder hat sich ge\u00e4ndert? mache weiter ...");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    static WebDriver checkForMTAN(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkForMTAN] ";
        String tanArt = "mobileTAN";
        String detectTANformPath = "//div[contains(@class,'smsChallenge')]";
        String secTextPath = "//div[contains(@class,'smsChallenge')]";
        String tanInputPath = "//input[contains(@id,'answer')]";
        String submitTanPath = "//button[@id='securityCodeSubmit']";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                WebElement tanForm = seleniumWebDriver.findElement(By.xpath((String)detectTANformPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "tanForm: " + tanForm);
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "tanForm", detectTANformPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String secText = seleniumWebDriver.findElement(By.xpath((String)("(" + secTextPath + ")"))).getText().trim();
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "secText: " + secText);
                boolean retryInput = false;
                do {
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-paypal.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:PayPal] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTan", submitTanPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String pageAfterTanResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebElement checkWrongTAN = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'input-hint--error')]"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "checkWrongTAN: " + checkWrongTAN);
                        DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der PayPal Pte. Ltd.:\n\n\nDie eingegebene " + tanArt + " ist falsch.", "institutlogo-paypal.png");
                        retryInput = true;
                    }
                    catch (NoSuchElementException | TimeoutException wrongTAN) {
                        retryInput = false;
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfterTanResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (retryInput);
            }
            catch (TimeoutException noTANauth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt oder wurde umgebaut? mache weiter ...");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    static WebDriver checkForBankingApp(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[waitBankingApp] ";
        String tanArt = "BankingApp";
        String detectAppAuthPath = "//div[contains(.,'den Login in der Fidor Smart Banking App')]";
        String detectVerifiPath = "//div[contains(.,'Der Vorgang wird nun validiert')]";
        String detectAbortPath = "//p[contains(.,'Der Vorgang wurde abgebrochen')]";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectAppAuthPath)));
                LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Warte auf Banking-App Freigabe ...");
                MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                int rounds = 0;
                Thread.sleep(3000L);
                boolean showWaiting = true;
                boolean validating = false;
                while (true) {
                    WebElement waiterCheckElement = null;
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAppAuthPath));
                        showWaiting = true;
                    }
                    catch (NoSuchElementException noBestSign) {
                        showWaiting = false;
                    }
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectVerifiPath));
                        validating = true;
                    }
                    catch (NoSuchElementException noBestSign) {
                        validating = false;
                    }
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAbortPath));
                        isSelfException = true;
                        throw new Exception("Banking-App Authentifizierung: Der Vorgang wurde abgebrochen");
                    }
                    catch (NoSuchElementException noBestSign) {
                        if (showWaiting) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                            Thread.sleep(3000L);
                        } else if (validating) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Validierung des Vorgang im gange ...");
                            MonitorLog.invoke((Object)MonitorLog, "Validierung des Vorgang im gange ...");
                            SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                        } else {
                            showWaiting = false;
                            validating = false;
                        }
                        if (++rounds >= 39) {
                            isSelfException = true;
                            throw new Exception("Banking-App Authentifizierung auch nach 120 Sekunden nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                            continue;
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                        if (showWaiting || validating) continue;
                    }
                    break;
                }
            }
            catch (TimeoutException noAuth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + tanArt + "' wird NICHT (direkt) abgefragt oder hat sich ge\u00e4ndert? mache weiter ...");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            isSelfException = true;
            throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    public static String checkResponse(String responseContentAsString, Page responsePage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        boolean isSelfException = false;
        try {
            String errorResponse = null;
            String errorMessage = null;
            if (responseContentAsString.contains("Fehlermeldung")) {
                errorResponse = responsePage.getWebResponse().getContentAsString();
                errorMessage = WebUtils.formErrorMessage(errorResponse, externalLogger, externalProgressMonitor);
                if (errorMessage.indexOf("bereits einen entsprechenden Kontoauszug angefordert") != -1) {
                    errorMessage = '\"' + errorMessage + '\"' + "\n\n\nDies bedeuted nun aber auch dass Sie Ihre Ums\u00e4tze nicht mit der klassischen Methode abrufen k\u00f6nnen.\nHierf\u00fcr m\u00fcssen Sie in Ihrem Hibiscus-Konto Ihre API-Anmeldedaten einstellen und somit\ndie API-Schnittstelle von PayPal verwenden. Dies kann auch technisch emfohlen werden.\n\nWeiterf\u00fchrende Informationen finden Sie in der FAQ/Hilfe auf der Projekt-Homepage\n\n";
                }
                DialogError.invoke((Object)DialogError, "Fehlermeldung der PayPal Pte. Ltd.:\n\n\n" + errorMessage, "institutlogo-paypal.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("wurden automatisch vom System abgemeldet")) {
                isSelfException = true;
                throw new Exception("Die Online Banking Sitzung ist abgelaufen. Bitte melden Sie sich erneut an.");
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String formErrorMessage(String contentStringToParse, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[formErrorMessage] ";
        try {
            int errorTextIDXStart = 0;
            int errorTextIDXend = 0;
            errorTextIDXStart = contentStringToParse.indexOf("Fehlermeldung") + 13;
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
            errorTextIDXend = contentStringToParse.indexOf("</p>", errorTextIDXStart);
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "ErrorTextIDXend: " + errorTextIDXend);
            String ErrorText = contentStringToParse.substring(errorTextIDXStart, errorTextIDXend);
            LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "ErrorText (unformatiert): " + ErrorText);
            String formErrorText = ErrorText.replaceAll("<br/> ", "\n");
            formErrorText = formErrorText.replaceAll("<br/ > ", "\n");
            formErrorText = formErrorText.replaceAll("<br> ", "\n");
            formErrorText = formErrorText.replaceAll("\t", "");
            formErrorText = formErrorText.replaceAll("<BR>", "\n");
            formErrorText = formErrorText.replace("die folgenden Tipps zur Fehlerbehebung", "die Tipps zur Fehlerbehebung unter der PayPal-Homepage\noder warten Sie zwei Stunden");
            formErrorText = StringEscapeUtils.unescapeHtml4((String)formErrorText);
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkWhitespaces(formErrorText);
            formErrorText = formErrorText.trim();
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "ErrorText (formatiert): " + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String checkCodecSetCodecHtmlUnit(WebClient syncWebClient, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogNotify = externalDialogInterface.getMethod("notify", String.class);
        String getLogMethod = "[checkCodecSetCodec] ";
        boolean isSelfException = false;
        LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Sracheinstellungen und Kodierung des PayPal-Accounts werden gepr\u00fcft ...");
        MonitorLog.invoke((Object)MonitorLog, "Sracheinstellungen und Kodierung des PayPal-Accounts werden gepr\u00fcft ...");
        try {
            HtmlPage codepage;
            String codepageResponse;
            HtmlPage langPage;
            String langPageResponse;
            String adr = "https://www.paypal.com/cgi-bin/customerprofileweb?cmd=%5fprofile%2dlanguage%2dencoding";
            LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Sracheinstellungen des PayPal-Accounts anzeigen ... (GET " + adr + ")");
            int versuche = 0;
            do {
                try {
                    langPage = (HtmlPage)syncWebClient.getPage(adr);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "checkCodecSetCodec: langpage: " + langPage);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                langPageResponse = langPage.getWebResponse().getContentAsString();
                try {
                    WebUtils.checkResponse(langPageResponse, (Page)langPage, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                }
                if (++versuche > 1) {
                    LogWarn.invoke((Object)LogWarn, "[WebSync:PayPal] Erneuter Versuch die Sracheinstellungen aufzurufen, da falscher Response, dies war Versuch Nr.: " + versuche);
                }
                if (versuche != 15) continue;
                isSelfException = true;
                throw new Exception("Sracheinstellungen kann auch nach 15 Versuchen nicht abgerufen werden (Meldung: The requested URL /de/cgi-bin/webscr was not found on this server)");
            } while (langPageResponse.contains("webscr was not found on this server"));
            HtmlInput optionButton = (HtmlInput)langPage.getElementByName("options.x");
            LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Codierung des PayPal-Accounts anzeigen ... (Click " + optionButton + ")");
            versuche = 0;
            do {
                try {
                    codepage = (HtmlPage)optionButton.click();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "checkCodecSetCodec: codepage: " + codepage);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                codepageResponse = codepage.getWebResponse().getContentAsString();
                try {
                    WebUtils.checkResponse(codepageResponse, (Page)codepage, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                }
                if (++versuche > 1) {
                    LogWarn.invoke((Object)LogWarn, "[WebSync:PayPal] Erneuter Versuch die Codierung aufzurufen, da falscher Response, dies war Versuch Nr.: " + versuche);
                }
                if (versuche != 15) continue;
                isSelfException = true;
                throw new Exception("Codierung kann auch nach 15 Versuchen nicht abgerufen werden (Meldung: The requested URL /de/cgi-bin/webscr was not found on this server)");
            } while (codepageResponse.contains("webscr was not found on this server"));
            String inputCodepage = ((HtmlOption)((HtmlSelect)codepage.getElementByName("input_encoding")).getSelectedOptions().get(0)).asNormalizedText();
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "checkCodecSetCodec: inputCodepage: " + inputCodepage);
            boolean outputCodepageOther = ((HtmlRadioButtonInput)codepage.getFirstByXPath("//input[@value='no']")).isChecked();
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "checkCodecSetCodec: outputCodepageOther (is checked): " + outputCodepageOther);
            String outputCodepage = ((HtmlOption)((HtmlSelect)codepage.getElementByName("output_encoding")).getSelectedOptions().get(0)).asNormalizedText();
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "checkCodecSetCodec: outputCodepage: " + outputCodepage);
            if ((inputCodepage.equals("ISO-8859-15") || inputCodepage.equals("UTF-8") || inputCodepage.equals("windows-1252")) && (outputCodepage.equals("ISO-8859-15") || outputCodepage.equals("UTF-8") || outputCodepage.equals("windows-1252"))) {
                return outputCodepage;
            }
            if (!inputCodepage.equals("ISO-8859-15") && !inputCodepage.equals("UTF-8") && !inputCodepage.equals("windows-1252") && (outputCodepage.equals("ISO-8859-15") || outputCodepage.equals("UTF-8") || outputCodepage.equals("windows-1252")) && outputCodepageOther) {
                return outputCodepage;
            }
            if (!(outputCodepage.equals("ISO-8859-15") || outputCodepage.equals("UTF-8") || outputCodepage.equals("windows-1252"))) {
                ((HtmlRadioButtonInput)codepage.getFirstByXPath("//input[@value='no']")).setChecked(true);
                ((HtmlSelect)codepage.getElementByName("output_encoding")).getOptionByValue("windows-1252").setSelected(true);
                DomElement submitButton = codepage.getElementByName("submit.x");
                LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Codierung des PayPal-Accounts f\u00fcr Ausgaben \u00e4ndern ... (Click " + submitButton + ")");
                versuche = 0;
                try {
                    codepage = (HtmlPage)submitButton.click();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "checkCodecSetCodec: codepage: " + codepage);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                codepageResponse = codepage.getWebResponse().getContentAsString();
                try {
                    WebUtils.checkResponse(codepageResponse, (Page)codepage, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                }
                outputCodepage = "windows-1252";
                DialogNotify.invoke((Object)DialogNotify, "\nDer Zeichensatz f\u00fcr Daten die PayPal an Sie sendet\n(z. B. sofortige Zahlungsbest\u00e4tigungen, herunterladbare Kontoausz\u00fcge, E-Mails)\nwurde in Ihrem PayPal-Konto auf 'windows-1252' umgestellt.\n\nDie Codierungsmethode die Sie wom\u00f6glich auf Ihrer Website verwenden\nwurde hierbei auf '" + inputCodepage + "' belassen.\n\nSie k\u00f6nnen diesen Zeichensatz auf 'ISO-8859-15', 'UTF-8' oder 'windows-1252' einstellen\num alle notwendigen Zeichen f\u00fcr dieses Plugin oder andere Software zu unterst\u00fctzen.\n\nBitte beachten Sie hierzu den Artikel der Version 2.1.4 auf der Projekt-Homepage,\nda es hier nun zu Umsatzdopplern kommen kann.\n\n");
            }
            return outputCodepage;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String checkCodecSetCodec(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogNotify = externalDialogInterface.getMethod("notify", String.class);
        String getLogMethod = "[checkCodecSetCodec] ";
        boolean isSelfException = false;
        LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Sracheinstellungen und Kodierung des PayPal-Accounts werden gepr\u00fcft ...");
        MonitorLog.invoke((Object)MonitorLog, "Sracheinstellungen und Kodierung des PayPal-Accounts werden gepr\u00fcft ...");
        try {
            String codecPageResponse;
            LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Sracheinstellungen des PayPal-Accounts anzeigen ... (GET " + "https://www.paypal.com/cgi-bin/customerprofileweb?cmd=%5fprofile%2dlanguage%2dencoding" + ")");
            int rounds = 0;
            do {
                try {
                    seleniumWebDriver.get("https://www.paypal.com/cgi-bin/customerprofileweb?cmd=%5fprofile%2dlanguage%2dencoding");
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "codecpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                codecPageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(codecPageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
                }
                if (++rounds > 1) {
                    LogWarn.invoke((Object)LogWarn, "[WebSync:PayPal] Erneuter Versuch die Sracheinstellungen aufzurufen, da falscher Response, dies war Versuch Nr.: " + rounds);
                }
                if (rounds != 15) continue;
                isSelfException = true;
                throw new Exception("Sracheinstellungen kann auch nach 15 Versuchen nicht abgerufen werden (Meldung: The requested URL /de/cgi-bin/webscr was not found on this server)");
            } while (codecPageResponse.contains("webscr was not found on this server"));
            LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Codierung des PayPal-Accounts anzeigen ... ");
            rounds = 0;
            do {
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "optionsButton", "//input[@name='options.x']", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                codecPageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(codecPageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
                }
                if (++rounds > 1) {
                    LogWarn.invoke((Object)LogWarn, "[WebSync:PayPal] Erneuter Versuch die Codierung aufzurufen, da falscher Response, dies war Versuch Nr.: " + rounds);
                }
                if (rounds != 15) continue;
                isSelfException = true;
                throw new Exception("Codierung kann auch nach 15 Versuchen nicht abgerufen werden (Meldung: The requested URL /de/cgi-bin/webscr was not found on this server)");
            } while (codecPageResponse.contains("webscr was not found on this server"));
            Select inputCodepageSelect = new Select(seleniumWebDriver.findElement(By.name((String)"input_encoding")));
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "accountSelect: " + inputCodepageSelect);
            String inputCodepage = inputCodepageSelect.getFirstSelectedOption().getText();
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "inputCodepage: " + inputCodepage);
            boolean outputCodepageOther = seleniumWebDriver.findElement(By.xpath((String)"//input[@value='no']")).isSelected();
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "checkCodecSetCodec: outputCodepageOther (is checked): " + outputCodepageOther);
            Select outputCodepageSelect = new Select(seleniumWebDriver.findElement(By.name((String)"output_encoding")));
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "accountSelect: " + outputCodepageSelect);
            String outputCodepage = outputCodepageSelect.getFirstSelectedOption().getText();
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "outputCodepage: " + outputCodepage);
            if ((inputCodepage.equals("ISO-8859-15") || inputCodepage.equals("UTF-8") || inputCodepage.equals("windows-1252")) && (outputCodepage.equals("ISO-8859-15") || outputCodepage.equals("UTF-8") || outputCodepage.equals("windows-1252"))) {
                return outputCodepage;
            }
            if (!inputCodepage.equals("ISO-8859-15") && !inputCodepage.equals("UTF-8") && !inputCodepage.equals("windows-1252") && (outputCodepage.equals("ISO-8859-15") || outputCodepage.equals("UTF-8") || outputCodepage.equals("windows-1252")) && outputCodepageOther) {
                return outputCodepage;
            }
            if (!(outputCodepage.equals("ISO-8859-15") || outputCodepage.equals("UTF-8") || outputCodepage.equals("windows-1252"))) {
                seleniumWebDriver.findElement(By.xpath((String)"//input[@value='no']")).click();
                new Select(seleniumWebDriver.findElement(By.name((String)"output_encoding"))).selectByValue("windows-1252");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "saveButton", "//input[@name='submit.x']", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                codecPageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(codecPageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
                }
                outputCodepage = "windows-1252";
                DialogNotify.invoke((Object)DialogNotify, "\nDer Zeichensatz f\u00fcr Daten die PayPal an Sie sendet\n(z. B. sofortige Zahlungsbest\u00e4tigungen, herunterladbare Kontoausz\u00fcge, E-Mails)\nwurde in Ihrem PayPal-Konto auf 'windows-1252' umgestellt.\n\nDie Codierungsmethode die Sie wom\u00f6glich auf Ihrer Website verwenden\nwurde hierbei auf '" + inputCodepage + "' belassen.\n\nSie k\u00f6nnen diesen Zeichensatz auf 'ISO-8859-15', 'UTF-8' oder 'windows-1252' einstellen\num alle notwendigen Zeichen f\u00fcr dieses Plugin oder andere Software zu unterst\u00fctzen.\n\nBitte beachten Sie hierzu den Artikel der Version 2.1.4 auf der Projekt-Homepage,\nda es hier nun zu Umsatzdopplern kommen kann.\n\n");
            }
            return outputCodepage;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static int getPosInCSV(String spalte, String[] header, Class<?> externalLogger) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[getPosInCSV] ";
        LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Suche nach Spalte '" + spalte + "' im Header: " + ArrayUtils.toString((Object)header));
        if (spalte.equals("Notiz")) {
            spalte = "Hinweis";
        }
        for (int i = 0; i < header.length; ++i) {
            if (!header[i].toString().trim().contains(spalte)) continue;
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Die Spalte '" + spalte + "' ist an Position '" + i + "' des Header");
            return i;
        }
        if (spalte.equals("Notiz") || spalte.equals("Hinweis")) {
            return -1;
        }
        throw new Exception("Keine Spalte '" + spalte + "' im Header des Kontoauszug gefunden");
    }
}

