/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.paypal;

import de.derrichter.finance.websync.institute.paypal.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kundennummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        try {
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            try {
                String amountText = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@data-test-id,'available-balance')]")).getText().trim();
                LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "amountText: " + amountText);
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Kontostand' fehlgeschlagen: " + error.getMessage());
            }
            availableAmount = amount;
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Amount: " + amount);
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "availableAmount: " + availableAmount);
            LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Kontobewegungen aufrufen ... (GET " + "https://www.paypal.com/reports/dlog" + ")");
            try {
                seleniumWebDriver.get("https://www.paypal.com/reports/dlog");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "transpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageTransResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageTransResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "searchSelect", "//div[contains(@class,'rangePickerDropDown')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                WebElement fromInput = seleniumWebDriver.findElement(By.xpath((String)"//input[@id='start']"));
                WebElement toInputPath = seleniumWebDriver.findElement(By.xpath((String)"//input[@id='end']"));
                fromInput.click();
                if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                    fromInput.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "a"})});
                } else {
                    fromInput.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                }
                fromInput.sendKeys(new CharSequence[]{fromDateSimple});
                new Actions(seleniumWebDriver).sendKeys(new CharSequence[]{Keys.ESCAPE}).perform();
                toInputPath.click();
                if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                    toInputPath.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "a"})});
                } else {
                    toInputPath.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                }
                toInputPath.sendKeys(new CharSequence[]{toDateSimple});
                new Actions(seleniumWebDriver).sendKeys(new CharSequence[]{Keys.ESCAPE}).perform();
                new Actions(seleniumWebDriver).sendKeys(new CharSequence[]{Keys.ESCAPE}).perform();
            }
            catch (Exception searchError) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)searchError));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "genReportButton", "//button[contains(@class,'csrSubmit')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String searchPageSource = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(searchPageSource, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                String messagePath = "//iframe[@title='PayPal Feedback']";
                boolean hasAbortButton = false;
                do {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)messagePath)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Zwischenseite oder PopUp mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "closeButton", "//button[contains(@class,'Dialog') and contains(@class,'close-btn')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (hasAbortButton);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
            }
            String payPalToDateSimple = toDateSimple;
            try {
                String transInfoText = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'rangeInfo__bodyText')]")).getText();
                LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + transInfoText);
                MonitorLog.invoke((Object)MonitorLog, "PayPal-INFO: " + transInfoText);
                String payPalToDateSimpleTime = transInfoText.substring(transInfoText.indexOf("wurden am ") + 10, transInfoText.indexOf(" aktualisiert"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "payPalToDateSimpleTime: " + payPalToDateSimpleTime);
                payPalToDateSimple = payPalToDateSimpleTime.substring(0, payPalToDateSimpleTime.indexOf(" um "));
                payPalToDateSimple = payPalToDateSimple.replace(" Januar ", "01.");
                payPalToDateSimple = payPalToDateSimple.replace(" Februar ", "02.");
                payPalToDateSimple = payPalToDateSimple.replace(" M&auml;rz ", "03.");
                payPalToDateSimple = payPalToDateSimple.replace(" M\u00e4rz ", "04.");
                payPalToDateSimple = payPalToDateSimple.replace(" April ", "05.");
                payPalToDateSimple = payPalToDateSimple.replace(" Mai ", "06.");
                payPalToDateSimple = payPalToDateSimple.replace(" Juni ", "07.");
                payPalToDateSimple = payPalToDateSimple.replace(" Juli ", "08.");
                payPalToDateSimple = payPalToDateSimple.replace(" August ", "09.");
                payPalToDateSimple = payPalToDateSimple.replace(" September ", "10.");
                payPalToDateSimple = payPalToDateSimple.replace(" Oktober ", "11.");
                payPalToDateSimple = payPalToDateSimple.replace(" November ", "12.");
                SimpleDateFormat gerDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                payPalToDateSimple = gerDateFormat.format(gerDateFormat.parse(payPalToDateSimple));
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "payPalToDateSimple: " + payPalToDateSimple);
            }
            catch (NoSuchElementException | TimeoutException notReady) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Info-Text zum Zeitraum der Daten in Berichten nicht gefunden?!");
            }
            boolean localTest = false;
            File downloadedFile = null;
            String doctext = null;
            String filetype = "";
            try {
                LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "Kontoauszug angefordert, warte auf Bereitstellung...");
                MonitorLog.invoke((Object)MonitorLog, "Kontoauszug angefordert, warte (max. 5 Min.) auf Bereitstellung...");
                String reportPath = "//tr[contains(.,'" + fromDateSimple + " - " + payPalToDateSimple + "')]//button[contains(.,'Herunterladen')]";
                boolean isReady = false;
                int readyWait = 0;
                do {
                    Thread.sleep(3000L);
                    seleniumWebDriver.findElement(By.xpath((String)"//button[contains(.,'Aktualisieren')]")).click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)reportPath));
                        isReady = true;
                    }
                    catch (NoSuchElementException | TimeoutException notReady) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Kontoauszug noch nicht fertig gestellt, warte weitere 3 Sekunden...");
                    }
                    if ((readyWait += 4) <= 300) continue;
                    isSelfException = true;
                    throw new Exception("Der CSV-Kontoauszug wurde auch nach 5 Minuten Wartezeit nicht generiert. Bitte online pr\u00fcfen oder auf die Mail-Benachrichtigung warten und dann nochmals abrufen.");
                } while (!isReady);
                if (localTest) {
                    String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                    downloadedFile = new File(docFixTempFilePath);
                }
                boolean downloadedFileIsFalse = false;
                int downloadCount = 1;
                do {
                    if (!localTest) {
                        try {
                            Thread.sleep(1000L);
                            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "csvExport", reportPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                    filetype = FilenameUtils.getExtension((String)downloadedFile.getAbsolutePath()).toUpperCase();
                    if (filetype.toLowerCase().equals("txt") || filetype.toLowerCase().equals("htm") || filetype.toLowerCase().equals("html") || filetype.toLowerCase().equals("asp") || filetype.toLowerCase().equals("js")) {
                        LogWarn.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / falscher Dateityp, versuche es nochmals ...");
                        ++downloadCount;
                        downloadedFileIsFalse = true;
                    } else {
                        downloadedFileIsFalse = false;
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                } while (downloadedFileIsFalse);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Der CSV-Kontoauszug konnte nicht generiert bzw. geladen werden\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String fileResponse = "";
            String fileencoding = "UTF-8";
            fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
            LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "raw-fileResponse witout file-encoding convert:\n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
            if (!fileencoding.equals("UTF-8")) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:PayPal] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                doctext = new String(filebytes, System.getProperty("file.encoding"));
            } else {
                doctext = fileResponse;
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + filetype + "-Rechnung (text):\n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
            if (doctext.contains("<html") || doctext.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            if (!localTest) {
                FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
            }
            String[] dataResponse = new String[]{doctext, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(doctext, '\"', ',', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "Der Header des aktuellen Kontoauszugs hat '" + String.valueOf(matrixArrayData[0].length) + "' Spalten");
            int datumPos = WebUtils.getPosInCSV("Datum", matrixArrayData[0], externalLogger);
            int betragPos = WebUtils.getPosInCSV("Brutto", matrixArrayData[0], externalLogger);
            int gebuehrPos = WebUtils.getPosInCSV("Geb\u00fchr", matrixArrayData[0], externalLogger);
            int saldoPos = WebUtils.getPosInCSV("Guthaben", matrixArrayData[0], externalLogger);
            int waehrungPos = WebUtils.getPosInCSV("W\u00e4hrung", matrixArrayData[0], externalLogger);
            int umsatzArtPos = WebUtils.getPosInCSV("Typ", matrixArrayData[0], externalLogger);
            int verwendungszweckPos = WebUtils.getPosInCSV("Artikelbezeichnung", matrixArrayData[0], externalLogger);
            int vonEmailPos = WebUtils.getPosInCSV("Absender E-Mail-Adresse", matrixArrayData[0], externalLogger);
            int anEmailPos = WebUtils.getPosInCSV("Empf\u00e4nger E-Mail-Adresse", matrixArrayData[0], externalLogger);
            int namePos = WebUtils.getPosInCSV("Name", matrixArrayData[0], externalLogger);
            int hinweisPos = WebUtils.getPosInCSV("Hinweis", matrixArrayData[0], externalLogger);
            int primanotaPos = WebUtils.getPosInCSV("Transaktionscode", matrixArrayData[0], externalLogger);
            int statusPos = WebUtils.getPosInCSV("Status", matrixArrayData[0], externalLogger);
            for (int i = matrixArrayData.length - 1; i > 0; --i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] CheckColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][datumPos].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double Betrag = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][betragPos]).replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll(" \u20ac", "").replaceAll(" &euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim());
                    double Gebuehr = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][gebuehrPos]).replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll(" \u20ac", "").replaceAll(" &euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim());
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    double Saldo = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][saldoPos]).replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll(" \u20ac", "").replaceAll(" &euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim());
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Saldo - Gebuehr);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][waehrungPos]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][umsatzArtPos]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][verwendungszweckPos])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][verwendungszweckPos].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    String ggktonr = "";
                    String email_von = StringCharUtils.shrinkString(matrixArrayData[i][vonEmailPos].toLowerCase()).replaceAll("\\s", "");
                    String email_an = StringCharUtils.shrinkString(matrixArrayData[i][anEmailPos].toLowerCase()).replaceAll("\\s", "");
                    String checkmail = StringCharUtils.shrinkString(kundennummer.toLowerCase()).replaceAll("\\s", "");
                    if (ggktonr.length() > 34) {
                        ggktonr = ggktonr.substring(0, 34);
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(email_von) && !email_von.equals(checkmail)) {
                        ggktonr = email_von;
                    }
                    if (StringCharUtils.isNullOrEmptyOrNothing(ggktonr) && !StringCharUtils.isNullOrEmptyOrNothing(email_an) && !email_an.equals(checkmail) && !StringCharUtils.isNullOrEmptyOrNothing(email_an)) {
                        ggktonr = email_an;
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][namePos])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][namePos]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(ggktonr);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    String dWaehrung = matrixArrayData[i][waehrungPos];
                    if (!matrixArrayData[i][waehrungPos].equals("EUR")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][waehrungPos]);
                    } else if (hinweisPos != -1) {
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][hinweisPos])) {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][hinweisPos]);
                        } else {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        }
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][primanotaPos])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][primanotaPos]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][statusPos])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][statusPos]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    if (Gebuehr == 0.0) continue;
                    String GebuehrArt = "PayPal-Geb\u00fchren";
                    if (String.valueOf(Gebuehr).indexOf("-") == -1) {
                        GebuehrArt = "Widerrufene Geb\u00fchr";
                    }
                    transactionDataList.add(new ArrayList());
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount - 1)).get(0));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount - 1)).get(0));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Gebuehr);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Saldo);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][waehrungPos]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(GebuehrArt);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(GebuehrArt);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (!StringCharUtils.isNullOrEmptyOrNothing((String)((ArrayList)transactionDataList.get(arrayRowCount - 1)).get(12))) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(GebuehrArt + " zur Transaktion:\n" + (String)((ArrayList)transactionDataList.get(arrayRowCount - 1)).get(13));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    if (!StringCharUtils.isNullOrEmptyOrNothing((String)((ArrayList)transactionDataList.get(arrayRowCount - 1)).get(13))) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount - 1)).get(13));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    if (!StringCharUtils.isNullOrEmptyOrNothing((String)((ArrayList)transactionDataList.get(arrayRowCount - 1)).get(14))) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount - 1)).get(14));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "inclInterBalace", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("PayPal", kundennummer, amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

