/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.paypal;

import de.derrichter.finance.websync.utils.StringCharUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.WordUtils;

public class ApiUtils {
    public static String checkApiResponse(String dataMessage, String details, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        String getLogMethod = "[CheckApiResponse] ";
        boolean isSelfException = false;
        try {
            if (!dataMessage.contains("ACK=")) {
                isSelfException = true;
                throw new Exception("Der empfangene Datensatz enth\u00e4lt keinen Abrufstatus. Fehlerpr\u00fcfung nicht m\u00f6glich da falsche Daten");
            }
            int ackStart = dataMessage.indexOf("ACK=") + 4;
            int ackEnd = dataMessage.indexOf("&", ackStart);
            String ackText = dataMessage.substring(ackStart, ackEnd);
            if (!ackText.equals("Success")) {
                int codeStart = dataMessage.indexOf("L_ERRORCODE0=") + 13;
                int codeEnd = dataMessage.indexOf("&", codeStart);
                String codeText = dataMessage.substring(codeStart, codeEnd);
                int smStart = dataMessage.indexOf("L_SHORTMESSAGE0=") + 16;
                int smEnd = dataMessage.indexOf("&", smStart);
                String smtext = dataMessage.substring(smStart, smEnd);
                int lmStart = dataMessage.indexOf("L_LONGMESSAGE0=") + 15;
                int lmEnd = dataMessage.indexOf("&", lmStart);
                String lmtext = dataMessage.substring(lmStart, lmEnd);
                int scStart = dataMessage.indexOf("L_SEVERITYCODE0=") + 16;
                int scEnd = dataMessage.indexOf("&", scStart);
                String sctext = dataMessage.substring(scStart);
                String gerText = ApiUtils.translateAPIerrors(codeText, lmtext, externalLogger, externalProgressMonitor);
                if (codeText.equals("10004") && lmtext.equals("The transaction could not be loaded")) {
                    LogWarn.invoke((Object)LogWarn, "[WebSync:PayPal] " + getLogMethod + "Warnung wegen Error 10004: The transaction could not be loaded; Folgefehler nicht ausgeschlossen");
                    MonitorLog.invoke((Object)MonitorLog, "Warnung wegen Error 10004: The transaction could not be loaded; Folgefehler nicht ausgeschlossen");
                    DialogWarn.invoke((Object)DialogWarn, "[WebSync:PayPal] " + getLogMethod + "\n-------------------------------\nACK: " + ackText + "\nErrorCode: " + codeText + "\nShort Message: " + smtext + "\n\nLong Message:\n" + lmtext + "\n\nSeverityCode: " + sctext + "\n-------------------------------\n\nDatensatzdetails: " + details + "\n\n\nDies k\u00f6nnte \u00dcbersetzt soviel bedeuten wie:\n\n" + gerText, "institutlogo-paypal.png");
                    return null;
                }
                DialogError.invoke((Object)DialogError, "[WebSync:PayPal] " + getLogMethod + "\n-------------------------------\nACK: " + ackText + "\nErrorCode: " + codeText + "\nShort Message: " + smtext + "\n\nLong Message:\n" + lmtext + "\n\nSeverityCode: " + sctext + "\n-------------------------------\n\nDatensatzdetails: " + details + "\n\n\nDies k\u00f6nnte \u00dcbersetzt soviel bedeuten wie:\n\n" + gerText, "institutlogo-paypal.png");
                isSelfException = true;
                throw new Exception("(" + sctext + ") " + lmtext + " [" + smtext + "]");
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkApiResponse fehlerhaft (Datensatzdetails: " + details + "): " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String getErrorString(String contentStringToParse, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String getLogMethod = "[GetErrorString] ";
        try {
            int shortErrorIDXstart = contentStringToParse.indexOf("s.prop14=");
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "shortErrorIDXstart: " + shortErrorIDXstart);
            if (shortErrorIDXstart == -1) {
                return "NULL";
            }
            int shortErrorIDXend = contentStringToParse.indexOf("\";", shortErrorIDXstart += 10);
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "shortErrorIDXend: " + shortErrorIDXend);
            String shortErrorText = contentStringToParse.substring(shortErrorIDXstart, shortErrorIDXend);
            String shortErrorTextString = StringCharUtils.HEXtoChar(shortErrorText);
            shortErrorTextString = shortErrorTextString.replaceAll("\\", "");
            shortErrorTextString = StringEscapeUtils.unescapeHtml4((String)shortErrorTextString);
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "shortErrorTextString (formatiert): " + shortErrorTextString);
            return shortErrorTextString;
        }
        catch (Exception error) {
            throw new Exception("getErrorString fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String formErrorMessage(String contentStringToParse, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[formErrorMessage] ";
        try {
            int longErrorIDXstart = contentStringToParse.indexOf("Fehlermeldung");
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "longErrorIDXstart: " + longErrorIDXstart);
            if (longErrorIDXstart == -1) {
                return "NULL";
            }
            int longErrorIDXend = contentStringToParse.indexOf("</p>", longErrorIDXstart += 13);
            LogDebug.invoke((Object)LogDebug, "[WebSync:PayPal] " + getLogMethod + "longErrorIDXend: " + longErrorIDXend);
            String longErrorText = contentStringToParse.substring(longErrorIDXstart, longErrorIDXend);
            longErrorText = longErrorText.replaceAll("<b>", "").replaceAll("</b>", "").replaceAll("</h2>", "").replaceAll("<p>", "");
            longErrorText = longErrorText.replace("die folgenden Tipps zur Fehlerbehebung", "die Tipps zur Fehlerbehebung unter der PayPal-Homepage\noder warten Sie zwei Stunden");
            longErrorText = StringEscapeUtils.unescapeHtml4((String)longErrorText);
            String errorFenster = WordUtils.wrap((String)longErrorText, (int)100);
            return errorFenster;
        }
        catch (Exception error) {
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String translateTransactions(String engText, String Art, String linkText, Class<?> externalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[translateTransactions] ";
        try {
            String translated = engText;
            if (engText.equals("Transfer")) {
                engText = linkText;
                translated = engText.replace("Bank Account (direct debit)", "Einzahlung vom Bankkonto (Lastschrift)").replace("Bank Account (giropay)", "Einzahlung von einem Bankkonto").replace("Bank Account", "Einzahlung von einem Bankkonto").replace("Credit Card", "Belastung von Kreditkarte");
            } else if (Art.equals("Typ")) {
                translated = engText.replace("Currency Conversion (credit)", "W\u00e4hrungsumrechnung").replace("Currency Conversion (debit)", "W\u00e4hrungsumrechnung").replace("Donation", "Spenden").replace("Refund", "R\u00fcckzahlung").replace("Temporary Hold", "Verz\u00f6gerte Verf\u00fcgbarkeit").replace("Authorization", "Autorisierung").replace("Bill", "Zahlungsbeleg").replace("Payment", "Zahlung (diverse)").replace("Purchase", "Zahlung (diverse)");
            } else if (Art.equals("Name")) {
                translated = engText.replace("Bank Account (direct debit)", "Bankkonto (Lastschrift)").replace("Bank Account (giropay)", "Bankkonto (giropay)").replace("Bank Account", "Bankkonto").replace("Credit Card", "Kreditkarte").replace("From Euro", "von Euro").replace("From U.S. Dollar", "von US-Dollar").replace("To U.S. Dollar", "in US-Dollar");
            } else if (Art.equals("Status")) {
                translated = engText.replace("Completed", "Abgeschlossen").replace("Refunded", "Zur\u00fcckgezahlt").replace("Removed", "Aufgehoben").replace("Placed", "Ausgef\u00fchrt").replace("Canceled", "Abgebrochen");
            }
            return translated;
        }
        catch (Exception error) {
            throw new Exception("translateTransactions fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String translateAPIerrors(String code, String engText, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[translateAPIerrors] ";
        try {
            String translated;
            if (code.equals("10001")) {
                translated = "Interner Fehler\n(Tipp: Dieser ist meist nur tempor\u00e4r, versuchen Sie es daher sp\u00e4ter einfach nochmals. Ansonsten ist dieser ausschlie\u00dflich durch PayPal selbst bearbeitbar. Melden Sie alle hier angegeben Daten im Online Kontaktformular unter https://de.paypal-techsupport.com, im Fussbereich unter 'Fragen Sie uns')";
            } else if (code.equals("10002")) {
                String header = "Authorisierung fehlgeschlagen\n";
                translated = engText.equals("Username/Password is incorrect") ? header + "API-Benutzername oder API-Passwort nicht korrekt\n(Tipp: API-Passwort ist nicht gleich WebLogin-Passwort auf Webseite)" : (engText.equals("You do not have permission to make this API call") ? header + "Sie haben keine Berechtigung um diesen Abruf auszuf\u00fchren" : (engText.equals("Account is locked or inactive") ? header + "Zugang ist gesperrt oder inaktiv" : (engText.equals("Internal Error") ? header + "Interner Fehler\n(Tipp: Dieser ist meist nur tempor\u00e4r, versuchen Sie es daher sp\u00e4ter einfach nochmals. Ansonsten ist dieser ausschlie\u00dflich durch PayPal selbst bearbeitbar. Melden Sie alle hier angegeben Daten im Online Kontaktformular unter https://de.paypal-techsupport.com, im Fussbereich unter 'Contact us' oder 'Fragen Sie uns')" : (engText.equals("Account is not verified") ? header + "Zugang ist nicht best\u00e4tigt" : (engText.equals("Account is restricted") ? header + "Ihr PayPal-Konto wurde eingeschr\u00e4nkt. Bitte wenden Sie sich an PayPal" : (engText.equals("API access is disabled for this account") ? header + "Der API-Zugang wurde f\u00fcr diesen Account gesperrt" : (engText.equals("Security header is not valid") ? header + "API-Benutzername, API-Passwort oder Unterschrift ist nicht korrekt\n(Tipp: API-Passwort ist nicht gleich WebLogin-Passwort auf Webseite)" : header)))))));
            } else {
                translated = code.equals("10004") && engText.equals("The transaction could not be loaded") ? "Die Transaktionsdetails konnten (im Moment) nicht abgerufen werden oder es liegt ein Problem bei PayPal vor. Bitte probieren Sie es daher entweder die n\u00e4chsten Tage noch einmal oder melden Sie diesen Fehler im Online Kontaktformular unter https://de.paypal-techsupport.com im Fussbereich unter 'Contact us' oder 'Fragen Sie uns'.\n(Die Entwicklung von Finance.Websync kann dieses Problem nicht l\u00f6sen!)" : (code.equals("10008") ? "API-Benutzername, API-Passwort oder Unterschrift ist nicht korrekt\n(Tipp: API-Passwort ist nicht gleich WebLogin-Passwort auf Webseite)" : (code.equals("10101") ? "Der API-Zugang ist im Moment nicht verf\u00fcgbar. Bitte versuchen Sie es sp\u00e4ter erneut" : (code.equals("10007") ? "Sie haben keine Berechtigung um diesen Abruf auszuf\u00fchren" : (code.equals("11002") ? "Die Zahl der Ergebnisse \u00fcberschreitet das Limit von 100 Transaktionen\nBitte verringern Sie Ihr angegebenes Abrufintervall (z. B. in den Synchronisierungsoptionen)" : (code.equals("10014") ? "Der API-Aufruf wurde abgelehnt, da dieser die zul\u00e4ssige Grenze der Anrufrate \u00fcberschritten hat" : (code.equals("81002") ? "Die aufgerufene Methode ist nicht bekannt.\n\n(Diese Fehlermeldung erscheint auch wenn das WebLogin-Passwort statt richtigerweise das API-Passwort verwendet wurde!)" : " - keine \u00dcbersetzung vorhanden -\n(bitte den ganzen Fehler dem Entwickler im Forum melden)"))))));
            }
            return translated;
        }
        catch (Exception error) {
            throw new Exception("translateAPIerrors fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

