/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.paypal;

import de.derrichter.finance.websync.institute.paypal.ApiUtils;
import de.derrichter.finance.websync.institute.paypal.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.WebClient;

public class ApiPull {
    /*
     * Unable to fully structure code
     */
    public static ArrayList getTransData(WebClient syncWebClient, String kundennummer, String responseUser, String ResponseSign, String responsePassword, String responseIntervall, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> ExternalDialogInterface) throws Exception {
        LogInfo = externalLogger.getMethod("info", new Class[]{String.class});
        LogWarn = externalLogger.getMethod("warn", new Class[]{String.class});
        LogError = externalLogger.getMethod("error", new Class[]{String.class});
        LogDebug = externalLogger.getMethod("debug", new Class[]{String.class});
        LogTrace = externalLogger.getMethod("trace", new Class[]{String.class});
        MonitorLog = externalProgressMonitor.getMethod("log", new Class[]{String.class});
        MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", new Class[]{Integer.TYPE});
        if (StringCharUtils.isNullOrEmptyOrNothing(kundennummer) || kundennummer.length() < 4) {
            throw new Exception("Die Login-Mailadresse (Kundennummer) wurde nicht gesetzt");
        }
        if (StringCharUtils.isNullOrEmptyOrNothing(responseUser) || responseUser.length() < 4) {
            throw new Exception("Der API-Benutzername wurde nicht gesetzt");
        }
        if (StringCharUtils.isNullOrEmptyOrNothing(ResponseSign) || ResponseSign.length() < 4) {
            throw new Exception("Die API-Unterschrift wurde nicht gesetzt");
        }
        if (StringCharUtils.isNullOrEmptyOrNothing(responsePassword) || responsePassword.length() < 4) {
            throw new Exception("Das API-Passwort wurde nicht gesetzt");
        }
        if (StringCharUtils.isNullOrEmptyOrNothing(responseIntervall)) {
            throw new Exception("Das API-Abrufintervall wurde nicht gesetzt");
        }
        getLogMethod = "[getTransData] ";
        isSelfException = false;
        adr = "";
        send_adr = "";
        Versuche = -1;
        simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        DateNow = new Date();
        try {
            transData = "Datum;Zeit;Zeitzone;Name;Art;Status;W\u00e4hrung;Brutto;Geb\u00fchr;Netto;Von E-Mail-Adresse;An E-Mail-Adresse;Transaktionscode;Status der Gegenpartei;Adressstatus;Verwendungszweck;Artikelnummer;Betrag f\u00fcr Versandkosten;Versicherungsbetrag;Umsatzsteuer;K\u00e4ufer-ID;Angebotsende;Rechnungsnummer;Guthaben;Adresse;Zus\u00e4tzliche Angaben;Ort;Staat/Provinz/Region/Landkreis/Territorium/Pr\u00e4fektur/Republik;PLZ;Land;Notiz\n";
            adr = "USER=" + responseUser + "&PWD=" + responsePassword + "&SIGNATURE=" + ResponseSign + "&VERSION=" + "204" + "&METHOD=GetBalance";
            send_adr = "https://api-3t.paypal.com/nvp?" + adr;
            LogInfo.invoke((Object)LogInfo, new Object[]{"[WebSync:PayPal] " + getLogMethod + "API-Saldoabruf ... (GET Encoded: " + "https://api-3t.paypal.com/nvp?" + adr.replace(responseUser, "*******").replace(responsePassword, "*******").replace(ResponseSign, "*******") + ")"});
            Versuche = 0;
            try {
                apiresponse = syncWebClient.getPage(send_adr);
                LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "apiresponse (Guthaben): " + apiresponse});
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + error.getMessage());
            }
            if (apiresponse == null) {
                throw new Exception("Transaktionen (API) konnten nicht aufgerufen werden!");
            }
            amountData = URLDecoder.decode(apiresponse.getWebResponse().getContentAsString(Charset.forName("UTF-8")), "UTF-8");
            try {
                ApiUtils.checkApiResponse(amountData, "GetBalance", externalLogger, externalProgressMonitor, ExternalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] Original API-Response zur Fehleranalyse beim Entwickler (kann sensible Daten enthalten):\n---------------BEGIN API-RESPONSE---------------\n" + amountData + "\n----------------END API-RESPONSE----------------"});
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            amount = NaN;
            if (amountData.indexOf("L_AMT") < 0) {
                throw new Exception("Aktuelles Guthaben konnte mit der API nicht ermittelt werden!");
            }
            amountStart = amountData.indexOf("L_AMT") + 7;
            LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Index of amountStart: " + amountStart});
            amountEnd = amountData.indexOf("&", amountStart);
            LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Index of amountEnd: " + amountEnd});
            amountText = amountData.substring(amountStart, amountEnd);
            amount = Double.parseDouble(amountText);
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Amount-Text: " + amountText});
            intervall = Long.parseLong(responseIntervall) * 3600000L;
            fromDateLong = simpleDateFormat.parse(fromDateSimple).getTime();
            toDateLong = simpleDateFormat.parse(toDateSimple).getTime();
            LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "\u00fcbergebener Wert f\u00fcr das API-Abrufintervall: " + String.valueOf(responseIntervall)});
            LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "API-Abrufintervall wurde auf den Wert gesetzt (Stunden): " + String.valueOf(intervall / 3600000L)});
            countIntervalls = (int)Math.ceil((toDateLong - fromDateLong - intervall) / intervall);
            if (countIntervalls < 1) {
                countIntervalls = 1;
            }
            LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Im Abrufzeitraum befinden sich so viele Abruf-Intervalle: " + String.valueOf(countIntervalls)});
            CounterI = 0;
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [fromDateSimple]: " + String.valueOf(fromDateSimple)});
            fromDate = simpleDateFormat.parse(fromDateSimple);
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [fromDate]: " + String.valueOf(fromDate)});
            fromDate = SysUtils.setHour(fromDate, 0);
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [fromDate Hour 0]: " + String.valueOf(fromDate)});
            fromDate = SysUtils.setMinutes(fromDate, 0);
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [fromDate Minutes 0]: " + String.valueOf(fromDate)});
            fromDate = SysUtils.setSeconds(fromDate, 0);
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [fromDate Seconds 0]: " + String.valueOf(fromDate)});
            callTimeZone = TimeZone.getTimeZone("Europe/Berlin");
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [callTimeZone]: " + String.valueOf(callTimeZone)});
            callOffset = callTimeZone.getRawOffset();
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [callOffset]: " + String.valueOf(callOffset)});
            callcalendar = Calendar.getInstance(callTimeZone);
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [callcalendar with timezone]: " + callcalendar});
            callcalendar.set(SysUtils.getYear(fromDate), SysUtils.getMonth(fromDate), SysUtils.getDay(fromDate), SysUtils.getHour(fromDate), SysUtils.getMinutes(fromDate), SysUtils.getSeconds(fromDate));
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [callcalendar set fromdate]: " + String.valueOf(callcalendar)});
            LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Abruf-Zeit im Kalender als Offset-Check (mSec): " + String.valueOf(callcalendar.getTime())});
            callTimeDiff = callTimeZone.inDaylightTime(callcalendar.getTime()) != false ? callOffset * 2 : callOffset;
            LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Differenz (Zeitverschiebung) der Zeitzone des Abrufers zur UTC-Zeit: " + String.valueOf(callTimeDiff)});
            fromDate.setTime(fromDate.getTime() - (long)callTimeDiff);
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Entwickler's Datum-Check [fromDate - callTimeDiff]: " + String.valueOf(fromDate)});
            toDate = simpleDateFormat.parse(toDateSimple);
            toDate.setTime(fromDate.getTime() + intervall);
            stopAPIcall = false;
            lastIntervall = false;
            if (toDate.getTime() > DateNow.getTime()) {
                lastIntervall = true;
                toDate = DateNow;
            }
            MonitorLog.invoke((Object)MonitorLog, new Object[]{"API-Transaktionssuche mit eingestelltem Intervall von '" + String.valueOf(intervall / 3600000L) + " Std.' gestartet ..."});
            do {
                MonitorPercent = Math.ceil(15.0 + 34.0 / (double)countIntervalls * (double)(++CounterI));
                MonitorSetPercent.invoke((Object)MonitorSetPercent, new Object[]{(int)MonitorPercent});
                adr = "USER=" + responseUser + "&PWD=" + responsePassword + "&SIGNATURE=" + ResponseSign + "&VERSION=" + "204" + "&METHOD=TransactionSearch&STARTDATE=" + SysUtils.getYear(fromDate) + "-" + (SysUtils.getMonth(fromDate) + 1) + "-" + SysUtils.getDay(fromDate) + "T" + SysUtils.getHour(fromDate) + ":" + SysUtils.getMinutes(fromDate) + ":" + SysUtils.getSeconds(fromDate) + "Z&ENDDATE=" + SysUtils.getYear(toDate) + "-" + (SysUtils.getMonth(toDate) + 1) + "-" + SysUtils.getDay(toDate) + "T" + SysUtils.getHour(toDate) + ":" + SysUtils.getMinutes(toDate) + ":" + SysUtils.getSeconds(toDate) + "Z";
                send_adr = "https://api-3t.paypal.com/nvp?" + adr;
                LogInfo.invoke((Object)LogInfo, new Object[]{"[WebSync:PayPal] " + getLogMethod + "API-Transaktionsabruf ... (GET Encoded: " + "https://api-3t.paypal.com/nvp?" + adr.replace(responseUser, "*******").replace(responsePassword, "*******").replace(ResponseSign, "*******") + ")"});
                fromDateSimpleText = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss z").format(fromDate);
                toDateSimpleText = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss z").format(toDate);
                callIntervall = fromDateSimpleText + "  bis  " + toDateSimpleText;
                LogInfo.invoke((Object)LogInfo, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Abrufzeitraum: von " + callIntervall});
                Versuche = 0;
                try {
                    apiresponse = syncWebClient.getPage(send_adr);
                    LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "apiresponse (Umsatzsuche): " + apiresponse});
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + error.getMessage());
                }
                if (apiresponse == null) {
                    throw new Exception("Tranaktionen (API) konnten nicht aufgerufen werden!");
                }
                dataMessage = URLDecoder.decode(apiresponse.getWebResponse().getContentAsString(Charset.forName("UTF-8")), "UTF-8");
                LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "DataMessage: \n" + dataMessage});
                try {
                    ApiUtils.checkApiResponse(dataMessage, "TransactionSearch\n" + callIntervall, externalLogger, externalProgressMonitor, ExternalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] Original API-Response zur Fehleranalyse beim Entwickler (kann sensible Daten enthalten):\n---------------BEGIN API-RESPONSE---------------\n" + dataMessage + "\n----------------END API-RESPONSE----------------"});
                    throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                }
                transactionData = dataMessage.split("&");
                transactionID = new ArrayList<String>();
                for (i = 0; i < transactionData.length; ++i) {
                    if (!transactionData[i].contains("L_TRANSACTIONID")) continue;
                    IDsplit = transactionData[i].split("=");
                    transactionID.add(IDsplit[1].replace("\"", "").replace(";", ","));
                }
                LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Dieses abgerufene Datenpaket enth\u00e4lt '" + transactionID.size() + "' Transaktionen"});
                LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "API-Datenpaket analysieren, Daten aus dem Suchergebnis holen und Detailabruf starten wenn passend"});
                cGuthaben = NaN;
                prevNetto = NaN;
                for (l = transactionID.size() - 1; l >= 0; --l) {
                    datum = "";
                    zeit = "";
                    zeitzone = "";
                    name = "";
                    art = "";
                    status = "";
                    waehrung = "";
                    brutto = "";
                    gebuehr = "";
                    netto = "";
                    von_E_Mail_Adresse = "";
                    an_E_Mail_Adresse = "";
                    transaktionscode = "";
                    status_der_Gegenpartei = "";
                    adressstatus = "";
                    verwendungszweck = "";
                    artikelnummer = "";
                    betrag_fuer_Versandkosten = "";
                    versicherungsbetrag = "";
                    umsatzsteuer = "";
                    option_1_Name = "";
                    option_1_Wert = "";
                    option_2_Name = "";
                    option_2_Wert = "";
                    auktions_Site = "";
                    kaeufer_ID = "";
                    artikel_URL = "";
                    angebotsende = "";
                    vorgangs_Nr = "";
                    rechnungs_Nr = "";
                    txn_Referenzkennung = "";
                    rechnungsnummer = "";
                    individuelle_Nummer = "";
                    bestaetigungsnummer = "";
                    guthaben = "";
                    adresse = "";
                    zusaetzliche_Angaben = "";
                    ort = "";
                    staat_Provinz_Region = "";
                    plz = "";
                    land = "";
                    telefonnummer_Kontaktperson = "";
                    notiz = "";
                    timestampStart = dataMessage.indexOf("L_TIMESTAMP" + l + "=");
                    if (timestampStart == -1) {
                        isSelfException = true;
                        throw new Exception("Datenzeile 'L_TIMESTAMP" + l + "=' in der Ergebnisliste nicht gefunden (idx -1 @ " + transactionID.get(l) + "); Bitte dem Entwickler im Forum melden");
                    }
                    timestampStart = dataMessage.indexOf("=", timestampStart) + 1;
                    timestampEnd = dataMessage.indexOf("&L", timestampStart);
                    timestampText = dataMessage.substring(timestampStart, timestampEnd);
                    datumZeit = timestampText.split("T");
                    datumTeile = datumZeit[0].split("-");
                    zeitTeile = datumZeit[1].substring(0, 8).split(":");
                    jahr = Integer.parseInt(datumTeile[0], 10);
                    monat = Integer.parseInt(datumTeile[1], 10) - 1;
                    tag = Integer.parseInt(datumTeile[2], 10);
                    stunde = Integer.parseInt(zeitTeile[0], 10);
                    minuten = Integer.parseInt(zeitTeile[1], 10);
                    sekunden = Integer.parseInt(zeitTeile[2], 10);
                    fromTimeZone = TimeZone.getTimeZone("GMT0");
                    toTimeZone = TimeZone.getTimeZone("Europe/Berlin");
                    calendar = Calendar.getInstance(fromTimeZone);
                    calendar.set(jahr, monat, tag, stunde, minuten, sekunden);
                    calendar.add(14, fromTimeZone.getRawOffset() * -1);
                    if (fromTimeZone.inDaylightTime(calendar.getTime())) {
                        calendar.add(14, calendar.getTimeZone().getDSTSavings() * -1);
                    }
                    calendar.add(14, toTimeZone.getRawOffset());
                    if (toTimeZone.inDaylightTime(calendar.getTime())) {
                        calendar.add(14, toTimeZone.getDSTSavings());
                    }
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Kalender-Zeit (nach dem Konvertieren in lokale Zeitzone) ist " + calendar.getTime() + " in " + toTimeZone.getDisplayName()});
                    datum = new SimpleDateFormat("dd.MM.yyyy").format(calendar.getTime());
                    zeit = new SimpleDateFormat("hh:mm:ss").format(calendar.getTime());
                    timezoneStart = dataMessage.indexOf("L_TIMEZONE" + l + "=");
                    if (timezoneStart == -1) {
                        isSelfException = true;
                        throw new Exception("Datenzeile 'L_TIMEZONE" + l + "=' in der Ergebnisliste nicht gefunden (idx -1 @ " + transactionID.get(l) + "); Bitte dem Entwickler im Forum melden");
                    }
                    timezoneStart = dataMessage.indexOf("=", timezoneStart) + 1;
                    timezoneEnd = dataMessage.indexOf("&L", timezoneStart);
                    zeitzone = dataMessage.substring(timezoneStart, timezoneEnd).replace("\"", "").replace(";", ",");
                    checkDST = toTimeZone.inDaylightTime(calendar.getTime());
                    if (!checkDST) {
                        zeitzone = "MEZ";
                    } else if (checkDST) {
                        zeitzone = "MESZ";
                    }
                    nameStart = dataMessage.indexOf("L_NAME" + l + "=");
                    checkName = "";
                    if (nameStart == -1) {
                        name = "";
                    } else {
                        nameStart = dataMessage.indexOf("=", nameStart) + 1;
                        nameEnd = dataMessage.indexOf("&L", nameStart);
                        checkName = dataMessage.substring(nameStart, nameEnd).replace("\"", "").replace("'", "").replace(";", ",");
                        name = ApiUtils.translateTransactions(checkName, "Name", "", externalLogger, externalProgressMonitor);
                    }
                    artStart = dataMessage.indexOf("L_TYPE" + l + "=");
                    checkArt = "";
                    if (artStart != -1) ** GOTO lbl276
                    if (checkName.contains("PayPal")) continue;
                    if (StringCharUtils.isNullOrEmptyOrNothing(name)) {
                        art = "";
                    } else {
                        isSelfException = true;
                        throw new Exception("Datenzeile 'L_TYPE" + l + "=' in der Ergebnisliste nicht gefunden (idx -1 @ " + transactionID.get(l) + "); Bitte dem Entwickler im Forum melden");
lbl276:
                        // 1 sources

                        artStart = dataMessage.indexOf("=", artStart) + 1;
                        ArtEnd = dataMessage.indexOf("&L", artStart);
                        checkArt = dataMessage.substring(artStart, ArtEnd).replace("\"", "").replace(";", ",");
                        art = ApiUtils.translateTransactions(checkArt, "Typ", checkName, externalLogger, externalProgressMonitor);
                    }
                    if (checkArt.equals("Subscription Completion") || checkArt.equals("Subscription Creation")) continue;
                    statusStart = dataMessage.indexOf("L_STATUS" + l + "=");
                    if (statusStart == -1) {
                        isSelfException = true;
                        throw new Exception("Datenzeile 'L_STATUS" + l + "=' in der Ergebnisliste nicht gefunden (idx -1 @ " + transactionID.get(l) + "); Bitte dem Entwickler im Forum melden");
                    }
                    statusStart = dataMessage.indexOf("=", statusStart) + 1;
                    statusEnd = dataMessage.indexOf("&L", statusStart);
                    checkStatus = dataMessage.substring(statusStart, statusEnd).replace("\"", "").replace(";", ",");
                    status = ApiUtils.translateTransactions(checkStatus, "Status", "", externalLogger, externalProgressMonitor);
                    if (checkStatus.equals("Created") || checkStatus.equals("Canceled") || checkStatus.equals("Pending") || checkStatus.equals("Suspended") || checkStatus.equals("Updated")) continue;
                    waehrungStart = dataMessage.indexOf("L_CURRENCYCODE" + l + "=");
                    if (waehrungStart == -1) {
                        isSelfException = true;
                        throw new Exception("Datenzeile 'L_CURRENCYCODE" + l + "=' in der Ergebnisliste nicht gefunden (idx -1 @ " + transactionID.get(l) + "); Bitte dem Entwickler im Forum melden");
                    }
                    waehrungStart = dataMessage.indexOf("=", waehrungStart) + 1;
                    waehrungEnd = dataMessage.indexOf("&L", waehrungStart);
                    waehrung = dataMessage.substring(waehrungStart, waehrungEnd).replace("\"", "").replace(";", ",");
                    bruttoStart = dataMessage.indexOf("L_AMT" + l + "=");
                    if (bruttoStart == -1) {
                        isSelfException = true;
                        throw new Exception("Datenzeile 'L_AMT" + l + "=' in der Ergebnisliste nicht gefunden (idx -1 @ " + transactionID.get(l) + "); Bitte dem Entwickler im Forum melden");
                    }
                    bruttoStart = dataMessage.indexOf("=", bruttoStart) + 1;
                    bruttoEnd = dataMessage.indexOf("&L", bruttoStart);
                    brutto = dataMessage.substring(bruttoStart, bruttoEnd).replace("\"", "").replace(";", ",");
                    gebuehrStart = dataMessage.indexOf("L_FEEAMT" + l + "=");
                    if (gebuehrStart == -1) {
                        isSelfException = true;
                        throw new Exception("Datenzeile 'L_FEEAMT" + l + "=' in der Ergebnisliste nicht gefunden (idx -1 @ " + transactionID.get(l) + "); Bitte dem Entwickler im Forum melden");
                    }
                    gebuehrStart = dataMessage.indexOf("=", gebuehrStart) + 1;
                    gebuehrEnd = dataMessage.indexOf("&L", gebuehrStart);
                    gebuehr = dataMessage.substring(gebuehrStart, gebuehrEnd).replace("\"", "").replace(";", ",");
                    nettoStart = dataMessage.indexOf("L_NETAMT" + l + "=");
                    if (nettoStart == -1) {
                        isSelfException = true;
                        throw new Exception("Datenzeile 'L_NETAMT" + l + "=' in der Ergebnisliste nicht gefunden (idx -1 @ " + transactionID.get(l) + "); Bitte dem Entwickler im Forum melden");
                    }
                    nettoStart = dataMessage.indexOf("=", nettoStart) + 1;
                    nettoEnd = dataMessage.indexOf("&", nettoStart);
                    netto = dataMessage.substring(nettoStart, nettoEnd).replace("\"", "").replace(";", ",");
                    setAnEmail = false;
                    if (dataMessage.indexOf("L_EMAIL" + l + "=") >= 0) {
                        an_E_Mail_AdresseStart = dataMessage.indexOf("L_EMAIL" + l + "=");
                        an_E_Mail_AdresseStart = dataMessage.indexOf("=", an_E_Mail_AdresseStart) + 1;
                        an_E_Mail_AdresseEnd = dataMessage.indexOf("&L", an_E_Mail_AdresseStart);
                        an_E_Mail_Adresse = dataMessage.substring(an_E_Mail_AdresseStart, an_E_Mail_AdresseEnd).replace("\"", "").replace("'", "").replace(";", ",");
                        setAnEmail = true;
                    }
                    transaktionscode = (String)transactionID.get(l);
                    if (!(!checkArt.equals("Payment") && !checkArt.equals("Authorization") && !checkArt.equals("Donation") || checkArt.equals("Fee Reversal") || checkArt.equals("Temporary Hold") || checkArt.equals("Authorization") || checkArt.equals("Bill") || checkStatus.equals("Created") || checkStatus.equals("Canceled") || checkStatus.equals("Reversed") || checkStatus.equals("Suspended") || checkStatus.equals("Unclaimed") || StringCharUtils.isNullOrEmptyOrNothing(checkName) || StringCharUtils.isNullOrEmptyOrNothing(checkArt) || checkStatus.equals("Returned"))) {
                        LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "API-Detailabruf der Transaktion mit der Abrufnummer: '" + l + "' von der Art '" + checkArt + "' und der ID '" + transaktionscode + "' ..."});
                        adr = "USER=" + responseUser + "&PWD=" + responsePassword + "&SIGNATURE=" + ResponseSign + "&VERSION=" + "204" + "&METHOD=GetTransactionDetails&TRANSACTIONID=" + transaktionscode;
                        send_adr = "https://api-3t.paypal.com/nvp?" + adr;
                        try {
                            apiresponse = syncWebClient.getPage(send_adr);
                            LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "apiresponse (Detailabruf): " + apiresponse});
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + error.getMessage());
                        }
                        if (apiresponse == null) {
                            throw new Exception("Transaktionsdetails (API) konnten nicht aufgerufen werden!");
                        }
                        detailDataMessage = URLDecoder.decode(apiresponse.getWebResponse().getContentAsString(Charset.forName("UTF-8")), "UTF-8");
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "DetailDataMessage: \n" + detailDataMessage});
                        try {
                            ApiUtils.checkApiResponse(detailDataMessage, "\nvom: " + datum + " mit Betrag: " + brutto + "\n" + art + " [" + checkArt + "]\n" + status + " [" + checkStatus + "]", externalLogger, externalProgressMonitor, ExternalDialogInterface);
                        }
                        catch (Exception error) {
                            transErrorDetail = "L_TIMESTAMP" + l + "=" + timestampText + "&L_TIMEZONE" + l + "=" + zeitzone + "&L_NAME" + l + "=" + checkName + "&L_TYPE" + l + "=" + checkArt;
                            if (setAnEmail) {
                                transErrorDetail = transErrorDetail + "&L_EMAIL" + l + "=" + an_E_Mail_Adresse;
                            }
                            transErrorDetail = transErrorDetail + "&L_STATUS" + l + "=" + checkStatus + "&L_CURRENCYCODE" + l + "=" + waehrung + "&L_AMT" + l + "=" + brutto + "&L_FEEAMT" + l + "=" + gebuehr + "&L_NETAMT" + l + "=" + netto;
                            LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] Original API-Response zur Fehleranalyse beim Entwickler (kann sensible Daten enthalten):\nDetailabruf zu Transaktion: " + transErrorDetail + "\n---------------BEGIN API-RESPONSE---------------\n" + detailDataMessage + "\n----------------END API-RESPONSE----------------"});
                            if (detailDataMessage.contains("ERRORCODE0=10004-DIESER-ERROR-IST-WIRD-IM-MOMENT-ANGEZEIGT-ABER-NICHT-IGNORIERT") && detailDataMessage.contains("LONGMESSAGE0=The transaction could not be loaded")) {
                                LogWarn.invoke((Object)LogWarn, new Object[]{"[WebSync:PayPal] API-Abruf wird nach Fehlerausgabe fortgesetzt..."});
                            }
                            isSelfException = true;
                            throw new Exception("Fehlermeldung des Servers: " + error.getMessage() + "\nBeim Detailabruf einer Transaktion: " + datum + "; " + brutto + "; " + art + "[" + checkArt + "]; " + status + "[" + checkStatus + "]");
                        }
                        try {
                            if (detailDataMessage.indexOf("&EMAIL=") >= 0) {
                                Von_E_Mail_AdresseStart = detailDataMessage.indexOf("&EMAIL=") + 7;
                                Von_E_Mail_AdresseEnd = detailDataMessage.indexOf("&", Von_E_Mail_AdresseStart);
                                von_E_Mail_Adresse = StringCharUtils.shrinkString(detailDataMessage.substring(Von_E_Mail_AdresseStart, Von_E_Mail_AdresseEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (!setAnEmail) {
                                if (detailDataMessage.indexOf("RECEIVEREMAIL=") >= 0) {
                                    an_E_Mail_AdresseStart = detailDataMessage.indexOf("RECEIVEREMAIL=") + 14;
                                    an_E_Mail_AdresseEnd = detailDataMessage.indexOf("&", an_E_Mail_AdresseStart);
                                    an_E_Mail_Adresse = StringCharUtils.shrinkString(detailDataMessage.substring(an_E_Mail_AdresseStart, an_E_Mail_AdresseEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                                } else if (detailDataMessage.indexOf("RECEIVERBUSINESS=") >= 0) {
                                    an_E_Mail_AdresseStart = detailDataMessage.indexOf("RECEIVERBUSINESS=") + 17;
                                    an_E_Mail_AdresseEnd = detailDataMessage.indexOf("&", an_E_Mail_AdresseStart);
                                    an_E_Mail_Adresse = StringCharUtils.shrinkString(detailDataMessage.substring(an_E_Mail_AdresseStart, an_E_Mail_AdresseEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                                }
                            }
                            if (detailDataMessage.indexOf("&PAYERSTATUS=") >= 0) {
                                status_der_GegenparteiStart = detailDataMessage.indexOf("&PAYERSTATUS=") + 13;
                                status_der_GegenparteiEnd = detailDataMessage.indexOf("&", status_der_GegenparteiStart);
                                status_der_Gegenpartei = StringCharUtils.shrinkString(detailDataMessage.substring(status_der_GegenparteiStart, status_der_GegenparteiEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&ADDRESSSTATUS=") >= 0) {
                                adressstatusStart = detailDataMessage.indexOf("&ADDRESSSTATUS=") + 15;
                                adressstatusEnd = detailDataMessage.indexOf("&", adressstatusStart);
                                adressstatus = StringCharUtils.shrinkString(detailDataMessage.substring(adressstatusStart, adressstatusEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&L_NAME0=") >= 0) {
                                feldnr = 0;
                                do {
                                    verwendungszweckStart = detailDataMessage.indexOf("&L_NAME" + feldnr);
                                    verwendungszweckText = StringCharUtils.shrinkString(detailDataMessage.substring(verwendungszweckStart = detailDataMessage.indexOf("=", verwendungszweckStart) + 1, verwendungszweckEnd = detailDataMessage.indexOf("&L", verwendungszweckStart)));
                                    if (verwendungszweckText.indexOf("BASE64_") >= 0) {
                                        endOfBase64 = verwendungszweckText.indexOf("xxxBASE64_ENDxxx");
                                        if (endOfBase64 == -1) {
                                            throw new Exception("Das Ende dieser Base64-Zeile konnte nicht ermittelt werden: " + verwendungszweckText);
                                        }
                                        Base64byte = DatatypeConverter.parseBase64Binary((String)new String(verwendungszweckText.substring(18, endOfBase64)));
                                        verwendungszweckText = StringCharUtils.shrinkString(new String(Base64byte, "UTF-8"));
                                    }
                                    verwendungszweck = feldnr == 0 ? verwendungszweckText : verwendungszweck + ", " + verwendungszweckText;
                                } while (detailDataMessage.indexOf("&L_NAME" + ++feldnr + "=") >= 0);
                                if (verwendungszweck.indexOf("BASE64_") >= 0 && detailDataMessage.indexOf("&SUBJECT=") >= 0) {
                                    verwendungszweckStart = detailDataMessage.indexOf("&SUBJECT=") + 9;
                                    verwendungszweckEnd = detailDataMessage.indexOf("&", verwendungszweckStart);
                                    verwendungszweck = StringCharUtils.shrinkString(detailDataMessage.substring(verwendungszweckStart, verwendungszweckEnd));
                                }
                            } else if (detailDataMessage.indexOf("&SUBJECT=") >= 0) {
                                verwendungszweckStart = detailDataMessage.indexOf("&SUBJECT=") + 9;
                                verwendungszweckEnd = detailDataMessage.indexOf("&", verwendungszweckStart);
                                verwendungszweck = StringCharUtils.shrinkString(detailDataMessage.substring(verwendungszweckStart, verwendungszweckEnd));
                            }
                            verwendungszweck = (verwendungszweck = verwendungszweck.replace("Shopping Cart", "")).startsWith("\"") != false ? verwendungszweck.replaceAll("\"", "'") : verwendungszweck.replaceAll("\"", "\\\"");
                            verwendungszweck = verwendungszweck.replace(";", ",");
                            if (detailDataMessage.indexOf("&L_NUMBER0=") >= 0) {
                                feldnr = 0;
                                do {
                                    artikelnummerStart = detailDataMessage.indexOf("&L_NUMBER" + feldnr);
                                    artikelnummerStart = detailDataMessage.indexOf("=", artikelnummerStart) + 1;
                                    artikelnummerEnd = detailDataMessage.indexOf("&", artikelnummerStart);
                                    artikelnummer = feldnr == 0 ? detailDataMessage.substring(artikelnummerStart, artikelnummerEnd).replace("\"", "").replace("'", "").replace(";", ",") : artikelnummer + " " + detailDataMessage.substring(artikelnummerStart, artikelnummerEnd).replace("\"", "").replace("'", "").replace(";", ",");
                                } while (detailDataMessage.indexOf("&L_NUMBER" + ++feldnr + "=") >= 0);
                            }
                            if (detailDataMessage.indexOf("&SHIPPINGAMT=") >= 0) {
                                betrag_fuer_VersandkostenStart = detailDataMessage.indexOf("&SHIPPINGAMT=") + 13;
                                betrag_fuer_VersandkostenEnd = detailDataMessage.indexOf("&", betrag_fuer_VersandkostenStart);
                                betrag_fuer_Versandkosten = detailDataMessage.substring(betrag_fuer_VersandkostenStart, betrag_fuer_VersandkostenEnd).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&INSURANCEAMOUNT=") >= 0) {
                                versicherungsbetragStart = detailDataMessage.indexOf("&INSURANCEAMOUNT=") + 17;
                                versicherungsbetragEnd = detailDataMessage.indexOf("&", versicherungsbetragStart);
                                versicherungsbetrag = detailDataMessage.substring(versicherungsbetragStart, versicherungsbetragEnd).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&TAXAMT=") >= 0) {
                                umsatzsteuerStart = detailDataMessage.indexOf("&TAXAMT=") + 8;
                                umsatzsteuerEnd = detailDataMessage.indexOf("&", umsatzsteuerStart);
                                umsatzsteuer = detailDataMessage.substring(umsatzsteuerStart, umsatzsteuerEnd).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&CLOSINGDATE=") >= 0) {
                                timestampStart = detailDataMessage.indexOf("CLOSINGDATE=") + 12;
                                timestampEnd = detailDataMessage.indexOf("&", timestampStart);
                                timestampText = detailDataMessage.substring(timestampStart, timestampEnd).replace("\"", "").replace("'", "").replace(";", ",");
                                datumZeit = timestampText.split("T");
                                datumTeile = datumZeit[0].split("-");
                                angebotsende = datumTeile[2] + "." + datumTeile[1] + "." + datumTeile[0];
                            }
                            if (detailDataMessage.indexOf("&INVNUM=") >= 0) {
                                rechnungsnummerStart = detailDataMessage.indexOf("&INVNUM=") + 8;
                                rechnungsnummerEnd = detailDataMessage.indexOf("&", rechnungsnummerStart);
                                rechnungsnummer = detailDataMessage.substring(rechnungsnummerStart, rechnungsnummerEnd);
                                StringCharUtils.shrinkString(rechnungsnummer).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&SHIPTOSTREET=") >= 0) {
                                adresseStart = detailDataMessage.indexOf("&SHIPTOSTREET=") + 14;
                                adresseEnd = detailDataMessage.indexOf("&", adresseStart);
                                adresse = StringCharUtils.shrinkString(detailDataMessage.substring(adresseStart, adresseEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&SHIPTOSTREET2=") >= 0) {
                                zusaetzliche_AngabenStart = detailDataMessage.indexOf("&SHIPTOSTREET2=") + 15;
                                zusaetzliche_AngabenEnd = detailDataMessage.indexOf("&", zusaetzliche_AngabenStart);
                                zusaetzliche_Angaben = StringCharUtils.shrinkString(detailDataMessage.substring(zusaetzliche_AngabenStart, zusaetzliche_AngabenEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&SHIPTOCITY=") >= 0) {
                                ortStart = detailDataMessage.indexOf("&SHIPTOCITY=") + 12;
                                ortEnd = detailDataMessage.indexOf("&", ortStart);
                                ort = StringCharUtils.shrinkString(detailDataMessage.substring(ortStart, ortEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&SHIPTOSTATE=") >= 0) {
                                staat_Provinz_RegionStart = detailDataMessage.indexOf("&SHIPTOSTATE=") + 13;
                                staat_Provinz_RegionEnd = detailDataMessage.indexOf("&", staat_Provinz_RegionStart);
                                staat_Provinz_Region = StringCharUtils.shrinkString(detailDataMessage.substring(staat_Provinz_RegionStart, staat_Provinz_RegionEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&SHIPTOZIP=") >= 0) {
                                PLZStart = detailDataMessage.indexOf("&SHIPTOZIP=") + 11;
                                PLZEnd = detailDataMessage.indexOf("&", PLZStart);
                                plz = StringCharUtils.shrinkString(detailDataMessage.substring(PLZStart, PLZEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&SHIPTOCOUNTRYNAME=") >= 0) {
                                landStart = detailDataMessage.indexOf("&SHIPTOCOUNTRYNAME=") + 19;
                                landEnd = detailDataMessage.indexOf("&", landStart);
                                land = StringCharUtils.shrinkString(detailDataMessage.substring(landStart, landEnd)).replace("\"", "").replace("'", "").replace(";", ",");
                            }
                            if (detailDataMessage.indexOf("&NOTE=") >= 0) {
                                notizStart = detailDataMessage.indexOf("&NOTE=") + 6;
                                notizEnd = detailDataMessage.indexOf("&", notizStart);
                                notiz = StringCharUtils.shrinkString(detailDataMessage.substring(notizStart, notizEnd));
                            }
                            notiz = notiz.startsWith("\"") != false ? notiz.replaceAll("\"", "'") : notiz.replaceAll("\"", "\\\"");
                            notiz = notiz.replace(";", ",");
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("Die Transaktionsdaten konnten nicht ohne Fehler ausgelesen werden (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                    }
                    LogDebug.invoke((Object)LogDebug, new Object[]{"[WebSync:PayPal] " + getLogMethod + "Detailabruf der Transaktion mit der Abrufnummer: '" + l + "' von der Art '" + checkArt + "' und der ID '" + transaktionscode + "' wurde ausgelassen!"});
                    if (transData == null) {
                        throw new Exception("Der Kontoauszug konnte nicht erstellt werden! (TransData=NULL)");
                    }
                    if (checkArt.equals("Fee Reversal") || checkArt.equals("Authorization") || checkStatus.equals("Canceled") || checkArt.equals("Bill")) continue;
                    transData = transData + datum + ";" + zeit + ";" + zeitzone + ";" + name + ";" + art + ";" + status + ";" + waehrung + ";" + brutto + ";" + gebuehr + ";" + netto + ";" + von_E_Mail_Adresse + ";" + an_E_Mail_Adresse + ";" + transaktionscode + ";" + status_der_Gegenpartei + ";" + adressstatus + ";" + verwendungszweck + ";" + artikelnummer + ";" + betrag_fuer_Versandkosten + ";" + versicherungsbetrag + ";" + umsatzsteuer + ";" + kaeufer_ID + ";" + angebotsende + ";" + rechnungsnummer + ";" + guthaben + ";" + adresse + ";" + zusaetzliche_Angaben + ";" + ort + ";" + staat_Provinz_Region + ";" + plz + ";" + land + ";" + notiz + "\n";
                }
                if (lastIntervall) {
                    stopAPIcall = true;
                    continue;
                }
                fromDate.setTime(fromDate.getTime() + intervall);
                toDate.setTime(toDate.getTime() + intervall);
                if (toDate.getTime() < DateNow.getTime()) continue;
                lastIntervall = true;
                toDate = DateNow;
            } while (!stopAPIcall);
            try {
                WebUtils.checkResponse(transData, apiresponse, externalLogger, externalProgressMonitor, ExternalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "formated apiResponse: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n"});
            if (transData.contains("<html") || transData.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            DataResponse = new String[]{transData, String.valueOf(amount)};
            transData = transData.replace("\u26aa", "");
            transData = transData.replace("\u26ab", "");
            transData = transData.replace("\u26ac", "");
            transData = transData.replace("\u26ad", "");
            transData = transData.replace("\u26ae", "");
            transData = transData.replace("\u26af", "");
            transData = transData.replace("\\/", "/");
            transData = transData.replace("\\", "");
            matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", "\\\""), '\"', ';', externalLogger);
            transactionDataList = new ArrayList<ArrayList<E>>();
            arrayRowCount = 0;
            Saldo = StringCharUtils.mathRound(amount, 2);
            prevNetto = 0.0;
            for (i = matrixArrayData.length - 1; i >= 0; --i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ..."});
                try {
                    CheckColumn = matrixArrayData[i][0].split("\\.");
                    testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ..."});
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + e.toString()});
                    continue;
                }
                LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "MatrixArrayData to Read: Zeile Nr.: " + i + " wird ausgelesen: " + ArrayUtils.toString((Object)matrixArrayData[i])});
                try {
                    gebuehr = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][8]).replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll("\u20ac", "").replaceAll("&euro;", "").replaceAll("\\+", "").replaceAll("\\s+", "").trim());
                    if (gebuehr != 0.0) {
                        GebuehrArt = "PayPal-Geb\u00fchren";
                        if (String.valueOf(gebuehr).indexOf("-") == -1) {
                            GebuehrArt = "Widerrufene Geb\u00fchr";
                        }
                        transactionDataList.add(new ArrayList<E>());
                        arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.mathRound(gebuehr, 2));
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.mathRound(Saldo, 2));
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][6]);
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(GebuehrArt);
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(GebuehrArt);
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11)});
                        Kommentar = "";
                        if (!matrixArrayData[i][6].equals("EUR")) {
                            Kommentar = "Tats\u00e4chliche W\u00e4hrung: " + matrixArrayData[i][6];
                        }
                        if (!StringCharUtils.isNullOrEmptyOrNothing(Kommentar)) {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add(GebuehrArt + " zur Transaktion: " + matrixArrayData[i][12] + "\n\n" + Kommentar);
                        } else {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add(GebuehrArt + " zur Transaktion: " + matrixArrayData[i][12]);
                        }
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12)});
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][12])) {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][12]);
                        } else {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        }
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13)});
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][5])) {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][5]);
                        } else {
                            ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        }
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18)});
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                        LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19)});
                        ++arrayRowCount;
                        Saldo = StringCharUtils.mathRound(Saldo - gebuehr, 2);
                    }
                    transactionDataList.add(new ArrayList<E>());
                    arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1)});
                    Betrag = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][7]).replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll("\u20ac", "").replaceAll("&euro;", "").replaceAll("\\+", "").replaceAll("\\s+", "").trim());
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.mathRound(Betrag, 2));
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.mathRound(Saldo, 2));
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][6]);
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][4]);
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5)});
                    purpbuild = new String();
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][15])) {
                        purpbuild = matrixArrayData[i][15];
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][16])) {
                        purpbuild = purpbuild + " Artikelnummer " + matrixArrayData[i][16];
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(purpbuild.replaceAll("\\<.*?\\>", "")));
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8)});
                    ggktonr = "";
                    email_von = StringCharUtils.shrinkString(matrixArrayData[i][10].toLowerCase()).replaceAll("\\s", "");
                    email_an = StringCharUtils.shrinkString(matrixArrayData[i][11].toLowerCase()).replaceAll("\\s", "");
                    checkmail = StringCharUtils.shrinkString(kundennummer.toLowerCase()).replaceAll("\\s", "");
                    if (ggktonr.length() > 34) {
                        ggktonr = ggktonr.substring(0, 34);
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(email_von) && !email_von.equals(checkmail)) {
                        ggktonr = email_von;
                    }
                    if (StringCharUtils.isNullOrEmptyOrNothing(ggktonr) && !StringCharUtils.isNullOrEmptyOrNothing(email_an) && !email_an.equals(checkmail) && !StringCharUtils.isNullOrEmptyOrNothing(email_an)) {
                        ggktonr = email_an;
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][3]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(ggktonr);
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11)});
                    Kommentar = "";
                    if (!matrixArrayData[i][6].equals("EUR")) {
                        Kommentar = "Tats\u00e4chliche W\u00e4hrung: " + matrixArrayData[i][6];
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][30])) {
                            Kommentar = Kommentar + "\nHinweis: ";
                        }
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][30])) {
                        Kommentar = Kommentar + matrixArrayData[i][30];
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Kommentar);
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12)});
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][12])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][12]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13)});
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][5])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][5]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18)});
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, new Object[]{"[WebSync:PayPal] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19)});
                    ++arrayRowCount;
                    Saldo = StringCharUtils.mathRound(Saldo - Betrag, 2);
                    continue;
                }
                catch (Exception err) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)err));
                }
            }
            sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "inclInterBalace", externalLogger, externalProgressMonitor);
            sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("PayPal", responseUser, amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseUser, "*******").replace(responsePassword, "*******"));
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error).replace(responseUser, "*******").replace(responsePassword, "*******"));
        }
    }
}

