/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.openbank;

import de.derrichter.finance.websync.institute.openbank.InstitutOptions;
import de.derrichter.finance.websync.institute.openbank.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        try {
            try {
                String detectPath = "//div[contains(@class,'interstitial-generic')]";
                String messagePath = detectPath + "//*[@class='interstitial-c__body']";
                String closePath = detectPath + "//*[contains(@class,'interstitial-close-button')]";
                boolean hasAbortButton = false;
                do {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPath)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                    String formWarnText = "";
                    List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)messagePath));
                    for (WebElement headline : allHeadlines) {
                        String headlinetext = headline.getText();
                        formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:Openbank] ", headlinetext, externalLogger) + " ";
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "warnText: " + formWarnText);
                    if (!formWarnText.contains("Freigabeverfahren verwalten")) {
                        DialogWarn.invoke((Object)DialogWarn, "Meldung der Open Bank, S.A.:\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://www.openbank.de/?toggleLogin" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-openbank.png");
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closePath)));
                    }
                    catch (NoSuchElementException | TimeoutException notAborterr) {
                        hasAbortButton = false;
                        isSelfException = true;
                        throw new Exception("Im Onlinebanking muss auf folgende Meldung reagiert werden: " + formWarnText.trim());
                    }
                    hasAbortButton = true;
                    LogWarn.invoke((Object)LogWarn, "[WebSync:Openbank] Meldung(en) der Bank: " + formWarnText);
                    MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (hasAbortButton);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "Konto\u00fcbersicht-Seite aufrufen ...");
            try {
                seleniumWebDriver.get(InstitutOptions.ACCOUNTS_URL);
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "accountspage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kontonummer enthalten ist ...");
            LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "Kontonummer (formated): " + kontonummer.substring(kontonummer.length() - 4));
            try {
                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//section[contains(.,'" + kontonummer.substring(kontonummer.length() - 4) + "')]"))));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
            }
            catch (NoSuchElementException | TimeoutException noCreditCard) {
                isSelfException = true;
                throw new Exception("Abbruch: Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "Kontodetails-Seite aufrufen ...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountDetails", "//section[contains(.,'" + kontonummer.substring(kontonummer.length() - 4) + "')]//a", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            try {
                String amountText = seleniumWebDriver.findElement(By.xpath((String)"(//span[contains(@class,'account-header-details__amount')])[3]")).getText().trim();
                LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "amountText: " + amountText);
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Kontostand' fehlgeschlagen: " + error.getMessage());
            }
            try {
                String availableAmountText = seleniumWebDriver.findElement(By.xpath((String)"(//span[contains(@class,'account-header-details__amount')])[1]")).getText().trim();
                LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "availableAmountText: " + availableAmountText);
                availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Verf\u00fcgbarer Betrag' fehlgeschlagen: " + error.getMessage() + "; Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "Amount: " + amount);
            LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "availableAmount: " + availableAmount);
            String dataPageResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(dataPageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            boolean haveNewTrans = false;
            File downloadedFile = null;
            boolean localTest = false;
            if (localTest) {
                haveNewTrans = true;
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontotransaktionen.xls";
                downloadedFile = new File(docFixTempFilePath);
            }
            if (!localTest) {
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterButton", "//button[contains(@id,'DISABLED_FOR_TEST_filterButton')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String startDateInputPath = "(//input[@class='ok-date-picker__input'])[1]";
                String endDateInputPath = "(//input[@class='ok-date-picker__input'])[2]";
                String dayInputPath = "//input[contains(@class,'input-custom-day')]";
                String monthInputPath = "//input[contains(@class,'input-custom-month')]";
                String yearInputPath = "//input[contains(@class,'input-custom-year')]";
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "customDateFilterButton", "//input[@type='radio' and @value='Custom']//following::label", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)startDateInputPath)));
                WebElement fromDateField = seleniumWebDriver.findElement(By.xpath((String)startDateInputPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "fromDateField: " + fromDateField);
                WebElement toDateField = seleniumWebDriver.findElement(By.xpath((String)endDateInputPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "toDateField: " + toDateField);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "fromDateField", startDateInputPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    WebElement fromDayField = seleniumWebDriver.findElement(By.xpath((String)dayInputPath));
                    fromDayField.clear();
                    fromDayField.sendKeys(new CharSequence[]{fromDateSimple.substring(0, 2)});
                    WebElement fromMonthField = seleniumWebDriver.findElement(By.xpath((String)monthInputPath));
                    fromMonthField.clear();
                    fromMonthField.sendKeys(new CharSequence[]{fromDateSimple.substring(3, 5)});
                    WebElement fromYearField = seleniumWebDriver.findElement(By.xpath((String)yearInputPath));
                    fromYearField.clear();
                    fromYearField.sendKeys(new CharSequence[]{fromDateSimple.substring(6)});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "toDateField", endDateInputPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    WebElement toDayField = seleniumWebDriver.findElement(By.xpath((String)dayInputPath));
                    toDayField.clear();
                    toDayField.sendKeys(new CharSequence[]{toDateSimple.substring(0, 2)});
                    WebElement toMonthField = seleniumWebDriver.findElement(By.xpath((String)monthInputPath));
                    toMonthField.clear();
                    toMonthField.sendKeys(new CharSequence[]{toDateSimple.substring(3, 5)});
                    WebElement toYearField = seleniumWebDriver.findElement(By.xpath((String)yearInputPath));
                    toYearField.clear();
                    toYearField.sendKeys(new CharSequence[]{toDateSimple.substring(6)});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Anfordern-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitButton", "(//button[contains(@class,'buttons-base--primary')])[last()]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterSearchResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterSearchResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                try {
                    String check2FAviewPath = "//p[contains(.,' \u00fcber 90 Tage alt') and contains(.,'einen Code per ')]";
                    WebElement check2FAview = seleniumWebDriver.findElement(By.xpath((String)check2FAviewPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "check2FAview: " + check2FAview);
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "Openbank" + "2FA-Verfahren anfragen, da auf der Homepage Transaktionen \u00e4lter als 90 Tage vorhanden sind...");
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitButton", "//button[contains(@class,'buttons-base--primary')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                }
                catch (NoSuchElementException | TimeoutException not2FAtext) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "kein Hinweis auf alte Transkaktionen \u00e4lter als 90 Tage");
                }
                try {
                    String checkMoreViewPath = "//div[contains(@class,'more-movements')]//a";
                    Iterator checkMoreView = seleniumWebDriver.findElement(By.xpath((String)checkMoreViewPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "checkMoreView: " + checkMoreView);
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "Openbank" + "2FA-Verfahren anfragen, da auf der Homepage weitere Transaktionen vorhanden sind, vermutlich \u00e4lter als 90 Tage...");
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitButton", checkMoreViewPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitButton", "//button[contains(@class,'buttons-base--primary')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                }
                catch (NoSuchElementException | TimeoutException not2FAtext) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "kein Hinweis auf alte Transkaktionen \u00e4lter als 90 Tage");
                }
                try {
                    try {
                        if (WebUtils.checkForMTAN(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "Openbank" + "-2FA-Login mit mTAN durchlaufen");
                        } else {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "2FA-Verfahren nicht erkannt, daher wohl nicht notwendig, mache weiter..." + seleniumWebDriver.getPageSource());
                        }
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    pageAfterSearchResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfterSearchResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                }
                catch (NoSuchElementException | TimeoutException wrongTAN) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "kein Hinweis auf alte Transkaktionen \u00e4lter als 90 Tage");
                }
            }
            String noTransPath = "//div[contains(.,'Es wurden keine Transaktionen ')]";
            try {
                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)noTransPath)));
                WebElement lastDate = seleniumWebDriver.findElement(By.xpath((String)noTransPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] keine aktuelle Transaktionen vorhanden: " + noTransPath);
                haveNewTrans = false;
            }
            catch (Exception waiterror) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] xpath " + noTransPath + "NICHT gefunden; Es sollten (aktuelle) Transaktionen vorhanden sein...");
                haveNewTrans = true;
            }
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Open Bank, S.A.\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\n";
            String doctext = null;
            String doctype = "";
            if (haveNewTrans || localTest) {
                boolean downloadedFileIsFalse = false;
                int downloadCount = 1;
                do {
                    if (!localTest) {
                        String downloadButtonPath = "//button[@id='btnDownloadAccountTransactions']";
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadButton", downloadButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        downloadButtonPath = "//span[contains(.,'Excel')]//ancestor::button[contains(@class,'buttons-base--')]";
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadExcelButton", downloadButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download eines Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                    doctype = downloadedFile.getAbsolutePath().substring(downloadedFile.getAbsolutePath().lastIndexOf(".") + 1).toUpperCase();
                    if (doctype.toLowerCase().equals("txt") || doctype.toLowerCase().equals("htm") || doctype.toLowerCase().equals("html") || doctype.toLowerCase().equals("asp") || doctype.toLowerCase().equals("js")) {
                        LogWarn.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / Falscher Dateityp, versuche es nochmals ...");
                        ++downloadCount;
                        downloadedFileIsFalse = true;
                    } else {
                        downloadedFileIsFalse = false;
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                } while (downloadedFileIsFalse);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "Erzeuge einen Kontoauszug aus dem " + doctype + "-Dokument ...");
                try {
                    Document doc = Jsoup.parse((File)downloadedFile, (String)"ISO-8859-15", (String)"http://example.com/");
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "[XHTML-Document.load FILE]:\n" + doc);
                    Element table = doc.select("table").first();
                    Elements rows = table.select("tr");
                    for (Element row : rows) {
                        Elements cols = row.select("td");
                        for (Element col : cols) {
                            doctext = doctext + col.text() + ";";
                        }
                        doctext = doctext + "\n";
                    }
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Beim Lesen des " + doctype + "-Kontoauszug hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                if (!localTest) {
                    FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedFile);
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "fileResponse with jsoup-parsing: \n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
                transData = doctext;
            }
            String[] dataResponse = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayData = StringCharUtils.data2matrixArray(transData, '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                try {
                    if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][1])) continue;
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                    String[] checkColumn = matrixArrayData[i][1].split("/");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][1].trim().split("/");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][3].trim().split("/");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][7], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    String art = "";
                    art = String.valueOf(betrag).contains("-") ? "Abbuchung" : "Gutschrift";
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(art));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    String purp = matrixArrayData[i][5];
                    if (!StringCharUtils.isNullOrEmptyOrNothing(purp)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(purp.replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("Openbank", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

