/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.openbank;

import de.derrichter.finance.websync.institute.openbank.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(20L));
        try {
            if (!responseLogin.startsWith("P-") && !responseLogin.startsWith("R-")) {
                isSelfException = true;
                throw new Exception("Benutzerkennung nicht im erforderlichen Format angegeben: Geben Sie zuerst P- f\u00fcr Personalausweis oder R- f\u00fcr Reisepass und gleich dahinter Ihre Reisepass- oder Personalausweis- Dokumentennummer die Sie auf der Hompage des Online-Banking angeben. Also im Format P-XXXXXXXXX oder R-XXXXXXXXX");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "Openbank" + "-Login aufrufen ... (GET " + "https://www.openbank.de/?toggleLogin" + ")");
            try {
                seleniumWebDriver.get("https://www.openbank.de/?toggleLogin");
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            Thread.sleep(3500L);
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                seleniumWebDriver.manage().addCookie(new Cookie("CONSENTMGR", "c1:0%7Cc2:0%7Cc3:0%7Cc4:0%7Cc5:0%7Cc6:0%7Cc7:0%7Cc8:0%7Cc9:0%7Cc10:0%7Cc11:0%7Cc12:0%7Cc13:0%7Cc14:0%7Cc15:0%7Cts:1678016523781%7Cconsent:false"));
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                Thread.sleep(5000L);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Cookie mit Ablehnung konnte in der aktuellen Browser-Sitzung nicht erstellt werden: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                String selectWrapperPath = "//span[@class='Select-multi-value-wrapper']";
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)selectWrapperPath)));
                WebElement selectWrapper = seleniumWebDriver.findElement(By.xpath((String)selectWrapperPath));
                if (responseLogin.startsWith("R-")) {
                    selectWrapper.click();
                    new Actions(seleniumWebDriver).sendKeys(new CharSequence[]{Keys.ARROW_DOWN}).sendKeys(new CharSequence[]{Keys.ENTER}).perform();
                }
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                String userNameXpath = "//input[@name='documentNumber']";
                String passXpath = "//input[@id='userPassword']";
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)userNameXpath)));
                WebElement inputUsername = seleniumWebDriver.findElement(By.xpath((String)userNameXpath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "inputUsername: " + inputUsername);
                WebElement inputPasswd = seleniumWebDriver.findElement(By.xpath((String)passXpath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "inputPassword: " + inputPasswd);
                inputUsername.click();
                inputUsername.sendKeys(new CharSequence[]{responseLogin.replace("R-", "").replace("P-", "")});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(2500L);
                inputPasswd.click();
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(1500L);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[contains(@class,'primary')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            Thread.sleep(3500L);
            try {
                seleniumWebDriver.manage().addCookie(new Cookie("CONSENTMGR", "c1:0%7Cc2:0%7Cc3:0%7Cc4:0%7Cc5:0%7Cc6:0%7Cc7:0%7Cc8:0%7Cc9:0%7Cc10:0%7Cc11:0%7Cc12:0%7Cc13:0%7Cc14:0%7Cc15:0%7Cts:1678016523781%7Cconsent:false"));
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Cookie mit Ablehnung konnte in der aktuellen Browser-Sitzung nicht erstellt werden: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                if (WebUtils.checkForMTAN(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "Openbank" + "-2FA-Login mit mTAN durchlaufen");
                } else {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "2FA-Verfahren nicht erkannt, daher wohl nicht notwendig, mache weiter..." + seleniumWebDriver.getPageSource());
                }
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//button[contains(.,'Kundenbereich')]"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            catch (NoSuchElementException | TimeoutException throwable) {
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:Openbank] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "Abmelden aufrufen...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "logoutLink", "//button[contains(.,'Beenden')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String successLogoutXpath = "//button[contains(.,'Kundenbereich') or contains(.,'Inloggen')]";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Openbank] " + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:Openbank] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPage);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Openbank] " + getLogMethod + "Logout bei der '" + "Open Bank, S.A." + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:Openbank] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

