/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.onvistabank;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static String COOKIE_DETECT_PATH = "//*[@id='popin_tc_privacy']";
    static String COOKIE_ACCEPT_PATH = "//button[@id='popin_tc_privacy_button']";
    static String LOADER_CATCHSTRING = "DummyCatchString";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//*[name()='svg' and contains(@id,'loader')]//ancestor::div[@class='overlay']";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[2];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//div[contains(@class,'alert-danger')]";
        WebUtils.xpathSearchString[1] = "//strong[contains(.,'Wartungsarbeiten')]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "DummyExclusion";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:onvista] ";
        String longName = "onvista bank";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-onvistabank.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    static boolean checkForBankingApp(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        String getLogMethod = "[waitBankingApp] ";
        String tanArt = "BankingApp";
        String detectAppAuthPath = "//p[contains(.,'Auftrags in der App Hanseatic Bank Secure')]";
        String detectVerifiPath = "//div[contains(.,'Der Vorgang wird nun validiert')]";
        String detectAbortPath = "//p[contains(.,'Der Vorgang wurde abgebrochen')]";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:onvista] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectAppAuthPath)));
                LogInfo.invoke((Object)LogInfo, "[WebSync:onvista] " + getLogMethod + "Warte auf Banking-App Freigabe ...");
                MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                int rounds = 0;
                Thread.sleep(3000L);
                boolean showWaiting = true;
                boolean validating = false;
                while (true) {
                    WebElement waiterCheckElement = null;
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAppAuthPath));
                        showWaiting = true;
                    }
                    catch (NoSuchElementException noMoreWaiting) {
                        showWaiting = false;
                    }
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectVerifiPath));
                        validating = true;
                    }
                    catch (NoSuchElementException noMoreWaiting) {
                        validating = false;
                    }
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAbortPath));
                        isSelfException = true;
                        throw new Exception("Banking-App Authentifizierung: Der Vorgang wurde abgebrochen");
                    }
                    catch (NoSuchElementException noMoreWaiting) {
                        if (showWaiting) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:onvista] " + getLogMethod + "Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                            Thread.sleep(3000L);
                        } else if (validating) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:onvista] " + getLogMethod + "Validierung des Vorgang im gange ...");
                            MonitorLog.invoke((Object)MonitorLog, "Validierung des Vorgang im gange ...");
                            SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                        } else {
                            showWaiting = false;
                            validating = false;
                        }
                        if (++rounds >= 39) {
                            isSelfException = true;
                            throw new Exception("Banking-App Authentifizierung auch nach 120 Sekunden nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                            continue;
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                        if (showWaiting || validating) continue;
                    }
                    break;
                }
            }
            catch (TimeoutException noAuth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:onvista] " + getLogMethod + tanArt + "' wird NICHT (direkt) abgefragt oder hat sich ge\u00e4ndert? mache weiter ...");
                return false;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            isSelfException = true;
            throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return true;
    }

    static boolean checkForMTAN(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkForMTAN] ";
        String tanArt = "mobileTAN";
        String detectTANformPath = "//legend[contains(.,'smsTAN')]";
        String secTextPath = "//p[contains(.,'hinterlegte Mobilnummer')]";
        String tanInputPath = "//input[@data-test-id='input-sms']";
        String submitTanPath = "//button[@data-test-id='continue']";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:onvista] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                WebElement tanForm = seleniumWebDriver.findElement(By.xpath((String)detectTANformPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:onvista] " + getLogMethod + "tanForm: " + tanForm);
                LogDebug.invoke((Object)LogDebug, "[WebSync:onvista] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "tanForm", detectTANformPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String secText = seleniumWebDriver.findElement(By.xpath((String)("(" + secTextPath + ")"))).getText().trim().replace(" Bitte geben Sie Ihre Tan innerhalb des angezeigten Zeitlimits ein.", "");
                LogDebug.invoke((Object)LogDebug, "[WebSync:onvista] " + getLogMethod + "secText: " + secText);
                boolean retryInput = false;
                do {
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-onvistabank.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:onvista] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:onvista] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.clear();
                    new Actions(seleniumWebDriver).click(tanInput).sendKeys(new CharSequence[]{Keys.CLEAR}).sendKeys(new CharSequence[]{Keys.END}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).sendKeys(new CharSequence[]{Keys.BACK_SPACE}).perform();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTan", submitTanPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String pageAfterTanResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebElement checkWrongTAN = seleniumWebDriver.findElement(By.xpath((String)"//*[contains(.,'Ihre smsTAN ist falsch')]"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:onvista] " + getLogMethod + "checkWrongTAN: " + checkWrongTAN);
                        DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der onvista bank:\n\n\nDie eingegebene " + tanArt + " ist falsch.", "institutlogo-onvistabank.png");
                        retryInput = true;
                    }
                    catch (NoSuchElementException | TimeoutException wrongTAN) {
                        retryInput = false;
                    }
                    if (retryInput) continue;
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfterTanResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (retryInput);
            }
            catch (TimeoutException noTANauth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:onvista] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt oder wurde umgebaut? mache weiter ...");
                return false;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return true;
    }
}

