/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.n26;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebUtils {
    static String LOADER_CATCHSTRING = "DummyLoaderCatchString";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//span[contains(.,'L\u00e4dt...') or contains(.,'Wird geladen')]";
    static String LOADER_TEXT = "Wird geladen...";
    protected static String[] xpathSearchString = new String[3];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//h1[contains(.,'Hm, das ist ungew')]//parent::div";
        WebUtils.xpathSearchString[1] = "//h1[contains(.,'Well, that was unexpected')]//parent::div";
        WebUtils.xpathSearchString[2] = "//div[@role='alert']//span[text()!='']";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Auf deinem verkn\u00fcpften Ger\u00e4t zulassen";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:N26] ";
        String longName = "N26 Bank GmbH";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-n26.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    protected static void authMTAN(WebDriver seleniumWebDriver, boolean authManual, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        String getLogMethod = "[authMTAN] ";
        String loaderCatchString = "DummyCatchString";
        String loaderExclusion = "DummyLoaderExclution";
        String loaderPath = "//span[contains(.,'L\u00e4dt...') or contains(.,'Wird geladen')]";
        String loaderText = "Wird geladen...";
        String submitButtonPath = "//button[contains(.,'Weiter')]";
        boolean isSelfException = false;
        try {
            if (authManual) {
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "requestMTAN", submitButtonPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    WebUtils.waitButtonLoader(seleniumWebDriver, submitButtonPath, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            String secText = seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'geschickt')]")).getText();
            LogTrace.invoke((Object)LogTrace, "[WebSync:N26] secText: " + secText);
            WebElement inputMTAN = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'verificationCode')]"));
            LogDebug.invoke((Object)LogDebug, "[WebSync:N26] inputMTAN: " + inputMTAN);
            String userTanInput = null;
            String tanArt = "mobileTAN";
            try {
                userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-n26.png");
            }
            catch (InvocationTargetException error) {
                isSelfException = true;
                if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                    throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                }
                LogError.invoke((Object)LogError, "[WebSync:N26] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
            }
            inputMTAN.click();
            inputMTAN.sendKeys(new CharSequence[]{userTanInput});
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitMTAN", submitButtonPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                WebUtils.waitButtonLoader(seleniumWebDriver, submitButtonPath, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("mobileTan-Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    protected static void waitButtonLoader(WebDriver seleniumWebDriver, String buttonPath, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String logIdent = "[WebSync:N26] ";
        WebElement waiterCheck = null;
        boolean waitButtonLoader = true;
        Thread.sleep(1000L);
        do {
            try {
                waiterCheck = seleniumWebDriver.findElement(By.xpath((String)buttonPath));
            }
            catch (NoSuchElementException | TimeoutException noBestSign) {
                waitButtonLoader = false;
            }
            if (waiterCheck != null) {
                try {
                    LogTrace.invoke((Object)LogTrace, logIdent + "buttonCheck (outerHTML): " + waiterCheck.getAttribute("outerHTML"));
                }
                catch (StaleElementReferenceException ex) {
                    waiterCheck = seleniumWebDriver.findElement(By.xpath((String)buttonPath));
                }
                if (!waiterCheck.getAttribute("outerHTML").contains("c-spinner")) {
                    waitButtonLoader = false;
                }
                if (!waitButtonLoader) continue;
                LogInfo.invoke((Object)LogInfo, logIdent + "Loader 'Button-Spinner' erkannt, warte 1 Sekunde ...");
                Thread.sleep(1000L);
                continue;
            }
            waitButtonLoader = false;
        } while (waitButtonLoader);
    }
}

