/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.n26;

import de.derrichter.finance.websync.institute.n26.WebUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPush {
    private static String secAuthMeth = "PIN";

    public static String getSecAuthMeth() {
        return secAuthMeth;
    }

    public static void setSecAuthMeth(String value) {
        secAuthMeth = value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void transfer(WebDriver seleniumWebDriver, String kontonummer, String gegenkontoName, String gegenkontoIBAN, String gegenkontoBIC, String betrag, String verwendungszweck, String termin, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        Method DialogAskPIN = externalDialogInterface.getMethod("askPINforTransaction", String.class, String.class, String.class);
        String getLogMethod = "[sendTrans] ";
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Originale Auftragsdaten wie vom Programm \u00fcbergeben (Auftragskonto, IBAN, BIC und Betrag sind aber schon getrimmt)");
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Auftragskonto (IBAN):             " + gegenkontoName);
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Auftragskonto (IBAN):             " + kontonummer);
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Gegenkonto (IBAN):                " + gegenkontoIBAN);
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Gegenkonto (BIC):                 " + gegenkontoBIC);
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Auftragsdaten (Betrag):           " + betrag);
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Auftragsdaten (Verwendungszweck): " + verwendungszweck);
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Auftragsdaten (Termin):           " + termin);
        kontonummer = kontonummer.replaceAll("\\s+", "").trim();
        gegenkontoIBAN = gegenkontoIBAN.replaceAll("\\s+", "").trim();
        gegenkontoBIC = gegenkontoBIC.replaceAll("\\s+", "").trim();
        betrag = betrag.replaceAll("[^\\d,]", "").trim();
        gegenkontoName = gegenkontoName.replace("\u00c4", "Ae").replace("\u00e4", "ae").replace("\u00d6", "Oe").replace("\u00f6", "oe").replace("\u00dc", "Ue").replace("\u00fc", "ue").replace("\u00df", "ss").trim();
        verwendungszweck = verwendungszweck.replace("\u00c4", "Ae").replace("\u00e4", "ae").replace("\u00d6", "Oe").replace("\u00f6", "oe").replace("\u00dc", "Ue").replace("\u00fc", "ue").replace("\u00df", "ss").trim();
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        boolean isSelfException = false;
        try {
            String pin;
            block82: {
                Object resPurposeField;
                try {
                    String messagePath = "//div[@id='mailboxtermsconditions-submitButton' or @id='welcome-process-form' or @id='datenabgleich' or contains(@class,'modal-dialog') or contains(.,'Upgrade zu N26 Smart')]";
                    boolean hasAbortButton = false;
                    do {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:N26] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)messagePath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                        String formWarnText = "";
                        List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)(messagePath + "//h1")));
                        for (WebElement headline : allHeadlines) {
                            String headlinetext = headline.getText();
                            formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:N26] ", headlinetext, externalLogger) + " ";
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "warnText: " + formWarnText);
                        if (!formWarnText.contains("Upgrade zu N26 Smart")) {
                            DialogWarn.invoke((Object)DialogWarn, "Meldung der N26 Bank GmbH:\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://app.n26.com/login" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-n26.png");
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                        try {
                            wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//button[contains(.,'Schlie\u00dfen')]")));
                        }
                        catch (NoSuchElementException | TimeoutException notAborterr) {
                            hasAbortButton = false;
                            isSelfException = true;
                            throw new Exception(formWarnText.trim());
                        }
                        hasAbortButton = true;
                        LogWarn.invoke((Object)LogWarn, "[WebSync:N26] Meldung(en) der Bank: " + formWarnText);
                        MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", "//button[contains(.,'Schlie\u00dfen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                    } while (hasAbortButton);
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:N26] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 25);
                MonitorLog.invoke((Object)MonitorLog, "SEPA-\u00dcberweisungsformular aufrufen, ausf\u00fcllen und Authentifizierung anfordern ...");
                try {
                    seleniumWebDriver.get("https://app.n26.com/transfer");
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "transferpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 25);
                String resNamePath = "//input[@id='partner-name']";
                String resIbanPath = "//input[@id='partner-iban']";
                String resAmountPath = "//input[@id='transfer-amount']";
                String toPurposeButtonPath = "//button[@id='transfer-reference-message']";
                String resPurposePath = "//input[@id='transfer-reference-text']";
                String continueButtonPath = "//button[contains(.,'Weiter')]";
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)resNamePath)));
                try {
                    JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
                    try {
                        String contactButtonPath = "//p//child::button//ancestor::p//child::span[contains(.,'" + gegenkontoIBAN + "') or contains(.,'" + StringCharUtils.ibanAddSpaces(gegenkontoIBAN) + "')]";
                        LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "Pr\u00fcfe auf bereits vorhandenen Kontakt...");
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)contactButtonPath)));
                        MonitorLog.invoke((Object)MonitorLog, "F\u00fcr diese Gegenkonto-IBAN ist ein Kontakt vorhanden. Da dieser genutzt wird, wird der angegebene Name nun nicht \u00fcbernommen!");
                        LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "F\u00fcr diese Gegenkonto-IBAN ist ein Kontakt vorhanden. Da dieser genutzt wird, wird der angegebene Name nun nicht \u00fcbernommen!");
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "contactButton", contactButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception clickError) {
                            throw new Exception(clickError.getMessage());
                        }
                    }
                    catch (NoSuchElementException | TimeoutException noContact) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "Kein bekannter Kontakt vorhanden, verarbeite Daten manuell...");
                        try {
                            String contactButtonPath = "//p[not(contains(.,'Betrag'))]//child::button//ancestor::p//child::span[contains(.,' ') ]//ancestor::p";
                            LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "Pr\u00fcfe ob ein anderer Kontakt vorhanden ist...");
                            wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)contactButtonPath)));
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "newContactButton", "//button[contains(.,'Neuen Kontakt')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                            }
                            catch (Exception clickError) {
                                throw new Exception(clickError.getMessage());
                            }
                        }
                        catch (NoSuchElementException | TimeoutException contactButtonPath) {
                            // empty catch block
                        }
                        WebElement resNameField = seleniumWebDriver.findElement(By.id((String)"partner-name"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "resNameField: " + resNameField);
                        jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{resNameField});
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        if (resNameField.isEnabled()) {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resNameField", resNamePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                            resNameField.sendKeys(new CharSequence[]{gegenkontoName});
                            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        }
                        WebElement resIbanField = seleniumWebDriver.findElement(By.id((String)"partner-iban"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "resIban: " + resIbanPath);
                        jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{resIbanField});
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        if (resIbanField.isEnabled()) {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resIbanField", resIbanPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                            resIbanField.sendKeys(new CharSequence[]{gegenkontoIBAN});
                            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        } else if (!resIbanField.getAttribute("value").equals(StringCharUtils.ibanAddSpaces(gegenkontoIBAN))) {
                            isSelfException = true;
                            throw new Exception("Dieses Konto unterst\u00fctzt das Gegenkonto als Empf\u00e4nger nicht. Fest vorgegebene IBAN ist: " + resIbanField.getAttribute("value") + " (" + resNameField.getAttribute("value") + ")");
                        }
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "continueButton", continueButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception clickError) {
                            throw new Exception(clickError.getMessage());
                        }
                        String pageNewContact = seleniumWebDriver.getPageSource();
                        try {
                            WebUtils.checkSeleniumResponseHasError(pageNewContact, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                    }
                    WebElement resAmountField = seleniumWebDriver.findElement(By.id((String)"transfer-amount"));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "resAmount: " + resAmountField);
                    jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{resAmountField});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    if (resAmountField.isEnabled()) {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resAmountField", resAmountPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    resAmountField.sendKeys(new CharSequence[]{betrag});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "toPurposeButtonPath", toPurposeButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception clickError) {
                        throw new Exception(clickError.getMessage());
                    }
                    resPurposeField = seleniumWebDriver.findElement(By.id((String)"transfer-reference-text"));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "resPurposeField: " + resPurposePath);
                    resPurposeField.sendKeys(new CharSequence[]{verwendungszweck});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(500L);
                }
                catch (Exception error) {
                    if (isSelfException) {
                        throw new Exception(error.getMessage());
                    }
                    isSelfException = true;
                    throw new Exception("Fehler beim Setzen der Auftrags-Werte (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 35);
                try {
                    List errorTextObjects = seleniumWebDriver.findElements(By.xpath((String)"//div[@role='alert']//span[text()!='']"));
                    if (errorTextObjects.size() <= 0) {
                        throw new NoSuchElementException("");
                    }
                    String formatedMessageText = "";
                    resPurposeField = errorTextObjects.iterator();
                    while (true) {
                        if (!resPurposeField.hasNext()) {
                            DialogError.invoke((Object)DialogError, "(Werte im \u00dcberweisungsformular sind fehlerhaft)\n\nFehlermeldung(en) der N26 Bank GmbH:\n\n" + formatedMessageText, "institutlogo-n26.png");
                            isSelfException = true;
                            throw new Exception("(Werte im \u00dcberweisungsformular sind fehlerhaft) Fehlermeldung(en) des Servers: " + formatedMessageText.trim());
                        }
                        WebElement errorTextObject = (WebElement)resPurposeField.next();
                        String errorText = errorTextObject.getText();
                        LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "errorTextObject (getText): " + errorText);
                        if (StringCharUtils.isNullOrEmptyOrNothing(errorText)) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "diese xPathExpression ist aber beim Auslesen mit Selenium leer und liefert keinen Text ... versuche noch alternativ den CSS-InnerHTML ...");
                            errorText = errorTextObject.getAttribute("innerHTML");
                            errorText = errorText.replaceAll("\\<.*?\\>", "").trim();
                            if (StringCharUtils.isNullOrEmptyOrNothing(errorText)) {
                                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "diese xPathExpression ist aber scheinbar wirklich leer und liefert keinen Text ...");
                            } else {
                                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "diese xPathExpression enth\u00e4lt den innerHTML (ohne HTML-Tags!) also nur Text: " + errorText);
                            }
                        }
                        formatedMessageText = formatedMessageText + "\n" + errorText;
                    }
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "OK. \u00dcberweisung-Form wurde wohl plausibel ausgef\u00fcllt, keine Fehler gefunden...");
                }
                catch (Exception error) {
                    if (!isSelfException) throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    throw new Exception(error.getMessage());
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "continueButton", "(" + continueButtonPath + ")[2]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception clickError) {
                    throw new Exception(clickError.getMessage());
                }
                String pageBeforeTransSend = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageBeforeTransSend, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 50);
                TakesScreenshot screenshotObject = null;
                String screenShotBASE64 = null;
                String tempScreenshotPath = null;
                String currentSourceToView = null;
                try {
                    screenshotObject = (TakesScreenshot)seleniumWebDriver;
                    File screenShotFile = (File)screenshotObject.getScreenshotAs(OutputType.FILE);
                    tempScreenshotPath = System.getProperty("java.io.tmpdir") + File.separator + "syncWebClient_ScreenCaptureTmp" + File.separator + "n26" + String.valueOf(new Date().getTime()) + "-transfer.png";
                    FileUtils.moveFile((File)screenShotFile, (File)new File(tempScreenshotPath));
                    String screenShotRawBASE64 = (String)screenshotObject.getScreenshotAs(OutputType.BASE64);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "screenShotRawBASE64: " + screenShotRawBASE64);
                    screenShotBASE64 = "data:image/png;base64," + screenShotRawBASE64;
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "screenShotBASE64: " + screenShotBASE64);
                    currentSourceToView = tempScreenshotPath;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Sichtkontrollseite konnte nicht erstellt werden; Errorseite vermutlich erstellt: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 55);
                if (!WebPush.getSecAuthMeth().equals("PIN")) {
                    isSelfException = true;
                    throw new Exception("Verifizierungs-Verfahren nicht bekannt (Bitte dem Entwickler im Forum melden)");
                }
                pin = null;
                try {
                    String userInfoText = "Identit\u00e4ts\u00fcberpr\u00fcfung: Gib deine PIN zur Best\u00e4tigung ein.\nBitte beachte, dass du diese Transaktion noch auf deinem verkn\u00fcpften Ger\u00e4t best\u00e4tigen muss.\n\nEmpf\u00e4nger: " + gegenkontoName + "\nEmpf\u00e4nger IBAN: " + gegenkontoIBAN + "\nAuftragsdatum: " + new SimpleDateFormat("dd.MM.yyyy").format(new Date().getTime()) + "\nBetrag: " + betrag + "" + System.getProperty("line.separator");
                    pin = (String)DialogAskPIN.invoke((Object)DialogAskPIN, userInfoText, currentSourceToView, "institutlogo-n26.png");
                    if (!currentSourceToView.contains("syncWebClient")) break block82;
                }
                catch (InvocationTargetException error) {
                    try {
                        isSelfException = true;
                        if (ExceptionUtils.getRootCauseStackTrace((Throwable)error)[0].contains("OperationCanceledException")) {
                            throw new Exception("Angabe der Best\u00e4tigungs-PIN vom Benutzer abgebrochen (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:N26] " + getLogMethod + "DialogAskPIN fehlerhaft:" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("DialogAskPIN fehlerhaft: " + error.getMessage());
                        catch (Exception error2) {
                            isSelfException = true;
                            throw new Exception("Angabe der Best\u00e4tigungs-PIN vom Benutzer abgebrochen oder DialogAskPIN fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error2));
                        }
                    }
                    catch (Throwable throwable) {
                        if (!currentSourceToView.contains("syncWebClient")) throw throwable;
                        try {
                            FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
                            throw throwable;
                        }
                        catch (Exception error3) {
                            LogError.invoke((Object)LogError, "[WebSync:N26] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error3.getMessage());
                        }
                        throw throwable;
                    }
                }
                try {
                    FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
                }
                catch (Exception error) {
                    LogError.invoke((Object)LogError, "[WebSync:N26] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error.getMessage());
                }
            }
            MonitorLog.invoke((Object)MonitorLog, "Authentifiziere Auftrag mit angegebener PIN ...");
            String tanInputPath = "//input[contains(@id,'pin')]";
            String submitTransferPath = "//button[contains(.,'Verifizierung senden')]";
            String detectPINformPath = "//input[contains(@id,'pin')]";
            wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPINformPath)));
            WebElement pinInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
            LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "pinInput: " + pinInput);
            pinInput.click();
            pinInput.sendKeys(new CharSequence[]{pin});
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTransfer", submitTransferPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageAfterTransSend = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterTransSend, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 70);
            String successPinAuthPath = "//span[contains(.,'Auf deinem verkn\u00fcpften Ger\u00e4t ')]";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Auftrag wohl erfolgreich mit PIN best\u00e4tigt, warte nun auf Banking-App Freigabe: " + wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successPinAuthPath))));
                try {
                    WebElement waiterCheck = null;
                    MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                    int rounds = 0;
                    Thread.sleep(3000L);
                    boolean waitBankingApp = true;
                    do {
                        try {
                            waiterCheck = seleniumWebDriver.findElement(By.xpath((String)successPinAuthPath));
                        }
                        catch (NoSuchElementException | TimeoutException noBestSign) {
                            waitBankingApp = false;
                        }
                        if (waitBankingApp) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:N26] Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                            Thread.sleep(3000L);
                            ++rounds;
                        }
                        if (rounds < 79) continue;
                        isSelfException = true;
                        throw new Exception("Banking-App Authentifizierung auch nach 4 Minuten nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen!");
                    } while (waitBankingApp);
                    MonitorLog.invoke((Object)MonitorLog, "OK. Onlinebanking-Seite wartet nicht mehr auf Banking-App Freigabe.");
                    MonitorLog.invoke((Object)MonitorLog, "INFO: Sollte die Transaktion in der App von Ihnen aber gel\u00f6scht und nicht best\u00e4tigt worden sein, sollte diese auch in der Bankingsoftware gel\u00f6scht werden!");
                    LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "OK. Onlinebanking-Seite wartet nicht mehr auf Banking-App Freigabe.\nSollte die Transaktion in der App von Ihnen aber gel\u00f6scht und nicht best\u00e4tigt worden sein, sollte diese auch in der Bankingsoftware gel\u00f6scht werden!");
                }
                catch (Exception error) {
                    if (isSelfException) {
                        throw new Exception(error.getMessage());
                    }
                    isSelfException = true;
                    throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Erfolgreiche Ausf\u00fchrung des Auftrags konnte nicht best\u00e4tigt werden! Bitte online pr\u00fcfen. (Falls dennoch ausgef\u00fchrt: Wenn notwendig, Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)" + ExceptionUtils.getStackTrace((Throwable)notFounderr));
            }
            catch (Exception error) {
                if (isSelfException) {
                    throw new Exception(error.getMessage());
                }
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 85);
            return;
        }
        catch (Exception error) {
            if (!isSelfException) throw new Exception("Exception beim Ausf\u00fchren des Auftrags: " + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception(error.getMessage());
        }
    }
}

