/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.n26;

import de.derrichter.finance.websync.institute.n26.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        boolean isSelfException = false;
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "fromDateSimple: " + fromDateSimple);
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "toDateSimple: " + toDateSimple);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        Date dateFrom = sdf.parse(fromDateSimple);
        long dateFromMilli = dateFrom.getTime();
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "dateFromMilli: " + dateFromMilli);
        long dateToMilli = System.currentTimeMillis();
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "dateToMilli: " + String.valueOf(dateToMilli));
        SimpleDateFormat edf = new SimpleDateFormat("yyyy-MM-dd");
        fromDateSimple = edf.format(dateFrom);
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "fromDateSimple: " + fromDateSimple);
        toDateSimple = edf.format(System.currentTimeMillis());
        LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "toDateSimple: " + toDateSimple);
        try {
            double availableAmount;
            double amount;
            try {
                String messagePath = "//div[@id='mailboxtermsconditions-submitButton' or @id='welcome-process-form' or @id='datenabgleich' or contains(@class,'modal-dialog') or contains(.,'Upgrade zu N26 Smart') or contains(.,'Upgrade zu N26 Business Smart')]";
                boolean hasAbortButton = false;
                do {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:N26] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)messagePath)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                    String formWarnText = "";
                    List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)(messagePath + "//h1")));
                    for (WebElement headline : allHeadlines) {
                        String headlinetext = headline.getText();
                        formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:N26] ", headlinetext, externalLogger) + " ";
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "warnText: " + formWarnText);
                    if (!formWarnText.contains("Upgrade zu N26")) {
                        DialogWarn.invoke((Object)DialogWarn, "Meldung der N26 Bank GmbH:\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://app.n26.com/login" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-n26.png");
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//button[contains(.,'Schlie\u00dfen')]")));
                    }
                    catch (NoSuchElementException | TimeoutException notAborterr) {
                        hasAbortButton = false;
                        isSelfException = true;
                        throw new Exception(formWarnText.trim());
                    }
                    hasAbortButton = true;
                    LogWarn.invoke((Object)LogWarn, "[WebSync:N26] Meldung(en) der Bank: " + formWarnText);
                    MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", "//button[contains(.,'Schlie\u00dfen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (hasAbortButton);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:N26] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
            }
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Suche Schaltfl\u00e4che auf deutscher Sprache...");
                wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//button[contains(text(),'Suchen')]")));
            }
            catch (Exception error1) {
                isSelfException = true;
                throw new Exception("Unerwartete Meldung bzw. Seite oder Sprache konnte nicht gefunden werden; Stellen Sie in Ihrem Online-Account unter App-Einstellungen die Sprache auf 'Deutsch'; Ist dies der Fall informieren Sie bitte den Entwickler im Forum.");
            }
            try {
                String amountPath = "(//section//span[contains(.,'\u20ac')])[1]";
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "read amount ...");
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)amountPath)));
                String amountText = seleniumWebDriver.findElement(By.xpath((String)amountPath)).getText();
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "amountText: " + amountText);
                availableAmount = amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            }
            catch (Exception error1) {
                isSelfException = true;
                throw new Exception("Auslesen des Kontostands fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error1));
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 30);
            boolean localTest = false;
            File downloadedFile = null;
            if (localTest) {
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                downloadedFile = new File(docFixTempFilePath);
            }
            String submitDownloadPath = null;
            String downloadResponse = null;
            if (!localTest) {
                String downloadsXpath = "//a[contains(@href,'download')";
                try {
                    wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)downloadsXpath)));
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "gotoDownloads", downloadsXpath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    LogWarn.invoke((Object)LogWarn, "[WebSync:N26] " + getLogMethod + "Click on Xpath fail or no Element: " + downloadsXpath);
                    LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "Direct-Call Page: " + "https://app.n26.com/downloads");
                    seleniumWebDriver.get("https://app.n26.com/downloads");
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "downloads-page: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                String pageDownlodsResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageDownlodsResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                try {
                    WebElement fromDate = seleniumWebDriver.findElement(By.id((String)"start-date-picker"));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "fromDate: " + fromDate);
                    WebElement toDate = seleniumWebDriver.findElement(By.id((String)"end-date-picker"));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "toDate: " + toDate);
                    fromDate.clear();
                    fromDate.sendKeys(new CharSequence[]{fromDateSimple});
                }
                catch (Exception error) {
                    throw new Exception("Fehler beim Setzen des Umsatz-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                submitDownloadPath = "//button[text()='CSV herunterladen']";
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitDownload", submitDownloadPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                downloadResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(downloadResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                do {
                    Thread.sleep(500L);
                    int waiter = 0;
                    do {
                        if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                        Thread.sleep(1000L);
                        ++waiter;
                    } while (downloadedFile == null && waiter < 30);
                    if (downloadedFile != null && downloadedFile.exists()) continue;
                    isSelfException = true;
                    throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
            String csvResponse = "";
            String fileResponse = "";
            String fileencoding = "UTF-8";
            fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
            LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "fileResponse: \n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
            if (!fileencoding.equals("UTF-8")) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                csvResponse = new String(filebytes, System.getProperty("file.encoding"));
            } else {
                csvResponse = fileResponse;
            }
            FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
            if (!localTest) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
            }
            csvResponse = csvResponse.replaceAll("\\n\"", "\"");
            LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + csvResponse + "\n======================= END DATA =======================\n");
            if (csvResponse.contains("<html") || csvResponse.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            if (csvResponse.contains("from must be equal or after account open date")) {
                String newFromDate = csvResponse.substring(csvResponse.indexOf("open date") + 11, csvResponse.indexOf("open date") + 21);
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "fromDate: " + newFromDate);
                try {
                    WebElement fromDate = seleniumWebDriver.findElement(By.id((String)"start-date-picker"));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "fromDate: " + fromDate);
                    fromDate.clear();
                    fromDate.sendKeys(new CharSequence[]{newFromDate});
                }
                catch (Exception error) {
                    throw new Exception("Fehler beim Setzen des Umsatz-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitDownload", submitDownloadPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    WebUtils.checkSeleniumResponseHasError(downloadResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                downloadedFile = null;
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                do {
                    Thread.sleep(500L);
                    int waiter = 0;
                    do {
                        if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                        Thread.sleep(1000L);
                        ++waiter;
                    } while (downloadedFile == null && waiter < 30);
                    if (downloadedFile != null && downloadedFile.exists()) continue;
                    isSelfException = true;
                    throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                csvResponse = "";
                fileResponse = "";
                fileencoding = "UTF-8";
                fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "fileResponse: \n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                if (!fileencoding.equals("UTF-8")) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                    byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                    csvResponse = new String(filebytes, System.getProperty("file.encoding"));
                } else {
                    csvResponse = fileResponse;
                }
                FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
                LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + csvResponse + "\n======================= END DATA =======================\n");
                if (csvResponse.contains("<html") || csvResponse.contains("<head")) {
                    throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
                }
            }
            String[] dataResponse = new String[]{csvResponse, String.valueOf(amount)};
            String[][] matrixArrayDataCSV = StringCharUtils.data2matrixArray(csvResponse, '\"', ',', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            int transDateCount = 1;
            for (int i = 0; i < matrixArrayDataCSV.length; ++i) {
                if (matrixArrayDataCSV[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "matrixArrayDataCSV: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayDataCSV[i][0].split("-");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] matrixArrayDataCSV: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayDataCSV[i][0].split("-");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[0], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[2], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    if (StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][1])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    } else {
                        String[] arraydatum2 = matrixArrayDataCSV[i][1].split("-");
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum2[0], 10), Integer.parseInt(arraydatum2[1], 10) - 1, Integer.parseInt(arraydatum2[2], 10)));
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    Double Betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataCSV[i][7], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][4])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][4]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][5])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][5]);
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][4])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][4]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][3]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][2])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][2]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    String iban = matrixArrayDataCSV[i][3];
                    String gegenkontoNummer = "";
                    String GegenkontoBLZ = "";
                    if (!StringCharUtils.isNullOrEmptyOrNothing(iban) && StringCharUtils.isIbanCountryStructure(iban) && iban.startsWith("DE")) {
                        gegenkontoNummer = iban.substring(12, 22);
                        GegenkontoBLZ = iban.substring(4, 12);
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(iban)) {
                        gegenkontoNummer = iban;
                        if (!StringCharUtils.isIbanCountryStructure(iban)) {
                            iban = "";
                        }
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoNummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(GegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][8])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Betrag Fremdw\u00e4hrung: " + matrixArrayDataCSV[i][8] + " " + matrixArrayDataCSV[i][9] + "\nWechselkurs: " + matrixArrayDataCSV[i][10]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + StringCharUtils.shrinkString(((ArrayList)transactionDataList.get(arrayRowCount)).get(12).toString()));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    ++transDateCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("N26", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

