/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.n26;

import de.derrichter.finance.websync.institute.n26.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "N26" + "-Login aufrufen ... (GET " + "https://app.n26.com/login" + ")");
            try {
                seleniumWebDriver.get("https://app.n26.com/login");
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            Select langSelect = new Select(seleniumWebDriver.findElement(By.id((String)"locale-picker")));
            LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "langSelect: " + langSelect.getFirstSelectedOption().getText());
            if (!langSelect.getFirstSelectedOption().getText().equals("Deutsch")) {
                langSelect.selectByValue("de");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(1500L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "langSelect (after set): " + langSelect.getFirstSelectedOption().getText());
            }
            WebElement acceptCookies = null;
            try {
                acceptCookies = seleniumWebDriver.findElement(By.xpath((String)"//div[@id='gdpr-notice']//button[text()='Akzeptieren']"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (acceptCookies != null) {
                acceptCookies.click();
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//button[contains(.,'Einloggen')]")));
                WebElement formLogin = seleniumWebDriver.findElement(By.xpath((String)"//form[@action='/graphql']"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "formLogin: " + formLogin);
                WebElement inputUser = formLogin.findElement(By.name((String)"username"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "inputUser: " + inputUser);
                WebElement inputPasswd = formLogin.findElement(By.name((String)"password"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "inputPasswd: " + inputPasswd);
                inputUser.click();
                inputUser.sendKeys(new CharSequence[]{responseLogin});
                inputPasswd.click();
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[contains(.,'Einloggen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            boolean isAppConfirm = false;
            boolean isMTANConfirm = false;
            boolean appAuthHasCancel = false;
            do {
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Pr\u00fcfen auf Verfahren der Zwei-Faktor-Authentifizierung ...");
                MonitorLog.invoke((Object)MonitorLog, "Erste Login-Phase abgeschlossen, pr\u00fcfe auf Verfahren der Zwei-Faktor-Authentifizierung ...");
                isAppConfirm = false;
                appAuthHasCancel = false;
                try {
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//p[contains(.,'Logge dich mit nur einem Klick ein')]")));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "\u00dcberspringen von Vorank\u00fcndigung der Zwei-Faktor-Authentifizierung");
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[text()='Weiter']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                }
                catch (NoSuchElementException | TimeoutException noManuellAuth) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Vorank\u00fcndigung der Zwei-Faktor-Authentifizierung wird nicht angezeigt");
                }
                String bankingAppWaitFormPath = "//*[contains(.,'Best\u00e4tige den Login auf deinem Handy')]";
                try {
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)bankingAppWaitFormPath)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Banking-App ist als Verfahren gesetzt ...");
                    isAppConfirm = true;
                }
                catch (NoSuchElementException | TimeoutException noBankingApp) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Sicherheitsverfahren 'Banking-App' ohne TAN-Eingabe wird NICHT (direkt) angeboten oder User war schneller, pr\u00fcfe auf mobileTAN-Verfahren ...");
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//input[contains(@id,'verificationCode')]")));
                        WebUtils.authMTAN(seleniumWebDriver, false, externalLogger, externalProgressMonitor, externalDialogInterface);
                        MonitorLog.invoke((Object)MonitorLog, "mobileTAN erkannt, wird abgefragt ...");
                        isMTANConfirm = true;
                    }
                    catch (NoSuchElementException | TimeoutException noMTan) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "Sicherheitsverfahren mobileTan wird NICHT angeboten ...");
                    }
                }
                if (!isAppConfirm) continue;
                try {
                    WebElement waiterCheck = null;
                    MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                    int rounds = 0;
                    Thread.sleep(3000L);
                    boolean waitBankingApp = true;
                    do {
                        try {
                            waiterCheck = seleniumWebDriver.findElement(By.xpath((String)bankingAppWaitFormPath));
                        }
                        catch (NoSuchElementException | TimeoutException noBestSign) {
                            waitBankingApp = false;
                        }
                        if (waitBankingApp) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:N26] Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                            Thread.sleep(3000L);
                            ++rounds;
                        }
                        if (rounds < 79) continue;
                        isSelfException = true;
                        throw new Exception("Banking-App Authentifizierung auch nach 4 Minuten nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                    } while (waitBankingApp);
                }
                catch (Exception error) {
                    if (isSelfException) {
                        throw new Exception(error.getMessage());
                    }
                    isSelfException = true;
                    throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            } while (appAuthHasCancel);
            if (!isAppConfirm && !isMTANConfirm) {
                try {
                    seleniumWebDriver.findElement(By.id((String)"verify-login-dialog"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Login-Dialog noch vorhanden ... bei der Seite mit dem vermeintlich angebotenen Sicherheitsverfahren handelt es sich um diese im XML-Format: \n" + seleniumWebDriver.getPageSource());
                    isSelfException = true;
                    throw new Exception("Angebotenes Sicherheitsverfahren nicht erkannt oder bekannt. Bitte informieren Sie im Forum den Entwickler");
                }
                catch (NoSuchElementException | TimeoutException noBankingApp) {
                    isAppConfirm = true;
                }
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//button[contains(.,'Einloggen')]"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Bitte pr\u00fcfen Sie dies zuerst manuell Online, ansonsten informieren Sie bitte den Entwickler im Forum");
            }
            catch (NoSuchElementException | TimeoutException throwable) {
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:N26] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "Abmelden aufrufen ... (" + "https://app.n26.com/logout" + ")");
            try {
                seleniumWebDriver.get("https://app.n26.com/logout");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:N26] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//button[text()='Einloggen']")));
                LogInfo.invoke((Object)LogInfo, "[WebSync:N26] " + getLogMethod + "Logout bei der '" + "N26 Bank GmbH" + "' war erfolgreich");
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                LogTrace.invoke((Object)LogTrace, "[WebSync:N26] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPage);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:N26] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

